/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.LocationEvent;
import eu.hansolo.tilesfx.events.LocationEventListener;
import eu.hansolo.tilesfx.tools.Helper;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.scene.paint.Color;
import org.json.simple.JSONObject;

public class Location {
    private String name;
    private Instant timestamp;
    private double latitude;
    private double longitude;
    private double altitude;
    private String info;
    private Color color;
    private int zoomLevel;
    private List<LocationEventListener> listenerList;

    public Location() {
        this(0.0, 0.0, 0.0, Instant.now(), "", "", Tile.TileColor.BLUE.color);
    }

    public Location(double LATITUDE, double LONGITUDE) {
        this(LATITUDE, LONGITUDE, 0.0, Instant.now(), "", "", Tile.TileColor.BLUE.color);
    }

    public Location(double LATITUDE, double LONGITUDE, String NAME) {
        this(LATITUDE, LONGITUDE, 0.0, Instant.now(), NAME, "", Tile.TileColor.BLUE.color);
    }

    public Location(double LATITUDE, double LONGITUDE, String NAME, Color COLOR) {
        this(LATITUDE, LONGITUDE, 0.0, Instant.now(), NAME, "", COLOR);
    }

    public Location(double LATITUDE, double LONGITUDE, String NAME, String INFO) {
        this(LATITUDE, LONGITUDE, 0.0, Instant.now(), NAME, INFO, Tile.TileColor.BLUE.color);
    }

    public Location(double LATITUDE, double LONGITUDE, String NAME, String INFO, Color COLOR) {
        this(LATITUDE, LONGITUDE, 0.0, Instant.now(), NAME, INFO, COLOR);
    }

    public Location(double LATITUDE, double LONGITUDE, double ALTITUDE, String NAME) {
        this(LATITUDE, LONGITUDE, ALTITUDE, Instant.now(), NAME, "", Tile.TileColor.BLUE.color);
    }

    public Location(double LATITUDE, double LONGITUDE, double ALTITUDE, Instant TIMESTAMP, String NAME) {
        this(LATITUDE, LONGITUDE, ALTITUDE, TIMESTAMP, NAME, "", Tile.TileColor.BLUE.color);
    }

    public Location(double LATITUDE, double LONGITUDE, double ALTITUDE, Instant TIMESTAMP, String NAME, String INFO, Color COLOR) {
        this.name = NAME;
        this.latitude = LATITUDE;
        this.longitude = LONGITUDE;
        this.altitude = ALTITUDE;
        this.timestamp = TIMESTAMP;
        this.info = INFO;
        this.color = COLOR;
        this.zoomLevel = 15;
        this.listenerList = new CopyOnWriteArrayList<LocationEventListener>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String NAME) {
        this.name = NAME;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public long getTimestampInSeconds() {
        return this.timestamp.getEpochSecond();
    }

    public void setTimestamp(Instant TIMESTAMP) {
        this.timestamp = TIMESTAMP;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double LATITUDE) {
        this.latitude = LATITUDE;
        this.fireLocationEvent(new LocationEvent(this));
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double LONGITUDE) {
        this.longitude = LONGITUDE;
        this.fireLocationEvent(new LocationEvent(this));
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double ALTITUDE) {
        this.altitude = ALTITUDE;
        this.fireLocationEvent(new LocationEvent(this));
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String INFO) {
        this.info = INFO;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color COLOR) {
        this.color = COLOR;
        this.fireLocationEvent(new LocationEvent(this));
    }

    public ZonedDateTime getZonedDateTime() {
        return this.getZonedDateTime(ZoneId.systemDefault());
    }

    public ZonedDateTime getZonedDateTime(ZoneId ZONE_ID) {
        return ZonedDateTime.ofInstant(this.timestamp, ZONE_ID);
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(int LEVEL) {
        this.zoomLevel = Helper.clamp(0, 17, LEVEL);
        this.fireLocationEvent(new LocationEvent(this));
    }

    public void update(double LATITUDE, double LONGITUDE) {
        this.set(LATITUDE, LONGITUDE);
    }

    public void set(double LATITUDE, double LONGITUDE) {
        this.latitude = LATITUDE;
        this.longitude = LONGITUDE;
        this.timestamp = Instant.now();
        this.fireLocationEvent(new LocationEvent(this));
    }

    public void set(double LATITUDE, double LONGITUDE, double ALTITUDE, Instant TIMESTAMP) {
        this.latitude = LATITUDE;
        this.longitude = LONGITUDE;
        this.altitude = ALTITUDE;
        this.timestamp = TIMESTAMP;
        this.fireLocationEvent(new LocationEvent(this));
    }

    public void set(double LATITUDE, double LONGITUDE, double ALTITUDE, Instant TIMESTAMP, String INFO) {
        this.latitude = LATITUDE;
        this.longitude = LONGITUDE;
        this.altitude = ALTITUDE;
        this.timestamp = TIMESTAMP;
        this.info = INFO;
        this.fireLocationEvent(new LocationEvent(this));
    }

    public void set(Location LOCATION) {
        this.name = LOCATION.getName();
        this.latitude = LOCATION.getLatitude();
        this.longitude = LOCATION.getLongitude();
        this.altitude = LOCATION.getAltitude();
        this.timestamp = LOCATION.getTimestamp();
        this.info = LOCATION.info;
        this.color = LOCATION.getColor();
        this.zoomLevel = LOCATION.getZoomLevel();
        this.fireLocationEvent(new LocationEvent(this));
    }

    public double getDistanceTo(Location LOCATION) {
        return this.calcDistanceInMeter(this, LOCATION);
    }

    public boolean isWithinRangeOf(Location LOCATION, double METERS) {
        return this.getDistanceTo(LOCATION) < METERS;
    }

    public double calcDistanceInMeter(Location P1, Location P2) {
        return this.calcDistanceInMeter(P1.getLatitude(), P1.getLongitude(), P2.getLatitude(), P2.getLongitude());
    }

    public double calcDistanceInKilometer(Location P1, Location P2) {
        return this.calcDistanceInMeter(P1, P2) / 1000.0;
    }

    public double calcDistanceInMeter(double LAT_1, double LON_1, double LAT_2, double LON_2) {
        double EARTH_RADIUS = 6371000.0;
        double LAT_1_RADIANS = Math.toRadians(LAT_1);
        double LAT_2_RADIANS = Math.toRadians(LAT_2);
        double DELTA_LAT_RADIANS = Math.toRadians(LAT_2 - LAT_1);
        double DELTA_LON_RADIANS = Math.toRadians(LON_2 - LON_1);
        double A = Math.sin(DELTA_LAT_RADIANS * 0.5) * Math.sin(DELTA_LAT_RADIANS * 0.5) + Math.cos(LAT_1_RADIANS) * Math.cos(LAT_2_RADIANS) * Math.sin(DELTA_LON_RADIANS * 0.5) * Math.sin(DELTA_LON_RADIANS * 0.5);
        double C = 2.0 * Math.atan2(Math.sqrt(A), Math.sqrt(1.0 - A));
        double DISTANCE = 6371000.0 * C;
        return DISTANCE;
    }

    public double getAltitudeDifferenceInMeter(Location LOCATION) {
        return this.altitude - LOCATION.getAltitude();
    }

    public double getBearingTo(Location LOCATION) {
        return this.calcBearingInDegree(this.getLatitude(), this.getLongitude(), LOCATION.getLatitude(), LOCATION.getLongitude());
    }

    public double getBearingTo(double LATITUDE, double LONGITUDE) {
        return this.calcBearingInDegree(this.getLatitude(), this.getLongitude(), LATITUDE, LONGITUDE);
    }

    public boolean isZero() {
        return Double.compare(this.latitude, 0.0) == 0 && Double.compare(this.longitude, 0.0) == 0;
    }

    public double calcBearingInDegree(double LAT_1, double LON_1, double LAT_2, double LON_2) {
        double lat1 = Math.toRadians(LAT_1);
        double lon1 = Math.toRadians(LON_1);
        double lat2 = Math.toRadians(LAT_2);
        double lon2 = Math.toRadians(LON_2);
        double deltaLon = lon2 - lon1;
        double deltaPhi = Math.log(Math.tan(lat2 * 0.5 + 0.7853981633974483) / Math.tan(lat1 * 0.5 + 0.7853981633974483));
        if (Math.abs(deltaLon) > Math.PI) {
            deltaLon = deltaLon > 0.0 ? -(Math.PI * 2 - deltaLon) : Math.PI * 2 + deltaLon;
        }
        double bearing = (Math.toDegrees(Math.atan2(deltaLon, deltaPhi)) + 360.0) % 360.0;
        return bearing;
    }

    public String getCardinalDirectionFromBearing(double BEARING) {
        double bearing = BEARING % 360.0;
        for (CardinalDirection cardinalDirection : CardinalDirection.values()) {
            if (Double.compare(bearing, cardinalDirection.from) < 0 || Double.compare(bearing, cardinalDirection.to) >= 0) continue;
            return cardinalDirection.direction;
        }
        return "";
    }

    public void setOnLocationEvent(LocationEventListener LISTENER) {
        this.addLocationEventListener(LISTENER);
    }

    public void addLocationEventListener(LocationEventListener LISTENER) {
        if (!this.listenerList.contains(LISTENER)) {
            this.listenerList.add(LISTENER);
        }
    }

    public void removeLocationEventListener(LocationEventListener LISTENER) {
        if (this.listenerList.contains(LISTENER)) {
            this.listenerList.remove(LISTENER);
        }
    }

    public void fireLocationEvent(LocationEvent EVENT) {
        for (LocationEventListener listener : this.listenerList) {
            listener.onLocationEvent(EVENT);
        }
    }

    public boolean equals(Object OBJECT) {
        if (OBJECT instanceof Location) {
            Location LOCATION = (Location)OBJECT;
            return Double.compare(this.latitude, LOCATION.latitude) == 0 && Double.compare(this.longitude, LOCATION.longitude) == 0 && Double.compare(this.altitude, LOCATION.altitude) == 0;
        }
        return false;
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"nam", (Object)this.name);
        jsonObject.put((Object)"tst", (Object)new Long(this.timestamp.getEpochSecond()));
        jsonObject.put((Object)"lat", (Object)new Double(this.latitude));
        jsonObject.put((Object)"lon", (Object)new Double(this.longitude));
        jsonObject.put((Object)"alt", (Object)new Double(this.altitude));
        jsonObject.put((Object)"inf", (Object)new String(this.info));
        jsonObject.put((Object)"col", (Object)new String(this.color.toString().replace("0x", "#")));
        jsonObject.put((Object)"zml", (Object)new Integer(this.zoomLevel));
        return jsonObject;
    }

    public String toJSONString() {
        return this.toJSON().toJSONString();
    }

    public String toString() {
        return "Name     : " + this.name + "\n" + "Timestamp: " + this.timestamp + "\n" + "Latitude : " + this.latitude + "\n" + "Longitude: " + this.longitude + "\n" + "Altitude : " + String.format(Locale.US, "%.1f", this.altitude) + " m\n" + "Info     : " + this.info + "\n" + "Color    : " + this.color.toString().replace("0x", "#") + "\n" + "ZoomLevel: " + this.zoomLevel + "\n";
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.altitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public static enum CardinalDirection {
        N("North", 348.75, 11.25),
        NNE("North North-East", 11.25, 33.75),
        NE("North-East", 33.75, 56.25),
        ENE("East North-East", 56.25, 78.75),
        E("East", 78.75, 101.25),
        ESE("East South-East", 101.25, 123.75),
        SE("South-East", 123.75, 146.25),
        SSE("South South-East", 146.25, 168.75),
        S("South", 168.75, 191.25),
        SSW("South South-West", 191.25, 213.75),
        SW("South-West", 213.75, 236.25),
        WSW("West South-West", 236.25, 258.75),
        W("West", 258.75, 281.25),
        WNW("West North-West", 281.25, 303.75),
        NW("North-West", 303.75, 326.25),
        NNW("North North-West", 326.25, 348.75);

        public String direction;
        public double from;
        public double to;

        private CardinalDirection(String DIRECTION, double FROM, double TO) {
            this.direction = DIRECTION;
            this.from = FROM;
            this.to = TO;
        }
    }
}

