/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.weather;

import eu.hansolo.tilesfx.weather.DarkSky;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import org.json.simple.JSONObject;

public class DataPoint {
    private static final DateTimeFormatter DTF = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private LocalDateTime time = LocalDateTime.now();
    private TimeZone timeZone = TimeZone.getDefault();
    private String summary = "";
    private DarkSky.ConditionAndIcon condition = DarkSky.ConditionAndIcon.NONE;
    private LocalDateTime sunriseTime = LocalDateTime.now();
    private LocalDateTime sunsetTime = LocalDateTime.now();
    private double moonPhase = -1.0;
    private double precipIntensity = 0.0;
    private double precipIntensityMax = 0.0;
    private LocalDateTime precipIntensityMaxTime = LocalDateTime.now();
    private double precipProbability = -1.0;
    private DarkSky.PrecipType precipType = DarkSky.PrecipType.NONE;
    private double temperature = 0.0;
    private double temperatureMin = -1.0;
    private LocalDateTime temperatureMinTime = LocalDateTime.now();
    private double temperatureMax = 0.0;
    private LocalDateTime temperatureMaxTime = LocalDateTime.now();
    private double apparentTemperatureMin = 0.0;
    private LocalDateTime apparentTemperatureMinTime = LocalDateTime.now();
    private double apparentTemperatureMax = -1.0;
    private LocalDateTime apparentTemperatureMaxTime = LocalDateTime.now();
    private double dewPoint = -1.0;
    private double humidity = -1.0;
    private double windSpeed = -1.0;
    private double windBearing = -1.0;
    private double cloudCover = -1.0;
    private double pressure = -1.0;
    private double ozone = -1.0;
    private double nearestStormBearing = -1.0;
    private double nearestStormDistance = -1.0;
    private double precipAccumlation = -1.0;
    private double visibility = -1.0;

    public LocalDateTime getTime() {
        return this.time;
    }

    public void setTime(LocalDateTime TIME) {
        this.time = TIME;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone TIME_ZONE) {
        this.timeZone = TIME_ZONE;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String SUMMARY) {
        this.summary = SUMMARY;
    }

    public DarkSky.ConditionAndIcon getCondition() {
        return this.condition;
    }

    public void setCondition(DarkSky.ConditionAndIcon Condition) {
        this.condition = Condition;
    }

    public LocalDateTime getSunriseTime() {
        return this.sunriseTime;
    }

    public void setSunriseTime(LocalDateTime SUNRISE_TIME) {
        this.sunriseTime = SUNRISE_TIME;
    }

    public LocalDateTime getSunsetTime() {
        return this.sunsetTime;
    }

    public void setSunsetTime(LocalDateTime SUNSET_TIME) {
        this.sunsetTime = SUNSET_TIME;
    }

    public double getMoonPhase() {
        return this.moonPhase;
    }

    public void setMoonPhase(double MOON_PHASE) {
        this.moonPhase = MOON_PHASE;
    }

    public double getPrecipIntensity() {
        return this.precipIntensity;
    }

    public void setPrecipIntensity(double PRECIP_INTENSITY) {
        this.precipIntensity = PRECIP_INTENSITY;
    }

    public double getPrecipIntensityMax() {
        return this.precipIntensityMax;
    }

    public void setPrecipIntensityMax(double PRECIP_INTENSITY_MAX) {
        this.precipIntensityMax = PRECIP_INTENSITY_MAX;
    }

    public LocalDateTime getPrecipIntensityMaxTime() {
        return this.precipIntensityMaxTime;
    }

    public void setPrecipIntensityMaxTime(LocalDateTime PRECIP_INTENSITY_MAX_TIME) {
        this.precipIntensityMaxTime = PRECIP_INTENSITY_MAX_TIME;
    }

    public double getPrecipProbability() {
        return this.precipProbability;
    }

    public void setPrecipProbability(double PRECIP_PROBABILITY) {
        this.precipProbability = PRECIP_PROBABILITY;
    }

    public DarkSky.PrecipType getPrecipType() {
        return this.precipType;
    }

    public void setPrecipType(DarkSky.PrecipType PRECIP_TYPE) {
        this.precipType = PRECIP_TYPE;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double TEMPERATURE) {
        this.temperature = TEMPERATURE;
    }

    public double getTemperatureMin() {
        return this.temperatureMin;
    }

    public void setTemperatureMin(double TEMPERATURE_MIN) {
        this.temperatureMin = TEMPERATURE_MIN;
    }

    public LocalDateTime getTemperatureMinTime() {
        return this.temperatureMinTime;
    }

    public void setTemperatureMinTime(LocalDateTime TEMPERATURE_MIN_TIME) {
        this.temperatureMinTime = TEMPERATURE_MIN_TIME;
    }

    public double getTemperatureMax() {
        return this.temperatureMax;
    }

    public void setTemperatureMax(double TEMPERATURE_MAX) {
        this.temperatureMax = TEMPERATURE_MAX;
    }

    public LocalDateTime getTemperatureMaxTime() {
        return this.temperatureMaxTime;
    }

    public void setTemperatureMaxTime(LocalDateTime TEMPERATURE_MAX_TIME) {
        this.temperatureMaxTime = TEMPERATURE_MAX_TIME;
    }

    public double getApparentTemperatureMin() {
        return this.apparentTemperatureMin;
    }

    public void setApparentTemperatureMin(double APPARENT_TEMPERATURE_MIN) {
        this.apparentTemperatureMin = APPARENT_TEMPERATURE_MIN;
    }

    public LocalDateTime getApparentTemperatureMinTime() {
        return this.apparentTemperatureMinTime;
    }

    public void setApparentTemperatureMinTime(LocalDateTime APPARENT_TEMPERATURE_MIN_TIME) {
        this.apparentTemperatureMinTime = APPARENT_TEMPERATURE_MIN_TIME;
    }

    public double getApparentTemperatureMax() {
        return this.apparentTemperatureMax;
    }

    public void setApparentTemperatureMax(double APPARENT_TEMPERATURE_MAX) {
        this.apparentTemperatureMax = APPARENT_TEMPERATURE_MAX;
    }

    public LocalDateTime getApparentTemperatureMaxTime() {
        return this.apparentTemperatureMaxTime;
    }

    public void setApparentTemperatureMaxTime(LocalDateTime APPARENT_TEMPERATURE_MAX_TIME) {
        this.apparentTemperatureMaxTime = APPARENT_TEMPERATURE_MAX_TIME;
    }

    public double getDewPoint() {
        return this.dewPoint;
    }

    public void setDewPoint(double DEW_POINT) {
        this.dewPoint = DEW_POINT;
    }

    public double getHumidity() {
        return this.humidity;
    }

    public void setHumidity(double HUMIDITY) {
        this.humidity = HUMIDITY;
    }

    public double getWindSpeed() {
        return this.windSpeed;
    }

    public void setWindSpeed(double WIND_SPEED) {
        this.windSpeed = WIND_SPEED;
    }

    public double getWindBearing() {
        return this.windBearing;
    }

    public void setWindBearing(double WIND_BEARING) {
        this.windBearing = WIND_BEARING;
    }

    public double getCloudCover() {
        return this.cloudCover;
    }

    public void setCloudCover(double CLOUD_COVER) {
        this.cloudCover = CLOUD_COVER;
    }

    public double getPressure() {
        return this.pressure;
    }

    public void setPressure(double PRESSURE) {
        this.pressure = PRESSURE;
    }

    public double getOzone() {
        return this.ozone;
    }

    public void setOzone(double OZONE) {
        this.ozone = OZONE;
    }

    public double getNearestStormBearing() {
        return this.nearestStormBearing;
    }

    public void setNearestStormBearing(double NEAREST_STORM_BEARING) {
        this.nearestStormBearing = NEAREST_STORM_BEARING;
    }

    public double getNearestStormDistance() {
        return this.nearestStormDistance;
    }

    public void setNearestStormDistance(double NEAREST_STORM_DISTANCE) {
        this.nearestStormDistance = NEAREST_STORM_DISTANCE;
    }

    public double getPrecipAccumlation() {
        return this.precipAccumlation;
    }

    public void setPrecipAccumlation(double PRECIP_ACCUMLATION) {
        this.precipAccumlation = PRECIP_ACCUMLATION;
    }

    public double getVisibility() {
        return this.visibility;
    }

    public void setVisibility(double VISIBILITY) {
        this.visibility = VISIBILITY;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put((Object)"date", (Object)DTF.format(ZonedDateTime.of(this.time, this.timeZone.toZoneId())));
        json.put((Object)"summary", (Object)this.summary);
        json.put((Object)"condition", (Object)this.condition.name());
        json.put((Object)"temperature", (Object)this.temperature);
        json.put((Object)"pressure", (Object)this.pressure);
        json.put((Object)"humidity", (Object)this.humidity);
        json.put((Object)"windSpeed", (Object)this.windSpeed);
        json.put((Object)"tempMin", (Object)this.temperatureMin);
        json.put((Object)"tempMax", (Object)this.temperatureMax);
        return json;
    }

    public String toJsonString() {
        return this.toJson().toJSONString().replace("\\", "");
    }
}

