/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.ChartDataEvent;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.events.TileEvent;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.BarChartItem;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class BarChartTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private Pane barChartPane;
    private ChartDataEventListener updateHandler;
    private InvalidationListener paneSizeListener;
    private Map<BarChartItem, EventHandler<MouseEvent>> handlerMap;

    public BarChartTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.updateHandler = e -> {
            ChartDataEvent.EventType TYPE = e.getType();
            switch (TYPE) {
                case UPDATE: {
                    this.updateChart();
                    break;
                }
                case FINISHED: {
                    this.sortItems();
                }
            }
        };
        this.paneSizeListener = o -> this.resizeItems();
        this.handlerMap = new HashMap<BarChartItem, EventHandler<MouseEvent>>();
        this.tile.getBarChartItems().forEach(item -> {
            item.addChartDataEventListener(this.updateHandler);
            EventHandler clickHandler = e -> this.tile.fireTileEvent(new TileEvent(TileEvent.EventType.SELECTED_CHART_DATA, item.getChartData()));
            this.handlerMap.put((BarChartItem)item, (EventHandler<MouseEvent>)clickHandler);
            item.addEventHandler(MouseEvent.MOUSE_PRESSED, clickHandler);
            item.setMaxValue(this.tile.getMaxValue());
            if (null == item.getFormatString() || item.getFormatString().isEmpty()) {
                item.setFormatString(this.formatString);
            }
        });
        this.barChartPane = new Pane();
        this.barChartPane.getChildren().addAll(this.tile.getBarChartItems());
        this.sortItems();
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.text, this.barChartPane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.getBarChartItems().addListener((ListChangeListener)new WeakListChangeListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(addedItem -> {
                        this.barChartPane.getChildren().add(addedItem);
                        addedItem.addChartDataEventListener(this.updateHandler);
                        EventHandler clickHandler = e -> this.tile.fireTileEvent(new TileEvent(TileEvent.EventType.SELECTED_CHART_DATA, addedItem.getChartData()));
                        this.handlerMap.put((BarChartItem)addedItem, (EventHandler<MouseEvent>)clickHandler);
                        addedItem.setOnMousePressed(clickHandler);
                    });
                    this.updateChart();
                    continue;
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(removedItem -> {
                    removedItem.removeChartDataEventListener(this.updateHandler);
                    removedItem.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.handlerMap.get(removedItem));
                    this.barChartPane.getChildren().remove(removedItem);
                });
                this.updateChart();
            }
        }));
        this.pane.widthProperty().addListener(this.paneSizeListener);
        this.pane.heightProperty().addListener(this.paneSizeListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (TileEvent.EventType.VISIBILITY.name().equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        } else if (TileEvent.EventType.DATA.name().equals(EVENT_TYPE)) {
            this.sortItems();
        } else if (TileEvent.EventType.ANIMATED_ON.name().equals(EVENT_TYPE)) {
            this.tile.getBarChartItems().forEach(item -> item.getChartData().setAnimated(true));
        } else if (TileEvent.EventType.ANIMATED_OFF.name().equals(EVENT_TYPE)) {
            this.tile.getBarChartItems().forEach(item -> item.getChartData().setAnimated(false));
        }
    }

    private void sortItems() {
        switch (this.tile.getItemSorting()) {
            case ASCENDING: {
                this.tile.getBarChartItems().sort(Comparator.comparing(BarChartItem::getValue));
                break;
            }
            case DESCENDING: {
                this.tile.getBarChartItems().sort(Comparator.comparing(BarChartItem::getValue).reversed());
                break;
            }
        }
        this.updateChart();
    }

    @Override
    public void dispose() {
        this.pane.widthProperty().removeListener(this.paneSizeListener);
        this.pane.heightProperty().removeListener(this.paneSizeListener);
        this.tile.getBarChartItems().forEach(item -> {
            item.removeChartDataEventListener(this.updateHandler);
            item.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.handlerMap.get(item));
        });
        this.handlerMap.clear();
        super.dispose();
    }

    private void updateChart() {
        Platform.runLater(() -> {
            ObservableList<BarChartItem> items = this.tile.getBarChartItems();
            int noOfItems = items.size();
            if (noOfItems == 0) {
                return;
            }
            double maxValue = this.tile.getMaxValue();
            double maxY = this.barChartPane.getLayoutBounds().getMaxY();
            double itemHeight = ((BarChartItem)items.get(0)).getPrefHeight();
            double factorY = Helper.clamp(itemHeight, itemHeight * 1.1, 0.13 * this.size);
            for (int i = 0; i < noOfItems; ++i) {
                BarChartItem item2 = (BarChartItem)items.get(i);
                double y = (double)i * factorY;
                if (y + itemHeight < maxY) {
                    item2.setMaxValue(maxValue);
                    Helper.enableNode((Node)item2, true);
                    item2.relocate(0.0, y);
                    continue;
                }
                Helper.enableNode((Node)item2, false);
            }
            long noOfVisibleItems = items.stream().filter(item -> item.isVisible()).count();
            this.tile.showLowerRightRegion(noOfVisibleItems != (long)noOfItems);
        });
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    private void resizeItems() {
        double itemHeight = Helper.clamp(30.0, 72.0, this.height * 0.14);
        this.barChartPane.getChildren().forEach(node -> {
            BarChartItem item = (BarChartItem)node;
            item.setParentSize(this.width, this.height);
            item.setPrefSize(this.width, itemHeight);
            item.setMaxSize(this.width, itemHeight);
        });
    }

    @Override
    protected void resize() {
        super.resize();
        this.barChartPane.setPrefSize(this.width, this.contentBounds.getHeight());
        this.barChartPane.relocate(0.0, this.contentBounds.getY());
        this.resizeItems();
        this.updateChart();
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.tile.getBarChartItems().forEach(item -> {
            item.setNameColor(this.tile.getTextColor());
            item.setValueColor(this.tile.getValueColor());
        });
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
    }
}

