/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import javafx.animation.Animation;
import javafx.animation.FillTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.RotateTransition;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javafx.util.Duration;

public class HighLowTileSkin
extends TileSkin {
    private Path triangle;
    private StackPane indicatorPane;
    private Text titleText;
    private Text text;
    private Text valueText;
    private Text upperUnitText;
    private Line fractionLine;
    private Text unitText;
    private VBox unitFlow;
    private HBox valueUnitFlow;
    private Label description;
    private Text deviationText;
    private Text deviationUnitText;
    private TextFlow referenceUnitFlow;
    private State state;
    private double oldValue;

    public HighLowTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.oldValue = this.tile.getValue();
        double deviation = this.calculateDeviation();
        this.updateState(deviation);
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getUnit());
        this.text.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.valueText = new Text(String.format(this.locale, this.formatString, this.tile.getValue()));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
        this.upperUnitText = new Text("");
        this.upperUnitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.upperUnitText, !this.tile.getUnit().isEmpty());
        this.fractionLine = new Line();
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.unitFlow = new VBox(new Node[]{this.upperUnitText, this.unitText});
        this.unitFlow.setAlignment(Pos.CENTER_RIGHT);
        this.valueUnitFlow = new HBox(new Node[]{this.valueText, this.unitFlow});
        this.valueUnitFlow.setAlignment(Pos.BOTTOM_RIGHT);
        this.valueUnitFlow.setMouseTransparent(true);
        this.description = new Label(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.description.setWrapText(true);
        this.description.setTextFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.description, !this.tile.getDescription().isEmpty());
        this.triangle = new Path();
        this.triangle.setStroke(null);
        this.triangle.setFill((Paint)this.state.color);
        this.indicatorPane = new StackPane(new Node[]{this.triangle});
        this.deviationText = new Text(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", deviation));
        this.deviationText.setFill((Paint)this.state.color);
        this.deviationUnitText = new Text("%");
        this.deviationUnitText.setFill((Paint)Tile.FOREGROUND);
        this.referenceUnitFlow = new TextFlow(new Node[]{this.indicatorPane, this.deviationText, this.deviationUnitText});
        this.referenceUnitFlow.setTextAlignment(TextAlignment.LEFT);
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.text, this.valueUnitFlow, this.fractionLine, this.description, this.referenceUnitFlow});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
            Helper.enableNode((Node)this.unitFlow, !this.tile.getUnit().isEmpty());
            Helper.enableNode((Node)this.description, !this.tile.getDescription().isEmpty());
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        double deviation = this.calculateDeviation(VALUE);
        this.updateState(deviation);
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(VALUE));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        }
        this.deviationText.setText(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", deviation));
        RotateTransition rotateTransition = new RotateTransition(Duration.millis((double)200.0), (Node)this.triangle);
        rotateTransition.setFromAngle(this.triangle.getRotate());
        rotateTransition.setToAngle(this.state.angle);
        FillTransition fillIndicatorTransition = new FillTransition(Duration.millis((double)200.0), (Shape)this.triangle);
        fillIndicatorTransition.setFromValue((Color)this.triangle.getFill());
        fillIndicatorTransition.setToValue(this.state.color);
        FillTransition fillReferenceTransition = new FillTransition(Duration.millis((double)200.0), (Shape)this.deviationText);
        fillReferenceTransition.setFromValue((Color)this.triangle.getFill());
        fillReferenceTransition.setToValue(this.state.color);
        FillTransition fillReferenceUnitTransition = new FillTransition(Duration.millis((double)200.0), (Shape)this.deviationUnitText);
        fillReferenceUnitTransition.setFromValue((Color)this.triangle.getFill());
        fillReferenceUnitTransition.setToValue(this.state.color);
        ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{rotateTransition, fillIndicatorTransition, fillReferenceTransition, fillReferenceUnitTransition});
        parallelTransition.play();
    }

    private double calculateDeviation() {
        return this.calculateDeviation(this.tile.getValue());
    }

    private double calculateDeviation(double VALUE) {
        double deviation = Double.compare(0.0, this.oldValue) == 0 ? VALUE : -((this.oldValue - VALUE) / this.oldValue) * 100.0;
        this.oldValue = VALUE;
        return deviation;
    }

    private void updateState(double DEVIATION) {
        this.state = DEVIATION > 0.0 ? State.INCREASE : (DEVIATION < 0.0 ? State.DECREASE : State.CONSTANT);
    }

    private void drawTriangle() {
        MoveTo moveTo = new MoveTo(0.056 * this.size, 0.032 * this.size);
        CubicCurveTo cubicCurveTo1 = new CubicCurveTo(0.06 * this.size, 0.028 * this.size, 0.064 * this.size, 0.028 * this.size, 0.068 * this.size, 0.032 * this.size);
        CubicCurveTo cubicCurveTo2 = new CubicCurveTo(0.068 * this.size, 0.032 * this.size, 0.12 * this.size, 0.08 * this.size, 0.12 * this.size, 0.08 * this.size);
        CubicCurveTo cubicCurveTo3 = new CubicCurveTo(0.128 * this.size, 0.088 * this.size, 0.124 * this.size, 0.096 * this.size, 0.112 * this.size, 0.096 * this.size);
        CubicCurveTo cubicCurveTo4 = new CubicCurveTo(0.112 * this.size, 0.096 * this.size, 0.012 * this.size, 0.096 * this.size, 0.012 * this.size, 0.096 * this.size);
        CubicCurveTo cubicCurveTo5 = new CubicCurveTo(0.0, 0.096 * this.size, -0.004 * this.size, 0.088 * this.size, 0.004 * this.size, 0.08 * this.size);
        CubicCurveTo cubicCurveTo6 = new CubicCurveTo(0.004 * this.size, 0.08 * this.size, 0.056 * this.size, 0.032 * this.size, 0.056 * this.size, 0.032 * this.size);
        ClosePath closePath = new ClosePath();
        this.triangle.getElements().setAll((Object[])new PathElement[]{moveTo, cubicCurveTo1, cubicCurveTo2, cubicCurveTo3, cubicCurveTo4, cubicCurveTo5, cubicCurveTo6, closePath});
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = 0.24 * this.size;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        maxWidth = this.width - this.size * 0.55;
        fontSize = this.size * 0.18;
        this.deviationText.setFont(Fonts.latoRegular(fontSize));
        if (this.deviationText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.deviationText, maxWidth, fontSize);
        }
        maxWidth = this.width - this.size * 0.9;
        fontSize = this.size * 0.12;
        this.deviationUnitText.setFont(Fonts.latoRegular(fontSize));
        if (this.deviationUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.deviationUnitText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
        maxWidth = this.width - (this.width - this.size * 0.275);
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.upperUnitText.setFont(Fonts.latoRegular(fontSize));
        if (this.upperUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.upperUnitText, maxWidth, fontSize);
        }
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        fontSize = this.size * 0.1;
        this.description.setFont(Fonts.latoRegular(fontSize));
    }

    @Override
    protected void resize() {
        super.resize();
        this.description.setPrefSize(this.width - this.size * 0.1, this.size * 0.43);
        this.description.relocate(this.size * 0.05, this.titleText.isVisible() ? this.height * 0.42 : this.height * 0.32);
        this.drawTriangle();
        this.indicatorPane.setPadding(new Insets(0.0, this.size * 0.035, 0.0, 0.0));
        this.resizeStaticText();
        this.resizeDynamicText();
        this.referenceUnitFlow.setPrefWidth(this.width - this.size * 0.1);
        this.referenceUnitFlow.relocate(this.size * 0.05, this.height * 0.595);
        this.valueUnitFlow.setPrefWidth(this.width - this.size * 0.1);
        this.valueUnitFlow.relocate(this.size * 0.05, this.contentBounds.getY());
        this.valueUnitFlow.setMaxHeight(this.valueText.getFont().getSize());
        this.fractionLine.setStartX(this.width - 0.17 * this.size);
        this.fractionLine.setStartY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setEndX(this.width - 0.05 * this.size);
        this.fractionLine.setEndY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setStroke((Paint)this.tile.getUnitColor());
        this.fractionLine.setStrokeWidth(this.size * 0.005);
        this.unitFlow.setTranslateY(-this.size * 0.005);
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.deviationText.setText(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", this.calculateDeviation()));
        if (this.tile.getUnit().contains("/")) {
            String[] units = this.tile.getUnit().split("/");
            this.upperUnitText.setText(units[0]);
            this.unitText.setText(units[1]);
            Helper.enableNode((Node)this.fractionLine, true);
        } else {
            this.upperUnitText.setText(" ");
            this.unitText.setText(this.tile.getUnit());
            Helper.enableNode((Node)this.fractionLine, false);
        }
        this.description.setText(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.upperUnitText.setFill((Paint)this.tile.getUnitColor());
        this.fractionLine.setStroke((Paint)this.tile.getUnitColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        this.description.setTextFill((Paint)this.tile.getDescriptionColor());
        this.deviationText.setFill((Paint)this.state.color);
        this.deviationUnitText.setFill((Paint)this.state.color);
        this.triangle.setFill((Paint)this.state.color);
    }

    private static enum State {
        INCREASE(Tile.GREEN, 0.0),
        DECREASE(Tile.RED, 180.0),
        CONSTANT(Tile.ORANGE, 90.0);

        public final Color color;
        public final double angle;

        private State(Color COLOR, double ANGLE) {
            this.color = COLOR;
            this.angle = ANGLE;
        }
    }
}

