/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2016-2021 Gerrit Grunwald.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.hansolo.tilesfx.chart;

/**
 * Created by hansolo on 21.04.17.
 */
public enum MatrixFont5x7 implements MatrixFont {
    INSTANCE;

    public static final int[][] ASCII_32_126 = {
        {
            0b00000,
            0b00000,
            0b00000,
            0b00000,
            0b00000,
            0b00000,
            0b00000
        }, {
            0b00100,
            0b00100,
            0b00100,
            0b00100,
            0b00000,
            0b00000,
            0b00100
        }, {
            0b01010,
            0b01010,
            0b01010,
            0b00000,
            0b00000,
            0b00000,
            0b00000
        }, {
            0b01010,
            0b01010,
            0b11111,
            0b01010,
            0b11111,
            0b01010,
            0b01010
        }, {
            0b00100,
            0b01111,
            0b10100,
            0b01110,
            0b00101,
            0b11110,
            0b00100
        }, {
            0b11000,
            0b11001,
            0b00010,
            0b00100,
            0b01000,
            0b10011,
            0b00011
        }, {
            0b01100,
            0b10010,
            0b10100,
            0b01000,
            0b10101,
            0b10010,
            0b01101
        }, {
            0b01100,
            0b00100,
            0b01000,
            0b00000,
            0b00000,
            0b00000,
            0b00000
        }, {
            0b00010,
            0b00100,
            0b01000,
            0b01000,
            0b01000,
            0b00100,
            0b00010
        }, {
            0b01000,
            0b00100,
            0b00010,
            0b00010,
            0b00010,
            0b00100,
            0b01000
        }, {
            0b00000,
            0b00100,
            0b10101,
            0b01110,
            0b10101,
            0b00100,
            0b00000
        }, {
            0b00000,
            0b00100,
            0b00100,
            0b11111,
            0b00100,
            0b00100,
            0b00000
        }, {
            0b00000,
            0b00000,
            0b00000,
            0b00000,
            0b01100,
            0b00100,
            0b01000
        }, {
            0b00000,
            0b00000,
            0b00000,
            0b11111,
            0b00000,
            0b00000,
            0b00000
        }, {
            0b00000,
            0b00000,
            0b00000,
            0b00000,
            0b00000,
            0b01100,
            0b01100
        }, {
            0b00000,
            0b00001,
            0b00010,
            0b00100,
            0b01000,
            0b10000,
            0b00000
        }, {
            0b01110,
            0b10001,
            0b10011,
            0b10101,
            0b11001,
            0b10001,
            0b01110
        }, {
            0b00100,
            0b01100,
            0b00100,
            0b00100,
            0b00100,
            0b00100,
            0b01110
        }, {
            0b01110,
            0b10001,
            0b00001,
            0b00010,
            0b00100,
            0b01000,
            0b11111
        }, {
            0b11111,
            0b00010,
            0b00100,
            0b00010,
            0b00001,
            0b10001,
            0b01110
        }, {
            0b00010,
            0b00110,
            0b01010,
            0b10010,
            0b11111,
            0b00010,
            0b00010
        }, {
            0b11111,
            0b10000,
            0b11110,
            0b00001,
            0b00001,
            0b10001,
            0b01110
        }, {
            0b00110,
            0b01000,
            0b10000,
            0b11110,
            0b10001,
            0b10001,
            0b01110
        }, {
            0b11111,
            0b00001,
            0b00010,
            0b00100,
            0b01000,
            0b01000,
            0b01000
        }, {
            0b01110,
            0b10001,
            0b10001,
            0b01110,
            0b10001,
            0b10001,
            0b01110
        }, {
            0b01110,
            0b10001,
            0b10001,
            0b01111,
            0b00001,
            0b00010,
            0b01100
        }, {
            0b00000,
            0b01100,
            0b01100,
            0b00000,
            0b01100,
            0b01100,
            0b00000
        }, {
            0b00000,
            0b01100,
            0b01100,
            0b00000,
            0b01100,
            0b00100,
            0b01000
        }, {
            0b00010,
            0b00100,
            0b01000,
            0b10000,
            0b01000,
            0b00100,
            0b00010
        }, {
            0b00000,
            0b00000,
            0b11111,
            0b00000,
            0b11111,
            0b00000,
            0b00000
        }, {
            0b01000,
            0b00100,
            0b00010,
            0b00001,
            0b00010,
            0b00100,
            0b01000
        }, {
            0b01110,
            0b10001,
            0b00001,
            0b00010,
            0b00100,
            0b00000,
            0b00100
        }, {
            0b01110,
            0b10001,
            0b00001,
            0b01101,
            0b10101,
            0b10101,
            0b01110
        }, {
            0b01110,
            0b10001,
            0b10001,
            0b10001,
            0b11111,
            0b10001,
            0b10001
        }, {
            0b11110,
            0b10001,
            0b10001,
            0b11110,
            0b10001,
            0b10001,
            0b11110
        }, {
            0b01110,
            0b10001,
            0b10000,
            0b10000,
            0b10000,
            0b10001,
            0b01110
        }, {
            0b11100,
            0b10010,
            0b10001,
            0b10001,
            0b10001,
            0b10010,
            0b11100
        }, {
            0b11111,
            0b10000,
            0b10000,
            0b11110,
            0b10000,
            0b10000,
            0b11111
        }, {
            0b11111,
            0b10000,
            0b10000,
            0b11110,
            0b10000,
            0b10000,
            0b10000
        }, {
            0b01110,
            0b10001,
            0b10000,
            0b10111,
            0b10001,
            0b10001,
            0b01111
        }, {
            0b10001,
            0b10001,
            0b10001,
            0b11111,
            0b10001,
            0b10001,
            0b10001
        }, {
            0b01110,
            0b00100,
            0b00100,
            0b00100,
            0b00100,
            0b00100,
            0b01110
        }, {
            0b00111,
            0b00010,
            0b00010,
            0b00010,
            0b00010,
            0b10010,
            0b01100
        }, {
            0b10001,
            0b10010,
            0b10100,
            0b11000,
            0b10100,
            0b10010,
            0b10001
        }, {
            0b10000,
            0b10000,
            0b10000,
            0b10000,
            0b10000,
            0b10000,
            0b11111
        }, {
            0b10001,
            0b11011,
            0b10101,
            0b10101,
            0b10001,
            0b10001,
            0b10001
        }, {
            0b10001,
            0b10001,
            0b11001,
            0b10101,
            0b10011,
            0b10001,
            0b10001
        }, {
            0b01110,
            0b10001,
            0b10001,
            0b10001,
            0b10001,
            0b10001,
            0b01110
        }, {
            0b11110,
            0b10001,
            0b10001,
            0b11110,
            0b10000,
            0b10000,
            0b10000
        }, {
            0b01110,
            0b10001,
            0b10001,
            0b10001,
            0b10101,
            0b10010,
            0b01101
        }, {
            0b11110,
            0b10001,
            0b10001,
            0b11110,
            0b10100,
            0b10010,
            0b10001
        }, {
            0b01111,
            0b10000,
            0b10000,
            0b01110,
            0b00001,
            0b00001,
            0b11110
        }, {
            0b11111,
            0b00100,
            0b00100,
            0b00100,
            0b00100,
            0b00100,
            0b00100
        }, {
            0b10001,
            0b10001,
            0b10001,
            0b10001,
            0b10001,
            0b10001,
            0b01110
        }, {
            0b10001,
            0b10001,
            0b10001,
            0b10001,
            0b10001,
            0b01010,
            0b00100
        }, {
            0b10001,
            0b10001,
            0b10001,
            0b10101,
            0b10101,
            0b10101,
            0b01010
        }, {
            0b10001,
            0b10001,
            0b01010,
            0b00100,
            0b01010,
            0b10001,
            0b10001
        }, {
            0b10001,
            0b10001,
            0b10001,
            0b01010,
            0b00100,
            0b00100,
            0b00100
        }, {
            0b11111,
            0b00001,
            0b00010,
            0b00100,
            0b01000,
            0b10000,
            0b11111
        }, {
            0b01110,
            0b01000,
            0b01000,
            0b01000,
            0b01000,
            0b01000,
            0b01110
        }, {
            0b00000,
            0b10000,
            0b01000,
            0b00100,
            0b00010,
            0b00001,
            0b00000
        }, {
            0b01110,
            0b00010,
            0b00010,
            0b00010,
            0b00010,
            0b00010,
            0b01110
        }, {
            0b00100,
            0b01010,
            0b10001,
            0b00000,
            0b00000,
            0b00000,
            0b00000
        }, {
            0b00000,
            0b00000,
            0b00000,
            0b00000,
            0b00000,
            0b00000,
            0b11111
        }, {
            0b01000,
            0b00100,
            0b00010,
            0b00000,
            0b00000,
            0b00000,
            0b00000
        }, {
            0b00000,
            0b00000,
            0b01110,
            0b00001,
            0b01111,
            0b10001,
            0b11111
        }, {
            0b10000,
            0b10000,
            0b10000,
            0b10110,
            0b11001,
            0b10001,
            0b11110
        }, {
            0b00000,
            0b00000,
            0b01110,
            0b10000,
            0b10000,
            0b10001,
            0b01110
        }, {
            0b00001,
            0b00001,
            0b00001,
            0b01101,
            0b10011,
            0b10001,
            0b01111
        }, {
            0b00000,
            0b00000,
            0b01110,
            0b10001,
            0b11111,
            0b10000,
            0b01110
        }, {
            0b00110,
            0b01001,
            0b01000,
            0b11100,
            0b01000,
            0b01000,
            0b01000
        }, {
            0b00000,
            0b01111,
            0b10001,
            0b10001,
            0b01111,
            0b00001,
            0b01110
        }, {
            0b10000,
            0b10000,
            0b10110,
            0b11001,
            0b10001,
            0b10001,
            0b10001
        }, {
            0b00000,
            0b00100,
            0b00000,
            0b00100,
            0b00100,
            0b00100,
            0b00100
        }, {
            0b00010,
            0b00000,
            0b00110,
            0b00010,
            0b00010,
            0b10010,
            0b01100
        }, {
            0b10000,
            0b10000,
            0b10010,
            0b10100,
            0b11000,
            0b10100,
            0b10010
        }, {
            0b01100,
            0b00100,
            0b00100,
            0b00100,
            0b00100,
            0b00100,
            0b01110
        }, {
            0b00000,
            0b00000,
            0b11010,
            0b10101,
            0b10101,
            0b10001,
            0b10001
        }, {
            0b00000,
            0b00000,
            0b10110,
            0b11001,
            0b10001,
            0b10001,
            0b10001
        }, {
            0b00000,
            0b00000,
            0b01110,
            0b10001,
            0b10001,
            0b10001,
            0b01110
        }, {
            0b00000,
            0b00000,
            0b11110,
            0b10001,
            0b11110,
            0b10000,
            0b10000
        }, {
            0b00000,
            0b00000,
            0b01101,
            0b10011,
            0b01111,
            0b00001,
            0b00001
        }, {
            0b00000,
            0b00000,
            0b10110,
            0b11001,
            0b10000,
            0b10000,
            0b10000
        }, {
            0b00000,
            0b00000,
            0b01110,
            0b10000,
            0b01110,
            0b00001,
            0b11110
        }, {
            0b01000,
            0b01000,
            0b11100,
            0b01000,
            0b01000,
            0b01001,
            0b00110
        }, {
            0b00000,
            0b00000,
            0b10001,
            0b10001,
            0b10001,
            0b10011,
            0b01101
        }, {
            0b00000,
            0b00000,
            0b10001,
            0b10001,
            0b10001,
            0b01010,
            0b00100
        }, {
            0b00000,
            0b00000,
            0b10001,
            0b10001,
            0b10101,
            0b10101,
            0b01010
        }, {
            0b00000,
            0b00000,
            0b10001,
            0b01010,
            0b00100,
            0b01010,
            0b10001
        }, {
            0b00000,
            0b00000,
            0b10001,
            0b10001,
            0b01111,
            0b00001,
            0b01110
        }, {
            0b00000,
            0b00000,
            0b11111,
            0b00010,
            0b00100,
            0b01000,
            0b11111
        }, {
            0b00010,
            0b00100,
            0b00100,
            0b01000,
            0b00100,
            0b00100,
            0b00010
        }, {
            0b00100,
            0b00100,
            0b00100,
            0b00100,
            0b00100,
            0b00100,
            0b00100
        }, {
            0b01000,
            0b00100,
            0b00100,
            0b00010,
            0b00100,
            0b00100,
            0b01000
        }, {
            0b01000,
            0b10101,
            0b10101,
            0b00010,
            0b00000,
            0b00000,
            0b00000
        }};

    @Override public int getCharacterWidth() { return 5; }
    @Override public int getCharacterHeight() { return 7; }

    @Override public int[] getCharacter(final char CHAR) {
        int ascii = (int) CHAR;
        if (ascii < 32 || ascii > 126) { return ASCII_32_126[0]; }
        return ASCII_32_126[ascii - 32];
    }
}
