/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.TileBuilder;
import eu.hansolo.tilesfx.skins.BarChartItem;
import java.util.ArrayList;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class Test
extends Application {
    private static final Random RND = new Random();
    private static final double SIZE = 400.0;
    private static final double WIDTH = 400.0;
    private static final double HEIGHT = 400.0;
    private static int noOfNodes = 0;
    private Tile tile;
    private DoubleProperty value;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        this.value = new SimpleDoubleProperty();
        this.tile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.BAR_CHART)).prefSize(400.0, 400.0)).title("Tile 1")).animated(false)).build();
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > Test.this.lastTimerCall + 5000000000L) {
                    Test.this.tile.setValue(RND.nextDouble() * Test.this.tile.getRange() + Test.this.tile.getMinValue());
                    Test.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane(new Node[]{this.tile});
        pane.setPadding(new Insets(10.0));
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("Test");
        stage.setScene(scene);
        stage.show();
        ArrayList<BarChartItem> items = new ArrayList<BarChartItem>();
        items.add(new BarChartItem("JDK17", 14.0, Tile.BLUE));
        items.add(new BarChartItem("JDK11", 23.0, Tile.BLUE));
        items.add(new BarChartItem("JDK8", 10.0, Tile.BLUE));
        Platform.runLater(() -> this.tile.setBarChartItems(items));
        Test.calcNoOfNodes((Node)pane);
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public void stop() {
        Platform.exit();
        System.exit(0);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Test.calcNoOfNodes(n);
            }
        }
    }

    public static void main(String[] args) {
        Test.launch((String[])args);
    }
}

