/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.chart;

import eu.hansolo.tilesfx.events.SmoothedChartEvent;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.util.Duration;

public class SmoothedChart<X, Y>
extends AreaChart<X, Y> {
    public static final Background TRANSPARENT_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)});
    private static final int MAX_SUBDIVISIONS = 64;
    private static final int MAX_DECIMALS = 10;
    private boolean _smoothed;
    private BooleanProperty smoothed;
    private ChartType _chartType;
    private ObjectProperty<ChartType> chartType;
    private int _subDivisions;
    private IntegerProperty subDivisions;
    private boolean _snapToTicks;
    private BooleanProperty snapToTicks;
    private boolean _symbolsVisible;
    private BooleanProperty symbolsVisible;
    private Color _selectorFillColor;
    private ObjectProperty<Color> selectorFillColor;
    private Color _selectorStrokeColor;
    private ObjectProperty<Color> selectorStrokeColor;
    private double _selectorSize;
    private DoubleProperty selectorSize;
    private int _decimals;
    private IntegerProperty decimals;
    private String formatString;
    private Circle selector;
    private Tooltip selectorTooltip;
    private Region chartPlotBackground;
    private PauseTransition timeBeforeFadeOut;
    private SequentialTransition fadeInFadeOut;
    private List<Path> strokePaths;
    private boolean _interactive;
    private BooleanProperty interactive;
    private double _tooltipTimeout;
    private DoubleProperty tooltipTimeout;
    private Path horizontalGridLines;
    private Path verticalGridLines;
    private Line horizontalZeroLine;
    private Line verticalZeroLine;
    private EventHandler<MouseEvent> clickHandler;
    private EventHandler<ActionEvent> endOfTransformationHandler;
    private ListChangeListener<XYChart.Series<X, Y>> seriesListener;

    public SmoothedChart(Axis<X> xAxis, Axis<Y> yAxis) {
        super(xAxis, yAxis);
        this.init();
        this.registerListeners();
    }

    public SmoothedChart(Axis<X> xAxis, Axis<Y> yAxis, ObservableList<XYChart.Series<X, Y>> data) {
        super(xAxis, yAxis, data);
        this.init();
        this.registerListeners();
    }

    private void init() {
        Path verticalGridLines;
        this._smoothed = true;
        this._chartType = ChartType.LINE;
        this._subDivisions = 16;
        this._snapToTicks = false;
        this._selectorFillColor = Color.WHITE;
        this._selectorStrokeColor = Color.RED;
        this._selectorSize = 10.0;
        this._decimals = 2;
        this._interactive = true;
        this._tooltipTimeout = 2000.0;
        this.formatString = "%.2f";
        this.strokePaths = new ArrayList<Path>();
        this.clickHandler = e -> this.select((MouseEvent)e);
        this.endOfTransformationHandler = e -> this.selectorTooltip.hide();
        this.seriesListener = change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(addedItem -> {
                        XYChart.Series series = addedItem;
                        Path strokePath = (Path)((Group)series.getNode()).getChildren().get(1);
                        Path fillPath = (Path)((Group)series.getNode()).getChildren().get(0);
                        fillPath.addEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
                        strokePath.addEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
                        this.strokePaths.add(strokePath);
                        series.getData().forEach(data -> data.YValueProperty().addListener(o -> this.layoutPlotChildren()));
                    });
                    continue;
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(removedItem -> {
                    XYChart.Series series = removedItem;
                    Path strokePath = (Path)((Group)series.getNode()).getChildren().get(1);
                    Path fillPath = (Path)((Group)series.getNode()).getChildren().get(0);
                    fillPath.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
                    strokePath.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
                    this.strokePaths.remove(strokePath);
                });
            }
        };
        this.selector = new Circle();
        this.selector.setFill((Paint)this._selectorFillColor);
        this.selector.setStroke((Paint)this._selectorStrokeColor);
        this.selector.setOpacity(0.0);
        this.selectorTooltip = new Tooltip("");
        Tooltip.install((Node)this.selector, (Tooltip)this.selectorTooltip);
        FadeTransition fadeIn = new FadeTransition(Duration.millis((double)100.0), (Node)this.selector);
        fadeIn.setFromValue(0.0);
        fadeIn.setToValue(1.0);
        this.timeBeforeFadeOut = new PauseTransition(Duration.millis((double)this._tooltipTimeout));
        FadeTransition fadeOut = new FadeTransition(Duration.millis((double)100.0), (Node)this.selector);
        fadeOut.setFromValue(1.0);
        fadeOut.setToValue(0.0);
        this.fadeInFadeOut = new SequentialTransition(new Animation[]{fadeIn, this.timeBeforeFadeOut, fadeOut});
        this.fadeInFadeOut.setOnFinished(this.endOfTransformationHandler);
        this.chartPlotBackground = this.getChartPlotBackground();
        this.chartPlotBackground.widthProperty().addListener(o -> this.resizeSelector());
        this.chartPlotBackground.heightProperty().addListener(o -> this.resizeSelector());
        this.chartPlotBackground.layoutYProperty().addListener(o -> this.resizeSelector());
        Path horizontalGridLines = this.getHorizontalGridLines();
        if (null != horizontalGridLines) {
            horizontalGridLines.setMouseTransparent(true);
        }
        if (null != (verticalGridLines = this.getVerticalGridLines())) {
            verticalGridLines.setMouseTransparent(true);
        }
        this.getChartChildren().addAll((Object[])new Node[]{this.selector});
    }

    private void registerListeners() {
        this.getData().addListener(this.seriesListener);
    }

    public boolean isSmoothed() {
        return null == this.smoothed ? this._smoothed : this.smoothed.get();
    }

    public void setSmoothed(boolean SMOOTHED) {
        if (null == this.smoothed) {
            this._smoothed = SMOOTHED;
            this.layoutPlotChildren();
        } else {
            this.smoothed.set(SMOOTHED);
        }
    }

    public BooleanProperty smoothedProperty() {
        if (null == this.smoothed) {
            this.smoothed = new BooleanPropertyBase(this._smoothed){

                protected void invalidated() {
                    SmoothedChart.this.layoutPlotChildren();
                }

                public Object getBean() {
                    return SmoothedChart.this;
                }

                public String getName() {
                    return "smoothed";
                }
            };
        }
        return this.smoothed;
    }

    public ChartType getChartType() {
        return null == this.chartType ? this._chartType : (ChartType)((Object)this.chartType.get());
    }

    public void setChartType(ChartType TYPE) {
        if (null == this.chartType) {
            this._chartType = TYPE;
            this.layoutPlotChildren();
        } else {
            this.chartType.set((Object)TYPE);
        }
    }

    public ObjectProperty<ChartType> chartTypeProperty() {
        if (null == this.chartType) {
            this.chartType = new ObjectPropertyBase<ChartType>(this._chartType){

                protected void invalidated() {
                    SmoothedChart.this.layoutPlotChildren();
                }

                public Object getBean() {
                    return SmoothedChart.this;
                }

                public String getName() {
                    return "chartType";
                }
            };
            this._chartType = null;
        }
        return this.chartType;
    }

    public int getSubDivisions() {
        return null == this.subDivisions ? this._subDivisions : this.subDivisions.get();
    }

    public void setSubDivisions(int SUB_DIVISIONS) {
        if (null == this.subDivisions) {
            this._subDivisions = Helper.clamp(1, 64, SUB_DIVISIONS);
            this.layoutPlotChildren();
        } else {
            this.subDivisions.set(SUB_DIVISIONS);
        }
    }

    public IntegerProperty subDivisionsProperty() {
        if (null == this.subDivisions) {
            this.subDivisions = new IntegerPropertyBase(this._subDivisions){

                protected void invalidated() {
                    this.set(Helper.clamp(1, 64, this.get()));
                    SmoothedChart.this.layoutPlotChildren();
                }

                public Object getBean() {
                    return SmoothedChart.this;
                }

                public String getName() {
                    return "subDivisions";
                }
            };
        }
        return this.subDivisions;
    }

    public boolean isSnapToTicks() {
        return null == this.snapToTicks ? this._snapToTicks : this.snapToTicks.get();
    }

    public void setSnapToTicks(boolean SNAP) {
        if (null == this.snapToTicks) {
            this._snapToTicks = SNAP;
        } else {
            this.snapToTicks.set(SNAP);
        }
    }

    public BooleanProperty snapToTicksProperty() {
        if (null == this.snapToTicks) {
            this.snapToTicks = new BooleanPropertyBase(this._snapToTicks){

                protected void invalidated() {
                }

                public Object getBean() {
                    return SmoothedChart.this;
                }

                public String getName() {
                    return "snapToTicks";
                }
            };
        }
        return this.snapToTicks;
    }

    public boolean getSymbolsVisible() {
        return null == this.symbolsVisible ? this._symbolsVisible : this.symbolsVisible.get();
    }

    public void setSymbolsVisible(boolean VISIBLE) {
        if (null == this.symbolsVisible) {
            this._symbolsVisible = VISIBLE;
            this.getData().forEach(series -> this.setSymbolsVisible((XYChart.Series<X, Y>)series, this._symbolsVisible));
        } else {
            this.symbolsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty symbolsVisibleProperty() {
        if (null == this.symbolsVisible) {
            this.symbolsVisible = new BooleanPropertyBase(this._symbolsVisible){

                protected void invalidated() {
                    SmoothedChart.this.getData().forEach(series -> SmoothedChart.this.setSymbolsVisible(series, SmoothedChart.this._symbolsVisible));
                }

                public Object getBean() {
                    return SmoothedChart.this;
                }

                public String getName() {
                    return "symbolsVisible";
                }
            };
        }
        return this.symbolsVisible;
    }

    public Color getSelectorFillColor() {
        return null == this.selectorFillColor ? this._selectorFillColor : (Color)this.selectorFillColor.get();
    }

    public void setSelectorFillColor(Color COLOR) {
        if (null == this.selectorFillColor) {
            this._selectorFillColor = COLOR;
            this.selector.setFill((Paint)this._selectorFillColor);
            this.layoutPlotChildren();
        } else {
            this.selectorFillColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> selectorFillColorProperty() {
        if (null == this.selectorFillColor) {
            this.selectorFillColor = new ObjectPropertyBase<Color>(this._selectorFillColor){

                protected void invalidated() {
                    SmoothedChart.this.selector.setFill((Paint)this.get());
                    SmoothedChart.this.layoutPlotChildren();
                }

                public Object getBean() {
                    return SmoothedChart.this;
                }

                public String getName() {
                    return "selectorFillColor";
                }
            };
            this._selectorFillColor = null;
        }
        return this.selectorFillColor;
    }

    public Color getSelectorStrokeColor() {
        return null == this.selectorStrokeColor ? this._selectorStrokeColor : (Color)this.selectorStrokeColor.get();
    }

    public void setSelectorStrokeColor(Color COLOR) {
        if (null == this.selectorStrokeColor) {
            this._selectorStrokeColor = COLOR;
            this.selector.setStroke((Paint)this._selectorStrokeColor);
            this.layoutPlotChildren();
        } else {
            this.selectorStrokeColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> selectorStrokeColorProperty() {
        if (null == this.selectorStrokeColor) {
            this.selectorStrokeColor = new ObjectPropertyBase<Color>(this._selectorStrokeColor){

                protected void invalidated() {
                    SmoothedChart.this.selector.setStroke((Paint)this.get());
                    SmoothedChart.this.layoutPlotChildren();
                }

                public Object getBean() {
                    return SmoothedChart.this;
                }

                public String getName() {
                    return "selectorStrokeColor";
                }
            };
            this._selectorStrokeColor = null;
        }
        return this.selectorStrokeColor;
    }

    public double getSelectorSize() {
        return null == this.selectorSize ? this._selectorSize : this.selectorSize.get();
    }

    public void setSelectorSize(double SIZE) {
        if (null == this.selectorSize) {
            this._selectorSize = Helper.clamp(1.0, 20.0, SIZE);
        } else {
            this.selectorSize.set(SIZE);
        }
    }

    public DoubleProperty selectorSizeProperty() {
        if (null == this.selectorSize) {
            this.selectorSize = new DoublePropertyBase(this._selectorSize){

                protected void invalidated() {
                    this.set(Helper.clamp(1.0, 20.0, this.get()));
                }

                public Object getBean() {
                    return SmoothedChart.this;
                }

                public String getName() {
                    return "selectorSize";
                }
            };
        }
        return this.selectorSize;
    }

    public int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = Helper.clamp(0, 10, DECIMALS);
            this.formatString = "%." + this._decimals + "f";
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 10, this.get()));
                    SmoothedChart.this.formatString = "%." + SmoothedChart.this._decimals + "f";
                }

                public Object getBean() {
                    return SmoothedChart.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public boolean isInteractive() {
        return null == this.interactive ? this._interactive : this.interactive.get();
    }

    public void setInteractive(boolean INTERACTIVE) {
        if (null == this.interactive) {
            this._interactive = INTERACTIVE;
        } else {
            this.interactive.set(INTERACTIVE);
        }
    }

    public BooleanProperty interactiveProperty() {
        if (null == this.interactive) {
            this.interactive = new BooleanPropertyBase(this._interactive){

                public Object getBean() {
                    return SmoothedChart.this;
                }

                public String getName() {
                    return "interactive";
                }
            };
        }
        return this.interactive;
    }

    public double getTooltipTimeout() {
        return null == this.tooltipTimeout ? this._tooltipTimeout : this.tooltipTimeout.get();
    }

    public void setTooltipTimeout(double TIMEOUT) {
        if (null == this.tooltipTimeout) {
            this._tooltipTimeout = Helper.clamp(0.0, 10000.0, TIMEOUT);
            this.timeBeforeFadeOut.setDuration(Duration.millis((double)this._tooltipTimeout));
        } else {
            this.tooltipTimeout.set(TIMEOUT);
        }
    }

    public DoubleProperty tooltipTimeoutProperty() {
        if (null == this.tooltipTimeout) {
            this.tooltipTimeout = new DoublePropertyBase(this._tooltipTimeout){

                protected void invalidated() {
                    this.set(Helper.clamp(0.0, 10000.0, this.get()));
                    SmoothedChart.this.timeBeforeFadeOut.setDuration(Duration.millis((double)this.get()));
                }

                public Object getBean() {
                    return SmoothedChart.this;
                }

                public String getName() {
                    return "tootipTimeout";
                }
            };
        }
        return this.tooltipTimeout;
    }

    public void setSymbolsVisible(XYChart.Series<X, Y> SERIES, boolean VISIBLE) {
        if (!this.getData().contains(SERIES)) {
            return;
        }
        for (XYChart.Data data : SERIES.getData()) {
            StackPane stackPane = (StackPane)data.getNode();
            if (null == stackPane) continue;
            stackPane.setVisible(VISIBLE);
        }
    }

    public void setSeriesColor(XYChart.Series<X, Y> SERIES, Paint COLOR) {
        Background symbolBackground = new Background(new BackgroundFill[]{new BackgroundFill(COLOR, new CornerRadii(5.0), Insets.EMPTY), new BackgroundFill((Paint)Color.WHITE, new CornerRadii(5.0), new Insets(2.0))});
        this.setSeriesColor(SERIES, COLOR, COLOR, symbolBackground, COLOR);
    }

    public void setSeriesColor(XYChart.Series<X, Y> SERIES, Paint STROKE, Paint FILL) {
        Background symbolBackground = new Background(new BackgroundFill[]{new BackgroundFill(STROKE, new CornerRadii(1024.0), Insets.EMPTY), new BackgroundFill((Paint)Color.WHITE, new CornerRadii(1024.0), new Insets(2.0))});
        this.setSeriesColor(SERIES, STROKE, FILL, symbolBackground, STROKE);
    }

    public void setSeriesColor(XYChart.Series<X, Y> SERIES, Paint STROKE, Paint FILL, Paint LEGEND_SYMBOL_FILL) {
        Background symbolBackground = new Background(new BackgroundFill[]{new BackgroundFill(STROKE, new CornerRadii(1024.0), Insets.EMPTY), new BackgroundFill((Paint)Color.WHITE, new CornerRadii(1024.0), new Insets(2.0))});
        this.setSeriesColor(SERIES, STROKE, FILL, symbolBackground, LEGEND_SYMBOL_FILL);
    }

    public void setSeriesColor(XYChart.Series<X, Y> SERIES, Paint STROKE, Paint FILL, Background SYMBOL_BACKGROUND) {
        this.setSeriesColor(SERIES, STROKE, FILL, SYMBOL_BACKGROUND, STROKE);
    }

    public void setSeriesColor(XYChart.Series<X, Y> SERIES, Paint STROKE, Paint FILL, BackgroundFill SYMBOL_STROKE, BackgroundFill SYMBOL_Fill) {
        this.setSeriesColor(SERIES, STROKE, FILL, new Background(new BackgroundFill[]{SYMBOL_STROKE, SYMBOL_Fill}), STROKE);
    }

    public void setSeriesColor(XYChart.Series<X, Y> SERIES, Paint STROKE, Paint FILL, Background SYMBOL_BACKGROUND, Paint LEGEND_SYMBOL_FILL) {
        if (this.getData().isEmpty()) {
            return;
        }
        if (!this.getData().contains(SERIES)) {
            return;
        }
        if (null != FILL) {
            ((Path)((Group)SERIES.getNode()).getChildren().get(0)).setFill(FILL);
        }
        if (null != STROKE) {
            ((Path)((Group)SERIES.getNode()).getChildren().get(1)).setStroke(STROKE);
        }
        if (null != SYMBOL_BACKGROUND) {
            this.setSymbolFill(SERIES, SYMBOL_BACKGROUND);
        }
    }

    public Dimension2D getSymbolSize(XYChart.Series<X, Y> SERIES) {
        if (!this.getData().contains(SERIES)) {
            return new Dimension2D(0.0, 0.0);
        }
        if (SERIES.getData().isEmpty()) {
            return new Dimension2D(0.0, 0.0);
        }
        for (XYChart.Data data : SERIES.getData()) {
            StackPane stackPane = (StackPane)data.getNode();
            if (null == stackPane) continue;
            return new Dimension2D(stackPane.getLayoutBounds().getWidth(), stackPane.getLayoutBounds().getHeight());
        }
        return new Dimension2D(0.0, 0.0);
    }

    public void setSymbolSize(XYChart.Series<X, Y> SERIES, double SIZE) {
        if (!this.getData().contains(SERIES)) {
            return;
        }
        if (SERIES.getData().isEmpty()) {
            return;
        }
        double symbolSize = Helper.clamp(0.0, 30.0, SIZE);
        for (XYChart.Data data : SERIES.getData()) {
            StackPane stackPane = (StackPane)data.getNode();
            if (null == stackPane) continue;
            stackPane.setPrefSize(symbolSize, symbolSize);
        }
    }

    public void setSymbolFill(XYChart.Series<X, Y> SERIES, Background SYMBOL_BACKGROUND) {
        if (!this.getData().contains(SERIES)) {
            return;
        }
        for (XYChart.Data data : SERIES.getData()) {
            StackPane stackPane = (StackPane)data.getNode();
            if (null == stackPane) continue;
            stackPane.setBackground(SYMBOL_BACKGROUND);
        }
    }

    public Region getChartPlotBackground() {
        if (null == this.chartPlotBackground) {
            for (Node node : this.lookupAll(".chart-plot-background")) {
                if (!(node instanceof Region)) continue;
                this.chartPlotBackground = (Region)node;
                break;
            }
        }
        return this.chartPlotBackground;
    }

    public Path getHorizontalGridLines() {
        if (null == this.horizontalGridLines) {
            for (Node node : this.lookupAll(".chart-horizontal-grid-lines")) {
                if (!(node instanceof Path)) continue;
                this.horizontalGridLines = (Path)node;
                break;
            }
        }
        return this.horizontalGridLines;
    }

    public Path getVerticalGridLines() {
        if (null == this.verticalGridLines) {
            for (Node node : this.lookupAll(".chart-vertical-grid-lines")) {
                if (!(node instanceof Path)) continue;
                this.verticalGridLines = (Path)node;
                break;
            }
        }
        return this.verticalGridLines;
    }

    public Line getHorizontalZeroLine() {
        if (null == this.horizontalZeroLine) {
            for (Node node : this.lookupAll(".chart-horizontal-zero-line")) {
                if (!(node instanceof Line)) continue;
                this.horizontalZeroLine = (Line)node;
                break;
            }
        }
        return this.horizontalZeroLine;
    }

    public Line getVerticalZeroLine() {
        if (null == this.verticalZeroLine) {
            for (Node node : this.lookupAll(".chart-vertical-zero-line")) {
                if (!(node instanceof Line)) continue;
                this.verticalZeroLine = (Line)node;
                break;
            }
        }
        return this.verticalZeroLine;
    }

    public void setChartPlotBackground(Paint FILL) {
        this.setChartPlotBackground(new Background(new BackgroundFill[]{new BackgroundFill(FILL, CornerRadii.EMPTY, Insets.EMPTY)}));
    }

    public void setChartPlotBackground(Background BACKGROUND) {
        this.getChartPlotBackground().setBackground(BACKGROUND);
    }

    public Group getChartPlotContent() {
        for (Node node : this.lookupAll(".plot-content")) {
            if (!(node instanceof Group)) continue;
            return (Group)node;
        }
        return null;
    }

    public void setXAxisTickMarkFill(Paint FILL) {
        for (Node node : this.getXAxis().lookupAll(".axis-tick-mark")) {
            if (!(node instanceof Path)) continue;
            ((Path)node).setStroke(FILL);
            break;
        }
    }

    public void setYAxisTickMarkFill(Paint FILL) {
        for (Node node : this.getYAxis().lookupAll(".axis-tick-mark")) {
            if (!(node instanceof Path)) continue;
            ((Path)node).setStroke(FILL);
            break;
        }
        for (Node node : this.getYAxis().lookupAll(".axis-minor-tick-mark")) {
            if (!(node instanceof Path)) continue;
            ((Path)node).setStroke(FILL);
            break;
        }
    }

    public void setAxisTickMarkFill(Paint FILL) {
        this.setXAxisTickMarkFill(FILL);
        this.setYAxisTickMarkFill(FILL);
    }

    public void setXAxisTickLabelFill(Paint FILL) {
        this.getXAxis().setTickLabelFill(FILL);
    }

    public void setYAxisTickLabelFill(Paint FILL) {
        this.getYAxis().setTickLabelFill(FILL);
    }

    public void setTickLabelFill(Paint FILL) {
        this.setXAxisTickLabelFill(FILL);
        this.setYAxisTickLabelFill(FILL);
    }

    public void setXAxisBorderColor(Paint FILL) {
        if (Side.BOTTOM == this.getXAxis().getSide()) {
            this.getXAxis().setBorder(new Border(new BorderStroke[]{new BorderStroke(FILL, (Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderStroke.DEFAULT_WIDTHS, Insets.EMPTY)}));
        } else {
            this.getXAxis().setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, FILL, (Paint)Color.TRANSPARENT, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderStroke.DEFAULT_WIDTHS, Insets.EMPTY)}));
        }
    }

    public void setYAxisBorderColor(Paint FILL) {
        if (Side.LEFT == this.getYAxis().getSide()) {
            this.getYAxis().setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.TRANSPARENT, FILL, (Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderStroke.DEFAULT_WIDTHS, Insets.EMPTY)}));
        } else {
            this.getYAxis().setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, FILL, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderStroke.DEFAULT_WIDTHS, Insets.EMPTY)}));
        }
    }

    public Path getFillPath(XYChart.Series<X, Y> SERIES) {
        return this.getPaths(SERIES)[0];
    }

    public Path getStrokePath(XYChart.Series<X, Y> SERIES) {
        return this.getPaths(SERIES)[1];
    }

    public List<StackPane> getSymbols(XYChart.Series<X, Y> SERIES) {
        return SERIES.getData().stream().map(node -> (StackPane)node.getNode()).collect(Collectors.toList());
    }

    public void dispose() {
        this.getData().removeListener(this.seriesListener);
    }

    protected void layoutPlotChildren() {
        super.layoutPlotChildren();
        double height = this.getLayoutBounds().getHeight();
        this.getData().forEach(series -> {
            Path[] paths = this.getPaths((XYChart.Series<X, Y>)series);
            if (null == paths) {
                return;
            }
            if (this.isSmoothed()) {
                this.smooth((ObservableList<PathElement>)paths[1].getElements(), (ObservableList<PathElement>)paths[0].getElements(), height);
            }
            paths[0].setVisible(ChartType.AREA == this.getChartType());
            paths[0].setManaged(ChartType.AREA == this.getChartType());
        });
    }

    private Path[] getPaths(XYChart.Series<X, Y> SERIES) {
        if (!this.getData().contains(SERIES)) {
            return null;
        }
        Node seriesNode = SERIES.getNode();
        if (null == seriesNode) {
            return null;
        }
        Group seriesGroup = (Group)seriesNode;
        if (seriesGroup.getChildren().isEmpty() || seriesGroup.getChildren().size() < 2) {
            return null;
        }
        return new Path[]{(Path)seriesGroup.getChildren().get(0), (Path)seriesGroup.getChildren().get(1)};
    }

    private void resizeSelector() {
        this.selectorTooltip.hide();
        this.selector.setVisible(false);
        this.selector.setRadius(this.getSelectorSize() * 0.5);
        this.selector.setStrokeWidth(this.getSelectorSize() * 0.25);
    }

    private void select(MouseEvent EVT) {
        if (!this.isInteractive()) {
            return;
        }
        double EVENT_X = EVT.getX();
        double EVENT_Y = EVT.getY();
        double CHART_X = this.chartPlotBackground.getBoundsInParent().getMinX();
        double CHART_MIN_Y = this.chartPlotBackground.getBoundsInParent().getMinY();
        double CHART_HEIGHT = this.chartPlotBackground.getBoundsInParent().getHeight();
        if (!(this.getYAxis() instanceof NumberAxis)) {
            return;
        }
        double upperBound = ((NumberAxis)this.getYAxis()).getUpperBound();
        double lowerBound = ((NumberAxis)this.getYAxis()).getLowerBound();
        double range = upperBound - lowerBound;
        double factor = range / this.getYAxis().getLayoutBounds().getHeight();
        List elements = null;
        int noOfElements = 0;
        Bounds pathBounds = null;
        double pathMinX = 0.0;
        double pathWidth = 0.0;
        PathElement lastElement = null;
        XYChart.Series series = null;
        for (XYChart.Series s : this.getData()) {
            int type;
            Path[] paths = this.getPaths(s);
            if (!paths[type = this.getChartType().ordinal()].contains(EVENT_X, EVENT_Y)) continue;
            series = s;
            elements = paths[type].getElements();
            noOfElements = elements.size();
            lastElement = (PathElement)elements.get(0);
            pathBounds = paths[1].getLayoutBounds();
            pathMinX = pathBounds.getMinX();
            pathWidth = pathBounds.getWidth();
            break;
        }
        if (null == series || series.getData().isEmpty()) {
            return;
        }
        if (this.isSnapToTicks()) {
            double reverseFactor = CHART_HEIGHT / range;
            int noOfDataElements = series.getData().size();
            double interval = pathWidth / (double)(noOfDataElements - 1);
            int selectedIndex = Helper.roundDoubleToInt((EVENT_X - pathMinX) / interval);
            XYChart.Data selectedData = (XYChart.Data)series.getData().get(selectedIndex);
            Object selectedYValue = selectedData.getYValue();
            if (!(selectedYValue instanceof Number)) {
                return;
            }
            double selectedValue = ((Number)selectedYValue).doubleValue();
            this.selector.setCenterX(pathMinX + CHART_X + interval * (double)selectedIndex);
            this.selector.setCenterY(CHART_MIN_Y + CHART_HEIGHT - selectedValue * reverseFactor);
            this.selector.setVisible(true);
            this.fadeInFadeOut.playFrom(Duration.millis((double)0.0));
            Point2D tooltipLocation = this.selector.localToScreen(this.selector.getCenterX(), this.selector.getCenterY());
            String tooltipText = selectedData.getXValue().toString() + "\n" + selectedData.getYValue();
            this.selectorTooltip.setText(tooltipText);
            this.selectorTooltip.setX(tooltipLocation.getX());
            this.selectorTooltip.setY(tooltipLocation.getY());
            this.selectorTooltip.show(this.getScene().getWindow());
            this.fireEvent(new SmoothedChartEvent((Object)this, null, SmoothedChartEvent.DATA_SELECTED, selectedValue));
        } else {
            for (int i = 1; i < noOfElements; ++i) {
                PathElement element = (PathElement)elements.get(i);
                double[] xy = this.getXYFromPathElement(lastElement);
                double[] xy1 = this.getXYFromPathElement(element);
                if (xy[0] < 0.0 || xy[1] < 0.0 || xy1[0] < 0.0 || xy1[1] < 0.0) continue;
                if (EVENT_X > xy[0] && EVENT_X < xy1[0]) {
                    double deltaX = xy1[0] - xy[0];
                    double deltaY = xy1[1] - xy[1];
                    double m = deltaY / deltaX;
                    double y = m * (EVT.getX() - xy[0]) + xy[1];
                    double selectedValue = (this.getYAxis().getLayoutBounds().getHeight() - y) * factor + lowerBound;
                    this.selector.setCenterX(CHART_X + EVT.getX());
                    this.selector.setCenterY(CHART_MIN_Y + y);
                    this.selector.setVisible(true);
                    this.fadeInFadeOut.playFrom(Duration.millis((double)0.0));
                    Point2D tooltipLocation = this.selector.localToScreen(this.selector.getCenterX(), this.selector.getCenterY());
                    String tooltipText = String.format(Locale.US, this.formatString, selectedValue);
                    this.selectorTooltip.setText(tooltipText);
                    this.selectorTooltip.setX(tooltipLocation.getX());
                    this.selectorTooltip.setY(tooltipLocation.getY());
                    this.selectorTooltip.show(this.getScene().getWindow());
                    this.fireEvent(new SmoothedChartEvent((Object)this, null, SmoothedChartEvent.DATA_SELECTED, selectedValue));
                    break;
                }
                lastElement = element;
            }
        }
    }

    private void smooth(ObservableList<PathElement> strokeElements, ObservableList<PathElement> fillElements, double HEIGHT) {
        if (fillElements.isEmpty()) {
            return;
        }
        Point[] dataPoints = new Point[strokeElements.size()];
        for (int i = 0; i < strokeElements.size(); ++i) {
            PathElement element = (PathElement)strokeElements.get(i);
            if (element instanceof MoveTo) {
                MoveTo move = (MoveTo)element;
                dataPoints[i] = new Point(move.getX(), move.getY());
                continue;
            }
            if (!(element instanceof LineTo)) continue;
            LineTo line = (LineTo)element;
            double x = line.getX();
            double y = line.getY();
            dataPoints[i] = new Point(x, y);
        }
        double firstX = dataPoints[0].getX();
        double lastX = dataPoints[dataPoints.length - 1].getX();
        Point[] points = Helper.subdividePoints(dataPoints, this.getSubDivisions());
        fillElements.clear();
        fillElements.add((Object)new MoveTo(firstX, HEIGHT));
        strokeElements.clear();
        strokeElements.add((Object)new MoveTo(points[0].getX(), points[0].getY()));
        for (Point p : points) {
            if (Double.compare(p.getX(), firstX) < 0) continue;
            fillElements.add((Object)new LineTo(p.getX(), p.getY()));
            strokeElements.add((Object)new LineTo(p.getX(), p.getY()));
        }
        fillElements.add((Object)new LineTo(lastX, HEIGHT));
        fillElements.add((Object)new LineTo(0.0, HEIGHT));
        fillElements.add((Object)new ClosePath());
    }

    private double[] getXYFromPathElement(PathElement ELEMENT) {
        if (ELEMENT instanceof MoveTo) {
            return new double[]{((MoveTo)ELEMENT).getX(), ((MoveTo)ELEMENT).getY()};
        }
        if (ELEMENT instanceof LineTo) {
            return new double[]{((LineTo)ELEMENT).getX(), ((LineTo)ELEMENT).getY()};
        }
        return new double[]{-1.0, -1.0};
    }

    public static enum ChartType {
        AREA,
        LINE;

    }
}

