/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.events.TileEvent;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.CtxBounds;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class ClusterMonitorTileSkin
extends TileSkin {
    private static final double MIN_HEIGHT = 100.0;
    private final TileEvent SVG_PRESSED_EVENT = new TileEvent(TileEvent.EventType.SVG_PATH_PRESSED);
    private Text titleText;
    private Text text;
    private VBox chartPane;
    private ChartDataEventListener updateHandler;
    private InvalidationListener paneSizeListener;
    private Map<ChartData, ChartItem> dataItemMap;
    private Region graphicRegion;
    private EventHandler<MouseEvent> svgPathPressedHandler;

    public ClusterMonitorTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.updateHandler = e -> {
            switch (e.getType()) {
                case UPDATE: {
                    this.updateChart();
                    break;
                }
                case FINISHED: {
                    this.updateChart();
                }
            }
        };
        this.paneSizeListener = e -> this.updateChart();
        this.dataItemMap = new HashMap<ChartData, ChartItem>();
        this.chartPane = new VBox();
        Collections.sort(this.tile.getChartData(), Comparator.comparing(ChartData::getName));
        this.tile.getChartData().forEach(data -> {
            data.addChartDataEventListener(this.updateHandler);
            this.dataItemMap.put((ChartData)data, new ChartItem((ChartData)data, this.contentBounds, data.getFormatString()));
            this.chartPane.getChildren().add((Object)((Node)this.dataItemMap.get(data)));
        });
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        SVGPath svgPath = this.tile.getSVGPath();
        if (null != svgPath) {
            this.svgPathPressedHandler = e -> this.tile.fireTileEvent(this.SVG_PRESSED_EVENT);
            this.graphicRegion = new Region();
            this.graphicRegion.setShape((Shape)svgPath);
            this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.text, this.chartPane, this.graphicRegion});
        } else {
            this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.text, this.chartPane});
        }
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.getChartData().addListener((ListChangeListener)new WeakListChangeListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(addedData -> {
                        addedData.addChartDataEventListener(this.updateHandler);
                        this.dataItemMap.put((ChartData)addedData, new ChartItem((ChartData)addedData, this.contentBounds));
                    });
                    continue;
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(removedData -> {
                    removedData.removeChartDataEventListener(this.updateHandler);
                    this.dataItemMap.remove(removedData);
                });
            }
            this.chartPane.getChildren().clear();
            this.dataItemMap.entrySet().forEach(entry -> this.chartPane.getChildren().add((Object)((Node)entry.getValue())));
            this.updateChart();
        }));
        if (null != this.tile.getSVGPath()) {
            this.graphicRegion.addEventHandler(MouseEvent.MOUSE_PRESSED, this.svgPathPressedHandler);
        }
        this.pane.widthProperty().addListener(this.paneSizeListener);
        this.pane.heightProperty().addListener(this.paneSizeListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            if (null != this.graphicRegion) {
                Helper.enableNode((Node)this.graphicRegion, this.tile.isTextVisible());
            }
        } else if ("DATA".equals(EVENT_TYPE)) {
            this.updateChart();
        }
    }

    @Override
    public void dispose() {
        this.pane.widthProperty().removeListener(this.paneSizeListener);
        this.pane.heightProperty().removeListener(this.paneSizeListener);
        this.tile.getBarChartItems().forEach(item -> item.removeChartDataEventListener(this.updateHandler));
        if (null != this.tile.getSVGPath()) {
            this.graphicRegion.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.svgPathPressedHandler);
        }
        this.dataItemMap.clear();
        super.dispose();
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.chartPane.setPrefSize(this.width * 0.8, this.contentBounds.getHeight());
        this.chartPane.relocate(this.contentBounds.getX(), this.contentBounds.getY());
        this.chartPane.setSpacing(this.contentBounds.getHeight() * 0.25);
        double itemHeight = this.contentBounds.getHeight() / (double)this.dataItemMap.size();
        this.dataItemMap.values().forEach(item -> {
            item.setCompressed(this.height < 100.0);
            item.setPrefSize(this.contentBounds.getWidth(), itemHeight);
            item.setLayoutX(this.contentBounds.getX());
        });
        int noOfChartData = this.tile.getChartData().size();
        if (this.titleText.getText().isEmpty()) {
            this.chartPane.setSpacing(this.contentBounds.getHeight() - (double)noOfChartData * itemHeight);
        } else {
            this.chartPane.setSpacing((this.contentBounds.getHeight() - (double)noOfChartData * itemHeight) / 1.5);
        }
        if (null != this.graphicRegion) {
            double prefGraphicSize = 0.05 * this.size;
            this.graphicRegion.setMinSize(prefGraphicSize, prefGraphicSize);
            this.graphicRegion.setMaxSize(prefGraphicSize, prefGraphicSize);
            this.graphicRegion.setPrefSize(prefGraphicSize, prefGraphicSize);
            switch (this.tile.getTextAlignment()) {
                default: {
                    this.graphicRegion.relocate(this.width - this.size * 0.05 - prefGraphicSize, this.height - this.size * 0.05 - prefGraphicSize);
                    break;
                }
                case RIGHT: {
                    this.graphicRegion.relocate(this.size * 0.05, this.height - this.size * 0.05 - prefGraphicSize);
                }
            }
        }
        this.updateChart();
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        if (null != this.graphicRegion) {
            this.graphicRegion.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.tile.getSVGPath().getFill(), CornerRadii.EMPTY, Insets.EMPTY)}));
        }
    }

    private void updateChart() {
        int noOfItems = this.dataItemMap.size();
        if (noOfItems == 0) {
            return;
        }
        for (int i = 0; i < noOfItems; ++i) {
            ChartData item = this.dataItemMap.keySet().iterator().next();
            this.dataItemMap.get(item).update();
            if (i > 1) break;
        }
    }

    private class ChartItem
    extends Region {
        private static final double PREF_WIDTH = 100.0;
        private static final double PREF_HEIGHT = 95.0;
        private ChartData chartData;
        private CtxBounds contentBounds;
        private Label title;
        private Label value;
        private Rectangle scale;
        private Rectangle bar;
        private String formatString;
        private double step;
        private boolean compressed;
        private ChartDataEventListener chartDataListener;

        public ChartItem(ChartData CHART_DATA, CtxBounds CONTENT_BOUNDS) {
            this(CHART_DATA, CONTENT_BOUNDS, "%.0f%%");
        }

        public ChartItem(ChartData CHART_DATA, CtxBounds CONTENT_BOUNDS, String FORMAT_STRING) {
            this.chartData = CHART_DATA;
            this.contentBounds = CONTENT_BOUNDS;
            this.title = new Label(this.chartData.getName());
            this.value = new Label(String.format(Locale.US, FORMAT_STRING, this.chartData.getValue()));
            this.scale = new Rectangle(0.0, 0.0);
            this.bar = new Rectangle(0.0, 0.0);
            this.formatString = FORMAT_STRING;
            this.step = 100.0 / (CHART_DATA.getMaxValue() - CHART_DATA.getMinValue());
            this.compressed = false;
            this.chartDataListener = e -> {
                switch (e.getType()) {
                    case UPDATE: {
                        this.update();
                        break;
                    }
                    case FINISHED: {
                        this.update();
                    }
                }
            };
            this.initGraphics();
            this.registerListeners();
        }

        private void initGraphics() {
            this.setPrefSize(this.contentBounds.getWidth(), this.contentBounds.getHeight() * 0.2375);
            Font font = Fonts.latoRegular(Helper.clamp(1.0, 48.0, this.getPrefHeight() * 0.50526316));
            this.title.setFont(font);
            this.title.setTextFill((Paint)this.chartData.getTextColor());
            this.title.setAlignment(Pos.CENTER_LEFT);
            this.value.setFont(font);
            this.value.setTextFill((Paint)this.chartData.getTextColor());
            this.value.setAlignment(Pos.CENTER_RIGHT);
            this.scale.setFill((Paint)Color.rgb((int)90, (int)90, (int)90));
            this.bar.setFill((Paint)this.chartData.getFillColor());
            this.getChildren().addAll((Object[])new Node[]{this.scale, this.bar, this.title, this.value});
        }

        private void registerListeners() {
            this.chartData.addChartDataEventListener(this.chartDataListener);
            this.widthProperty().addListener(o -> this.resize());
            this.heightProperty().addListener(o -> this.resize());
        }

        public String getFormatString() {
            return this.formatString;
        }

        public void setFormatString(String FORMAT_STRING) {
            this.formatString = FORMAT_STRING;
            this.update();
        }

        public boolean isCompressed() {
            return this.compressed;
        }

        public void setCompressed(boolean COMPRESSED) {
            this.compressed = COMPRESSED;
            Helper.enableNode((Node)this.scale, !this.compressed);
            this.resize();
        }

        public void update() {
            this.value.setText(String.format(Locale.US, this.formatString, this.chartData.getValue()));
            this.bar.setWidth(this.chartData.getValue() * this.step);
            if (ClusterMonitorTileSkin.this.tile.isFillWithGradient() && null != this.chartData.getGradientLookup()) {
                this.bar.setFill((Paint)this.chartData.getGradientLookup().getColorAt(this.chartData.getValue() / (this.chartData.getMaxValue() - this.chartData.getMinValue())));
            } else {
                this.bar.setFill((Paint)this.chartData.getFillColor());
            }
            if (this.compressed) {
                this.title.setTextFill((Paint)(this.bar.getWidth() > ClusterMonitorTileSkin.this.width * 0.2 ? ClusterMonitorTileSkin.this.tile.getBackgroundColor() : this.chartData.getTextColor()));
                this.value.setTextFill((Paint)(this.bar.getWidth() > ClusterMonitorTileSkin.this.width * 0.8 ? ClusterMonitorTileSkin.this.tile.getBackgroundColor() : this.chartData.getTextColor()));
            } else {
                this.title.setTextFill((Paint)this.chartData.getTextColor());
                this.value.setTextFill((Paint)this.chartData.getTextColor());
            }
        }

        public void dispose() {
            this.chartData.removeChartDataEventListener(this.chartDataListener);
        }

        private void resize() {
            double width = this.getPrefWidth();
            double height = this.getPrefHeight();
            this.step = width / (this.chartData.getMaxValue() - this.chartData.getMinValue());
            double textWidth = width * 0.5;
            double textHeight = height * 0.13;
            this.title.setPrefSize(textWidth, textHeight);
            this.value.setPrefSize(textWidth, textHeight);
            Font font = Fonts.latoRegular(Helper.clamp(1.0, 48.0, this.getPrefHeight() * (this.compressed ? 0.5 : 0.35)));
            this.title.setFont(font);
            this.value.setFont(font);
            this.title.setLayoutX(0.0);
            this.value.setLayoutX(width * 0.5);
            this.bar.setX(0.0);
            if (this.compressed) {
                this.bar.setY(height * 0.05);
                this.bar.setHeight(height * 0.9);
                this.value.setLayoutY((height - font.getSize()) * 0.5);
                this.title.setLayoutY((height - font.getSize()) * 0.5);
            } else {
                this.bar.setY(this.title.getLayoutY() + font.getSize() + height * 0.12);
                this.bar.setHeight(height * 0.35);
                this.value.setLayoutY(0.0);
                this.title.setLayoutY(0.0);
            }
            this.bar.setWidth(this.chartData.getValue() * this.step);
            this.scale.setX(0.0);
            this.scale.setWidth(width);
            this.scale.setHeight(height * 0.05263158);
            this.scale.setY(this.bar.getY() + (this.bar.getHeight() - this.scale.getHeight()) * 0.5);
            this.update();
        }
    }
}

