/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.TileEvent;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Country;
import eu.hansolo.tilesfx.tools.CountryPath;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class CountryTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private Text valueText;
    private Text upperUnitText;
    private Line fractionLine;
    private Text unitText;
    private VBox unitFlow;
    private HBox valueUnitFlow;
    private Country country;
    private StackPane countryContainer;
    private Group countryGroup;
    private EventHandler<MouseEvent> clickHandler;
    private List<CountryPath> countryPaths;
    private double countryMinX;
    private double countryMinY;
    private double countryMaxX;
    private double countryMaxY;

    public CountryTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.country = this.tile.getCountry();
        if (null == this.country) {
            this.country = Country.DE;
        }
        this.clickHandler = event -> this.tile.fireTileEvent(new TileEvent(TileEvent.EventType.SELECTED_CHART_DATA, new ChartData(this.country.getName(), this.country.getValue(), this.country.getColor())));
        this.countryPaths = Helper.getHiresCountryPaths().get(this.country.name());
        this.countryMinX = 1007.9609816074371;
        this.countryMinY = 665.242f;
        this.countryMaxX = 0.0;
        this.countryMaxY = 0.0;
        this.countryPaths.forEach(path -> {
            path.setFill((Paint)this.tile.getBarColor());
            this.countryMinX = Math.min(this.countryMinX, path.getBoundsInParent().getMinX());
            this.countryMinY = Math.min(this.countryMinY, path.getBoundsInParent().getMinY());
            this.countryMaxX = Math.max(this.countryMaxX, path.getBoundsInParent().getMaxX());
            this.countryMaxY = Math.max(this.countryMaxY, path.getBoundsInParent().getMaxY());
        });
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getCountry().getDisplayName());
        this.text.setFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.countryGroup = new Group();
        this.countryGroup.getChildren().setAll(this.countryPaths);
        this.countryContainer = new StackPane();
        this.countryContainer.setMinSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.countryContainer.setMaxSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.countryContainer.setPrefSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.countryContainer.getChildren().setAll((Object[])new Node[]{this.countryGroup});
        this.valueText = new Text(String.format(this.locale, this.formatString, (this.tile.getValue() - this.minValue) / this.range * 100.0));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.valueText.setTextOrigin(VPos.BASELINE);
        Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
        this.upperUnitText = new Text("");
        this.upperUnitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.upperUnitText, !this.tile.getUnit().isEmpty());
        this.fractionLine = new Line();
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.unitFlow = new VBox(new Node[]{this.upperUnitText, this.unitText});
        this.unitFlow.setAlignment(Pos.CENTER_RIGHT);
        this.valueUnitFlow = new HBox(new Node[]{this.valueText, this.unitFlow});
        this.valueUnitFlow.setAlignment(Pos.BOTTOM_RIGHT);
        this.valueUnitFlow.setMouseTransparent(true);
        this.valueUnitFlow.setMouseTransparent(true);
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.countryContainer, this.valueUnitFlow, this.fractionLine, this.text});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.addEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
            Helper.enableNode((Node)this.unitFlow, !this.tile.getUnit().isEmpty());
            this.countryContainer.setMaxSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.68 : this.size * 0.795);
            this.countryContainer.setPrefSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.68 : this.size * 0.795);
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.country = this.tile.getCountry();
            if (null == this.country) {
                this.country = Country.DE;
            }
            this.countryPaths = Helper.getHiresCountryPaths().get(this.country.name());
            this.countryPaths.forEach(path -> path.setFill((Paint)this.tile.getBarColor()));
            this.countryGroup.getChildren().setAll(this.countryPaths);
            this.text.setText(this.country.getDisplayName());
            this.resize();
            this.redraw();
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(VALUE));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        }
        this.resizeDynamicText();
    }

    @Override
    public void dispose() {
        this.tile.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
        super.dispose();
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
        maxWidth = this.width - (this.width - this.size * 0.275);
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.upperUnitText.setFont(Fonts.latoRegular(fontSize));
        if (this.upperUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.upperUnitText, maxWidth, fontSize);
        }
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resize() {
        double countrySize;
        super.resize();
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        this.size = this.width < this.height ? this.width : this.height;
        this.valueUnitFlow.setPrefWidth(this.width - this.size * 0.1);
        this.valueUnitFlow.relocate(this.size * 0.05, this.contentBounds.getY());
        this.valueUnitFlow.setMaxHeight(this.valueText.getFont().getSize());
        this.fractionLine.setStartX(this.width - 0.17 * this.size);
        this.fractionLine.setStartY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setEndX(this.width - 0.05 * this.size);
        this.fractionLine.setEndY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setStroke((Paint)this.tile.getUnitColor());
        this.fractionLine.setStrokeWidth(this.size * 0.005);
        this.unitFlow.setTranslateY(-this.size * 0.005);
        double containerWidth = this.contentBounds.getWidth();
        double containerHeight = this.contentBounds.getHeight();
        double containerSize = containerWidth < containerHeight ? containerWidth : containerHeight;
        double countryWidth = this.countryGroup.getLayoutBounds().getWidth();
        double countryHeight = this.countryGroup.getLayoutBounds().getHeight();
        double d = countrySize = countryWidth < countryHeight ? countryHeight : countryWidth;
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            if (containerWidth > 0.0 && containerHeight > 0.0) {
                this.countryContainer.setMinSize(containerWidth, containerHeight);
                this.countryContainer.setMaxSize(containerWidth, containerHeight);
                this.countryContainer.setPrefSize(containerWidth, containerHeight);
                this.countryContainer.relocate(this.contentBounds.getX(), this.contentBounds.getY());
                double scaleFactor = containerSize / countrySize;
                this.countryGroup.setScaleX(scaleFactor);
                this.countryGroup.setScaleY(scaleFactor);
            }
            this.resizeStaticText();
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getCountry().getDisplayName());
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(this.tile.getCurrentValue()));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, this.tile.getCurrentValue()));
        }
        if (this.tile.getUnit().contains("/")) {
            String[] units = this.tile.getUnit().split("/");
            this.upperUnitText.setText(units[0]);
            this.unitText.setText(units[1]);
            Helper.enableNode((Node)this.fractionLine, true);
        } else {
            this.upperUnitText.setText(" ");
            this.unitText.setText(this.tile.getUnit());
            Helper.enableNode((Node)this.fractionLine, false);
        }
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.upperUnitText.setFill((Paint)this.tile.getUnitColor());
        this.fractionLine.setStroke((Paint)this.tile.getUnitColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        this.countryPaths.forEach(path -> path.setFill((Paint)Helper.getColorWithOpacity(this.tile.getBarColor(), 0.5)));
    }
}

