/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.TileEvent;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.AngleConicalGradient;
import eu.hansolo.tilesfx.tools.GradientLookup;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.HashMap;
import java.util.List;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class Gauge2TileSkin
extends TileSkin {
    private double angleRange;
    private double angleStep;
    private double oldValue;
    private Circle knob;
    private Arc barBackground;
    private Arc bar;
    private Path needle;
    private Rotate needleRotate;
    private Rotate needleRectRotate;
    private Text titleText;
    private Text text;
    private Text valueText;
    private Text unitText;
    private TextFlow valueUnitFlow;
    private Text minValueText;
    private Text maxValueText;
    private Color barBackgroundColor;
    private GradientLookup gradientLookup;
    private AngleConicalGradient conicalGradient;
    private Rectangle barBounds;

    public Gauge2TileSkin(Tile TILE) {
        super(TILE);
        this.handleCurrentValue(this.tile.getValue());
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.angleRange = this.tile.getAngleRange();
        this.angleStep = this.tile.getAngleStep();
        if (this.tile.isAutoScale()) {
            this.tile.calcAutoScale();
        }
        this.oldValue = this.tile.getValue();
        this.barBackgroundColor = this.tile.getBarBackgroundColor();
        this.gradientLookup = new GradientLookup(this.tile.getGradientStops());
        this.knob = new Circle();
        this.barBackground = new Arc(125.0, 174.0, 68.75, 68.75, this.angleRange * 0.5 + 90.0, -this.angleRange);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)this.barBackgroundColor);
        this.barBackground.setStrokeWidth(14.097745);
        this.barBackground.setStrokeLineCap(StrokeLineCap.ROUND);
        this.barBackground.setFill(null);
        this.bar = new Arc(125.0, 174.0, 68.75, 68.75, this.angleRange * 0.5 + 90.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStrokeWidth(14.097745);
        this.bar.setStrokeLineCap(StrokeLineCap.ROUND);
        this.bar.setFill(null);
        this.barBounds = new Rectangle();
        this.createConicalGradient();
        this.needleRotate = new Rotate((this.tile.getValue() - this.oldValue - this.minValue) * this.angleStep);
        this.needleRectRotate = new Rotate((this.tile.getValue() - this.oldValue - this.minValue) * this.angleStep);
        this.needle = new Path();
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needle.setFill((Paint)this.tile.getNeedleColor());
        this.needle.setStrokeWidth(0.0);
        this.needle.setStroke((Paint)Color.TRANSPARENT);
        this.titleText = new Text(this.tile.getTitle());
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, this.tile.getCurrentValue()));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        Helper.enableNode((Node)this.valueText, this.tile.isValueVisible() && !this.tile.isAlert());
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.valueUnitFlow = new TextFlow(new Node[]{this.valueText, this.unitText});
        this.valueUnitFlow.setTextAlignment(TextAlignment.CENTER);
        this.minValueText = new Text(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", this.tile.getMinValue()));
        this.minValueText.setFill((Paint)this.tile.getTitleColor());
        this.minValueText.setTextOrigin(VPos.CENTER);
        this.maxValueText = new Text(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", this.tile.getMaxValue()));
        this.maxValueText.setFill((Paint)this.tile.getTitleColor());
        this.maxValueText.setTextOrigin(VPos.CENTER);
        this.text = new Text(this.tile.getText());
        this.text.setTextOrigin(VPos.TOP);
        this.text.setFill((Paint)this.tile.getTextColor());
        this.getPane().getChildren().addAll((Object[])new Node[]{this.knob, this.barBackground, this.bar, this.needle, this.titleText, this.valueUnitFlow, this.minValueText, this.maxValueText, this.text});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (TileEvent.EventType.VISIBILITY.name().equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
            Helper.enableNode((Node)this.valueUnitFlow, !this.tile.getUnit().isEmpty());
            Helper.enableNode((Node)this.minValueText, this.tile.getMinValueVisible());
            Helper.enableNode((Node)this.maxValueText, this.tile.getMaxValueVisible());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        double needleStartAngle = this.angleRange * 0.5;
        double targetAngle = (VALUE - this.minValue) * this.angleStep - needleStartAngle;
        targetAngle = Helper.clamp(-needleStartAngle, -needleStartAngle + this.angleRange, targetAngle);
        this.needleRotate.setAngle(targetAngle);
        this.needleRectRotate.setAngle(targetAngle);
        this.bar.setLength(-this.angleStep * VALUE);
        if (this.tile.isStrokeWithGradient()) {
            this.needle.setFill((Paint)this.gradientLookup.getColorAt(VALUE / this.tile.getRange()));
            this.bar.setStroke((Paint)this.conicalGradient.getImagePattern(this.barBounds));
        } else {
            this.needle.setFill((Paint)this.tile.getNeedleColor());
            this.bar.setStroke((Paint)this.tile.getBarColor());
        }
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(VALUE));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        }
        this.resizeDynamicText();
    }

    private void drawNeedle() {
        double needleWidth = this.size * 0.04536638;
        double needleHeight = this.size * 0.23706897;
        this.needle.setCache(false);
        this.needle.getElements().clear();
        this.needle.getElements().add((Object)new MoveTo(needleWidth * 0.813182897862233, needleHeight * 0.227272727272727));
        this.needle.getElements().add((Object)new CubicCurveTo(needleWidth * 0.754441805225653, needleHeight * 0.0743545454545455, needleWidth * 0.788052256532067, needleHeight * 0.0, needleWidth * 0.499643705463183, needleHeight * 0.0));
        this.needle.getElements().add((Object)new CubicCurveTo(needleWidth * 0.211235154394299, needleHeight * 0.0, needleWidth * 0.248907363420428, needleHeight * 0.0741090909090909, needleWidth * 0.186104513064133, needleHeight * 0.227272727272727));
        this.needle.getElements().add((Object)new LineTo(needleWidth * 8.31353919239905E-4, needleHeight * 0.886363636363636));
        this.needle.getElements().add((Object)new CubicCurveTo(needleWidth * -0.0155581947743468, needleHeight * 0.978604545454545, needleWidth * 0.211235154394299, needleHeight * 1.0, needleWidth * 0.499643705463183, needleHeight * 1.0));
        this.needle.getElements().add((Object)new CubicCurveTo(needleWidth * 0.788052256532067, needleHeight * 1.0, needleWidth * 1.0253919239905, needleHeight * 0.976459090909091, needleWidth * 0.998456057007126, needleHeight * 0.886363636363636));
        this.needle.getElements().add((Object)new LineTo(needleWidth * 0.813182897862233, needleHeight * 0.227272727272727));
        this.needle.getElements().add((Object)new ClosePath());
        this.needle.getElements().add((Object)new MoveTo(needleWidth * 0.552826603325416, needleHeight * 0.854286363636364));
        this.needle.getElements().add((Object)new CubicCurveTo(needleWidth * 0.536223277909739, needleHeight * 0.852981818181818, needleWidth * 0.518313539192399, needleHeight * 0.852272727272727, needleWidth * 0.499643705463183, needleHeight * 0.852272727272727));
        this.needle.getElements().add((Object)new CubicCurveTo(needleWidth * 0.480237529691211, needleHeight * 0.852272727272727, needleWidth * 0.46166270783848, needleHeight * 0.853040909090909, needleWidth * 0.444513064133017, needleHeight * 0.854445454545455));
        this.needle.getElements().add((Object)new CubicCurveTo(needleWidth * 0.37313539192399, needleHeight * 0.858890909090909, needleWidth * 0.321496437054632, needleHeight * 0.871736363636364, needleWidth * 0.321496437054632, needleHeight * 0.886868181818182));
        this.needle.getElements().add((Object)new CubicCurveTo(needleWidth * 0.321496437054632, needleHeight * 0.905681818181818, needleWidth * 0.401330166270784, needleHeight * 0.920959090909091, needleWidth * 0.499643705463183, needleHeight * 0.920959090909091));
        this.needle.getElements().add((Object)new LineTo(needleWidth * 0.500285035629454, needleHeight * 0.920959090909091));
        this.needle.getElements().add((Object)new CubicCurveTo(needleWidth * 0.598598574821853, needleHeight * 0.920959090909091, needleWidth * 0.678432304038005, needleHeight * 0.905681818181818, needleWidth * 0.678432304038005, needleHeight * 0.886868181818182));
        this.needle.getElements().add((Object)new CubicCurveTo(needleWidth * 0.678432304038005, needleHeight * 0.871554545454545, needleWidth * 0.625534441805226, needleHeight * 0.858581818181818, needleWidth * 0.552826603325416, needleHeight * 0.854286363636364));
        this.needle.getElements().add((Object)new ClosePath());
        this.needle.setCache(true);
        this.needle.setCacheHint(CacheHint.ROTATE);
    }

    private void createConicalGradient() {
        List<Stop> stops = this.tile.getGradientStops();
        HashMap<Double, Color> stopAngleMap = new HashMap<Double, Color>(stops.size());
        for (Stop stop : stops) {
            stopAngleMap.put(stop.getOffset() * this.angleRange, stop.getColor());
        }
        double offsetFactor = this.tile.getStartAngle() - 90.0;
        this.conicalGradient = new AngleConicalGradient(this.barBounds.getX() * this.barBounds.getWidth() * 0.5, this.barBounds.getY() * this.barBounds.getHeight() * 0.5, offsetFactor, stopAngleMap);
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isManaged() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.12;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        maxWidth = this.width - (this.width - this.size * 0.275);
        fontSize = this.size * 0.06;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        fontSize = this.size * 0.04;
        this.minValueText.setFont(Fonts.latoRegular(fontSize));
        this.minValueText.setText(String.format(this.locale, "%.0f", this.tile.getMinValue()));
        this.minValueText.setX(this.width * 0.5 - this.bar.getRadiusX() * 0.9);
        this.minValueText.setY(this.height * 0.5 + this.size * 0.225);
        this.maxValueText.setFont(Fonts.latoRegular(fontSize));
        this.maxValueText.setText(String.format(this.locale, "%.0f", this.tile.getMaxValue()));
        this.maxValueText.setX(this.width * 0.5 + this.bar.getRadiusX() * 0.9 - this.maxValueText.getLayoutBounds().getWidth());
        this.maxValueText.setY(this.height * 0.5 + this.size * 0.225);
        fontSize = this.size * 0.06;
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.1);
    }

    @Override
    protected void resize() {
        super.resize();
        double centerX = this.width * 0.5;
        double centerY = this.height * 0.5;
        double barRadius = this.size * 0.3;
        double barWidth = this.size * 0.07;
        this.createConicalGradient();
        this.knob.setCenterX(centerX);
        this.knob.setCenterY(centerY);
        this.knob.setRadius(barRadius * 0.1637931);
        this.barBackground.setCenterX(centerX);
        this.barBackground.setCenterY(centerY);
        this.barBackground.setRadiusX(barRadius);
        this.barBackground.setRadiusY(barRadius);
        this.barBackground.setStrokeWidth(barWidth);
        this.barBackground.setStartAngle(this.angleRange * 0.5 + 90.0);
        this.barBackground.setLength(-this.angleRange);
        this.bar.setCenterX(centerX);
        this.bar.setCenterY(centerY);
        this.bar.setRadiusX(barRadius);
        this.bar.setRadiusY(barRadius);
        this.bar.setStrokeWidth(barWidth);
        this.bar.setStartAngle(this.angleRange * 0.5 + 90.0);
        this.bar.setLength(-this.angleStep * this.tile.getValue());
        this.barBounds.setX(this.bar.getCenterX() - this.bar.getRadiusX() - barWidth * 0.5);
        this.barBounds.setY(this.bar.getCenterY() - this.bar.getRadiusY() - barWidth * 0.5);
        this.barBounds.setWidth(this.bar.getRadiusX() * 2.0 + barWidth);
        this.barBounds.setHeight(this.bar.getRadiusX() * 2.0 + barWidth);
        this.drawNeedle();
        this.needle.relocate((this.width - this.needle.getLayoutBounds().getWidth()) * 0.5, centerY - this.size * 0.21112);
        this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
        this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() * 0.88659091);
        this.resizeStaticText();
        this.resizeDynamicText();
        this.valueUnitFlow.setPrefWidth(this.width - this.doubleInset);
        this.valueUnitFlow.relocate(this.inset, this.height * 0.5 + this.size * 0.25);
    }

    @Override
    protected void redraw() {
        Color needleColor;
        super.redraw();
        this.angleRange = this.tile.getAngleRange();
        this.angleStep = this.tile.getAngleStep();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.unitText.setText(this.tile.getUnit());
        this.minValueText.setText(String.format(this.locale, this.tickLabelFormatString, this.tile.getMinValue()));
        this.maxValueText.setText(String.format(this.locale, this.tickLabelFormatString, this.tile.getMaxValue()));
        this.resizeStaticText();
        this.barBackgroundColor = this.tile.getBarBackgroundColor();
        if (this.tile.isStrokeWithGradient()) {
            this.gradientLookup.setStops(this.tile.getGradientStops());
            needleColor = this.gradientLookup.getColorAt(this.tile.getValue() / this.tile.getRange());
            this.createConicalGradient();
            this.bar.setStroke((Paint)this.conicalGradient.getImagePattern(this.barBounds));
        } else {
            needleColor = this.tile.getNeedleColor();
            this.bar.setStroke((Paint)this.tile.getBarColor());
        }
        this.knob.setFill((Paint)this.tile.getBarBackgroundColor());
        this.barBackground.setStroke((Paint)this.tile.getBarBackgroundColor());
        this.needle.setFill((Paint)needleColor);
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.minValueText.setFill((Paint)this.tile.getTitleColor());
        this.maxValueText.setFill((Paint)this.tile.getTitleColor());
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
    }
}

