/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.TileBuilder;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.colors.Dark;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class Test
extends Application {
    private static final Random RND = new Random();
    private static final double SIZE = 400.0;
    private static final double WIDTH = 400.0;
    private static final double HEIGHT = 400.0;
    private static int noOfNodes = 0;
    private Tile tile1;
    private Tile tile2;
    private long lastTimerCall;
    private AnimationTimer timer;
    private ChartData cpuChartData;
    private ChartData memChartData;

    public void init() {
        this.cpuChartData = new ChartData("CPU", 0.0, Tile.GREEN);
        this.cpuChartData.setTextColor(Color.WHITE);
        this.cpuChartData.setFormatString("%.0f%%");
        this.memChartData = new ChartData("MEM", 0.0, Tile.GREEN);
        this.memChartData.setTextColor(Color.WHITE);
        this.memChartData.setFormatString("%.0f%%");
        this.tile1 = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.CLUSTER_MONITOR)).prefSize(400.0, 400.0)).title("Production")).text("blabla")).maxValue(20000.0)).chartData(this.cpuChartData, this.memChartData)).animated(true)).shortenNumbers(true)).build();
        this.tile2 = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.CENTER_TEXT)).title("Server")).text("Last check")).backgroundColor(Dark.GREEN)).description("ONLINE")).build();
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > Test.this.lastTimerCall + 1000000000L) {
                    Test.this.cpuChartData.setValue(RND.nextDouble() * 10000.0);
                    Test.this.memChartData.setValue(RND.nextDouble() * 10000.0);
                    Test.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane(new Node[]{new HBox(10.0, new Node[]{this.tile1, this.tile2})});
        pane.setPadding(new Insets(10.0));
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("Test");
        stage.setScene(scene);
        stage.show();
        Test.calcNoOfNodes((Node)pane);
        System.out.println(noOfNodes + " Nodes in SceneGraph");
        this.timer.start();
    }

    public void stop() {
        Platform.exit();
        System.exit(0);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Test.calcNoOfNodes(n);
            }
        }
    }

    public static void main(String[] args) {
        Test.launch((String[])args);
    }
}

