/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Alarm;
import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.AlarmEvent;
import eu.hansolo.tilesfx.events.TileEvent;
import eu.hansolo.tilesfx.events.TimeEvent;
import eu.hansolo.tilesfx.events.TimeEventListener;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.time.Duration;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import javafx.beans.value.ChangeListener;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Line;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class CountdownTimerTileSkin
extends TileSkin {
    private static final double ANGLE_RANGE = 360.0;
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("HH:mm:ss");
    private double size;
    private double chartSize;
    private Arc barBackground;
    private Arc bar;
    private Line separator;
    private Text titleText;
    private Text text;
    private Text durationText;
    private TextFlow durationFlow;
    private Text timeText;
    private TextFlow timeFlow;
    private long range;
    private double angleStep;
    private Duration duration;
    private ChangeListener<Boolean> runningListener;
    private TimeEventListener timeListener;

    public CountdownTimerTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.duration = this.tile.getTimePeriod();
        this.minValue = 0.0;
        this.maxValue = this.duration.getSeconds();
        this.range = this.duration.getSeconds();
        this.angleStep = 360.0 / (double)this.range;
        this.locale = this.tile.getLocale();
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.barBackground = new Arc(125.0, 125.0, 117.0, 117.0, 90.0, 360.0);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)this.tile.getBarBackgroundColor());
        this.barBackground.setStrokeWidth(25.0);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.bar = new Arc(125.0, 125.0, 117.0, 117.0, 90.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStroke((Paint)this.tile.getBarColor());
        this.bar.setStrokeWidth(25.0);
        this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.bar.setFill(null);
        this.separator = new Line(125.0, 1.0, 125.0, 41.667500000000004);
        this.separator.setStroke((Paint)this.tile.getBackgroundColor());
        this.separator.setFill((Paint)Color.TRANSPARENT);
        this.durationText = new Text();
        this.durationText.setFont(Fonts.latoRegular(68.33250000000001));
        this.durationText.setFill((Paint)this.tile.getValueColor());
        this.durationText.setTextOrigin(VPos.CENTER);
        this.durationFlow = new TextFlow(new Node[]{this.durationText});
        this.durationFlow.setTextAlignment(TextAlignment.CENTER);
        this.timeText = new Text(DTF.format(LocalTime.now().plus(this.tile.getTimePeriod().getSeconds(), ChronoUnit.SECONDS)));
        this.timeText.setFont(Fonts.latoRegular(68.33250000000001));
        this.timeText.setFill((Paint)this.tile.getValueColor());
        this.timeText.setTextOrigin(VPos.CENTER);
        Helper.enableNode((Node)this.timeText, this.tile.isValueVisible());
        this.timeFlow = new TextFlow(new Node[]{this.timeText});
        this.timeFlow.setTextAlignment(TextAlignment.CENTER);
        this.runningListener = (o, ov, nv) -> {
            if (nv.booleanValue()) {
                this.timeText.setText(DTF.format(LocalTime.now().plus(this.duration.getSeconds(), ChronoUnit.SECONDS)));
            }
        };
        this.timeListener = e -> {
            if (TimeEvent.TimeEventType.SECOND == e.TYPE) {
                this.updateBar();
            }
        };
        this.getPane().getChildren().addAll((Object[])new Node[]{this.barBackground, this.bar, this.separator, this.titleText, this.text, this.durationFlow, this.timeFlow});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.runningProperty().addListener(this.runningListener);
        this.tile.addTimeEventListener(this.timeListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (TileEvent.EventType.RECALC.name().equals(EVENT_TYPE)) {
            this.redraw();
        } else if (TileEvent.EventType.VISIBILITY.name().equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            Helper.enableNode((Node)this.timeText, this.tile.isValueVisible());
        } else if (TileEvent.EventType.TIME_PERIOD.name().equals(EVENT_TYPE)) {
            this.duration = this.tile.getTimePeriod();
            this.minValue = 0.0;
            this.maxValue = this.duration.getSeconds();
            this.range = this.duration.getSeconds();
            this.angleStep = 360.0 / (double)this.range;
        }
    }

    private void updateBar() {
        if (this.duration.getSeconds() > 0L) {
            this.duration = this.duration.minusSeconds(1L);
            long value = this.duration.getSeconds();
            this.bar.setLength((double)(-value) * this.angleStep);
            this.durationText.setText(DTF.format(LocalTime.ofSecondOfDay(value)));
        } else if (this.duration.getSeconds() == 0L) {
            this.tile.fireAlarmEvent(new AlarmEvent(new Alarm(ZonedDateTime.now(), this.tile.getAlarmColor())));
            this.tile.setRunning(false);
            this.timeText.setText("");
        }
    }

    @Override
    public void dispose() {
        this.tile.runningProperty().removeListener(this.runningListener);
        this.tile.removeTimeEventListener(this.timeListener);
        super.dispose();
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.chartSize * 0.8;
        double fontSize = this.chartSize * 0.15;
        this.durationText.setFont(Fonts.latoRegular(fontSize));
        if (this.durationText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.durationText, maxWidth, fontSize);
        }
        maxWidth = this.chartSize * 0.4;
        fontSize = this.chartSize * 0.1;
        this.timeText.setFont(Fonts.latoRegular(fontSize));
        if (this.timeText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.timeText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resize() {
        super.resize();
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            double chartWidth = this.contentBounds.getWidth();
            double chartHeight = this.contentBounds.getHeight();
            this.chartSize = chartWidth < chartHeight ? chartWidth : chartHeight;
            double radius = this.chartSize * 0.495 - this.contentBounds.getX();
            this.barBackground.setCenterX(this.contentCenterX);
            this.barBackground.setCenterY(this.contentCenterY);
            this.barBackground.setRadiusX(radius);
            this.barBackground.setRadiusY(radius);
            this.barBackground.setStrokeWidth(this.chartSize * 0.1);
            this.bar.setCenterX(this.contentCenterX);
            this.bar.setCenterY(this.contentCenterY);
            this.bar.setRadiusX(radius);
            this.bar.setRadiusY(radius);
            this.bar.setStrokeWidth(this.chartSize * 0.1);
            this.separator.setStartX(this.contentCenterX);
            this.separator.setStartY(this.contentCenterX - radius - this.chartSize * 0.05);
            this.separator.setEndX(this.contentCenterX);
            this.separator.setEndY(this.contentCenterX - radius + this.chartSize * 0.05);
            this.resizeStaticText();
            this.durationFlow.setPrefWidth(this.width * 0.9);
            this.durationFlow.relocate(this.width * 0.05, this.bar.getCenterY() - this.chartSize * 0.12);
            this.timeFlow.setPrefWidth(this.width * 0.9);
            this.timeFlow.relocate(this.width * 0.05, this.bar.getCenterY() + this.chartSize * 0.15);
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.barBackground.setStroke((Paint)this.tile.getBarBackgroundColor());
        this.bar.setStroke((Paint)this.tile.getBarColor());
        this.durationText.setFill((Paint)this.tile.getValueColor());
        this.timeText.setFill((Paint)this.tile.getValueColor());
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.separator.setStroke((Paint)this.tile.getBackgroundColor());
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.resizeStaticText();
        this.resizeDynamicText();
    }
}

