/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class PlusMinusTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private Text valueText;
    private Text upperUnitText;
    private Line fractionLine;
    private Text unitText;
    private VBox unitFlow;
    private HBox valueUnitFlow;
    private Label description;
    private Label plusLabel;
    private Label minusLabel;
    private EventHandler<MouseEvent> mouseEventHandler;

    public PlusMinusTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.mouseEventHandler = e -> {
            EventType TYPE = e.getEventType();
            Label SRC = (Label)e.getSource();
            if (MouseEvent.MOUSE_PRESSED == TYPE) {
                if (SRC.equals(this.minusLabel)) {
                    this.decrement();
                } else if (SRC.equals(this.plusLabel)) {
                    this.increment();
                }
            } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
                if (SRC.equals(this.minusLabel)) {
                    this.minusLabel.setTextFill((Paint)this.tile.getForegroundColor());
                    this.minusLabel.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)this.tile.getForegroundColor(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.size * 0.01))}));
                } else if (SRC.equals(this.plusLabel)) {
                    this.plusLabel.setTextFill((Paint)this.tile.getForegroundColor());
                    this.plusLabel.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)this.tile.getForegroundColor(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.size * 0.01))}));
                }
            }
        };
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.valueText = new Text(String.format(this.locale, this.formatString, (this.tile.getValue() - this.minValue) / this.range * 100.0));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
        this.upperUnitText = new Text("");
        this.upperUnitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.upperUnitText, !this.tile.getUnit().isEmpty());
        this.fractionLine = new Line();
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.unitFlow = new VBox(new Node[]{this.upperUnitText, this.unitText});
        this.unitFlow.setAlignment(Pos.CENTER_RIGHT);
        this.valueUnitFlow = new HBox(new Node[]{this.valueText, this.unitFlow});
        this.valueUnitFlow.setAlignment(Pos.BOTTOM_RIGHT);
        this.valueUnitFlow.setMouseTransparent(true);
        this.description = new Label(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.description.setWrapText(true);
        this.description.setTextFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.description, !this.tile.getDescription().isEmpty());
        this.plusLabel = new Label("+");
        this.plusLabel.setAlignment(Pos.CENTER);
        this.plusLabel.setEffect((Effect)this.shadow);
        this.plusLabel.setPickOnBounds(false);
        this.minusLabel = new Label("-");
        this.minusLabel.setAlignment(Pos.CENTER);
        this.minusLabel.setEffect((Effect)this.shadow);
        this.minusLabel.setPickOnBounds(false);
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.text, this.valueUnitFlow, this.fractionLine, this.description, this.minusLabel, this.plusLabel});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.plusLabel.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.plusLabel.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseEventHandler);
        this.minusLabel.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.minusLabel.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseEventHandler);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
            Helper.enableNode((Node)this.unitFlow, !this.tile.getUnit().isEmpty());
            Helper.enableNode((Node)this.description, !this.tile.getDescription().isEmpty());
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        if (this.tile.getShortenNumbers()) {
            this.valueText.setText(Helper.shortenNumber((long)VALUE));
        } else if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(VALUE));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        }
        this.resizeDynamicText();
    }

    private void increment() {
        this.plusLabel.setTextFill((Paint)this.tile.getActiveColor());
        this.plusLabel.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)this.tile.getActiveColor(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.size * 0.01))}));
        double newValue = Helper.clamp(this.minValue, this.maxValue, this.tile.getValue() + this.tile.getIncrement());
        this.tile.setValue(newValue);
    }

    private void decrement() {
        this.minusLabel.setTextFill((Paint)this.tile.getActiveColor());
        this.minusLabel.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)this.tile.getActiveColor(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.size * 0.01))}));
        double newValue = Helper.clamp(this.minValue, this.maxValue, this.tile.getValue() - this.tile.getIncrement());
        this.tile.setValue(newValue);
    }

    @Override
    public void dispose() {
        this.plusLabel.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.plusLabel.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseEventHandler);
        this.minusLabel.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.minusLabel.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseEventHandler);
        super.dispose();
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
        maxWidth = this.width - (this.width - this.size * 0.275);
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.upperUnitText.setFont(Fonts.latoRegular(fontSize));
        if (this.upperUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.upperUnitText, maxWidth, fontSize);
        }
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        fontSize = this.size * 0.1;
        this.description.setFont(Fonts.latoRegular(fontSize));
    }

    @Override
    protected void resize() {
        super.resize();
        this.description.setPrefSize(this.width - this.size * 0.1, this.size * 0.43);
        this.description.relocate(this.size * 0.05, this.titleText.isVisible() ? this.height * 0.42 : this.height * 0.32);
        double buttonSize = this.size * 0.18;
        this.minusLabel.setFont(Fonts.latoBold(this.size * 0.2));
        this.minusLabel.setPrefSize(buttonSize, buttonSize);
        this.minusLabel.setMinSize(buttonSize, buttonSize);
        this.minusLabel.setMaxSize(buttonSize, buttonSize);
        this.minusLabel.setPadding(new Insets(-0.0625 * this.size, 0.0, 0.0, 0.0));
        this.minusLabel.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)this.tile.getForegroundColor(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.size * 0.01))}));
        this.minusLabel.relocate(this.size * 0.05, this.height - this.size * 0.2 - buttonSize);
        this.plusLabel.setFont(Fonts.latoBold(this.size * 0.2));
        this.plusLabel.setPrefSize(buttonSize, buttonSize);
        this.plusLabel.setMinSize(buttonSize, buttonSize);
        this.plusLabel.setMaxSize(buttonSize, buttonSize);
        this.plusLabel.setPadding(new Insets(-0.05 * this.size, 0.0, 0.0, 0.0));
        this.plusLabel.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)this.tile.getForegroundColor(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.size * 0.01))}));
        this.plusLabel.relocate(this.width - this.size * 0.05 - buttonSize, this.height - this.size * 0.2 - buttonSize);
        this.valueUnitFlow.setPrefWidth(this.width - this.size * 0.1);
        this.valueUnitFlow.relocate(this.size * 0.05, this.contentBounds.getY());
        this.valueUnitFlow.setMaxHeight(this.valueText.getFont().getSize());
        this.fractionLine.setStartX(this.width - 0.17 * this.size);
        this.fractionLine.setStartY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setEndX(this.width - 0.05 * this.size);
        this.fractionLine.setEndY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setStroke((Paint)this.tile.getUnitColor());
        this.fractionLine.setStrokeWidth(this.size * 0.005);
        this.unitFlow.setTranslateY(-this.size * 0.005);
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        if (this.tile.getUnit().contains("/")) {
            String[] units = this.tile.getUnit().split("/");
            this.upperUnitText.setText(units[0]);
            this.unitText.setText(units[1]);
            Helper.enableNode((Node)this.fractionLine, true);
        } else {
            this.upperUnitText.setText(" ");
            this.unitText.setText(this.tile.getUnit());
            Helper.enableNode((Node)this.fractionLine, false);
        }
        this.description.setText(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.upperUnitText.setFill((Paint)this.tile.getUnitColor());
        this.fractionLine.setStroke((Paint)this.tile.getUnitColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        this.plusLabel.setTextFill((Paint)this.tile.getForegroundColor());
        this.minusLabel.setTextFill((Paint)this.tile.getForegroundColor());
    }
}

