/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.TimeSection;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class TimerControlTileSkin
extends TileSkin {
    private DateTimeFormatter dateFormatter;
    private double clockSize;
    private Pane sectionsPane;
    private Path minuteTickMarks;
    private Path hourTickMarks;
    private Rectangle hour;
    private Rectangle minute;
    private Rectangle second;
    private Circle knob;
    private Text titleText;
    private Text amPmText;
    private Text dateText;
    private Text text;
    private Rotate hourRotate;
    private Rotate minuteRotate;
    private Rotate secondRotate;
    private Group shadowGroupHour;
    private Group shadowGroupMinute;
    private Group shadowGroupSecond;
    private DropShadow dropShadow;
    private Map<TimeSection, Arc> sectionMap;

    public TimerControlTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.currentValueListener = o -> {
            if (this.tile.isRunning()) {
                return;
            }
            this.updateTime(ZonedDateTime.ofInstant(Instant.ofEpochSecond(this.tile.getCurrentTime()), ZoneId.of(ZoneId.systemDefault().getId())));
        };
        this.timeListener = o -> this.updateTime(this.tile.getTime());
        this.dateFormatter = DateTimeFormatter.ofPattern("EE d", this.tile.getLocale());
        this.sectionMap = new HashMap<TimeSection, Arc>(this.tile.getTimeSections().size());
        for (TimeSection section : this.tile.getTimeSections()) {
            this.sectionMap.put(section, new Arc());
        }
        this.minuteRotate = new Rotate();
        this.hourRotate = new Rotate();
        this.secondRotate = new Rotate();
        this.sectionsPane = new Pane();
        this.sectionsPane.getChildren().addAll(this.sectionMap.values());
        Helper.enableNode((Node)this.sectionsPane, this.tile.getSectionsVisible());
        this.minuteTickMarks = new Path();
        this.minuteTickMarks.setFillRule(FillRule.EVEN_ODD);
        this.minuteTickMarks.setFill(null);
        this.minuteTickMarks.setStroke((Paint)this.tile.getMinuteColor());
        this.minuteTickMarks.setStrokeLineCap(StrokeLineCap.ROUND);
        this.hourTickMarks = new Path();
        this.hourTickMarks.setFillRule(FillRule.EVEN_ODD);
        this.hourTickMarks.setFill(null);
        this.hourTickMarks.setStroke((Paint)this.tile.getHourColor());
        this.hourTickMarks.setStrokeLineCap(StrokeLineCap.ROUND);
        this.hour = new Rectangle(3.0, 60.0);
        this.hour.setArcHeight(3.0);
        this.hour.setArcWidth(3.0);
        this.hour.setStroke((Paint)this.tile.getHourColor());
        this.hour.getTransforms().setAll((Object[])new Transform[]{this.hourRotate});
        this.minute = new Rectangle(3.0, 96.0);
        this.minute.setArcHeight(3.0);
        this.minute.setArcWidth(3.0);
        this.minute.setStroke((Paint)this.tile.getMinuteColor());
        this.minute.getTransforms().setAll((Object[])new Transform[]{this.minuteRotate});
        this.second = new Rectangle(1.0, 96.0);
        this.second.setArcHeight(1.0);
        this.second.setArcWidth(1.0);
        this.second.setStroke((Paint)this.tile.getSecondColor());
        this.second.getTransforms().setAll((Object[])new Transform[]{this.secondRotate});
        this.second.setVisible(this.tile.isSecondsVisible());
        this.second.setManaged(this.tile.isSecondsVisible());
        this.knob = new Circle(125.0, 125.0, 4.5);
        this.knob.setStroke((Paint)Color.web((String)"#282a3280"));
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(3.75);
        this.dropShadow.setOffsetY(3.75);
        this.shadowGroupHour = new Group(new Node[]{this.hour});
        this.shadowGroupMinute = new Group(new Node[]{this.minute});
        this.shadowGroupSecond = new Group(new Node[]{this.second, this.knob});
        this.shadowGroupHour.setEffect((Effect)(this.tile.isShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupMinute.setEffect((Effect)(this.tile.isShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupSecond.setEffect((Effect)(this.tile.isShadowsEnabled() ? this.dropShadow : null));
        this.titleText = new Text("");
        this.titleText.setTextOrigin(VPos.TOP);
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.amPmText = new Text(this.tile.getTime().get(ChronoField.AMPM_OF_DAY) == 0 ? "AM" : "PM");
        this.dateText = new Text("");
        Helper.enableNode((Node)this.dateText, this.tile.isDateVisible());
        this.text = new Text("");
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.getPane().getChildren().addAll((Object[])new Node[]{this.sectionsPane, this.hourTickMarks, this.minuteTickMarks, this.titleText, this.amPmText, this.dateText, this.text, this.shadowGroupHour, this.shadowGroupMinute, this.shadowGroupSecond});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.timeProperty().addListener(this.timeListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            Helper.enableNode((Node)this.dateText, this.tile.isDateVisible());
            Helper.enableNode((Node)this.second, this.tile.isSecondsVisible());
            Helper.enableNode((Node)this.sectionsPane, this.tile.getSectionsVisible());
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sectionMap.clear();
            for (TimeSection section : this.tile.getTimeSections()) {
                this.sectionMap.put(section, new Arc());
            }
            this.sectionsPane.getChildren().setAll(this.sectionMap.values());
            this.resize();
            this.redraw();
        }
    }

    private void drawTicks() {
        this.minuteTickMarks.setCache(false);
        this.hourTickMarks.setCache(false);
        this.minuteTickMarks.getElements().clear();
        this.hourTickMarks.getElements().clear();
        double startAngle = 180.0;
        double angleStep = 6.0;
        Point2D center = new Point2D(this.clockSize * 0.5, this.clockSize * 0.5);
        boolean hourTickMarksVisible = this.tile.isHourTickMarksVisible();
        boolean minuteTickMarksVisible = this.tile.isMinuteTickMarksVisible();
        double angle = 0.0;
        double counter = 0.0;
        while (Double.compare(counter, 59.0) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerPoint = new Point2D(center.getX() + this.clockSize * 0.405 * sinValue, center.getY() + this.clockSize * 0.405 * cosValue);
            Point2D innerMinutePoint = new Point2D(center.getX() + this.clockSize * 0.435 * sinValue, center.getY() + this.clockSize * 0.435 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + this.clockSize * 0.465 * sinValue, center.getY() + this.clockSize * 0.465 * cosValue);
            if (counter % 5.0 == 0.0) {
                if (hourTickMarksVisible) {
                    this.hourTickMarks.setStrokeWidth(this.clockSize * 0.01);
                    this.hourTickMarks.getElements().add((Object)new MoveTo(innerPoint.getX(), innerPoint.getY()));
                    this.hourTickMarks.getElements().add((Object)new LineTo(outerPoint.getX(), outerPoint.getY()));
                } else if (minuteTickMarksVisible) {
                    this.minuteTickMarks.setStrokeWidth(this.clockSize * 0.005);
                    this.minuteTickMarks.getElements().add((Object)new MoveTo(innerMinutePoint.getX(), innerMinutePoint.getY()));
                    this.minuteTickMarks.getElements().add((Object)new LineTo(outerPoint.getX(), outerPoint.getY()));
                }
            } else if (counter % 1.0 == 0.0 && minuteTickMarksVisible) {
                this.minuteTickMarks.setStrokeWidth(this.clockSize * 0.005);
                this.minuteTickMarks.getElements().add((Object)new MoveTo(innerMinutePoint.getX(), innerMinutePoint.getY()));
                this.minuteTickMarks.getElements().add((Object)new LineTo(outerPoint.getX(), outerPoint.getY()));
            }
            angle -= angleStep;
            counter += 1.0;
        }
        this.minuteTickMarks.setCache(true);
        this.minuteTickMarks.setCacheHint(CacheHint.QUALITY);
        this.hourTickMarks.setCache(true);
        this.hourTickMarks.setCacheHint(CacheHint.QUALITY);
    }

    private void drawTimeSections() {
        if (this.sectionMap.isEmpty()) {
            return;
        }
        ZonedDateTime time = this.tile.getTime();
        DayOfWeek day = time.getDayOfWeek();
        boolean isAM = time.get(ChronoField.AMPM_OF_DAY) == 0;
        double offset = 90.0;
        double angleStep = 6.0;
        boolean highlightSections = this.tile.isHighlightSections();
        for (TimeSection section : this.sectionMap.keySet()) {
            boolean draw;
            boolean isStopAM;
            LocalTime start = section.getStart();
            LocalTime stop = section.getStop();
            boolean isStartAM = start.get(ChronoField.AMPM_OF_DAY) == 0;
            boolean bl = isStopAM = stop.get(ChronoField.AMPM_OF_DAY) == 0;
            boolean bl2 = isAM ? isStartAM || isStopAM : (draw = !isStartAM || !isStopAM);
            if (!section.getDays().contains(day)) {
                draw = false;
            }
            if (!section.isActive()) {
                draw = false;
            }
            if (!draw) continue;
            double sectionStartAngle = ((double)(start.getHour() % 12) * 5.0 + (double)start.getMinute() / 12.0 + (double)start.getSecond() / 300.0) * angleStep + 180.0;
            double sectionAngleExtend = ((double)((stop.getHour() - start.getHour()) % 12) * 5.0 + (double)(stop.getMinute() - start.getMinute()) / 12.0 + (double)(stop.getSecond() - start.getSecond()) / 300.0) * angleStep;
            if (start.getHour() > stop.getHour()) {
                sectionAngleExtend = 360.0 - Math.abs(sectionAngleExtend);
            }
            Arc arc = this.sectionMap.get(section);
            arc.setCenterX(this.clockSize * 0.5);
            arc.setCenterY(this.clockSize * 0.5);
            arc.setRadiusX(this.clockSize * 0.45);
            arc.setRadiusY(this.clockSize * 0.45);
            arc.setStartAngle(-(offset + sectionStartAngle));
            arc.setLength(-sectionAngleExtend);
            arc.setType(ArcType.OPEN);
            arc.setStrokeWidth(this.clockSize * 0.04);
            arc.setStrokeLineCap(StrokeLineCap.BUTT);
            arc.setFill(null);
            if (highlightSections) {
                arc.setStroke((Paint)(section.contains(time.toLocalTime()) ? section.getHighlightColor() : section.getColor()));
                continue;
            }
            arc.setStroke((Paint)section.getColor());
        }
    }

    public void updateTime(ZonedDateTime TIME) {
        if (this.tile.isDiscreteHours()) {
            this.hourRotate.setAngle((double)(TIME.getHour() * 30));
        } else {
            this.hourRotate.setAngle(0.5 * (double)(60 * TIME.getHour() + TIME.getMinute()));
        }
        if (this.tile.isDiscreteMinutes()) {
            this.minuteRotate.setAngle((double)(TIME.getMinute() * 6));
        } else {
            this.minuteRotate.setAngle((double)(TIME.getMinute() * 6) + (double)TIME.getSecond() * 0.1);
        }
        if (this.second.isVisible()) {
            if (this.tile.isDiscreteSeconds()) {
                this.secondRotate.setAngle((double)(TIME.getSecond() * 6));
            } else {
                this.secondRotate.setAngle((double)(TIME.getSecond() * 6) + (double)TIME.get(ChronoField.MILLI_OF_SECOND) * 0.006);
            }
        }
        if (this.sectionsVisible) {
            for (TimeSection section : this.sectionMap.keySet()) {
                if (this.highlightSections) {
                    this.sectionMap.get(section).setStroke((Paint)(section.contains(TIME.toLocalTime()) ? section.getHighlightColor() : section.getColor()));
                    continue;
                }
                this.sectionMap.get(section).setStroke((Paint)section.getColor());
            }
            this.drawTimeSections();
        }
        this.amPmText.setText(TIME.get(ChronoField.AMPM_OF_DAY) == 0 ? "AM" : "PM");
        Helper.adjustTextSize(this.amPmText, 0.2 * this.size, this.size * 0.05);
        this.amPmText.setX((this.width - this.amPmText.getLayoutBounds().getWidth()) * 0.5);
        this.amPmText.setY(this.height * 0.5 - this.size * 0.1);
        this.dateText.setText(this.dateFormatter.format(TIME).toUpperCase());
        Helper.adjustTextSize(this.dateText, 0.3 * this.size, this.size * 0.05);
        this.dateText.setX((this.width - this.dateText.getLayoutBounds().getWidth()) * 0.5);
        this.dateText.setY(this.height * 0.5 + this.size * 0.15);
    }

    @Override
    public void dispose() {
        this.tile.timeProperty().removeListener(this.timeListener);
        super.dispose();
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        this.titleText.setText(this.tile.getTitle());
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.titleText.setY(this.size * 0.05);
        maxWidth = this.width - this.size * 0.8;
        this.amPmText.setFont(font);
        this.amPmText.setText(this.tile.getTime().get(ChronoField.AMPM_OF_DAY) == 0 ? "AM" : "PM");
        Helper.adjustTextSize(this.amPmText, maxWidth, fontSize);
        this.amPmText.setX((this.width - this.amPmText.getLayoutBounds().getWidth()) * 0.5);
        this.amPmText.setY(this.height * 0.5 - this.size * 0.1);
        maxWidth = this.width - this.size * 0.4;
        this.dateText.setFont(font);
        if (this.dateText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.dateText, maxWidth, fontSize);
        }
        this.dateText.setX((this.width - this.dateText.getLayoutBounds().getWidth()) * 0.5);
        this.dateText.setY(this.height * 0.5 + this.size * 0.15);
        maxWidth = this.width - this.size * 0.1;
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.clockSize = this.contentBounds.getWidth() < this.contentBounds.getHeight() ? this.contentBounds.getWidth() : this.contentBounds.getHeight();
        double centerX = this.width * 0.5;
        double centerY = this.height * 0.5;
        this.sectionsPane.setMinSize(this.clockSize, this.clockSize);
        this.sectionsPane.relocate((this.width - this.clockSize) * 0.5, (this.height - this.clockSize) * 0.5);
        this.dropShadow.setRadius(0.008 * this.size);
        this.dropShadow.setOffsetY(0.008 * this.size);
        this.drawTimeSections();
        this.drawTicks();
        this.hourTickMarks.relocate((this.width - this.hourTickMarks.getLayoutBounds().getWidth()) * 0.5, (this.height - this.hourTickMarks.getLayoutBounds().getHeight()) * 0.5);
        this.minuteTickMarks.relocate((this.width - this.minuteTickMarks.getLayoutBounds().getWidth()) * 0.5, (this.height - this.minuteTickMarks.getLayoutBounds().getHeight()) * 0.5);
        this.hour.setFill((Paint)this.tile.getHourColor());
        this.hour.setCache(false);
        this.hour.setWidth(this.clockSize * 0.015);
        this.hour.setHeight(this.clockSize * 0.29);
        this.hour.setArcWidth(this.clockSize * 0.015);
        this.hour.setArcHeight(this.clockSize * 0.015);
        this.hour.setCache(true);
        this.hour.setCacheHint(CacheHint.ROTATE);
        this.hour.relocate(centerX - this.hour.getWidth() * 0.5, centerY - this.hour.getHeight());
        this.minute.setFill((Paint)this.tile.getMinuteColor());
        this.minute.setCache(false);
        this.minute.setWidth(this.clockSize * 0.015);
        this.minute.setHeight(this.clockSize * 0.47);
        this.minute.setArcWidth(this.clockSize * 0.015);
        this.minute.setArcHeight(this.clockSize * 0.015);
        this.minute.setCache(true);
        this.minute.setCacheHint(CacheHint.ROTATE);
        this.minute.relocate(centerX - this.minute.getWidth() * 0.5, centerY - this.minute.getHeight());
        this.second.setFill((Paint)this.tile.getSecondColor());
        this.second.setCache(false);
        this.second.setWidth(this.clockSize * 0.005);
        this.second.setHeight(this.clockSize * 0.47);
        this.second.setArcWidth(this.clockSize * 0.015);
        this.second.setArcHeight(this.clockSize * 0.015);
        this.second.setCache(true);
        this.second.setCacheHint(CacheHint.ROTATE);
        this.second.relocate(centerX - this.second.getWidth() * 0.5, centerY - this.second.getHeight());
        this.knob.setFill((Paint)this.tile.getKnobColor());
        this.knob.setRadius(this.clockSize * 0.0225);
        this.knob.setCenterX(centerX);
        this.knob.setCenterY(centerY);
        this.minuteRotate.setPivotX(this.minute.getWidth() * 0.5);
        this.minuteRotate.setPivotY(this.minute.getHeight());
        this.hourRotate.setPivotX(this.hour.getWidth() * 0.5);
        this.hourRotate.setPivotY(this.hour.getHeight());
        this.secondRotate.setPivotX(this.second.getWidth() * 0.5);
        this.secondRotate.setPivotY(this.second.getHeight());
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.dateFormatter = DateTimeFormatter.ofPattern("EE d", this.tile.getLocale());
        this.shadowGroupHour.setEffect((Effect)(this.tile.isShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupMinute.setEffect((Effect)(this.tile.isShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupSecond.setEffect((Effect)(this.tile.isShadowsEnabled() ? this.dropShadow : null));
        this.minuteTickMarks.setStroke((Paint)this.tile.getMinuteColor());
        this.hourTickMarks.setStroke((Paint)this.tile.getHourColor());
        this.updateTime(this.tile.getTime());
        this.resizeDynamicText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.amPmText.setFill((Paint)this.tile.getTitleColor());
        this.dateText.setFill((Paint)this.tile.getDateColor());
        this.text.setFill((Paint)this.tile.getTextColor());
    }
}

