/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.addons;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.SwitchEvent;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

@DefaultProperty(value="children")
public class Switch
extends Region {
    private static final SwitchEvent SWITCH_PRESSED = new SwitchEvent(SwitchEvent.SWITCH_PRESSED);
    private static final SwitchEvent SWITCH_RELEASED = new SwitchEvent(SwitchEvent.SWITCH_RELEASED);
    private static final double PREFERRED_WIDTH = 110.0;
    private static final double PREFERRED_HEIGHT = 55.0;
    private static final double MINIMUM_WIDTH = 20.0;
    private static final double MINIMUM_HEIGHT = 20.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static double aspectRatio;
    private double size;
    private double width;
    private double height;
    private DropShadow shadow;
    private Rectangle switchBorder;
    private Rectangle switchBackground;
    private Circle thumb;
    private Pane pane;
    private Timeline timeline;
    private EventHandler<MouseEvent> mouseEventHandler;
    private InvalidationListener selectedListener;
    private boolean _active;
    private BooleanProperty active;
    private Color _activeColor;
    private ObjectProperty<Color> activeColor;
    private Color _foregroundColor;
    private ObjectProperty<Color> foregroundColor;
    private Color _backgroundColor;
    private ObjectProperty<Color> backgroundColor;

    public Switch() {
        aspectRatio = 0.5;
        this._active = false;
        this._activeColor = Tile.BLUE;
        this._foregroundColor = Tile.FOREGROUND;
        this._backgroundColor = Tile.BACKGROUND;
        this.mouseEventHandler = e -> {
            EventType TYPE = e.getEventType();
            if (MouseEvent.MOUSE_PRESSED == TYPE) {
                this.setActive(!this.isActive());
                this.fireEvent(SWITCH_PRESSED);
            } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
                this.fireEvent(SWITCH_RELEASED);
            }
        };
        this.selectedListener = o -> this.moveThumb();
        this.timeline = new Timeline();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(110.0, 55.0);
            }
        }
        this.shadow = new DropShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 3.0, 0.0, 0.0, 0.0);
        this.switchBorder = new Rectangle();
        this.switchBorder.setFill((Paint)this.getForegroundColor());
        this.switchBackground = new Rectangle();
        this.switchBackground.setMouseTransparent(true);
        this.switchBackground.setFill((Paint)(this.isActive() ? this.getActiveColor() : this.getBackgroundColor()));
        this.thumb = new Circle();
        this.thumb.setMouseTransparent(true);
        this.thumb.setFill((Paint)this.getForegroundColor());
        this.thumb.setEffect((Effect)this.shadow);
        this.pane = new Pane(new Node[]{this.switchBorder, this.switchBackground, this.thumb});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    public void dispose() {
        this.switchBorder.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.switchBorder.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseEventHandler);
        this.activeProperty().removeListener(this.selectedListener);
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.switchBorder.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.switchBorder.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseEventHandler);
        this.activeProperty().addListener(this.selectedListener);
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 20.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 20.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public boolean isActive() {
        return null == this.active ? this._active : this.active.get();
    }

    public void setActive(boolean ACTIVE) {
        if (null == this.active) {
            this._active = ACTIVE;
        } else {
            this.active.set(ACTIVE);
        }
    }

    public BooleanProperty activeProperty() {
        if (null == this.active) {
            this.active = new BooleanPropertyBase(this._active){

                protected void invalidated() {
                }

                public Object getBean() {
                    return Switch.this;
                }

                public String getName() {
                    return "active";
                }
            };
        }
        return this.active;
    }

    public Color getActiveColor() {
        return null == this.activeColor ? this._activeColor : (Color)this.activeColor.get();
    }

    public void setActiveColor(Color COLOR) {
        if (null == this.activeColor) {
            this._activeColor = COLOR;
            this.redraw();
        } else {
            this.activeColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> activeColorProperty() {
        if (null == this.activeColor) {
            this.activeColor = new ObjectPropertyBase<Color>(this._activeColor){

                protected void invalidated() {
                    Switch.this.redraw();
                }

                public Object getBean() {
                    return Switch.this;
                }

                public String getName() {
                    return "activeColor";
                }
            };
            this._activeColor = null;
        }
        return this.activeColor;
    }

    public Color getForegroundColor() {
        return null == this.foregroundColor ? this._foregroundColor : (Color)this.foregroundColor.get();
    }

    public void setForegroundColor(Color COLOR) {
        if (null == this.foregroundColor) {
            this._foregroundColor = COLOR;
            this.redraw();
        } else {
            this.foregroundColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> foregroundColorProperty() {
        if (null == this.foregroundColor) {
            this.foregroundColor = new ObjectPropertyBase<Color>(this._foregroundColor){

                protected void invalidated() {
                    Switch.this.redraw();
                }

                public Object getBean() {
                    return Switch.this;
                }

                public String getName() {
                    return "foregroundColor";
                }
            };
            this._foregroundColor = null;
        }
        return this.foregroundColor;
    }

    public Color getBackgroundColor() {
        return null == this.backgroundColor ? this._backgroundColor : (Color)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color COLOR) {
        if (null == this.backgroundColor) {
            this._backgroundColor = COLOR;
            this.redraw();
        } else {
            this.backgroundColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        if (null == this.backgroundColor) {
            this.backgroundColor = new ObjectPropertyBase<Color>(this._backgroundColor){

                protected void invalidated() {
                    Switch.this.redraw();
                }

                public Object getBean() {
                    return Switch.this;
                }

                public String getName() {
                    return "backgroundColor";
                }
            };
            this._backgroundColor = null;
        }
        return this.backgroundColor;
    }

    private void moveThumb() {
        KeyValue thumbLeftX = new KeyValue((WritableValue)this.thumb.centerXProperty(), (Object)(this.thumb.getRadius() + this.height * 0.1));
        KeyValue thumbRightX = new KeyValue((WritableValue)this.thumb.centerXProperty(), (Object)(this.width - this.thumb.getRadius() - this.height * 0.1));
        KeyValue switchBackgroundLeftColor = new KeyValue((WritableValue)this.switchBackground.fillProperty(), (Object)this.getBackgroundColor());
        KeyValue switchBackgroundRightColor = new KeyValue((WritableValue)this.switchBackground.fillProperty(), (Object)this.getActiveColor());
        if (this.isActive()) {
            KeyFrame kf0 = new KeyFrame(Duration.ZERO, new KeyValue[]{thumbLeftX, switchBackgroundLeftColor});
            KeyFrame kf1 = new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{thumbRightX, switchBackgroundRightColor});
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf0, kf1});
        } else {
            KeyFrame kf0 = new KeyFrame(Duration.ZERO, new KeyValue[]{thumbRightX, switchBackgroundRightColor});
            KeyFrame kf1 = new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{thumbLeftX, switchBackgroundLeftColor});
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf0, kf1});
        }
        this.timeline.play();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (aspectRatio * this.width > this.height) {
            this.width = 1.0 / (aspectRatio / this.height);
        } else if (1.0 / (aspectRatio / this.height) > this.width) {
            this.height = aspectRatio * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.shadow.setRadius(this.width * 0.012);
            this.switchBorder.setWidth(this.width);
            this.switchBorder.setHeight(this.height);
            this.switchBorder.setArcWidth(this.height);
            this.switchBorder.setArcHeight(this.height);
            this.switchBorder.relocate((this.width - this.switchBorder.getWidth()) * 0.5, (this.height - this.switchBorder.getHeight()) * 0.5);
            this.switchBackground.setWidth(this.width * 0.95505618);
            this.switchBackground.setHeight(this.height * 0.90909091);
            this.switchBackground.setArcWidth(this.height * 0.90909091);
            this.switchBackground.setArcHeight(this.height * 0.90909091);
            this.switchBackground.relocate((this.width - this.switchBackground.getWidth()) * 0.5, (this.height - this.switchBackground.getHeight()) * 0.5);
            this.thumb.setRadius(this.height * 0.40909091);
            this.thumb.setCenterX(this.isActive() ? this.width - this.thumb.getRadius() - this.height * 0.1 : this.thumb.getRadius() + this.height * 0.1);
            this.thumb.setCenterY(this.height * 0.5);
            this.redraw();
        }
    }

    private void redraw() {
        this.switchBorder.setFill((Paint)this.getForegroundColor());
        this.switchBackground.setFill((Paint)(this.isActive() ? this.getActiveColor() : this.getBackgroundColor()));
        this.thumb.setFill((Paint)this.getForegroundColor());
    }
}

