/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.addons;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.toolboxfx.GradientLookup;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.DefaultProperty;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class YearChart
extends Region {
    public static final Map<Integer, String> monthNames = Map.ofEntries(Map.entry(1, "J"), Map.entry(2, "F"), Map.entry(3, "M"), Map.entry(4, "A"), Map.entry(5, "M"), Map.entry(6, "J"), Map.entry(7, "J"), Map.entry(8, "A"), Map.entry(9, "S"), Map.entry(10, "O"), Map.entry(11, "N"), Map.entry(12, "D"));
    private static final double PREFERRED_WIDTH = 288.0;
    private static final double PREFERRED_HEIGHT = 24.0;
    private static final double MINIMUM_WIDTH = 10.0;
    private static final double MINIMUM_HEIGHT = 10.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private double size;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Map<Integer, Double> months;
    private GradientLookup gradientLookup;
    private boolean showMonth;
    private boolean separateMonths;
    private String text;
    private Color textColor;
    private double minValue;
    private double maxValue;

    public YearChart() {
        this("", Color.WHITE, false, false);
    }

    public YearChart(String text, Color textColor, boolean showMonth, boolean separateMonths) {
        this.text = text;
        this.textColor = textColor;
        this.showMonth = showMonth;
        this.separateMonths = separateMonths;
        this.months = new HashMap<Integer, Double>(12);
        this.gradientLookup = new GradientLookup(new Stop[]{new Stop(0.0, Tile.BLUE), new Stop(0.25, Tile.GREEN), new Stop(0.5, Tile.YELLOW), new Stop(0.75, Tile.ORANGE), new Stop(1.0, Tile.RED)});
        for (int i = 1; i < 13; ++i) {
            this.months.put(i, 0.0);
        }
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(288.0, 24.0);
            }
        }
        this.canvas = new Canvas(288.0, 24.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    protected double computeMinWidth(double HEIGHT) {
        return 10.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 10.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 2048.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 2048.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void set(int month, double value) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Month must be in the range of 1..12");
        }
        this.months.put(month, value);
        this.minValue = this.months.values().stream().min(Comparator.comparingDouble(v -> v)).get();
        this.maxValue = this.months.values().stream().max(Comparator.comparingDouble(v -> v)).get();
        this.redraw();
    }

    public double get(int month) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Month must be in the range of 1..12");
        }
        return this.months.get(month);
    }

    public void setGradientLookup(GradientLookup gradientLookup) {
        this.gradientLookup = gradientLookup;
        this.redraw();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
        this.redraw();
    }

    public boolean getShowMonth() {
        return this.showMonth;
    }

    public void setShowMonth(boolean showMonths) {
        this.showMonth = showMonths;
        this.redraw();
    }

    public boolean getSeparateMonths() {
        return this.separateMonths;
    }

    public void setSeparateMonths(boolean separateMonths) {
        this.separateMonths = separateMonths;
        this.redraw();
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.redraw();
        }
    }

    private void redraw() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        double range = this.maxValue - this.minValue;
        double gap = 0.0;
        if (this.width >= this.height) {
            double yearSize;
            double yearWidth = this.width / 12.0;
            double yearHeight = this.height;
            double d = yearSize = yearWidth < yearHeight ? yearWidth : yearHeight;
            if (this.getSeparateMonths()) {
                gap = yearSize * 0.05;
            }
            yearWidth -= 2.0 * gap;
            yearHeight -= 2.0 * gap;
            this.ctx.setFont(Font.font((double)(yearSize * 0.5)));
            for (int i = 0; i < 12; ++i) {
                this.ctx.setFill((Paint)this.gradientLookup.getColorAt((this.months.get(i + 1) - this.minValue) / range));
                this.ctx.fillRect(gap + (double)i * (yearWidth + gap), gap, yearWidth, yearHeight);
                if (!this.getShowMonth()) continue;
                this.ctx.setFill((Paint)this.getTextColor());
                this.ctx.fillText(monthNames.get(i + 1), gap + (double)i * (yearWidth + gap) + yearWidth / 2.0, gap + yearHeight / 2.0);
            }
        } else {
            double yearWidth = this.width;
            double yearHeight = this.height / 12.0;
            double yearSize = yearWidth < yearHeight ? yearWidth : yearHeight;
            this.ctx.setFont(Font.font((double)(yearSize * 0.5)));
            if (this.getSeparateMonths()) {
                gap = yearSize * 0.05;
            }
            yearWidth -= 2.0 * gap;
            yearHeight -= 2.0 * gap;
            for (int i = 0; i < 12; ++i) {
                this.ctx.setFill((Paint)this.gradientLookup.getColorAt((this.months.get(i + 1) - this.minValue) / range));
                this.ctx.fillRect(gap, gap + (double)i * (yearHeight + gap), yearWidth, yearHeight);
                if (!this.getShowMonth()) continue;
                this.ctx.setFill((Paint)this.getTextColor());
                this.ctx.fillText(monthNames.get(i + 1), gap + yearWidth / 2.0, gap + (double)i * (yearHeight + gap) + yearHeight / 2.0);
            }
        }
    }
}

