/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Section;
import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.TileEvt;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.toolboxfx.GradientLookup;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.AnimationTimer;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class FluidTileSkin
extends TileSkin {
    private Canvas canvas;
    private GraphicsContext ctx;
    private Text titleText;
    private Text valueText;
    private Text upperUnitText;
    private Line fractionLine;
    private Text unitText;
    private VBox unitFlow;
    private HBox valueUnitFlow;
    private Text text;
    private GradientLookup gradientLookup;
    private List<Point> particles;
    private double density;
    private double friction;
    private double detail;
    private long impulseInterval;
    private long updateInterval;
    private long lastUpdateCall;
    private long lastImpulseCall;
    private AnimationTimer timer;

    public FluidTileSkin(Tile TILE) {
        super(TILE);
        this.timer.start();
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.density = 0.9;
        this.friction = 1.1;
        this.detail = Math.round(12.5);
        this.particles = new ArrayList<Point>();
        this.impulseInterval = 1000000000L;
        this.updateInterval = 50000000L;
        this.lastUpdateCall = System.nanoTime();
        this.lastImpulseCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > FluidTileSkin.this.lastUpdateCall + FluidTileSkin.this.updateInterval) {
                    FluidTileSkin.this.update();
                    FluidTileSkin.this.lastUpdateCall = now;
                }
                if (now > FluidTileSkin.this.lastImpulseCall + FluidTileSkin.this.impulseInterval) {
                    FluidTileSkin.this.impulse();
                    FluidTileSkin.this.lastImpulseCall = now;
                }
            }
        };
        int i = 0;
        while ((double)i < this.detail + 1.0) {
            this.particles.add(new Point(this, 250.0 / (this.detail - 4.0) * (double)(i - 2), 250.0 * (1.0 - this.tile.getCurrentValue()), 0.0, 250.0 * (1.0 - this.tile.getCurrentValue()), 0.0, Math.random() * 3.0, 0.0, 0.0, 20.0));
            ++i;
        }
        this.canvas = new Canvas();
        this.ctx = this.canvas.getGraphicsContext2D();
        this.gradientLookup = new GradientLookup();
        this.ctx.setFill((Paint)this.tile.getBarColor());
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, (this.tile.getValue() - this.minValue) / this.range * 100.0));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.valueText.setTextOrigin(VPos.BASELINE);
        this.valueText.setStroke((Paint)this.tile.getBackgroundColor());
        Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
        this.upperUnitText = new Text("");
        this.upperUnitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.upperUnitText, !this.tile.getUnit().isEmpty());
        this.fractionLine = new Line();
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.unitFlow = new VBox(new Node[]{this.upperUnitText, this.unitText});
        this.unitFlow.setAlignment(Pos.CENTER_RIGHT);
        this.valueUnitFlow = new HBox(new Node[]{this.valueText, this.unitFlow});
        this.valueUnitFlow.setAlignment(Pos.CENTER);
        this.valueUnitFlow.setMouseTransparent(true);
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.getPane().getChildren().addAll((Object[])new Node[]{this.canvas, this.titleText, this.valueUnitFlow, this.fractionLine, this.text});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (TileEvt.VALUE.getName().equals(EVENT_TYPE)) {
            this.handleCurrentValue(this.tile.getCurrentValue());
        } else if (TileEvt.VISIBILITY.getName().equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        } else if (TileEvt.SECTION.getName().equals(EVENT_TYPE)) {
            this.redraw();
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        double percentage = VALUE / this.tile.getRange();
        if (this.tile.getShortenNumbers()) {
            this.valueText.setText(Helper.shortenNumber((long)VALUE));
        } else if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(Helper.clamp(this.minValue, this.maxValue, VALUE)));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, Helper.clamp(this.minValue, this.maxValue, VALUE)));
        }
        if (this.tile.isFillWithGradient()) {
            this.ctx.setFill((Paint)this.gradientLookup.getColorAt(percentage));
        } else {
            for (Section section : this.tile.getSections()) {
                if (!section.contains(Helper.clamp(this.minValue, this.maxValue, VALUE))) continue;
                this.ctx.setFill((Paint)section.getColor());
                break;
            }
        }
        this.resizeDynamicText();
        int i = 0;
        while ((double)i < this.detail + 1.0) {
            Point p = this.particles.get(i);
            p.originalY = p.y = this.size * (1.0 - percentage);
            ++i;
        }
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.48;
        this.valueText.setFont(Fonts.latoBold(fontSize));
        double correctedFontSize = fontSize;
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            correctedFontSize = Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        double fontFactor = correctedFontSize / fontSize;
        maxWidth = this.size * 0.275;
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.24 : this.size * 0.2;
        this.upperUnitText.setFont(Fonts.latoRegular(fontSize * fontFactor));
        if (this.upperUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.upperUnitText, maxWidth, fontSize);
        }
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.24 : this.size * 0.2;
        this.unitText.setFont(Fonts.latoRegular(fontSize * fontFactor));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.valueUnitFlow.relocate(this.size * 0.05, (this.height - this.valueUnitFlow.getLayoutBounds().getHeight()) * 0.5);
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.canvas.setWidth(this.width);
        this.canvas.setHeight(this.height);
        Rectangle clip = new Rectangle(this.width, this.height);
        if (this.tile.getRoundedCorners()) {
            clip.setArcWidth(Helper.clamp(0.0, Double.MAX_VALUE, this.size * 0.025));
            clip.setArcHeight(Helper.clamp(0.0, Double.MAX_VALUE, this.size * 0.025));
        }
        this.canvas.setClip((Node)clip);
        this.resizeDynamicText();
        this.resizeStaticText();
        this.valueUnitFlow.setPrefWidth(this.width - this.size * 0.1);
        this.valueUnitFlow.relocate(this.size * 0.05, (this.height - this.valueUnitFlow.getLayoutBounds().getHeight()) * 0.5);
        this.valueUnitFlow.setMaxHeight(this.valueText.getFont().getSize());
        this.fractionLine.setStartX(this.width - 0.17 * this.size);
        this.fractionLine.setStartY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setEndX(this.width - 0.05 * this.size);
        this.fractionLine.setEndY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setStroke((Paint)this.tile.getUnitColor());
        this.fractionLine.setStrokeWidth(this.size * 0.005);
        this.unitFlow.setTranslateY(-this.size * 0.005);
        int i = 0;
        while ((double)i < this.detail + 1.0) {
            Point p = this.particles.get(i);
            p.x = this.width / (this.detail - 4.0) * (double)(i - 2);
            p.y = this.height * (1.0 - this.tile.getCurrentValue());
            p.originalX = p.x;
            p.originalY = p.y;
            ++i;
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(Helper.clamp(this.minValue, this.maxValue, this.tile.getCurrentValue())));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, Helper.clamp(this.minValue, this.maxValue, this.tile.getCurrentValue())));
        }
        if (this.tile.getUnit().contains("/")) {
            String[] units = this.tile.getUnit().split("/");
            this.upperUnitText.setText(units[0]);
            this.unitText.setText(units[1]);
            Helper.enableNode((Node)this.fractionLine, true);
        } else {
            this.upperUnitText.setText(" ");
            this.unitText.setText(this.tile.getUnit());
            Helper.enableNode((Node)this.fractionLine, false);
        }
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.upperUnitText.setFill((Paint)this.tile.getUnitColor());
        this.fractionLine.setStroke((Paint)this.tile.getUnitColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        if (this.tile.isFillWithGradient() && !this.tile.getGradientStops().isEmpty()) {
            this.gradientLookup.setStops(this.tile.getGradientStops());
        }
    }

    private void impulse() {
        int forceRange = 2;
        this.insertImpulse(Math.random() * this.width, Math.random() * (double)(forceRange * 2) - (double)forceRange);
    }

    private void insertImpulse(double POSITION_X, double FORCE_Y) {
        int pos = (int)Math.round(POSITION_X / this.width * (double)this.particles.size());
        if (pos > this.particles.size() - 1) {
            return;
        }
        Point particle = this.particles.get(pos);
        particle.forceY += FORCE_Y;
    }

    private void update() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.ctx.beginPath();
        this.ctx.moveTo(this.particles.get((int)0).x, this.particles.get((int)0).y);
        int listSize = this.particles.size();
        for (int i = 0; i < listSize; ++i) {
            Point nextParticle;
            Point currentParticle = this.particles.get(i);
            Point previousParticle = i - 1 < 0 ? null : this.particles.get(i - 1);
            Point point = nextParticle = i + 1 > listSize - 1 ? null : this.particles.get(i + 1);
            if (null == previousParticle || null == nextParticle) continue;
            double forceY = 0.0;
            forceY += -this.density * (previousParticle.y - currentParticle.y);
            forceY += this.density * (currentParticle.y - nextParticle.y);
            currentParticle.velocityY += -((forceY += this.density / 15.0 * (currentParticle.y - currentParticle.originalY)) / currentParticle.mass) + currentParticle.forceY;
            currentParticle.velocityY /= this.friction;
            currentParticle.forceY /= this.friction;
            currentParticle.y += currentParticle.velocityY;
            this.ctx.quadraticCurveTo(previousParticle.x, previousParticle.y, previousParticle.x + (currentParticle.x - previousParticle.x) / 2.0, previousParticle.y + (currentParticle.y - previousParticle.y) / 2.0);
        }
        this.ctx.lineTo(this.particles.get((int)(this.particles.size() - 1)).x, this.particles.get((int)(this.particles.size() - 1)).y);
        this.ctx.lineTo(this.width, this.height);
        this.ctx.lineTo(0.0, this.height);
        this.ctx.lineTo(this.particles.get((int)0).x, this.particles.get((int)0).y);
        this.ctx.closePath();
        this.ctx.fill();
    }

    private class Point {
        double x;
        double y;
        double originalX;
        double originalY;
        double velocityX;
        double velocityY;
        double forceX;
        double forceY;
        double mass;

        public Point(FluidTileSkin fluidTileSkin, double X, double Y, double ORIGINAL_X, double ORIGINAL_Y, double VELOCITY_X, double VELOCITY_Y, double FORCE_X, double FORCE_Y, double MASS) {
            this.x = X;
            this.y = Y;
            this.originalX = ORIGINAL_X;
            this.originalY = ORIGINAL_Y;
            this.velocityX = VELOCITY_X;
            this.velocityY = VELOCITY_Y;
            this.forceX = FORCE_X;
            this.forceY = FORCE_Y;
            this.mass = MASS;
        }
    }
}

