/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.addons;

import eu.hansolo.tilesfx.addons.CanvasSpinner;
import eu.hansolo.tilesfx.addons.ImageSpinner;
import eu.hansolo.tilesfx.addons.Spinner;
import eu.hansolo.tilesfx.addons.SpinnerType;
import eu.hansolo.tilesfx.events.SpinnerObserver;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.scene.paint.Color;

public class SpinnerBuilder<B extends SpinnerBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected SpinnerBuilder() {
    }

    public static final SpinnerBuilder create() {
        return new SpinnerBuilder();
    }

    public final B value(double value) {
        this.properties.put("value", (Property)new SimpleDoubleProperty(value));
        return (B)this;
    }

    public final B backgroundVisible(boolean visible) {
        this.properties.put("backgroundVisible", (Property)new SimpleBooleanProperty(visible));
        return (B)this;
    }

    public final B overlayVisible(boolean visible) {
        this.properties.put("overlayVisible", (Property)new SimpleBooleanProperty(visible));
        return (B)this;
    }

    public final B snapshotBackground(Color color) {
        this.properties.put("snapshotBackground", (Property)new SimpleObjectProperty((Object)color));
        return (B)this;
    }

    public final B backgroundColor(Color color) {
        this.properties.put("backgroundColor", (Property)new SimpleObjectProperty((Object)color));
        return (B)this;
    }

    public final B foregroundColor(Color color) {
        this.properties.put("foregroundColor", (Property)new SimpleObjectProperty((Object)color));
        return (B)this;
    }

    public final B type(SpinnerType spinnerType) {
        this.properties.put("spinnerType", (Property)new SimpleObjectProperty((Object)spinnerType));
        return (B)this;
    }

    public final B prefSize(double width, double height) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B onValueChanged(SpinnerObserver observer) {
        this.properties.put("onValueChanged", (Property)new SimpleObjectProperty((Object)observer));
        return (B)this;
    }

    public final B onZeroPassed(SpinnerObserver observer) {
        this.properties.put("onZeroPassed", (Property)new SimpleObjectProperty((Object)observer));
        return (B)this;
    }

    public final B onSpinnerEvent(SpinnerObserver observer) {
        this.properties.put("onSpinnerEvent", (Property)new SimpleObjectProperty((Object)observer));
        return (B)this;
    }

    private void build(Spinner spinner) {
        this.properties.forEach((key, property) -> {
            switch (key) {
                case "value": {
                    spinner.setValue(((DoubleProperty)property).get());
                    break;
                }
                case "snapshotBackground": {
                    spinner.setSnapshotBackground((Color)((ObjectProperty)property).get());
                    break;
                }
                case "backgroundVisible": {
                    spinner.setBackgroundVisible(((BooleanProperty)property).get());
                    break;
                }
                case "overlayVisible": {
                    spinner.setOverlayVisible(((BooleanProperty)property).get());
                    break;
                }
                case "backgroundColor": {
                    spinner.setBackgroundColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "foregroundColor": {
                    spinner.setForegroundColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "spinnerType": {
                    spinner.setSpinnerType((SpinnerType)((Object)((Object)((ObjectProperty)property).get())));
                    break;
                }
                case "onValueChanged": {
                    spinner.setOnValueChanged((SpinnerObserver)((ObjectProperty)property).get());
                    break;
                }
                case "onZeroPassed": {
                    spinner.setOnZeroPassed((SpinnerObserver)((ObjectProperty)property).get());
                    break;
                }
                case "onSpinnerEvent": {
                    spinner.setOnSpinnerEvent((SpinnerObserver)((ObjectProperty)property).get());
                }
            }
        });
    }

    public final ImageSpinner buildImageSpinner() {
        ImageSpinner spinner = new ImageSpinner();
        this.build(spinner);
        if (this.properties.containsKey("prefSize")) {
            Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get("prefSize")).get();
            spinner.setPrefSize(dim.getWidth(), dim.getHeight());
        }
        return spinner;
    }

    public final CanvasSpinner buildCanvasSpinner() {
        CanvasSpinner spinner = new CanvasSpinner();
        this.build(spinner);
        if (this.properties.containsKey("prefSize")) {
            Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get("prefSize")).get();
            spinner.setPrefSize(dim.getWidth(), dim.getHeight());
        }
        return spinner;
    }
}

