/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.chart;

import eu.hansolo.tilesfx.chart.MatrixFont;
import eu.hansolo.tilesfx.chart.PixelMatrix;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class PixelMatrixBuilder<B extends PixelMatrixBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected PixelMatrixBuilder() {
    }

    public static final PixelMatrixBuilder create() {
        return new PixelMatrixBuilder();
    }

    public final B colsAndRows(int[] COLS_AND_ROWS) {
        return this.colsAndRows(COLS_AND_ROWS[0], COLS_AND_ROWS[1]);
    }

    public final B colsAndRows(int COLS, int ROWS) {
        this.properties.put("cols", (Property)new SimpleIntegerProperty(COLS));
        this.properties.put("rows", (Property)new SimpleIntegerProperty(ROWS));
        return (B)this;
    }

    public final B pixelOnColor(Color COLOR) {
        this.properties.put("pixelOnColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B pixelOffColor(Color COLOR) {
        this.properties.put("pixelOffColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B pixelShape(PixelMatrix.PixelShape SHAPE) {
        this.properties.put("pixelShape", (Property)new SimpleObjectProperty((Object)SHAPE));
        return (B)this;
    }

    public final B matrixFont(MatrixFont FONT) {
        this.properties.put("matrixFont", (Property)new SimpleObjectProperty((Object)FONT));
        return (B)this;
    }

    public final B useSpacer(boolean USE) {
        this.properties.put("useSpacer", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B squarePixels(boolean SQUARE) {
        this.properties.put("squarePixels", (Property)new SimpleBooleanProperty(SQUARE));
        return (B)this;
    }

    public final B spacerSizeFactor(double FACTOR) {
        this.properties.put("spacerSizeFactor", (Property)new SimpleDoubleProperty(FACTOR));
        return (B)this;
    }

    public final B innerShadowEnabled(boolean ENABLED) {
        this.properties.put("innerShadowEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final PixelMatrix build() {
        PixelMatrix CONTROL;
        if (this.properties.keySet().contains("cols") && this.properties.keySet().contains("rows")) {
            int cols = ((IntegerProperty)this.properties.get("cols")).get();
            int rows = ((IntegerProperty)this.properties.get("rows")).get();
            CONTROL = new PixelMatrix(cols, rows);
        } else {
            CONTROL = new PixelMatrix();
        }
        this.properties.forEach((key, property) -> {
            switch (key) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    CONTROL.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    CONTROL.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    CONTROL.setPrefWidth(((DoubleProperty)property).get());
                    break;
                }
                case "prefHeight": {
                    CONTROL.setPrefHeight(((DoubleProperty)property).get());
                    break;
                }
                case "minWidth": {
                    CONTROL.setMinWidth(((DoubleProperty)property).get());
                    break;
                }
                case "minHeight": {
                    CONTROL.setMinHeight(((DoubleProperty)property).get());
                    break;
                }
                case "maxWidth": {
                    CONTROL.setMaxWidth(((DoubleProperty)property).get());
                    break;
                }
                case "maxHeight": {
                    CONTROL.setMaxHeight(((DoubleProperty)property).get());
                    break;
                }
                case "scaleX": {
                    CONTROL.setScaleX(((DoubleProperty)property).get());
                    break;
                }
                case "scaleY": {
                    CONTROL.setScaleY(((DoubleProperty)property).get());
                    break;
                }
                case "layoutX": {
                    CONTROL.setLayoutX(((DoubleProperty)property).get());
                    break;
                }
                case "layoutY": {
                    CONTROL.setLayoutY(((DoubleProperty)property).get());
                    break;
                }
                case "translateX": {
                    CONTROL.setTranslateX(((DoubleProperty)property).get());
                    break;
                }
                case "translateY": {
                    CONTROL.setTranslateY(((DoubleProperty)property).get());
                    break;
                }
                case "padding": {
                    CONTROL.setPadding((Insets)((ObjectProperty)property).get());
                    break;
                }
                case "pixelOnColor": {
                    CONTROL.setPixelOnColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "pixelOffColor": {
                    CONTROL.setPixelOffColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "pixelShape": {
                    CONTROL.setPixelShape((PixelMatrix.PixelShape)((Object)((Object)((ObjectProperty)property).get())));
                    break;
                }
                case "matrixFont": {
                    CONTROL.setMatrixFont((MatrixFont)((ObjectProperty)property).get());
                    break;
                }
                case "useSpacer": {
                    CONTROL.setUseSpacer(((BooleanProperty)property).get());
                    break;
                }
                case "spacerSizeFactor": {
                    CONTROL.setSpacerSizeFactor(((DoubleProperty)property).get());
                    break;
                }
                case "squarePixels": {
                    CONTROL.setSquarePixels(((BooleanProperty)property).get());
                    break;
                }
                case "innerShadowEnabled": {
                    CONTROL.setInnerShadowEnabled(((BooleanProperty)property).get());
                }
            }
        });
        return CONTROL;
    }
}

