/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Section;
import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Line;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class CircularProgressTileSkin
extends TileSkin {
    private static final double ANGLE_RANGE = 360.0;
    private double size;
    private double chartSize;
    private Arc barBackground;
    private Arc bar;
    private Line separator;
    private Text titleText;
    private Text text;
    private Text percentageValueText;
    private Text percentageUnitText;
    private TextFlow percentageFlow;
    private Text valueText;
    private Text unitText;
    private TextFlow valueUnitFlow;
    private double minValue;
    private double range;
    private double angleStep;
    private boolean sectionsVisible;
    private List<Section> sections;
    private String formatString;
    private Locale locale;
    private StackPane graphicContainer;
    private ChangeListener graphicListener;
    private InvalidationListener currentValueListener;

    public CircularProgressTileSkin(Tile TILE) {
        super(TILE);
        this.setBar(TILE.getCurrentValue());
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        if (this.tile.isAutoScale()) {
            this.tile.calcAutoScale();
        }
        this.minValue = this.tile.getMinValue();
        this.range = this.tile.getRange();
        this.angleStep = 360.0 / this.range;
        this.sectionsVisible = this.tile.getSectionsVisible();
        this.sections = this.tile.getSections();
        this.formatString = "%." + Integer.toString(this.tile.getDecimals()) + "f";
        this.locale = this.tile.getLocale();
        this.currentValueListener = o -> this.setBar(this.tile.getCurrentValue());
        this.graphicListener = (o, ov, nv) -> {
            if (nv != null) {
                this.graphicContainer.getChildren().setAll((Object[])new Node[]{this.tile.getGraphic()});
            }
        };
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.barBackground = new Arc(125.0, 125.0, 117.0, 117.0, 90.0, 360.0);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)this.tile.getBarBackgroundColor());
        this.barBackground.setStrokeWidth(25.0);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.bar = new Arc(125.0, 125.0, 117.0, 117.0, 90.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStroke((Paint)this.tile.getBarColor());
        this.bar.setStrokeWidth(25.0);
        this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.bar.setFill(null);
        this.separator = new Line(125.0, 1.0, 125.0, 41.667500000000004);
        this.separator.setStroke((Paint)this.tile.getBackgroundColor());
        this.separator.setFill((Paint)Color.TRANSPARENT);
        this.percentageValueText = new Text(String.format(this.locale, this.formatString, this.tile.getCurrentValue()));
        this.percentageValueText.setFont(Fonts.latoRegular(68.33250000000001));
        this.percentageValueText.setFill((Paint)this.tile.getValueColor());
        this.percentageValueText.setTextOrigin(VPos.CENTER);
        this.percentageUnitText = new Text(this.tile.getUnit());
        this.percentageUnitText = new Text("%");
        this.percentageUnitText.setFont(Fonts.latoLight(20.0));
        this.percentageUnitText.setFill((Paint)this.tile.getUnitColor());
        this.percentageFlow = new TextFlow(new Node[]{this.percentageValueText, this.percentageUnitText});
        this.percentageFlow.setTextAlignment(TextAlignment.CENTER);
        this.valueText = new Text(String.format(this.locale, this.formatString, this.tile.getCurrentValue()));
        this.valueText.setFont(Fonts.latoRegular(68.33250000000001));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.valueText.setTextOrigin(VPos.CENTER);
        Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
        this.unitText = new Text(this.tile.getUnit());
        this.unitText = new Text("%");
        this.unitText.setFont(Fonts.latoLight(20.0));
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.valueUnitFlow = new TextFlow(new Node[]{this.valueText, this.unitText});
        this.valueUnitFlow.setTextAlignment(TextAlignment.CENTER);
        this.graphicContainer = new StackPane();
        this.graphicContainer.setMinSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.graphicContainer.setMaxSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.graphicContainer.setPrefSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        if (null == this.tile.getGraphic()) {
            Helper.enableNode((Node)this.graphicContainer, false);
        } else {
            this.graphicContainer.getChildren().setAll((Object[])new Node[]{this.tile.getGraphic()});
        }
        this.getPane().getChildren().addAll((Object[])new Node[]{this.barBackground, this.bar, this.separator, this.titleText, this.text, this.graphicContainer, this.percentageFlow, this.valueUnitFlow});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.currentValueProperty().addListener(this.currentValueListener);
        this.tile.graphicProperty().addListener(this.graphicListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = this.tile.getMinValue();
            this.range = this.tile.getRange();
            this.angleStep = 360.0 / this.range;
            this.sections = this.tile.getSections();
            this.redraw();
            this.setBar(this.tile.getCurrentValue());
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
            Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
        }
    }

    private void setBar(double VALUE) {
        if (this.minValue > 0.0) {
            this.bar.setLength((this.minValue - VALUE) * this.angleStep);
        } else {
            this.bar.setLength(-VALUE * this.angleStep);
        }
        this.setBarColor(VALUE);
        this.percentageValueText.setText(String.format(this.locale, this.formatString, VALUE / this.range * 100.0));
        if (this.tile.getShortenNumbers()) {
            this.valueText.setText(Helper.shortenNumber((long)VALUE));
        } else if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(VALUE));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        }
    }

    private void setBarColor(double VALUE) {
        if (!this.sectionsVisible) {
            this.bar.setStroke((Paint)this.tile.getBarColor());
        } else {
            this.bar.setStroke((Paint)this.tile.getBarColor());
            for (Section section : this.sections) {
                if (!section.contains(VALUE)) continue;
                this.bar.setStroke((Paint)section.getColor());
                break;
            }
        }
    }

    @Override
    public void dispose() {
        this.tile.currentValueProperty().removeListener(this.currentValueListener);
        this.tile.graphicProperty().removeListener(this.graphicListener);
        super.dispose();
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.percentageUnitText.isVisible() ? this.chartSize * 0.7 : this.chartSize * 0.8;
        double fontSize = this.graphicContainer.isVisible() ? this.chartSize * 0.15 : this.chartSize * 0.2;
        this.percentageValueText.setFont(Fonts.latoRegular(fontSize));
        if (this.percentageValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.percentageValueText, maxWidth, fontSize);
        }
        fontSize = this.graphicContainer.isVisible() ? this.chartSize * 0.07 : this.chartSize * 0.08;
        this.percentageUnitText.setFont(Fonts.latoLight(fontSize));
        if (this.percentageUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.percentageUnitText, maxWidth, fontSize);
        }
        maxWidth = this.unitText.isVisible() ? this.chartSize * 0.3 : this.chartSize * 0.4;
        fontSize = this.graphicContainer.isVisible() ? this.chartSize * 0.075 : this.chartSize * 0.1;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        fontSize = this.graphicContainer.isVisible() ? this.chartSize * 0.035 : this.chartSize * 0.04;
        this.unitText.setFont(Fonts.latoLight(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resize() {
        super.resize();
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            double chartWidth = this.contentBounds.getWidth();
            double chartHeight = this.contentBounds.getHeight();
            this.chartSize = chartWidth < chartHeight ? chartWidth : chartHeight;
            double maxContainerSize = this.chartSize * 0.5;
            double containerWidth = maxContainerSize - this.size * 0.1;
            double containerHeight = this.tile.isTextVisible() ? this.height - maxContainerSize * 0.28 : this.height - maxContainerSize * 0.205;
            double radius = this.chartSize * 0.495 - this.contentBounds.getX();
            this.barBackground.setCenterX(this.contentCenterX);
            this.barBackground.setCenterY(this.contentCenterY);
            this.barBackground.setRadiusX(radius);
            this.barBackground.setRadiusY(radius);
            this.barBackground.setStrokeWidth(this.chartSize * 0.1);
            this.bar.setCenterX(this.contentCenterX);
            this.bar.setCenterY(this.contentCenterY);
            this.bar.setRadiusX(radius);
            this.bar.setRadiusY(radius);
            this.bar.setStrokeWidth(this.chartSize * 0.1);
            this.separator.setStartX(this.contentCenterX);
            this.separator.setStartY(this.contentCenterX - radius - this.chartSize * 0.05);
            this.separator.setEndX(this.contentCenterX);
            this.separator.setEndY(this.contentCenterX - radius + this.chartSize * 0.05);
            if (this.graphicContainer.isVisible() && containerWidth > 0.0 && containerHeight > 0.0) {
                this.graphicContainer.setMinSize(containerWidth, containerHeight);
                this.graphicContainer.setMaxSize(containerWidth, containerHeight);
                this.graphicContainer.setPrefSize(containerWidth, containerHeight);
                this.graphicContainer.relocate((this.width - containerWidth) * 0.5, (this.height - containerHeight) * 0.35);
                Node graphic = this.tile.getGraphic();
                if (this.tile.getGraphic() instanceof Shape) {
                    double graphicWidth = graphic.getBoundsInLocal().getWidth();
                    double graphicHeight = graphic.getBoundsInLocal().getHeight();
                    if (graphicWidth > containerWidth || graphicHeight > containerHeight) {
                        double scale = graphicWidth - containerWidth > graphicHeight - containerHeight ? containerWidth / graphicWidth : containerHeight / graphicHeight;
                        graphic.setScaleX(scale);
                        graphic.setScaleY(scale);
                    }
                } else if (this.tile.getGraphic() instanceof ImageView) {
                    ((ImageView)graphic).setFitWidth(containerWidth);
                    ((ImageView)graphic).setFitHeight(containerHeight);
                }
            }
            this.resizeStaticText();
            this.percentageFlow.setPrefWidth(this.width * 0.9);
            this.percentageFlow.relocate(this.width * 0.05, this.graphicContainer.isVisible() ? this.bar.getCenterY() + this.chartSize * 0.12 : this.bar.getCenterY() - this.chartSize * 0.12);
            this.valueUnitFlow.setPrefWidth(this.width * 0.9);
            this.valueUnitFlow.relocate(this.width * 0.05, this.graphicContainer.isVisible() ? this.bar.getCenterY() - this.chartSize * 0.32 : this.bar.getCenterY() + this.chartSize * 0.15);
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.locale = this.tile.getLocale();
        this.formatString = "%." + Integer.toString(this.tile.getDecimals()) + "f";
        this.sectionsVisible = this.tile.getSectionsVisible();
        this.barBackground.setStroke((Paint)this.tile.getBarBackgroundColor());
        this.setBarColor(this.tile.getCurrentValue());
        this.percentageValueText.setFill((Paint)this.tile.getValueColor());
        this.percentageUnitText.setFill((Paint)this.tile.getUnitColor());
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.separator.setStroke((Paint)this.tile.getBackgroundColor());
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.unitText.setText(this.tile.getUnit());
        this.resizeStaticText();
        this.resizeDynamicText();
    }
}

