/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class ImageTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private ImageView imgView;
    private StackPane graphicContainer;
    private Circle roundFrame;
    private Rectangle rectangularFrame;
    private ChangeListener imageListener;

    public ImageTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.imageListener = (o, ov, nv) -> {
            if (nv != null) {
                this.imgView.setImage(this.tile.getImage());
            }
        };
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.imgView = new ImageView(this.tile.getImage());
        this.roundFrame = new Circle();
        this.roundFrame.setFill((Paint)Color.TRANSPARENT);
        this.rectangularFrame = new Rectangle();
        this.rectangularFrame.setFill((Paint)Color.TRANSPARENT);
        this.graphicContainer = new StackPane();
        this.graphicContainer.setMinSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.graphicContainer.setMaxSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.graphicContainer.setPrefSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.graphicContainer.getChildren().setAll((Object[])new Node[]{this.roundFrame, this.rectangularFrame, this.imgView});
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.graphicContainer, this.text});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.imageProperty().addListener(this.imageListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            this.graphicContainer.setMaxSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.68 : this.size * 0.795);
            this.graphicContainer.setPrefSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.68 : this.size * 0.795);
        }
    }

    @Override
    public void dispose() {
        this.tile.graphicProperty().removeListener(this.imageListener);
        super.dispose();
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        double containerSize;
        super.resize();
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        this.size = this.width < this.height ? this.width : this.height;
        double containerWidth = this.contentBounds.getWidth();
        double containerHeight = this.contentBounds.getHeight();
        double d = containerSize = containerWidth < containerHeight ? containerWidth : containerHeight;
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            if (containerWidth > 0.0 && containerHeight > 0.0) {
                this.graphicContainer.setMinSize(containerWidth, containerHeight);
                this.graphicContainer.setMaxSize(containerWidth, containerHeight);
                this.graphicContainer.setPrefSize(containerWidth, containerHeight);
                this.graphicContainer.relocate(this.contentBounds.getX(), this.contentBounds.getY());
                this.imgView.setPreserveRatio(true);
                this.imgView.setFitWidth(containerWidth * 0.96);
                this.imgView.setFitHeight(containerHeight * 0.96);
                this.imgView.relocate((this.width - containerWidth) * 0.5, (this.height - containerHeight) * 0.5);
                switch (this.tile.getImageMask()) {
                    case ROUND: {
                        this.imgView.setClip((Node)new Circle(this.imgView.getLayoutBounds().getWidth() * 0.5, this.imgView.getLayoutBounds().getHeight() * 0.5, containerSize * 0.48));
                        this.rectangularFrame.setManaged(false);
                        this.rectangularFrame.setVisible(false);
                        this.roundFrame.setManaged(true);
                        this.roundFrame.setVisible(true);
                        this.roundFrame.setRadius(containerSize * 0.5);
                        this.roundFrame.setStrokeWidth(this.size * 0.01);
                        this.roundFrame.setStroke((Paint)this.tile.getForegroundColor());
                        break;
                    }
                    case RECTANGULAR: {
                        Rectangle clip = new Rectangle(containerSize * 0.96, containerSize * 0.96);
                        clip.setArcWidth(this.size * 0.03);
                        clip.setArcHeight(this.size * 0.03);
                        this.imgView.setClip((Node)clip);
                        this.roundFrame.setManaged(false);
                        this.roundFrame.setVisible(false);
                        this.rectangularFrame.setManaged(true);
                        this.rectangularFrame.setVisible(true);
                        this.rectangularFrame.setWidth(containerSize);
                        this.rectangularFrame.setHeight(containerSize);
                        this.rectangularFrame.setStrokeWidth(this.size * 0.01);
                        this.rectangularFrame.setArcWidth(this.size * 0.05);
                        this.rectangularFrame.setArcHeight(this.size * 0.05);
                        this.rectangularFrame.setStroke((Paint)this.tile.getForegroundColor());
                        break;
                    }
                    default: {
                        this.imgView.setClip(null);
                        this.roundFrame.setManaged(false);
                        this.roundFrame.setVisible(false);
                        this.rectangularFrame.setManaged(false);
                        this.rectangularFrame.setVisible(false);
                    }
                }
                if (Tile.ImageMask.ROUND == this.tile.getImageMask()) {
                    this.imgView.setClip((Node)new Circle(this.imgView.getLayoutBounds().getWidth() * 0.5, this.imgView.getLayoutBounds().getHeight() * 0.5, containerSize * 0.48));
                    this.roundFrame.setManaged(true);
                    this.roundFrame.setVisible(true);
                    this.roundFrame.setRadius(containerSize * 0.5);
                    this.roundFrame.setStrokeWidth(this.size * 0.01);
                    this.roundFrame.setStroke((Paint)this.tile.getForegroundColor());
                } else {
                    this.roundFrame.setManaged(false);
                    this.roundFrame.setVisible(false);
                }
            }
            this.resizeStaticText();
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
    }
}

