/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.addons.ImageSpinner;
import eu.hansolo.tilesfx.addons.SpinnerBuilder;
import eu.hansolo.tilesfx.addons.SpinnerType;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.LinkedList;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class SpinnerTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private List<Character> characters;
    private List<ImageSpinner> spinners;
    private Text unitText;
    private Rectangle clip;
    private HBox spinnerBox;
    private Label description;
    private Timeline timeline;
    private int noOfSpinners;

    public SpinnerTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        this.timeline = new Timeline();
        super.initGraphics();
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        String valueText = this.tile.getCustomDecimalFormatEnabled() ? this.decimalFormat.format(this.tile.getValue()) : String.format(this.locale, this.formatString, this.tile.getValue());
        this.characters = Helper.splitStringInCharacters(valueText);
        this.clip = new Rectangle();
        this.noOfSpinners = this.calcNoOfSpinners();
        this.spinners = new LinkedList<ImageSpinner>();
        this.spinnerBox = new HBox();
        this.spinnerBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.tile.getBackgroundColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.spinnerBox.setAlignment(Pos.CENTER);
        this.spinnerBox.setFillHeight(false);
        this.spinnerBox.setClip((Node)this.clip);
        this.createSpinners();
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setTextOrigin(VPos.CENTER);
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        if (!this.tile.getUnit().isEmpty()) {
            this.spinnerBox.getChildren().add((Object)this.unitText);
        }
        this.description = new Label(this.tile.getText());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.description.setWrapText(true);
        this.description.setTextFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.description, this.tile.isTextVisible());
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.text, this.spinnerBox, this.description});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.backgroundColorProperty().addListener((o, ov, nv) -> {
            this.spinnerBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)nv, CornerRadii.EMPTY, Insets.EMPTY)}));
            this.spinners.forEach(spinner -> spinner.setSnapshotBackground((Color)nv));
        });
        this.tile.valueColorProperty().addListener((o, ov, nv) -> this.spinners.forEach(spinner -> spinner.setForegroundColor((Color)nv)));
        this.tile.rangeProperty().addListener(o -> {
            this.noOfSpinners = this.calcNoOfSpinners();
            this.createSpinners();
            this.resize();
        });
        this.tile.unitProperty().addListener((o, ov, nv) -> {
            if (ov.isEmpty() && !nv.isEmpty()) {
                if (this.spinnerBox.getChildren().contains((Object)this.unitText)) {
                    return;
                }
                this.spinnerBox.getChildren().add((Object)this.unitText);
            } else if (!ov.isEmpty() && nv.isEmpty()) {
                if (!this.spinnerBox.getChildren().contains((Object)this.unitText)) {
                    return;
                }
                this.spinnerBox.getChildren().remove((Object)this.unitText);
            }
            this.resize();
        });
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        String valueText = this.tile.getCustomDecimalFormatEnabled() ? this.decimalFormat.format(VALUE) : String.format(this.locale, this.formatString, VALUE);
        this.characters = Helper.splitStringInCharacters(valueText);
        if (this.characters.size() > this.spinners.size()) {
            this.spinners.clear();
            for (int i = 0; i < this.characters.size(); ++i) {
                this.spinners.add(((SpinnerBuilder)((SpinnerBuilder)((SpinnerBuilder)((SpinnerBuilder)((SpinnerBuilder)SpinnerBuilder.create().type(SpinnerType.NUMERIC_0_9)).backgroundColor(this.tile.getBackgroundColor())).foregroundColor(this.tile.getForegroundColor())).overlayVisible(false)).backgroundVisible(false)).buildImageSpinner());
            }
            this.spinnerBox.getChildren().setAll(this.spinners);
        }
        this.set(this.characters);
        this.resizeDynamicText();
    }

    private void set(List<Character> characters) {
        ImageSpinner spinner;
        int i;
        if (characters.size() > this.spinners.size()) {
            return;
        }
        LinkedList<KeyValue> kf0Values = new LinkedList<KeyValue>();
        LinkedList<KeyValue> kf1Values = new LinkedList<KeyValue>();
        int noOfSpinners = this.spinners.size() - 1;
        int spinnerCounter = 0;
        ParallelTransition fader = new ParallelTransition();
        for (i = characters.size() - 1; i >= 0; --i) {
            int targetValue;
            spinner = this.spinners.get(noOfSpinners - spinnerCounter);
            char character = characters.get(i).charValue();
            if (characters.get(i).toString().equals(".")) {
                targetValue = character == ' ' ? 1 : character - 45;
                spinner.setSpinnerType(SpinnerType.SIGNS);
            } else if (characters.get(i).toString().equals("-")) {
                targetValue = character == ' ' ? 1 : character - 45;
                spinner.setSpinnerType(SpinnerType.SIGNS);
            } else {
                targetValue = character == ' ' ? 10 : character - 48;
                spinner.setSpinnerType(SpinnerType.NUMERIC_0_9);
            }
            if (Double.compare(spinner.getValue(), targetValue) != 0) {
                KeyValue kv0 = new KeyValue((WritableValue)spinner.valueProperty(), (Object)spinner.getValue(), Interpolator.LINEAR);
                KeyValue kv1 = new KeyValue((WritableValue)spinner.valueProperty(), (Object)targetValue, Interpolator.LINEAR);
                kf0Values.add(kv0);
                kf1Values.add(kv1);
            }
            if (spinner.getOpacity() == 0.0) {
                fader.getChildren().add((Object)this.fadeInSpinner(spinner));
            }
            ++spinnerCounter;
        }
        for (i = spinnerCounter; i <= noOfSpinners; ++i) {
            spinner = this.spinners.get(noOfSpinners - i);
            fader.getChildren().add((Object)this.fadeOutSpinner(spinner));
            if (spinner.getValue() == 0.0) continue;
            KeyValue kv0 = new KeyValue((WritableValue)spinner.valueProperty(), (Object)spinner.getValue(), Interpolator.LINEAR);
            KeyValue kv1 = new KeyValue((WritableValue)spinner.valueProperty(), (Object)0, Interpolator.LINEAR);
            kf0Values.add(kv0);
            kf1Values.add(kv1);
        }
        if (!fader.getChildren().isEmpty()) {
            fader.play();
        }
        KeyFrame kf0 = new KeyFrame(Duration.ZERO, kf0Values.toArray(new KeyValue[0]));
        KeyFrame kf1 = new KeyFrame(Duration.millis((double)this.tile.getAnimationDuration()), kf1Values.toArray(new KeyValue[0]));
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf0, kf1});
        this.timeline.play();
    }

    private FadeTransition fadeOutSpinner(ImageSpinner spinner) {
        FadeTransition fadeOut = new FadeTransition(Duration.millis((double)500.0), (Node)spinner);
        fadeOut.setFromValue(spinner.getOpacity());
        fadeOut.setToValue(0.0);
        return fadeOut;
    }

    private FadeTransition fadeInSpinner(ImageSpinner spinner) {
        FadeTransition fadeIn = new FadeTransition(Duration.millis((double)500.0), (Node)spinner);
        fadeIn.setFromValue(spinner.getOpacity());
        fadeIn.setToValue(1.0);
        return fadeIn;
    }

    private int calcNoOfSpinners() {
        int noOfSpinners = Long.toString((long)this.tile.getRange()).length();
        if (this.tile.getDecimals() > 0) {
            noOfSpinners += this.tile.getDecimals() + 1;
        }
        if (this.tile.getMinValue() < 0.0) {
            ++noOfSpinners;
        }
        return noOfSpinners;
    }

    private void createSpinners() {
        this.spinners.clear();
        for (int i = 0; i < this.noOfSpinners; ++i) {
            this.spinners.add(((SpinnerBuilder)((SpinnerBuilder)((SpinnerBuilder)((SpinnerBuilder)((SpinnerBuilder)((SpinnerBuilder)SpinnerBuilder.create().type(SpinnerType.NUMERIC_0_9)).snapshotBackground(this.tile.getBackgroundColor())).backgroundColor(this.tile.getBackgroundColor())).foregroundColor(this.tile.getValueColor())).overlayVisible(false)).backgroundVisible(false)).buildImageSpinner());
        }
        this.spinnerBox.getChildren().setAll(this.spinners);
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
        maxWidth = this.width - (this.width - this.size * 0.275);
        fontSize = this.size * 0.12;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        fontSize = this.size * 0.1;
        this.description.setFont(Fonts.latoRegular(fontSize));
    }

    @Override
    protected void resize() {
        super.resize();
        this.unitText.setText(this.tile.getUnit());
        this.resizeDynamicText();
        this.resizeStaticText();
        double spinnerHeight = this.spinners.get(0).getSpinnerHeight() - 2.0;
        this.clip.setX(0.0);
        this.clip.setY((144.0 - spinnerHeight) * 0.5);
        this.clip.setWidth(this.width);
        this.clip.setHeight(spinnerHeight);
        this.spinnerBox.setPrefWidth(this.width - this.size * 0.1);
        this.spinnerBox.relocate(this.size * 0.05, this.contentBounds.getMinY() + (this.contentBounds.getHeight() - this.spinnerBox.getHeight()) * 0.5);
        double translateY = this.spinners.isEmpty() ? 0.0 : (spinnerHeight - this.spinners.get(0).getDigitHeight()) * 1.1;
        this.unitText.setTranslateY(translateY);
        this.description.setPrefSize(this.width - this.size * 0.1, this.size * 0.43);
        this.description.relocate(this.size * 0.05, this.titleText.isVisible() ? this.height * 0.42 : this.height * 0.32);
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.description.setText(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        this.description.setTextFill((Paint)this.tile.getDescriptionColor());
    }
}

