/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.SwitchEvent;
import eu.hansolo.tilesfx.events.TileEvt;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javafx.util.Duration;

public class SwitchSliderTileSkin
extends TileSkin {
    private static final SwitchEvent SWITCH_PRESSED = new SwitchEvent(SwitchEvent.SWITCH_PRESSED);
    private static final SwitchEvent SWITCH_RELEASED = new SwitchEvent(SwitchEvent.SWITCH_RELEASED);
    private final TileEvt VALUE_CHANGING;
    private final TileEvt VALUE_CHANGED;
    private Text titleText;
    private Text text;
    private Text valueText;
    private Text unitText;
    private TextFlow valueUnitFlow;
    private Label description;
    private Rectangle switchBorder;
    private Rectangle switchBackground;
    private Circle switchThumb;
    private Circle thumb;
    private Rectangle barBackground;
    private Rectangle bar;
    private Point2D dragStart;
    private double centerX;
    private double centerY;
    private double formerThumbPos;
    private double trackStart;
    private double trackLength;
    private Timeline timeline;
    private EventHandler<MouseEvent> mouseEventHandler;
    private InvalidationListener selectedListener;
    private InvalidationListener valueListener;

    public SwitchSliderTileSkin(Tile TILE) {
        super(TILE);
        this.VALUE_CHANGING = new TileEvt((Object)this.tile, TileEvt.VALUE_CHANGING);
        this.VALUE_CHANGED = new TileEvt((Object)this.tile, TileEvt.VALUE_CHANGED);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.mouseEventHandler = e -> {
            EventType TYPE = e.getEventType();
            Object SRC = e.getSource();
            if (MouseEvent.MOUSE_PRESSED == TYPE) {
                if (SRC.equals(this.thumb)) {
                    this.dragStart = this.thumb.localToParent(e.getX(), e.getY());
                    this.formerThumbPos = (this.tile.getCurrentValue() - this.minValue) / this.range;
                    this.tile.fireTileEvt(this.VALUE_CHANGING);
                } else if (SRC.equals(this.switchBorder)) {
                    this.tile.setActive(!this.tile.isActive());
                    this.tile.fireEvent(SWITCH_PRESSED);
                }
            } else if (MouseEvent.MOUSE_DRAGGED == TYPE) {
                Point2D currentPos = this.thumb.localToParent(e.getX(), e.getY());
                double dragPos = currentPos.getX() - this.dragStart.getX();
                this.thumbDragged(this.formerThumbPos + dragPos / this.trackLength);
            } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
                if (SRC.equals(this.thumb)) {
                    this.tile.fireTileEvt(this.VALUE_CHANGED);
                } else if (SRC.equals(this.switchBorder)) {
                    this.tile.fireEvent(SWITCH_RELEASED);
                }
            }
        };
        this.selectedListener = o -> this.moveThumb();
        this.valueListener = o -> {
            if (this.tile.isActive() && Double.compare(this.tile.getValue(), this.tile.getMinValue()) != 0) {
                this.thumb.setFill((Paint)this.tile.getBarColor());
            } else {
                this.thumb.setFill((Paint)this.tile.getForegroundColor());
            }
        };
        this.timeline = new Timeline();
        this.timeline.setOnFinished(event -> this.thumb.setFill((Paint)(this.tile.isActive() ? this.tile.getBarColor() : this.tile.getForegroundColor())));
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.valueText = new Text(String.format(this.locale, this.formatString, (this.tile.getValue() - this.minValue) / this.range * 100.0));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.valueUnitFlow = new TextFlow(new Node[]{this.valueText, this.unitText});
        this.valueUnitFlow.setTextAlignment(TextAlignment.RIGHT);
        this.description = new Label(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.description.setWrapText(true);
        this.description.setTextFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.description, !this.tile.getDescription().isEmpty());
        this.barBackground = new Rectangle(198.75, 6.875);
        this.bar = new Rectangle(0.0, 6.875);
        this.thumb = new Circle(22.5);
        this.thumb.setEffect((Effect)this.shadow);
        this.switchBorder = new Rectangle();
        this.switchBackground = new Rectangle();
        this.switchBackground.setMouseTransparent(true);
        this.switchBackground.setFill((Paint)(this.tile.isActive() ? this.tile.getActiveColor() : this.tile.getBackgroundColor()));
        this.switchThumb = new Circle();
        this.switchThumb.setMouseTransparent(true);
        this.switchThumb.setEffect((Effect)this.shadow);
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.text, this.valueUnitFlow, this.description, this.barBackground, this.bar, this.thumb, this.switchBorder, this.switchBackground, this.switchThumb});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.thumb.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.thumb.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseEventHandler);
        this.thumb.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseEventHandler);
        this.switchBorder.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.switchBorder.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseEventHandler);
        this.tile.activeProperty().addListener(this.selectedListener);
        this.tile.valueProperty().addListener(this.valueListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
            Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
            Helper.enableNode((Node)this.description, !this.tile.getDescription().isEmpty());
        }
    }

    private void moveThumb() {
        KeyValue switchThumbLeftX = new KeyValue((WritableValue)this.switchThumb.centerXProperty(), (Object)(this.switchBackground.getLayoutX() + this.size * 0.05));
        KeyValue switchThumbRightX = new KeyValue((WritableValue)this.switchThumb.centerXProperty(), (Object)(this.switchBackground.getLayoutX() + this.switchBackground.getWidth() - this.size * 0.05));
        KeyValue switchBackgroundLeftColor = new KeyValue((WritableValue)this.switchBackground.fillProperty(), (Object)this.tile.getBackgroundColor());
        KeyValue switchBackgroundRightColor = new KeyValue((WritableValue)this.switchBackground.fillProperty(), (Object)this.tile.getActiveColor());
        if (this.tile.isActive()) {
            KeyFrame kf0 = new KeyFrame(Duration.ZERO, new KeyValue[]{switchThumbLeftX, switchBackgroundLeftColor});
            KeyFrame kf1 = new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{switchThumbRightX, switchBackgroundRightColor});
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf0, kf1});
        } else {
            KeyFrame kf0 = new KeyFrame(Duration.ZERO, new KeyValue[]{switchThumbRightX, switchBackgroundRightColor});
            KeyFrame kf1 = new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{switchThumbLeftX, switchBackgroundLeftColor});
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf0, kf1});
        }
        this.timeline.play();
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(VALUE));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        }
        this.resizeDynamicText();
        this.centerX = this.trackStart + this.trackLength * ((VALUE - this.minValue) / this.range);
        this.thumb.setCenterX(Helper.clamp(this.trackStart, this.trackStart + this.trackLength, this.centerX));
        this.thumb.setFill((Paint)(Double.compare(VALUE, this.tile.getMinValue()) != 0 ? this.tile.getBarColor() : this.tile.getForegroundColor()));
        this.bar.setWidth(this.thumb.getCenterX() - this.trackStart);
    }

    private void thumbDragged(double POSITION) {
        this.tile.setValue(Helper.clamp(this.minValue, this.maxValue, POSITION * this.range + this.minValue));
    }

    @Override
    public void dispose() {
        this.thumb.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.thumb.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseEventHandler);
        this.thumb.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseEventHandler);
        this.switchBorder.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.switchBorder.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseEventHandler);
        this.tile.activeProperty().removeListener(this.selectedListener);
        this.tile.valueProperty().removeListener(this.valueListener);
        super.dispose();
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
        maxWidth = this.width - this.size * 0.275;
        fontSize = this.size * 0.12;
        this.unitText.setText(this.tile.getUnit());
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        fontSize = this.size * 0.1;
        this.description.setFont(Fonts.latoRegular(fontSize));
    }

    @Override
    protected void resize() {
        super.resize();
        this.description.setPrefSize(this.contentBounds.getWidth(), this.size * 0.43);
        this.description.relocate(this.contentBounds.getX(), this.titleText.isVisible() ? this.height * 0.42 : this.height * 0.32);
        this.trackStart = this.size * 0.14;
        this.trackLength = this.width - this.size * 0.28;
        this.centerX = this.trackStart + this.trackLength * ((this.tile.getCurrentValue() - this.minValue) / this.range);
        this.centerY = this.height * 0.71;
        this.thumb.setRadius(this.size * 0.09);
        this.thumb.setCenterX(this.centerX);
        this.thumb.setCenterY(this.centerY);
        this.barBackground.setWidth(this.trackLength);
        this.barBackground.setHeight(this.size * 0.0275);
        this.barBackground.setX(this.trackStart);
        this.barBackground.setY(this.centerY - this.size * 0.01375);
        this.barBackground.setArcWidth(this.size * 0.0275);
        this.barBackground.setArcHeight(this.size * 0.0275);
        this.bar.setWidth(this.thumb.getCenterX() - this.trackStart);
        this.bar.setHeight(this.size * 0.0275);
        this.bar.setX(this.trackStart);
        this.bar.setY(this.centerY - this.size * 0.01375);
        this.bar.setArcWidth(this.size * 0.0275);
        this.bar.setArcHeight(this.size * 0.0275);
        this.switchBorder.setWidth(this.size * 0.2225);
        this.switchBorder.setHeight(this.size * 0.11);
        this.switchBorder.setArcWidth(this.size * 0.11);
        this.switchBorder.setArcHeight(this.size * 0.11);
        this.switchBorder.relocate(this.size * 0.05, this.centerY - this.size * 0.275);
        this.switchBackground.setWidth(this.size * 0.2125);
        this.switchBackground.setHeight(this.size * 0.1);
        this.switchBackground.setArcWidth(this.size * 0.1);
        this.switchBackground.setArcHeight(this.size * 0.1);
        this.switchBackground.relocate(this.switchBorder.getLayoutX() + this.size * 0.005, this.switchBorder.getLayoutY() + this.size * 0.005);
        this.switchThumb.setRadius(this.size * 0.045);
        this.switchThumb.setCenterX(this.tile.isActive() ? this.width * 0.30625 : this.width * 0.19375);
        this.switchThumb.setCenterX(this.tile.isActive() ? this.switchBackground.getLayoutX() + this.switchBackground.getWidth() - this.size * 0.05 : this.switchBackground.getLayoutX() + this.size * 0.05);
        this.switchThumb.setCenterY(this.switchBackground.getLayoutY() + this.switchBackground.getLayoutBounds().getHeight() * 0.5);
        this.valueUnitFlow.setPrefWidth(this.width - this.size * 0.1);
        this.valueUnitFlow.relocate(this.contentBounds.getX(), this.contentBounds.getY());
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.description.setText(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        this.barBackground.setFill((Paint)this.tile.getBarBackgroundColor());
        this.bar.setFill((Paint)this.tile.getBarColor());
        if (this.tile.isActive() && Double.compare(this.tile.getValue(), this.tile.getMinValue()) != 0) {
            this.thumb.setFill((Paint)this.tile.getBarColor());
        } else {
            this.thumb.setFill((Paint)this.tile.getForegroundColor());
        }
        this.switchBorder.setFill((Paint)this.tile.getForegroundColor());
        this.switchThumb.setFill((Paint)this.tile.getForegroundColor());
    }
}

