/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.skins.BarChartItem;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;

public class BarChartItemBuilder<B extends BarChartItemBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected BarChartItemBuilder() {
    }

    public static final BarChartItemBuilder create() {
        return new BarChartItemBuilder();
    }

    public final B name(String NAME) {
        this.properties.put("name", (Property)new SimpleStringProperty(NAME));
        return (B)this;
    }

    public final B value(double VALUE) {
        this.properties.put("value", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B timestamp(Instant TIMESTAMP) {
        this.properties.put("timestamp", (Property)new SimpleObjectProperty((Object)TIMESTAMP));
        return (B)this;
    }

    public final B timestamp(ZonedDateTime TIMESTAMP) {
        this.properties.put("timestamp", (Property)new SimpleObjectProperty((Object)TIMESTAMP.toInstant()));
        return (B)this;
    }

    public final B duration(Duration DURATION) {
        this.properties.put("duration", (Property)new SimpleObjectProperty((Object)DURATION));
        return (B)this;
    }

    public final B shortenNumbers(boolean SHORTEN) {
        this.properties.put("shortenNumbers", (Property)new SimpleBooleanProperty(SHORTEN));
        return (B)this;
    }

    public final B percentageVisible(boolean VISIBLE) {
        this.properties.put("percentageVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B nameColor(Color COLOR) {
        this.properties.put("nameColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B valueColor(Color COLOR) {
        this.properties.put("valueColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B barColor(Color COLOR) {
        this.properties.put("barColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B barBackgroundColor(Color COLOR) {
        this.properties.put("barBackgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B chartData(ChartData CHART_DATA) {
        this.properties.put("chartData", (Property)new SimpleObjectProperty((Object)CHART_DATA));
        return (B)this;
    }

    public final BarChartItem build() {
        BarChartItem item = new BarChartItem();
        this.properties.forEach((key, property) -> {
            switch (key) {
                case "name": {
                    item.setName((String)((StringProperty)property).get());
                    break;
                }
                case "value": {
                    item.setValue(((DoubleProperty)property).get());
                    break;
                }
                case "timestamp": {
                    item.setTimestamp((Instant)((ObjectProperty)property).get());
                    break;
                }
                case "duration": {
                    item.setDuration((Duration)((ObjectProperty)property).get());
                    break;
                }
                case "barColor": {
                    item.setBarColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "barBackgroundColor": {
                    item.setBarBackgroundColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "nameColor": {
                    item.setNameColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "valueColor": {
                    item.setValueColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "formatString": {
                    item.setFormatString((String)((StringProperty)property).get());
                    break;
                }
                case "maxValue": {
                    item.setMaxValue(((DoubleProperty)property).get());
                    break;
                }
                case "shortenNumbers": {
                    item.setShortenNumbers(((BooleanProperty)property).get());
                    break;
                }
                case "percentageVisible": {
                    item.setPercentageVisible(((BooleanProperty)property).get());
                    break;
                }
                case "onChartDataEvent": {
                    item.setOnChartDataEvent((ChartDataEventListener)((ObjectProperty)property).get());
                }
            }
        });
        return item;
    }
}

