/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import eu.hansolo.tilesfx.Section;
import eu.hansolo.tilesfx.tools.CountryPath;
import eu.hansolo.toolbox.Statistics;
import eu.hansolo.toolboxfx.geom.Bounds;
import eu.hansolo.toolboxfx.geom.CatmullRom;
import eu.hansolo.toolboxfx.geom.CornerRadii;
import eu.hansolo.toolboxfx.geom.Point;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Pair;

public class Helper {
    private static final double EPSILON = 1.0E-6;
    private static final String HIRES_COUNTRY_PROPERTIES = "eu/hansolo/tilesfx/highres.properties";
    private static final String LORES_COUNTRY_PROPERTIES = "eu/hansolo/tilesfx/lowres.properties";
    private static Properties hiresCountryProperties;
    private static Properties loresCountryProperties;
    public static final double MAP_WIDTH = 1007.9609816074371;
    public static final double MAP_HEIGHT = (double)665.242f;
    public static final double MAP_OFFSET_X = -28.72688797581196;
    public static final double MAP_OFFSET_Y = 129.7221908569336;
    public static final double MIN_FONT_SIZE = 5.0;
    public static final String[] TIME_0_TO_5;
    public static final String[] TIME_5_TO_0;
    public static final String[] TIME_0_TO_9;
    public static final String[] TIME_9_TO_0;
    public static final String[] TIME_0_TO_12;
    public static final String[] TIME_0_TO_24;
    public static final String[] TIME_24_TO_0;
    public static final String[] TIME_00_TO_59;
    public static final String[] TIME_59_TO_00;
    public static final String[] NUMERIC;
    public static final String[] ALPHANUMERIC;
    public static final String[] ALPHA;
    public static final String[] EXTENDED;
    public static final String[] EXTENDED_UMLAUTE;
    public static final String PERCENTAGE = "%";
    public static final String DEGREE = "\u00b0";
    public static final long SECONDS_PER_MINUTE = 60L;
    public static final long SECONDS_PER_HOUR = 3600L;
    public static final long SECONDS_PER_DAY = 86400L;
    public static final long SECONDS_PER_MONTH = 2592000L;
    public static final Duration TIME_PERIOD_24_HOURS;
    public static final Duration TIME_PERIOD_3_DAYS;
    public static final Duration TIME_PERIOD_5_DAYS;
    public static final Duration TIME_PERIOD_7_DAYS;
    public static final Duration TIME_PERIOD_1_MONTH;
    public static final Duration TIME_PERIOD_3_MONTH;
    public static final Duration TIME_PERIOD_6_MONTH;
    public static final Duration TIME_PERIOD_12_MONTH;
    private static final NavigableMap<Long, String> SUFFIXES;

    public static final <T extends Number> T clamp(T MIN, T MAX, T VALUE) {
        if (VALUE.doubleValue() < MIN.doubleValue()) {
            return MIN;
        }
        if (VALUE.doubleValue() > MAX.doubleValue()) {
            return MAX;
        }
        return VALUE;
    }

    public static final int clamp(int MIN, int MAX, int VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public static final long clamp(long MIN, long MAX, long VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public static final double clamp(double MIN, double MAX, double VALUE) {
        if (Double.compare(VALUE, MIN) < 0) {
            return MIN;
        }
        if (Double.compare(VALUE, MAX) > 0) {
            return MAX;
        }
        return VALUE;
    }

    public static final double clampMin(double MIN, double VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        return VALUE;
    }

    public static final double clampMax(double MAX, double VALUE) {
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public static final double round(double VALUE, int PRECISION) {
        int SCALE = (int)Math.pow(10.0, PRECISION);
        return (double)Math.round(VALUE * (double)SCALE) / (double)SCALE;
    }

    public static final double roundTo(double VALUE, double TARGET) {
        return TARGET * (double)Math.round(VALUE / TARGET);
    }

    public static final double roundToHalf(double VALUE) {
        return (double)Math.round(VALUE * 2.0) / 2.0;
    }

    public static final double nearest(double SMALLER, double VALUE, double LARGER) {
        return VALUE - SMALLER < LARGER - VALUE ? SMALLER : LARGER;
    }

    public static int roundDoubleToInt(double VALUE) {
        int i;
        double dAbs = Math.abs(VALUE);
        double result = dAbs - (double)(i = (int)dAbs);
        if (result < 0.5) {
            return VALUE < 0.0 ? -i : i;
        }
        return VALUE < 0.0 ? -(i + 1) : i + 1;
    }

    public static final double[] calcAutoScale(double MIN_VALUE, double MAX_VALUE) {
        double maxNoOfMajorTicks = 10.0;
        double maxNoOfMinorTicks = 10.0;
        double niceRange = Helper.calcNiceNumber(MAX_VALUE - MIN_VALUE, false);
        double majorTickSpace = Helper.calcNiceNumber(niceRange / (maxNoOfMajorTicks - 1.0), true);
        double niceMinValue = Math.floor(MIN_VALUE / majorTickSpace) * majorTickSpace;
        double niceMaxValue = Math.ceil(MAX_VALUE / majorTickSpace) * majorTickSpace;
        double minorTickSpace = Helper.calcNiceNumber(majorTickSpace / (maxNoOfMinorTicks - 1.0), true);
        return new double[]{niceMinValue, niceMaxValue, majorTickSpace, minorTickSpace};
    }

    public static final double[] getNiceScale(double MIN, double MAX) {
        return Helper.getNiceScale(MIN, MAX, 20);
    }

    public static final double[] getNiceScale(double MIN, double MAX, int MAX_NO_OF_TICKS) {
        double niceMax;
        double minimum = MIN;
        double maximum = MAX;
        double epsilon = (MAX - MIN) / 1000000.0;
        double range = (maximum += epsilon) - (minimum -= epsilon);
        int stepCount = MAX_NO_OF_TICKS;
        double roughStep = range / (double)(stepCount - 1);
        double[] goodNormalizedSteps = new double[]{1.0, 2.0, 5.0, 10.0};
        double stepPower = Math.pow(10.0, -Math.floor(Math.log10(Math.abs(roughStep))));
        double normalizedStep = roughStep * stepPower;
        double goodNormalizedStep = Arrays.stream(goodNormalizedSteps).filter(n -> Double.compare(n, normalizedStep) >= 0).findFirst().getAsDouble();
        double niceStep = goodNormalizedStep / stepPower;
        double niceMin = minimum < 0.0 ? Math.floor(minimum / niceStep) * niceStep : Math.ceil(minimum / niceStep) * niceStep;
        double d = niceMax = maximum < 0.0 ? Math.floor(maximum / niceStep) * niceStep : Math.ceil(maximum / niceStep) * niceStep;
        if (MIN % niceStep == 0.0) {
            niceMin = MIN;
        }
        if (MAX % niceStep == 0.0) {
            niceMax = MAX;
        }
        double niceRange = niceMax - niceMin;
        return new double[]{niceMin, niceMax, niceRange, niceStep};
    }

    public static double snapToTicks(double MIN_VALUE, double MAX_VALUE, double VALUE, int MINOR_TICK_COUNT, double MAJOR_TICK_UNIT) {
        double v = VALUE;
        int minorTickCount = Helper.clamp(0, 10, MINOR_TICK_COUNT);
        double majorTickUnit = Double.compare(MAJOR_TICK_UNIT, 0.0) <= 0 ? 0.25 : MAJOR_TICK_UNIT;
        double tickSpacing = minorTickCount != 0 ? majorTickUnit / (double)(Math.max(minorTickCount, 0) + 1) : majorTickUnit;
        int prevTick = (int)((v - MIN_VALUE) / tickSpacing);
        double prevTickValue = (double)prevTick * tickSpacing + MIN_VALUE;
        double nextTickValue = (double)(prevTick + 1) * tickSpacing + MIN_VALUE;
        v = Helper.nearest(prevTickValue, v, nextTickValue);
        return Helper.clamp(MIN_VALUE, MAX_VALUE, v);
    }

    public static final double calcNiceNumber(double RANGE, boolean ROUND) {
        double exponent = Math.floor(Math.log10(RANGE));
        double fraction = RANGE / Math.pow(10.0, exponent);
        double niceFraction = ROUND ? (Double.compare(fraction, 1.5) < 0 ? 1.0 : (Double.compare(fraction, 3.0) < 0 ? 2.0 : (Double.compare(fraction, 7.0) < 0 ? 5.0 : 10.0))) : (Double.compare(fraction, 1.0) <= 0 ? 1.0 : (Double.compare(fraction, 2.0) <= 0 ? 2.0 : (Double.compare(fraction, 5.0) <= 0 ? 5.0 : 10.0)));
        return niceFraction * Math.pow(10.0, exponent);
    }

    public static final Color getColorOfSection(List<Section> SECTIONS, double VALUE, Color DEFAULT_COLOR) {
        for (Section section : SECTIONS) {
            if (!section.contains(VALUE)) continue;
            return section.getColor();
        }
        return DEFAULT_COLOR;
    }

    public static final double adjustTextSize(Text TEXT, double MAX_WIDTH, double FONT_SIZE) {
        String FONT_NAME = TEXT.getFont().getName();
        double adjustableFontSize = FONT_SIZE;
        while (TEXT.getLayoutBounds().getWidth() > MAX_WIDTH && adjustableFontSize > 5.0) {
            TEXT.setFont(new Font(FONT_NAME, adjustableFontSize -= 0.1));
        }
        return adjustableFontSize;
    }

    public static final void adjustTextSize(Label TEXT, double MAX_WIDTH, double FONT_SIZE) {
        String FONT_NAME = TEXT.getFont().getName();
        double adjustableFontSize = FONT_SIZE;
        while (TEXT.getLayoutBounds().getWidth() > MAX_WIDTH && adjustableFontSize > 5.0) {
            TEXT.setFont(new Font(FONT_NAME, adjustableFontSize -= 0.1));
        }
    }

    public static final void fitNodeWidth(Node NODE, double MAX_WIDTH) {
        NODE.setVisible(NODE.getLayoutBounds().getWidth() < MAX_WIDTH);
    }

    public static final DateTimeFormatter getDateFormat(Locale LOCALE) {
        if (Locale.US == LOCALE) {
            return DateTimeFormatter.ofPattern("MM/dd/YYYY");
        }
        if (Locale.CHINA == LOCALE) {
            return DateTimeFormatter.ofPattern("YYYY.MM.dd");
        }
        return DateTimeFormatter.ofPattern("dd.MM.getY()YYY");
    }

    public static final DateTimeFormatter getLocalizedDateFormat(Locale LOCALE) {
        return DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(LOCALE);
    }

    public static final void enableNode(Node NODE, boolean ENABLE) {
        NODE.setManaged(ENABLE);
        NODE.setVisible(ENABLE);
    }

    public static final String colorToCss(Color COLOR) {
        return COLOR.toString().replace("0x", "#");
    }

    public static final ThreadFactory getThreadFactory(String THREAD_NAME, boolean IS_DAEMON) {
        return runnable -> {
            Thread thread = new Thread(runnable, THREAD_NAME);
            thread.setDaemon(IS_DAEMON);
            return thread;
        };
    }

    public static final void stopTask(ScheduledFuture<?> task) {
        if (null == task) {
            return;
        }
        task.cancel(true);
        task = null;
    }

    public static final boolean isMonochrome(Color COLOR) {
        return Double.compare(COLOR.getRed(), COLOR.getGreen()) == 0 && Double.compare(COLOR.getGreen(), COLOR.getBlue()) == 0;
    }

    public static final double colorDistance(Color COLOR_1, Color COLOR_2) {
        double DELTA_R = COLOR_2.getRed() - COLOR_1.getRed();
        double DELTA_G = COLOR_2.getGreen() - COLOR_1.getGreen();
        double DELTA_B = COLOR_2.getBlue() - COLOR_1.getBlue();
        return Math.sqrt(DELTA_R * DELTA_R + DELTA_G * DELTA_G + DELTA_B * DELTA_B);
    }

    public static double[] colorToYUV(Color COLOR) {
        double WEIGHT_FACTOR_RED = 0.299;
        double WEIGHT_FACTOR_GREEN = 0.587;
        double WEIGHT_FACTOR_BLUE = 0.144;
        double U_MAX = 0.436;
        double V_MAX = 0.615;
        double y = Helper.clamp(0.0, 1.0, 0.299 * COLOR.getRed() + 0.587 * COLOR.getGreen() + 0.144 * COLOR.getBlue());
        double u = Helper.clamp(-0.436, 0.436, 0.436 * ((COLOR.getBlue() - y) / 0.856));
        double v = Helper.clamp(-0.615, 0.615, 0.615 * ((COLOR.getRed() - y) / 0.7010000000000001));
        return new double[]{y, u, v};
    }

    public static final boolean isBright(Color COLOR) {
        return (double)Double.compare(Helper.colorToYUV(COLOR)[0], 0.5) >= 0.0;
    }

    public static final boolean isDark(Color COLOR) {
        return Helper.colorToYUV(COLOR)[0] < 0.5;
    }

    public static final Color getContrastColor(Color COLOR) {
        return COLOR.getBrightness() > 0.5 ? Color.BLACK : Color.WHITE;
    }

    public static final Color getColorWithOpacity(Color COLOR, double OPACITY) {
        return Color.color((double)COLOR.getRed(), (double)COLOR.getGreen(), (double)COLOR.getBlue(), (double)Helper.clamp(0.0, 1.0, OPACITY));
    }

    public static final List<Color> createColorPalette(Color FROM_COLOR, Color TO_COLOR, int NO_OF_COLORS) {
        int steps = Helper.clamp(1, 12, NO_OF_COLORS) - 1;
        double step = 1.0 / (double)steps;
        double deltaRed = (TO_COLOR.getRed() - FROM_COLOR.getRed()) * step;
        double deltaGreen = (TO_COLOR.getGreen() - FROM_COLOR.getGreen()) * step;
        double deltaBlue = (TO_COLOR.getBlue() - FROM_COLOR.getBlue()) * step;
        double deltaOpacity = (TO_COLOR.getOpacity() - FROM_COLOR.getOpacity()) * step;
        ArrayList<Color> palette = new ArrayList<Color>(NO_OF_COLORS);
        Color currentColor = FROM_COLOR;
        palette.add(currentColor);
        for (int i = 0; i < steps; ++i) {
            double red = Helper.clamp(0.0, 1.0, currentColor.getRed() + deltaRed);
            double green = Helper.clamp(0.0, 1.0, currentColor.getGreen() + deltaGreen);
            double blue = Helper.clamp(0.0, 1.0, currentColor.getBlue() + deltaBlue);
            double opacity = Helper.clamp(0.0, 1.0, currentColor.getOpacity() + deltaOpacity);
            currentColor = Color.color((double)red, (double)green, (double)blue, (double)opacity);
            palette.add(currentColor);
        }
        return palette;
    }

    public static final Color[] createColorVariations(Color COLOR, int NO_OF_COLORS) {
        int noOfColors = Helper.clamp(1, 12, NO_OF_COLORS);
        double step = 0.8 / (double)noOfColors;
        double hue = COLOR.getHue();
        double brg = COLOR.getBrightness();
        Color[] colors = new Color[noOfColors];
        for (int i = 0; i < noOfColors; ++i) {
            colors[i] = Color.hsb((double)hue, (double)(0.2 + (double)i * step), (double)brg);
        }
        return colors;
    }

    public static final Color getColorAt(List<Stop> STOP_LIST, double POSITION_OF_COLOR) {
        Color COLOR;
        TreeMap<Double, Stop> STOPS = new TreeMap<Double, Stop>();
        for (Stop stop : STOP_LIST) {
            STOPS.put(stop.getOffset(), stop);
        }
        if (STOPS.isEmpty()) {
            return Color.BLACK;
        }
        double minFraction = (Double)Collections.min(STOPS.keySet());
        double maxFraction = (Double)Collections.max(STOPS.keySet());
        if (Double.compare(minFraction, 0.0) > 0) {
            STOPS.put(0.0, new Stop(0.0, ((Stop)STOPS.get(minFraction)).getColor()));
        }
        if (Double.compare(maxFraction, 1.0) < 0) {
            STOPS.put(1.0, new Stop(1.0, ((Stop)STOPS.get(maxFraction)).getColor()));
        }
        double POSITION = Helper.clamp(0.0, 1.0, POSITION_OF_COLOR);
        if (STOPS.size() == 1) {
            Map ONE_ENTRY = (Map)((Object)STOPS.entrySet().iterator().next());
            COLOR = ((Stop)STOPS.get(ONE_ENTRY.keySet().iterator().next())).getColor();
        } else {
            Stop lowerBound = (Stop)STOPS.get(0.0);
            Stop upperBound = (Stop)STOPS.get(1.0);
            for (Map.Entry entry : STOPS.entrySet()) {
                double fraction = (Double)entry.getKey();
                if (Double.compare(fraction, POSITION) < 0) {
                    lowerBound = (Stop)STOPS.get(fraction);
                }
                if (Double.compare(fraction, POSITION) <= 0) continue;
                upperBound = (Stop)STOPS.get(fraction);
                break;
            }
            COLOR = Helper.interpolateColor(lowerBound, upperBound, POSITION);
        }
        return COLOR;
    }

    public static final Color interpolateColor(Stop LOWER_BOUND, Stop UPPER_BOUND, double POSITION) {
        double POS = (POSITION - LOWER_BOUND.getOffset()) / (UPPER_BOUND.getOffset() - LOWER_BOUND.getOffset());
        double DELTA_RED = (UPPER_BOUND.getColor().getRed() - LOWER_BOUND.getColor().getRed()) * POS;
        double DELTA_GREEN = (UPPER_BOUND.getColor().getGreen() - LOWER_BOUND.getColor().getGreen()) * POS;
        double DELTA_BLUE = (UPPER_BOUND.getColor().getBlue() - LOWER_BOUND.getColor().getBlue()) * POS;
        double DELTA_OPACITY = (UPPER_BOUND.getColor().getOpacity() - LOWER_BOUND.getColor().getOpacity()) * POS;
        double red = Helper.clamp(0.0, 1.0, LOWER_BOUND.getColor().getRed() + DELTA_RED);
        double green = Helper.clamp(0.0, 1.0, LOWER_BOUND.getColor().getGreen() + DELTA_GREEN);
        double blue = Helper.clamp(0.0, 1.0, LOWER_BOUND.getColor().getBlue() + DELTA_BLUE);
        double opacity = Helper.clamp(0.0, 1.0, LOWER_BOUND.getColor().getOpacity() + DELTA_OPACITY);
        return Color.color((double)red, (double)green, (double)blue, (double)opacity);
    }

    public static final void scaleNodeTo(Node NODE, double TARGET_WIDTH, double TARGET_HEIGHT) {
        NODE.setScaleX(TARGET_WIDTH / NODE.getLayoutBounds().getWidth());
        NODE.setScaleY(TARGET_HEIGHT / NODE.getLayoutBounds().getHeight());
    }

    public static final String normalize(String TEXT) {
        String normalized = TEXT.replaceAll("\u00fc", "ue").replaceAll("\u00f6", "oe").replaceAll("\u00e4", "ae").replaceAll("\u00df", "ss");
        normalized = normalized.replaceAll("\u00dc(?=[a-z\u00fc\u00f6\u00e4\u00df ])", "Ue").replaceAll("\u00d6(?=[a-z\u00fc\u00f6\u00e4\u00df ])", "Oe").replaceAll("\u00c4(?=[a-z\u00fc\u00f6\u00e4\u00df ])", "Ae");
        normalized = normalized.replaceAll("\u00dc", "UE").replaceAll("\u00d6", "OE").replaceAll("\u00c4", "AE");
        return normalized;
    }

    public static final boolean equals(double A, double B) {
        return A == B || Math.abs(A - B) < 1.0E-6;
    }

    public static final boolean biggerThan(double A, double B) {
        return A - B > 1.0E-6;
    }

    public static final boolean lessThan(double A, double B) {
        return B - A > 1.0E-6;
    }

    public static final List<Point> subdividePoints(List<Point> POINTS, int SUB_DEVISIONS) {
        Point[] points = POINTS.toArray(new Point[0]);
        return Arrays.asList(Helper.subdividePoints(points, SUB_DEVISIONS));
    }

    public static final Point[] subdividePoints(Point[] POINTS, int SUB_DEVISIONS) {
        if (null == POINTS || POINTS.length < 3) {
            throw new IllegalArgumentException("Points cannot be null and must at least contain 3 items");
        }
        int noOfPoints = POINTS.length;
        Point[] subdividedPoints = new Point[(noOfPoints - 1) * SUB_DEVISIONS + 1];
        double increments = 1.0 / (double)SUB_DEVISIONS;
        for (int i = 0; i < noOfPoints - 1; ++i) {
            Point p0 = i == 0 ? POINTS[i] : POINTS[i - 1];
            Point p1 = POINTS[i];
            Point p2 = POINTS[i + 1];
            Point p3 = i + 2 == noOfPoints ? POINTS[i + 1] : POINTS[i + 2];
            CatmullRom crs = new CatmullRom(p0, p1, p2, p3);
            for (int j = 0; j <= SUB_DEVISIONS; ++j) {
                subdividedPoints[i * SUB_DEVISIONS + j] = crs.q((double)j * increments);
            }
        }
        return subdividedPoints;
    }

    public static final Point[] smoothSparkLine(List<Double> DATA_LIST, double MIN_VALUE, double MAX_VALUE, Rectangle GRAPH_BOUNDS, int NO_OF_DATAPOINTS) {
        double high;
        int size = DATA_LIST.size();
        Point[] points = new Point[size];
        double low = Statistics.getMin(DATA_LIST);
        if (Helper.equals(low, high = Statistics.getMax(DATA_LIST))) {
            low = MIN_VALUE;
            high = MAX_VALUE;
        }
        double range = high - low;
        double minX = GRAPH_BOUNDS.getX();
        double maxX = minX + GRAPH_BOUNDS.getWidth();
        double minY = GRAPH_BOUNDS.getY();
        double maxY = minY + GRAPH_BOUNDS.getHeight();
        double stepX = GRAPH_BOUNDS.getWidth() / (double)(NO_OF_DATAPOINTS - 1);
        double stepY = GRAPH_BOUNDS.getHeight() / range;
        for (int i = 0; i < size; ++i) {
            points[i] = new Point(minX + (double)i * stepX, maxY - Math.abs(low - DATA_LIST.get(i)) * stepY);
        }
        return Helper.subdividePoints(points, 16);
    }

    public static final Map<String, List<CountryPath>> getHiresCountryPaths() {
        if (null == hiresCountryProperties) {
            hiresCountryProperties = Helper.readProperties(HIRES_COUNTRY_PROPERTIES);
        }
        ConcurrentHashMap<String, List<CountryPath>> hiresCountryPaths = new ConcurrentHashMap<String, List<CountryPath>>();
        hiresCountryProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String name = key.toString();
            ArrayList<CountryPath> pathList = new ArrayList<CountryPath>();
            for (String path : value.toString().split(";")) {
                pathList.add(new CountryPath(name, path));
            }
            hiresCountryPaths.put(name, pathList);
        }));
        return hiresCountryPaths;
    }

    public static final Map<String, List<CountryPath>> getLoresCountryPaths() {
        if (null == loresCountryProperties) {
            loresCountryProperties = Helper.readProperties(LORES_COUNTRY_PROPERTIES);
        }
        ConcurrentHashMap<String, List<CountryPath>> loresCountryPaths = new ConcurrentHashMap<String, List<CountryPath>>();
        loresCountryProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String name = key.toString();
            ArrayList<CountryPath> pathList = new ArrayList<CountryPath>();
            for (String path : value.toString().split(";")) {
                pathList.add(new CountryPath(name, path));
            }
            loresCountryPaths.put(name, pathList);
        }));
        return loresCountryPaths;
    }

    private static final Properties readProperties(String FILE_NAME) {
        ClassLoader LOADER = Thread.currentThread().getContextClassLoader();
        Properties PROPERTIES = new Properties();
        try (InputStream resourceStream = LOADER.getResourceAsStream(FILE_NAME);){
            PROPERTIES.load(resourceStream);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return PROPERTIES;
    }

    public static final void drawRoundedRect(GraphicsContext CTX, Bounds BOUNDS, CornerRadii RADII) {
        double x = BOUNDS.getX();
        double y = BOUNDS.getY();
        double width = BOUNDS.getWidth();
        double height = BOUNDS.getHeight();
        double xPlusWidth = x + width;
        double yPlusHeight = y + height;
        CTX.beginPath();
        CTX.moveTo(x + RADII.getTopLeft(), y);
        CTX.lineTo(xPlusWidth - RADII.getTopRight(), y);
        CTX.quadraticCurveTo(xPlusWidth, y, xPlusWidth, y + RADII.getTopRight());
        CTX.lineTo(xPlusWidth, yPlusHeight - RADII.getBottomRight());
        CTX.quadraticCurveTo(xPlusWidth, yPlusHeight, xPlusWidth - RADII.getBottomRight(), yPlusHeight);
        CTX.lineTo(x + RADII.getBottomLeft(), yPlusHeight);
        CTX.quadraticCurveTo(x, yPlusHeight, x, yPlusHeight - RADII.getBottomLeft());
        CTX.lineTo(x, y + RADII.getTopLeft());
        CTX.quadraticCurveTo(x, y, x + RADII.getTopLeft(), y);
        CTX.closePath();
    }

    public static final void smoothPath(Path PATH, boolean FILLED) {
        ObservableList pathElements = PATH.getElements();
        if (pathElements.isEmpty()) {
            return;
        }
        Point[] dataPoints = new Point[pathElements.size()];
        for (int i = 0; i < pathElements.size(); ++i) {
            PathElement element = (PathElement)pathElements.get(i);
            if (element instanceof MoveTo) {
                MoveTo move = (MoveTo)element;
                dataPoints[i] = new Point(move.getX(), move.getY());
                continue;
            }
            if (!(element instanceof LineTo)) continue;
            LineTo line = (LineTo)element;
            dataPoints[i] = new Point(line.getX(), line.getY());
        }
        double zeroY = ((MoveTo)pathElements.get(0)).getY();
        ArrayList<Object> smoothedElements = new ArrayList<Object>();
        Pair<Point[], Point[]> result = Helper.calcCurveControlPoints(dataPoints);
        Point[] firstControlPoints = (Point[])result.getKey();
        Point[] secondControlPoints = (Point[])result.getValue();
        if (FILLED) {
            smoothedElements.add(new MoveTo(dataPoints[0].getX(), zeroY));
            smoothedElements.add(new LineTo(dataPoints[0].getX(), dataPoints[0].getY()));
        } else {
            smoothedElements.add(new MoveTo(dataPoints[0].getX(), dataPoints[0].getY()));
        }
        for (int i = 2; i < dataPoints.length; ++i) {
            int ci = i - 1;
            smoothedElements.add(new CubicCurveTo(firstControlPoints[ci].getX(), firstControlPoints[ci].getY(), secondControlPoints[ci].getX(), secondControlPoints[ci].getY(), dataPoints[i].getX(), dataPoints[i].getY()));
        }
        if (FILLED) {
            smoothedElements.add(new LineTo(dataPoints[dataPoints.length - 1].getX(), zeroY));
            smoothedElements.add(new ClosePath());
        }
        PATH.getElements().setAll(smoothedElements);
    }

    public static final Path smoothPath(ObservableList<PathElement> ELEMENTS, boolean FILLED) {
        if (ELEMENTS.isEmpty()) {
            return new Path();
        }
        Point[] dataPoints = new Point[ELEMENTS.size()];
        for (int i = 0; i < ELEMENTS.size(); ++i) {
            PathElement element = (PathElement)ELEMENTS.get(i);
            if (element instanceof MoveTo) {
                MoveTo move = (MoveTo)element;
                dataPoints[i] = new Point(move.getX(), move.getY());
                continue;
            }
            if (!(element instanceof LineTo)) continue;
            LineTo line = (LineTo)element;
            dataPoints[i] = new Point(line.getX(), line.getY());
        }
        double zeroY = ((MoveTo)ELEMENTS.get(0)).getY();
        ArrayList<Object> smoothedElements = new ArrayList<Object>();
        Pair<Point[], Point[]> result = Helper.calcCurveControlPoints(dataPoints);
        Point[] firstControlPoints = (Point[])result.getKey();
        Point[] secondControlPoints = (Point[])result.getValue();
        if (FILLED) {
            smoothedElements.add(new MoveTo(dataPoints[0].getX(), zeroY));
            smoothedElements.add(new LineTo(dataPoints[0].getX(), dataPoints[0].getY()));
        } else {
            smoothedElements.add(new MoveTo(dataPoints[0].getX(), dataPoints[0].getY()));
        }
        for (int i = 2; i < dataPoints.length; ++i) {
            int ci = i - 1;
            smoothedElements.add(new CubicCurveTo(firstControlPoints[ci].getX(), firstControlPoints[ci].getY(), secondControlPoints[ci].getX(), secondControlPoints[ci].getY(), dataPoints[i].getX(), dataPoints[i].getY()));
        }
        if (FILLED) {
            smoothedElements.add(new LineTo(dataPoints[dataPoints.length - 1].getX(), zeroY));
            smoothedElements.add(new ClosePath());
        }
        return new Path(smoothedElements);
    }

    private static final Pair<Point[], Point[]> calcCurveControlPoints(Point[] DATA_POINTS) {
        int n = DATA_POINTS.length - 1;
        if (n == 1) {
            Point[] firstControlPoints = new Point[]{new Point((2.0 * DATA_POINTS[0].getX() + DATA_POINTS[1].getX()) / 3.0, (2.0 * DATA_POINTS[0].getY() + DATA_POINTS[1].getY()) / 3.0)};
            Point[] secondControlPoints = new Point[]{new Point(2.0 * firstControlPoints[0].getX() - DATA_POINTS[0].getX(), 2.0 * firstControlPoints[0].getY() - DATA_POINTS[0].getY())};
            return new Pair((Object)firstControlPoints, (Object)secondControlPoints);
        }
        double[] rhs = new double[n];
        for (int i = 1; i < n - 1; ++i) {
            rhs[i] = 4.0 * DATA_POINTS[i].getX() + 2.0 * DATA_POINTS[i + 1].getX();
        }
        rhs[0] = DATA_POINTS[0].getX() + 2.0 * DATA_POINTS[1].getX();
        rhs[n - 1] = (8.0 * DATA_POINTS[n - 1].getX() + DATA_POINTS[n].getX()) / 2.0;
        double[] x = Helper.getFirstControlPoints(rhs);
        for (int i = 1; i < n - 1; ++i) {
            rhs[i] = 4.0 * DATA_POINTS[i].getY() + 2.0 * DATA_POINTS[i + 1].getY();
        }
        rhs[0] = DATA_POINTS[0].getY() + 2.0 * DATA_POINTS[1].getY();
        rhs[n - 1] = (8.0 * DATA_POINTS[n - 1].getY() + DATA_POINTS[n].getY()) / 2.0;
        double[] y = Helper.getFirstControlPoints(rhs);
        Point[] firstControlPoints = new Point[n];
        Point[] secondControlPoints = new Point[n];
        for (int i = 0; i < n; ++i) {
            firstControlPoints[i] = new Point(x[i], y[i]);
            secondControlPoints[i] = i < n - 1 ? new Point(2.0 * DATA_POINTS[i + 1].getX() - x[i + 1], 2.0 * DATA_POINTS[i + 1].getY() - y[i + 1]) : new Point((DATA_POINTS[n].getX() + x[n - 1]) / 2.0, (DATA_POINTS[n].getY() + y[n - 1]) / 2.0);
        }
        return new Pair((Object)firstControlPoints, (Object)secondControlPoints);
    }

    private static final double[] getFirstControlPoints(double[] rhs) {
        int i;
        int n = rhs.length;
        double[] x = new double[n];
        double[] tmp = new double[n];
        double b = 2.0;
        x[0] = rhs[0] / b;
        for (i = 1; i < n; ++i) {
            tmp[i] = 1.0 / b;
            b = (i < n - 1 ? 4.0 : 3.5) - tmp[i];
            x[i] = (rhs[i] - x[i - 1]) / b;
        }
        for (i = 1; i < n; ++i) {
            int n2 = n - i - 1;
            x[n2] = x[n2] - tmp[n - i] * x[n - i];
        }
        return x;
    }

    public static final boolean isInRectangle(double X, double Y, double MIN_X, double MIN_Y, double MAX_X, double MAX_Y) {
        return Double.compare(X, MIN_X) >= 0 && Double.compare(X, MAX_X) <= 0 && Double.compare(Y, MIN_Y) >= 0 && Double.compare(Y, MAX_Y) <= 0;
    }

    public static final boolean isInEllipse(double X, double Y, double ELLIPSE_CENTER_X, double ELLIPSE_CENTER_Y, double ELLIPSE_RADIUS_X, double ELLIPSE_RADIUS_Y) {
        return (double)Double.compare((X - ELLIPSE_CENTER_X) * (X - ELLIPSE_CENTER_X) / (ELLIPSE_RADIUS_X * ELLIPSE_RADIUS_X) + (Y - ELLIPSE_CENTER_Y) * (Y - ELLIPSE_CENTER_Y) / (ELLIPSE_RADIUS_Y * ELLIPSE_RADIUS_Y), 1.0) <= 0.0;
    }

    public static final boolean isInPolygon(double X, double Y, Polygon POLYGON) {
        ObservableList points = POLYGON.getPoints();
        int noOfPointsInPolygon = POLYGON.getPoints().size() / 2;
        double[] pointsX = new double[noOfPointsInPolygon];
        double[] pointsY = new double[noOfPointsInPolygon];
        int pointCounter = 0;
        int size = points.size();
        for (int i = 0; i < size - 1; i += 2) {
            pointsX[pointCounter] = (Double)points.get(i);
            pointsY[pointCounter] = (Double)points.get(i + 1);
            ++pointCounter;
        }
        return Helper.isInPolygon(X, Y, noOfPointsInPolygon, pointsX, pointsY);
    }

    public static final boolean isInPolygon(double X, double Y, int NO_OF_POINTS_IN_POLYGON, double[] POINTS_X, double[] POINTS_Y) {
        if (NO_OF_POINTS_IN_POLYGON != POINTS_X.length || NO_OF_POINTS_IN_POLYGON != POINTS_Y.length) {
            return false;
        }
        boolean inside = false;
        int i = 0;
        int j = NO_OF_POINTS_IN_POLYGON - 1;
        while (i < NO_OF_POINTS_IN_POLYGON) {
            if (POINTS_Y[i] > Y != POINTS_Y[j] > Y && X < (POINTS_X[j] - POINTS_X[i]) * (Y - POINTS_Y[i]) / (POINTS_Y[j] - POINTS_Y[i]) + POINTS_X[i]) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    public static final boolean isInRingSegment(double X, double Y, double CENTER_X, double CENTER_Y, double OUTER_RADIUS, double INNER_RADIUS, double START_ANGLE, double SEGMENT_ANGLE) {
        double angleOffset = 90.0;
        double pointRadius = Math.sqrt((X - CENTER_X) * (X - CENTER_X) + (Y - CENTER_Y) * (Y - CENTER_Y));
        double pointAngle = Helper.getAngleFromXY(X, Y, CENTER_X, CENTER_Y, angleOffset);
        double startAngle = angleOffset - START_ANGLE;
        double endAngle = startAngle + SEGMENT_ANGLE;
        return Double.compare(pointRadius, INNER_RADIUS) >= 0 && Double.compare(pointRadius, OUTER_RADIUS) <= 0 && Double.compare(pointAngle, startAngle) >= 0 && Double.compare(pointAngle, endAngle) <= 0;
    }

    public static final double distance(Point P1, Point P2) {
        return Helper.distance(P1.getX(), P1.getY(), P2.getX(), P2.getY());
    }

    public static final double distance(double P1_X, double P1_Y, double P2_X, double P2_Y) {
        return Math.sqrt((P2_X - P1_X) * (P2_X - P1_X) + (P2_Y - P1_Y) * (P2_Y - P1_Y));
    }

    public static double euclideanDistance(Point P1, Point P2) {
        return Helper.euclideanDistance(P1.getX(), P1.getY(), P2.getX(), P2.getY());
    }

    public static double euclideanDistance(double X1, double Y1, double X2, double Y2) {
        double deltaX = X2 - X1;
        double deltaY = Y2 - Y1;
        return deltaX * deltaX + deltaY * deltaY;
    }

    public static final Point pointOnLine(double P1_X, double P1_Y, double P2_X, double P2_Y, double DISTAINCE_TOP_2) {
        double distanceP1P2 = Helper.distance(P1_X, P1_Y, P2_X, P2_Y);
        double t = DISTAINCE_TOP_2 / distanceP1P2;
        return new Point((1.0 - t) * P1_X + t * P2_X, (1.0 - t) * P1_Y + t * P2_Y);
    }

    public static int checkLineCircleCollision(Point P1, Point P2, double CENTER_X, double CENTER_Y, double RADIUS) {
        return Helper.checkLineCircleCollision(P1.getX(), P1.getY(), P2.getX(), P2.getY(), CENTER_X, CENTER_Y, RADIUS);
    }

    public static int checkLineCircleCollision(double P1_X, double P1_Y, double P2_X, double P2_Y, double CENTER_X, double CENTER_Y, double RADIUS) {
        double A = P1_Y - P2_Y;
        double B = P2_X - P1_X;
        double C = P1_X * P2_Y - P2_X * P1_Y;
        return Helper.checkCollision(A, B, C, CENTER_X, CENTER_Y, RADIUS);
    }

    public static int checkCollision(double a, double b, double c, double centerX, double centerY, double radius) {
        double dist = Math.abs(a * centerX + b * centerY + c) / Math.sqrt(a * a + b * b);
        if (radius > (dist = Helper.round(dist, 1))) {
            return 1;
        }
        if (radius < dist) {
            return -1;
        }
        return 0;
    }

    public static final double getAngleFromXY(double X, double Y, double CENTER_X, double CENTER_Y) {
        return Helper.getAngleFromXY(X, Y, CENTER_X, CENTER_Y, 90.0);
    }

    public static final double getAngleFromXY(double X, double Y, double CENTER_X, double CENTER_Y, double ANGLE_OFFSET) {
        double nx;
        double deltaY = Y - CENTER_Y;
        double deltaX = X - CENTER_X;
        double radius = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        double ny = deltaY / radius;
        double theta = Math.atan2(ny, nx = deltaX / radius);
        theta = Double.compare(theta, 0.0) >= 0 ? Math.toDegrees(theta) : Math.toDegrees(theta) + 360.0;
        double angle = (theta + ANGLE_OFFSET) % 360.0;
        return angle;
    }

    public static final Point rotatePointAroundRotationCenter(Point POINT, Point ROTATION_CENTER, double ANGLE) {
        double[] xy = Helper.rotatePointAroundRotationCenter(POINT.getX(), POINT.getY(), ROTATION_CENTER.getX(), ROTATION_CENTER.getY(), ANGLE);
        return new Point(xy[0], xy[1]);
    }

    public static final double[] rotatePointAroundRotationCenter(double X, double Y, double RX, double RY, double ANGLE) {
        double rad = Math.toRadians(ANGLE);
        double sin = Math.sin(rad);
        double cos = Math.cos(rad);
        double nX = RX + (X - RX) * cos - (Y - RY) * sin;
        double nY = RY + (X - RX) * sin + (Y - RY) * cos;
        return new double[]{nX, nY};
    }

    public static final Point getPointBetweenP1AndP2(Point P1, Point P2) {
        double[] xy = Helper.getPointBetweenP1AndP2(P1.getX(), P1.getY(), P2.getX(), P2.getY());
        return new Point(xy[0], xy[1]);
    }

    public static final double[] getPointBetweenP1AndP2(double P1_X, double P1_Y, double P2_X, double P2_Y) {
        return new double[]{(P1_X + P2_X) * 0.5, (P1_Y + P2_Y) * 0.5};
    }

    public static int getDegrees(double DEC_DEG) {
        return (int)DEC_DEG;
    }

    public static int getMinutes(double DEC_DEG) {
        return (int)((DEC_DEG - (double)Helper.getDegrees(DEC_DEG)) * 60.0);
    }

    public static double getSeconds(double DEC_DEG) {
        return ((DEC_DEG - (double)Helper.getDegrees(DEC_DEG)) * 60.0 - (double)Helper.getMinutes(DEC_DEG)) * 60.0;
    }

    public static double getDecimalDeg(int DEGREES, int MINUTES, double SECONDS) {
        return (SECONDS / 60.0 + (double)MINUTES) / 60.0 + (double)DEGREES;
    }

    public static final double[] latLonToXY(double LATITUDE, double LONGITUDE) {
        return Helper.latLonToXY(LATITUDE, LONGITUDE, -28.72688797581196, 129.7221908569336);
    }

    public static final double[] latLonToXY(double LATITUDE, double LONGITUDE, double MAP_OFFSET_X, double MAP_OFFSET_Y) {
        double x = (LONGITUDE + 180.0) * 2.799891615576214 + MAP_OFFSET_X;
        double y = (double)332.621f - 1007.9609816074371 * Math.log(Math.tan(0.7853981633974483 + Math.toRadians(LATITUDE) / 2.0)) / (Math.PI * 2) + MAP_OFFSET_Y;
        return new double[]{x, y};
    }

    public static final <T> Predicate<T> not(Predicate<T> PREDICATE) {
        return PREDICATE.negate();
    }

    public static final List<Point> createSmoothedConvexHull(List<Point> POINTS, int SUB_DIVISIONS) {
        List<Point> hullPolygon = Helper.createConvexHull(POINTS);
        return Helper.subdividePoints(hullPolygon, SUB_DIVISIONS);
    }

    public static final <T extends Point> List<T> createConvexHull(List<T> POINTS) {
        ArrayList<Point> convexHull = new ArrayList<Point>();
        if (POINTS.size() < 3) {
            return new ArrayList<T>(POINTS);
        }
        int minDataPoint = -1;
        int maxDataPoint = -1;
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (int i = 0; i < POINTS.size(); ++i) {
            if (((Point)POINTS.get(i)).getX() < (double)minX) {
                minX = (int)((Point)POINTS.get(i)).getX();
                minDataPoint = i;
            }
            if (!(((Point)POINTS.get(i)).getX() > (double)maxX)) continue;
            maxX = (int)((Point)POINTS.get(i)).getX();
            maxDataPoint = i;
        }
        Point minPoint = (Point)POINTS.get(minDataPoint);
        Point maxPoint = (Point)POINTS.get(maxDataPoint);
        convexHull.add(minPoint);
        convexHull.add(maxPoint);
        POINTS.remove(minPoint);
        POINTS.remove(maxPoint);
        ArrayList<Point> leftSet = new ArrayList<Point>();
        ArrayList<Point> rightSet = new ArrayList<Point>();
        for (int i = 0; i < POINTS.size(); ++i) {
            Point p = (Point)POINTS.get(i);
            if (Helper.pointLocation(minPoint, maxPoint, p) == -1) {
                leftSet.add(p);
                continue;
            }
            if (Helper.pointLocation(minPoint, maxPoint, p) != 1) continue;
            rightSet.add(p);
        }
        Helper.hullSet(minPoint, maxPoint, rightSet, convexHull);
        Helper.hullSet(maxPoint, minPoint, leftSet, convexHull);
        return convexHull;
    }

    private static final <T extends Point> double distance(T P1, T P2, T P3) {
        double deltaX = P2.getX() - P1.getX();
        double deltaY = P2.getY() - P1.getY();
        double num = deltaX * (P1.getY() - P3.getY()) - deltaY * (P1.getX() - P3.getX());
        return Math.abs(num);
    }

    private static final <T extends Point> void hullSet(T P1, T P2, List<T> POINTS, List<T> HULL) {
        int insertPosition = HULL.indexOf(P2);
        if (POINTS.size() == 0) {
            return;
        }
        if (POINTS.size() == 1) {
            Point point = (Point)POINTS.get(0);
            POINTS.remove(point);
            HULL.add(insertPosition, point);
            return;
        }
        int dist = Integer.MIN_VALUE;
        int furthestDataPoint = -1;
        for (int i = 0; i < POINTS.size(); ++i) {
            Point point = (Point)POINTS.get(i);
            double distance = Helper.distance(P1, P2, point);
            if (!(distance > (double)dist)) continue;
            dist = (int)distance;
            furthestDataPoint = i;
        }
        Point point = (Point)POINTS.get(furthestDataPoint);
        POINTS.remove(furthestDataPoint);
        HULL.add(insertPosition, point);
        ArrayList<Point> leftSetAP = new ArrayList<Point>();
        for (int i = 0; i < POINTS.size(); ++i) {
            Point M = (Point)POINTS.get(i);
            if (Helper.pointLocation(P1, point, M) != 1) continue;
            leftSetAP.add(M);
        }
        ArrayList<Point> leftSetPB = new ArrayList<Point>();
        for (int i = 0; i < POINTS.size(); ++i) {
            Point M = (Point)POINTS.get(i);
            if (Helper.pointLocation(point, P2, M) != 1) continue;
            leftSetPB.add(M);
        }
        Helper.hullSet(P1, point, leftSetAP, HULL);
        Helper.hullSet(point, P2, leftSetPB, HULL);
    }

    private static final <T extends Point> int pointLocation(T P1, T P2, T P3) {
        double cp1 = (P2.getX() - P1.getX()) * (P3.getY() - P1.getY()) - (P2.getY() - P1.getY()) * (P3.getX() - P1.getX());
        return cp1 > 0.0 ? 1 : (Double.compare(cp1, 0.0) == 0 ? 0 : -1);
    }

    public static final List<Character> splitStringInCharacters(String text) {
        return text.chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toList());
    }

    public static final List<Character> splitNumberInDigits(double number) {
        return Helper.splitStringInCharacters(Double.toString(number));
    }

    public static final String padLeft(String text, String filler, int n) {
        return String.format(PERCENTAGE + n + "s", text).replace(" ", filler);
    }

    public static final String padRight(String text, String filler, int n) {
        return String.format("%-" + n + "s", text).replace(" ", filler);
    }

    public static <T> Collector<T, ?, List<T>> lastN(int n) {
        return Collector.of(ArrayDeque::new, (acc, t) -> {
            if (acc.size() == n) {
                acc.pollFirst();
            }
            acc.add(t);
        }, (acc1, acc2) -> {
            while (acc2.size() < n && !acc1.isEmpty()) {
                acc2.addFirst(acc1.pollLast());
            }
            return acc2;
        }, ArrayList::new, new Collector.Characteristics[0]);
    }

    public static final int calcNumberOfDatapointsForPeriod(Duration TIME_PERIOD, TimeUnit RESOLUTION) {
        switch (RESOLUTION) {
            case DAYS: {
                return (int)(TIME_PERIOD.getSeconds() / 86400L);
            }
            case HOURS: {
                return (int)(TIME_PERIOD.getSeconds() / 3600L);
            }
            case MINUTES: {
                return (int)(TIME_PERIOD.getSeconds() / 60L);
            }
        }
        return (int)TIME_PERIOD.getSeconds();
    }

    public static final int calcNumberOfVerticalTickLinesForPeriod(Duration TIME_PERIOD, TimeUnit RESOLUTION) {
        switch (RESOLUTION) {
            case DAYS: {
                return (int)(TIME_PERIOD.getSeconds() / 86400L);
            }
            case HOURS: {
                return (int)(TIME_PERIOD.getSeconds() / 3600L);
            }
            case MINUTES: {
                return (int)(TIME_PERIOD.getSeconds() / 60L);
            }
        }
        return (int)TIME_PERIOD.getSeconds();
    }

    public static final String shortenNumber(long value) {
        return Helper.shortenNumber(value, Locale.US);
    }

    public static final String shortenNumber(long value, Locale locale) {
        if (value == Long.MIN_VALUE) {
            return Helper.shortenNumber(-9223372036854775807L, locale);
        }
        if (value < 0L) {
            return "-" + Helper.shortenNumber(-value, locale);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> entry = SUFFIXES.floorEntry(value);
        Long divideBy = entry.getKey();
        String suffix = entry.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        NumberFormat formatter = NumberFormat.getNumberInstance(locale);
        formatter.setMinimumFractionDigits(1);
        formatter.setMaximumFractionDigits(1);
        return hasDecimal ? formatter.format((double)truncated / 10.0) + suffix : truncated / 10L + suffix;
    }

    public static final Node createDataNode(ObjectExpression<Number> VALUE, double RADIUS) {
        return Helper.createDataNode(VALUE, "%,.2f", RADIUS, Color.WHITE);
    }

    public static final Node createDataNode(ObjectExpression<Number> VALUE, String FORMAT_STRING, double RADIUS, Color TEXT_COLOR) {
        Label label = new Label();
        label.setTextFill((Paint)TEXT_COLOR);
        label.textProperty().bind((ObservableValue)VALUE.asString(FORMAT_STRING));
        Pane pane = new Pane(new Node[]{label});
        pane.setShape((Shape)new Circle(RADIUS));
        pane.setScaleShape(false);
        label.translateYProperty().bind((ObservableValue)label.heightProperty().divide(-1.5));
        return pane;
    }

    static {
        TIME_0_TO_5 = new String[]{"1", "2", "3", "4", "5", "0"};
        TIME_5_TO_0 = new String[]{"5", "4", "3", "2", "1", "0"};
        TIME_0_TO_9 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
        TIME_9_TO_0 = new String[]{"9", "8", "7", "6", "5", "4", "3", "2", "1", "0"};
        TIME_0_TO_12 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
        TIME_0_TO_24 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "00"};
        TIME_24_TO_0 = new String[]{"00", "23", "22", "21", "20", "19", "18", "17", "16", "15", "14", "13", "12", "11", "10", "09", "08", "07", "06", "05", "04", "03", "02", "01"};
        TIME_00_TO_59 = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"};
        TIME_59_TO_00 = new String[]{"59", "58", "57", "56", "55", "54", "53", "52", "51", "50", "49", "48", "47", "46", "45", "44", "43", "42", "41", "40", "39", "38", "37", "36", "35", "34", "33", "32", "31", "30", "29", "28", "27", "26", "25", "24", "23", "22", "21", "20", "19", "18", "17", "16", "15", "14", "13", "12", "11", "10", "09", "08", "07", "06", "05", "04", "03", "02", "01", "00"};
        NUMERIC = new String[]{" ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
        ALPHANUMERIC = new String[]{" ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        ALPHA = new String[]{" ", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        EXTENDED = new String[]{" ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "-", "/", ":", ",", "", ";", "@", "#", "+", "?", "!", PERCENTAGE, "$", "=", "<", ">"};
        EXTENDED_UMLAUTE = new String[]{" ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "-", "/", ":", ",", "", ";", "@", "#", "+", "?", "!", PERCENTAGE, "$", "=", "<", ">", "\u00c4", "\u00d6", "\u00dc", "\u00df"};
        TIME_PERIOD_24_HOURS = Duration.ofHours(24L);
        TIME_PERIOD_3_DAYS = Duration.ofDays(3L);
        TIME_PERIOD_5_DAYS = Duration.ofDays(5L);
        TIME_PERIOD_7_DAYS = Duration.ofDays(7L);
        TIME_PERIOD_1_MONTH = Duration.ofSeconds((long)Period.ofMonths(1).getDays() * 86400L);
        TIME_PERIOD_3_MONTH = Duration.ofSeconds((long)Period.ofMonths(3).getDays() * 86400L);
        TIME_PERIOD_6_MONTH = Duration.ofSeconds((long)Period.ofMonths(6).getDays() * 86400L);
        TIME_PERIOD_12_MONTH = Duration.ofSeconds((long)Period.ofYears(1).getDays() * 86400L);
        SUFFIXES = new TreeMap<Long, String>(Map.of(1000L, "k", 1000000L, "M", 1000000000L, "G", 1000000000000L, "T", 1000000000000000L, "P", 1000000000000000000L, "E"));
    }
}

