/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox;

import java.io.File;
import java.time.Duration;
import java.time.Period;
import java.util.regex.Pattern;

public class Constants {
    public static final double EPSILON = 1.0E-6;
    public static final Pattern INT_PATTERN = Pattern.compile("[0-9]+");
    public static final Pattern FLOAT_PATTERN = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+");
    public static final Pattern HEX_PATTERN = Pattern.compile("#?([A-Fa-f0-9]{8}|[A-Fa-f0-9]{6})");
    public static final Pattern POSITIVE_INTEGER_PATTERN = Pattern.compile("\\d+");
    public static final String HOME_FOLDER = System.getProperty("user.home") + File.separator;
    public static final long SECONDS_PER_MINUTE = 60L;
    public static final long SECONDS_PER_HOUR = 3600L;
    public static final long SECONDS_PER_DAY = 86400L;
    public static final long SECONDS_PER_MONTH = 2592000L;
    public static final Duration TIME_PERIOD_24_HOURS = Duration.ofHours(24L);
    public static final Duration TIME_PERIOD_3_DAYS = Duration.ofDays(3L);
    public static final Duration TIME_PERIOD_5_DAYS = Duration.ofDays(5L);
    public static final Duration TIME_PERIOD_7_DAYS = Duration.ofDays(7L);
    public static final Duration TIME_PERIOD_1_MONTH = Duration.ofSeconds((long)Period.ofMonths(1).getDays() * 86400L);
    public static final Duration TIME_PERIOD_3_MONTH = Duration.ofSeconds((long)Period.ofMonths(3).getDays() * 86400L);
    public static final Duration TIME_PERIOD_6_MONTH = Duration.ofSeconds((long)Period.ofMonths(6).getDays() * 86400L);
    public static final Duration TIME_PERIOD_12_MONTH = Duration.ofSeconds((long)Period.ofYears(1).getDays() * 86400L);
    public static final String SQUARE_BRACKET_OPEN = "[";
    public static final String SQUARE_BRACKET_CLOSE = "]";
    public static final String CURLY_BRACKET_OPEN = "{";
    public static final String CURLY_BRACKET_CLOSE = "}";
    public static final String INDENTED_QUOTES = "  \"";
    public static final String QUOTES = "\"";
    public static final String QUOTES_COLON = "\":";
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String SLASH = "/";
    public static final String NEW_LINE = "\n";
    public static final String COMMA_NEW_LINE = ",\n";
    public static final String INDENT = "  ";
    public static final String PERCENTAGE = "%";
    public static final String DEGREE = "\u00b0";

    private Constants() {
    }

    public static enum OperatingMode {
        NATIVE,
        EMULATED,
        NONE,
        NOT_FOUND;


        public static OperatingMode fromText(String text) {
            if (null == text) {
                return NOT_FOUND;
            }
            switch (text) {
                case "native": 
                case "NATIVE": 
                case "Native": {
                    return NATIVE;
                }
                case "emulated": 
                case "EMULATED": 
                case "Emulated": {
                    return EMULATED;
                }
            }
            return NOT_FOUND;
        }
    }

    public static enum OperatingSystem {
        ALPINE_LINUX,
        LINUX,
        LINUX_MUSL,
        FREE_BSD,
        MACOS,
        WINDOWS,
        SOLARIS,
        QNX,
        AIX,
        NOT_FOUND;


        public static OperatingSystem fromText(String text) {
            if (null == text) {
                return NOT_FOUND;
            }
            switch (text) {
                case "-linux": 
                case "linux": 
                case "Linux": 
                case "LINUX": 
                case "unix": 
                case "UNIX": 
                case "Unix": 
                case "-unix": {
                    return LINUX;
                }
                case "-linux-musl": 
                case "-linux_musl": 
                case "Linux-Musl": 
                case "linux-musl": 
                case "Linux_Musl": 
                case "LINUX_MUSL": 
                case "linux_musl": 
                case "alpine": 
                case "ALPINE": 
                case "Alpine": 
                case "alpine-linux": 
                case "ALPINE-LINUX": 
                case "alpine_linux": 
                case "Alpine_Linux": 
                case "ALPINE_LINUX": 
                case "Alpine Linux": 
                case "alpine linux": 
                case "ALPINE LINUX": {
                    return ALPINE_LINUX;
                }
                case "-free-bsd": 
                case "-free_bsd": 
                case "FreeBSD": 
                case "FREE BSD": 
                case "FREEBSD": 
                case "freebsd": 
                case "free bsd": {
                    return FREE_BSD;
                }
                case "-solaris": 
                case "solaris": 
                case "SOLARIS": 
                case "Solaris": {
                    return SOLARIS;
                }
                case "-qnx": 
                case "qnx": 
                case "QNX": {
                    return QNX;
                }
                case "-aix": 
                case "aix": 
                case "AIX": {
                    return AIX;
                }
                case "darwin": 
                case "-darwin": 
                case "-macosx": 
                case "-MACOSX": 
                case "MacOS": 
                case "Mac OS": 
                case "mac_os": 
                case "Mac_OS": 
                case "mac-os": 
                case "Mac-OS": 
                case "mac": 
                case "MAC": 
                case "macos": 
                case "MACOS": 
                case "osx": 
                case "OSX": 
                case "macosx": 
                case "MACOSX": 
                case "Mac OSX": 
                case "Mac OS X": 
                case "mac osx": {
                    return MACOS;
                }
                case "-win": 
                case "windows": 
                case "Windows": 
                case "WINDOWS": 
                case "win": 
                case "Win": 
                case "WIN": {
                    return WINDOWS;
                }
            }
            return NOT_FOUND;
        }
    }

    public static enum Architecture {
        SPARC,
        AMD64,
        X86,
        X64,
        S390X,
        PPC64,
        AARCH64,
        ARM,
        ARMEL,
        ARMHF,
        MIPS,
        MIPSEL,
        PPC,
        PPC64LE,
        RISCV64,
        SPARCV9,
        IA64,
        NOT_FOUND;


        public static Architecture fromText(String text) {
            if (null == text) {
                return NOT_FOUND;
            }
            switch (text) {
                case "aarch64": 
                case "AARCH64": 
                case "arm64": 
                case "ARM64": 
                case "armv8": 
                case "ARMV8": {
                    return AARCH64;
                }
                case "amd64": 
                case "AMD64": 
                case "_amd64": {
                    return AMD64;
                }
                case "aarch32": 
                case "AARCH32": 
                case "arm32": 
                case "ARM32": 
                case "armv6": 
                case "ARMV6": 
                case "armv7l": 
                case "ARMV7L": 
                case "armv7": 
                case "ARMV7": 
                case "arm": 
                case "ARM": {
                    return ARM;
                }
                case "armel": 
                case "ARMEL": {
                    return ARMEL;
                }
                case "armhf": 
                case "ARMHF": {
                    return ARMHF;
                }
                case "mips": 
                case "MIPS": {
                    return MIPS;
                }
                case "mipsel": 
                case "MIPSEL": {
                    return MIPSEL;
                }
                case "ppc": 
                case "PPC": {
                    return PPC;
                }
                case "ppc64el": 
                case "PPC64EL": 
                case "ppc64le": 
                case "PPC64LE": {
                    return PPC64LE;
                }
                case "ppc64": 
                case "PPC64": {
                    return PPC64;
                }
                case "riscv64": 
                case "RISCV64": {
                    return RISCV64;
                }
                case "s390": 
                case "s390x": 
                case "S390X": {
                    return S390X;
                }
                case "sparc": 
                case "SPARC": {
                    return SPARC;
                }
                case "sparcv9": 
                case "SPARCV9": {
                    return SPARCV9;
                }
                case "x64": 
                case "X64": 
                case "x86-64": 
                case "X86-64": 
                case "x86_64": 
                case "X86_64": 
                case "x86lx64": 
                case "X86LX64": {
                    return X64;
                }
                case "x32": 
                case "x86": 
                case "X86": 
                case "286": 
                case "386": 
                case "486": 
                case "586": 
                case "686": 
                case "i386": 
                case "i486": 
                case "i586": 
                case "i686": 
                case "x86-32": 
                case "x86lx32": 
                case "X86LX32": {
                    return X86;
                }
                case "ia64": 
                case "IA64": 
                case "ia-64": 
                case "IA-64": {
                    return IA64;
                }
            }
            return NOT_FOUND;
        }
    }
}

