/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox;

import eu.hansolo.toolbox.Constants;
import eu.hansolo.toolbox.geo.CardinalDirection;
import eu.hansolo.toolbox.geo.GeoLocation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.WeekFields;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.zip.CRC32;

public class Helper {
    private static final String[] DETECT_ALPINE_CMDS = new String[]{"/bin/sh", "-c", "cat /etc/os-release | grep 'NAME=' | grep -ic 'Alpine'"};
    private static final String[] UX_DETECT_ARCH_CMDS = new String[]{"/bin/sh", "-c", "uname -m"};
    private static final String[] MAC_DETECT_ROSETTA2_CMDS = new String[]{"/bin/sh", "-c", "sysctl -in sysctl.proc_translated"};
    private static final String[] WIN_DETECT_ARCH_CMDS = new String[]{"cmd.exe", "/c", "SET Processor"};
    private static final Pattern ARCHITECTURE_PATTERN = Pattern.compile("(PROCESSOR_ARCHITECTURE)=([a-zA-Z0-9_\\-]+)");
    private static final Matcher ARCHITECTURE_MATCHER = ARCHITECTURE_PATTERN.matcher("");
    private static final Matcher INT_MATCHER = Constants.INT_PATTERN.matcher("");
    private static final Matcher FLOAT_MATCHER = Constants.FLOAT_PATTERN.matcher("");
    private static final Matcher HEX_MATCHER = Constants.HEX_PATTERN.matcher("");
    private static final NavigableMap<Long, String> SUFFIXES = new TreeMap<Long, String>(Map.of(1000L, "k", 1000000L, "M", 1000000000L, "G", 1000000000000L, "T", 1000000000000000L, "P", 1000000000000000000L, "E"));

    private Helper() {
    }

    public static final <T extends Number> T clamp(T min, T max, T value) {
        if (value.doubleValue() < min.doubleValue()) {
            return min;
        }
        if (value.doubleValue() > max.doubleValue()) {
            return max;
        }
        return value;
    }

    public static final int clamp(int min, int max, int value) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final long clamp(long min, long max, long value) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final double clamp(double min, double max, double value) {
        if (Double.compare(value, min) < 0) {
            return min;
        }
        if (Double.compare(value, max) > 0) {
            return max;
        }
        return value;
    }

    public static final Instant clamp(Instant min, Instant max, Instant value) {
        if (value.isBefore(min)) {
            return min;
        }
        if (value.isAfter(max)) {
            return max;
        }
        return value;
    }

    public static final LocalDateTime clamp(LocalDateTime min, LocalDateTime max, LocalDateTime value) {
        if (value.isBefore(min)) {
            return min;
        }
        if (value.isAfter(max)) {
            return max;
        }
        return value;
    }

    public static final LocalDate clamp(LocalDate min, LocalDate max, LocalDate value) {
        if (value.isBefore(min)) {
            return min;
        }
        if (value.isAfter(max)) {
            return max;
        }
        return value;
    }

    public static final double clampMin(double min, double value) {
        if (value < min) {
            return min;
        }
        return value;
    }

    public static final double clampMax(double max, double value) {
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final boolean almostEqual(double value1, double value2, double epsilon) {
        return Math.abs(value1 - value2) < epsilon;
    }

    public static final double round(double value, int precision) {
        int SCALE = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)SCALE) / (double)SCALE;
    }

    public static final double roundTo(double value, double target) {
        return target * (double)Math.round(value / target);
    }

    public static final double roundToHalf(double value) {
        return (double)Math.round(value * 2.0) / 2.0;
    }

    public static final int roundDoubleToInt(double value) {
        int i;
        double dAbs = Math.abs(value);
        double result = dAbs - (double)(i = (int)dAbs);
        if (result < 0.5) {
            return value < 0.0 ? -i : i;
        }
        return value < 0.0 ? -(i + 1) : i + 1;
    }

    public static final boolean equals(double a, double b) {
        return a == b || Math.abs(a - b) < 1.0E-6;
    }

    public static final boolean biggerThan(double a, double b) {
        return a - b > 1.0E-6;
    }

    public static final boolean lessThan(double a, double b) {
        return b - a > 1.0E-6;
    }

    public static final boolean isPositiveInteger(String text) {
        if (null == text || text.isEmpty()) {
            return false;
        }
        return Constants.POSITIVE_INTEGER_PATTERN.matcher(text).matches();
    }

    public static final String trimPrefix(String text, String prefix) {
        return text.replaceFirst(prefix, "");
    }

    public static final DateTimeFormatter getDateFormat(Locale locale) {
        if (Locale.US == locale) {
            return DateTimeFormatter.ofPattern("MM/dd/YYYY");
        }
        if (Locale.CHINA == locale) {
            return DateTimeFormatter.ofPattern("YYYY.MM.dd");
        }
        return DateTimeFormatter.ofPattern("dd.MM.YYYY");
    }

    public static final DateTimeFormatter getLocalizedDateFormat(Locale locale) {
        return DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(locale);
    }

    public static final String normalize(String text) {
        String normalized = text.replace("\u00fc", "ue").replace("\u00f6", "oe").replace("\u00e4", "ae").replace("\u00df", "ss");
        normalized = normalized.replace("\u00dc(?=[a-z\u00fc\u00f6\u00e4\u00df ])", "Ue").replace("\u00d6(?=[a-z\u00fc\u00f6\u00e4\u00df ])", "Oe").replace("\u00c4(?=[a-z\u00fc\u00f6\u00e4\u00df ])", "Ae");
        normalized = normalized.replace("\u00dc", "UE").replace("\u00d6", "OE").replace("\u00c4", "AE");
        return normalized;
    }

    public static final int getDegrees(double decDeg) {
        return (int)decDeg;
    }

    public static final int getMinutes(double decDeg) {
        return (int)((decDeg - (double)Helper.getDegrees(decDeg)) * 60.0);
    }

    public static final double getSeconds(double decDeg) {
        return ((decDeg - (double)Helper.getDegrees(decDeg)) * 60.0 - (double)Helper.getMinutes(decDeg)) * 60.0;
    }

    public static final double getDecimalDeg(int degrees, int minutes, double seconds) {
        return (seconds / 60.0 + (double)minutes) / 60.0 + (double)degrees;
    }

    public static final <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static <T> Collector<T, ?, List<T>> lastN(int n) {
        return Collector.of(ArrayDeque::new, (acc, t) -> {
            if (acc.size() == n) {
                acc.pollFirst();
            }
            acc.add(t);
        }, (acc1, acc2) -> {
            while (acc2.size() < n && !acc1.isEmpty()) {
                acc2.addFirst(acc1.pollLast());
            }
            return acc2;
        }, ArrayList::new, new Collector.Characteristics[0]);
    }

    public static final double getDoubleFromText(String text) {
        if (null == text || text.isEmpty()) {
            return 0.0;
        }
        FLOAT_MATCHER.reset(text);
        String result = "";
        double number = 0.0;
        try {
            while (FLOAT_MATCHER.find()) {
                result = FLOAT_MATCHER.group(0);
            }
            number = Double.parseDouble(result);
        }
        catch (IllegalStateException | NumberFormatException ex) {
            return 0.0;
        }
        return number;
    }

    public static final int getIntFromText(String text) {
        INT_MATCHER.reset(text);
        String result = "";
        int number = 0;
        try {
            while (INT_MATCHER.find()) {
                result = INT_MATCHER.group(0);
            }
            number = Integer.parseInt(result);
        }
        catch (IllegalStateException | NumberFormatException ex) {
            return 0;
        }
        return number;
    }

    public static final String getHexColorFromString(String text) {
        HEX_MATCHER.reset(text);
        String result = "";
        try {
            while (HEX_MATCHER.find()) {
                result = HEX_MATCHER.group(0);
            }
        }
        catch (IllegalStateException ex) {
            return "-";
        }
        return result;
    }

    public static final String readFromInputStream(InputStream inputStream) throws IOException {
        StringBuilder resultStringBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = br.readLine()) != null) {
                resultStringBuilder.append(line).append("\n");
            }
        }
        return resultStringBuilder.toString();
    }

    public static final String readTextFileToString(String filename) {
        if (null == filename || !new File(filename).exists()) {
            throw new IllegalArgumentException("File: " + filename + " not found or null");
        }
        try {
            Path fileObj = Path.of(filename, new String[0]);
            return Files.readString(fileObj);
        }
        catch (IOException e) {
            return "";
        }
    }

    public static final String readTextFileToString(File file) {
        if (null == file || !file.isFile()) {
            throw new IllegalArgumentException("Given file is either null or no file");
        }
        try {
            Path fileObj = file.toPath();
            return Files.readString(fileObj);
        }
        catch (IOException e) {
            return "";
        }
    }

    public static final void saveStringToTextFile(String filename, String text) {
        if (null == filename || filename.isEmpty()) {
            throw new IllegalArgumentException("filename cannot be null or empty");
        }
        if (null == text || text.isEmpty()) {
            throw new IllegalArgumentException("text cannot be null or empty");
        }
        try {
            Files.write(Paths.get("/" + filename, new String[0]), text.getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final LocalDate getFirstDayOfWeek(int year, int weekNumber, Locale locale) {
        return LocalDate.of(year, 2, 1).with(WeekFields.of(locale).getFirstDayOfWeek()).with(WeekFields.of(locale).weekOfWeekBasedYear(), weekNumber);
    }

    public static final long getEpochSecondsOfFirstDayOfWeek(int year, int weekNumber, Locale locale) {
        return Helper.getFirstDayOfWeek(year, weekNumber, locale).atStartOfDay().toEpochSecond(ZoneOffset.UTC);
    }

    public static final LocalDate getLastDayOfWeek(int year, int weekNumber, Locale locale) {
        return Helper.getFirstDayOfWeek(year, weekNumber, locale).plusDays(6L);
    }

    public static final long getEpochSecondsOfLastDayOfWeek(int year, int weekNumber, Locale locale) {
        return Helper.getLastDayOfWeek(year, weekNumber, locale).atStartOfDay().toEpochSecond(ZoneOffset.UTC);
    }

    public static final int getWeekOfYear(ZonedDateTime zonedDateTime) {
        return Helper.getWeekOfYear(zonedDateTime.toInstant(), zonedDateTime.getZone());
    }

    public static final int getWeekOfYeear(Instant instant) {
        return Helper.getWeekOfYear(instant, ZoneId.systemDefault());
    }

    public static final int getWeekOfYear(Instant instant, ZoneId zoneId) {
        return Helper.getWeekOfYear(LocalDate.ofInstant(instant, zoneId));
    }

    public static final int getWeekOfYear(LocalDateTime dateTime) {
        return Helper.getWeekOfYear(dateTime.toLocalDate());
    }

    public static final int getWeekOfYear(LocalDate date) {
        return date.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
    }

    public static final int getWeekOfYear(long epochSeconds) {
        return Helper.getWeekOfYear(epochSeconds, ZoneId.systemDefault());
    }

    public static final int getWeekOfYear(long epochSeconds, ZoneId zoneId) {
        if (epochSeconds < 0L) {
            throw new IllegalArgumentException("Epochseconds cannot be smaller than 0");
        }
        return LocalDate.ofInstant(Instant.ofEpochSecond(epochSeconds), zoneId).get(ChronoField.ALIGNED_WEEK_OF_YEAR);
    }

    public static final String shortenNumber(long value) {
        return Helper.shortenNumber(value, Locale.US);
    }

    public static final String shortenNumber(long value, Locale locale) {
        if (value == Long.MIN_VALUE) {
            return Helper.shortenNumber(-9223372036854775807L, locale);
        }
        if (value < 0L) {
            return "-" + Helper.shortenNumber(-value, locale);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> entry = SUFFIXES.floorEntry(value);
        Long divideBy = entry.getKey();
        String suffix = entry.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        NumberFormat formatter = NumberFormat.getNumberInstance(locale);
        formatter.setMinimumFractionDigits(1);
        formatter.setMaximumFractionDigits(1);
        return hasDecimal ? formatter.format((double)truncated / 10.0) + suffix : truncated / 10L + suffix;
    }

    public static final <K, V extends Comparable<V>> V getMaxValueInMap(Map<K, V> map) {
        Map.Entry maxEntry = Collections.max(map.entrySet(), Comparator.comparing(Map.Entry::getValue));
        return (V)((Comparable)maxEntry.getValue());
    }

    public static final <K, V extends Comparable<V>> K getKeyWithMaxValueInMap(Map<K, V> map) {
        Map.Entry maxEntry = Collections.max(map.entrySet(), Comparator.comparing(Map.Entry::getValue));
        return maxEntry.getKey();
    }

    public static final String secondsToHHMMString(long seconds) {
        long[] hhmmss = Helper.secondsToHHMMSS(seconds);
        return String.format("%02d:%02d:%02d", hhmmss[0], hhmmss[1], hhmmss[2]);
    }

    public static final long[] secondsToHHMMSS(long seconds) {
        long secs = seconds % 60L;
        long minutes = secs / 60L % 60L;
        long hours = secs / 3600L % 24L;
        return new long[]{hours, minutes, secs};
    }

    public static final long getCRC32Checksum(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes, 0, bytes.length);
        return crc32.getValue();
    }

    public static final String getMD5(String text) {
        return Helper.bytesToHex(Helper.getMD5Bytes(text.getBytes(StandardCharsets.UTF_8)));
    }

    public static final String getMD5(byte[] bytes) {
        return Helper.bytesToHex(Helper.getMD5Bytes(bytes));
    }

    public static final byte[] getMD5Bytes(byte[] bytes) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Error getting MD5 algorithm. " + e.getMessage());
            return new byte[0];
        }
        return md.digest(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getMD5ForFile(File file) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        try (FileInputStream fis = new FileInputStream(file);){
            int n = 0;
            byte[] buffer = new byte[4096];
            while (n != -1) {
                n = ((InputStream)fis).read(buffer);
                if (n <= 0) continue;
                md.update(buffer, 0, n);
            }
        }
        byte[] byteData = md.digest();
        return Helper.getMD5(Helper.bytesToHex(byteData));
    }

    public static final String getSHA1(String text) {
        return Helper.bytesToHex(Helper.getSHA1Bytes(text.getBytes(StandardCharsets.UTF_8)));
    }

    public static final String getSHA1(byte[] bytes) {
        return Helper.bytesToHex(Helper.getSHA1Bytes(bytes));
    }

    public static final byte[] getSHA1Bytes(byte[] bytes) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Error getting SHA-1 algorithm. " + e.getMessage());
            return new byte[0];
        }
        return md.digest(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getSHA1ForFile(File file) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        try (FileInputStream fis = new FileInputStream(file);){
            int n = 0;
            byte[] buffer = new byte[4096];
            while (n != -1) {
                n = ((InputStream)fis).read(buffer);
                if (n <= 0) continue;
                md.update(buffer, 0, n);
            }
        }
        byte[] byteData = md.digest();
        return Helper.getSHA1(Helper.bytesToHex(byteData));
    }

    public static final String getSHA256(String text) {
        return Helper.bytesToHex(Helper.getSHA256Bytes(text.getBytes(StandardCharsets.UTF_8)));
    }

    public static final String getSHA256(byte[] bytes) {
        return Helper.bytesToHex(Helper.getSHA256Bytes(bytes));
    }

    public static final byte[] getSHA256Bytes(byte[] bytes) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Error getting SHA2-256 algorithm. " + e.getMessage());
            return new byte[0];
        }
        return md.digest(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getSHA256ForFile(File file) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        try (FileInputStream fis = new FileInputStream(file);){
            int n = 0;
            byte[] buffer = new byte[4096];
            while (n != -1) {
                n = ((InputStream)fis).read(buffer);
                if (n <= 0) continue;
                md.update(buffer, 0, n);
            }
        }
        byte[] byteData = md.digest();
        return Helper.getSHA256(Helper.bytesToHex(byteData));
    }

    public static final String getSHA3_256(String text) {
        return Helper.bytesToHex(Helper.getSHA3_256Bytes(text.getBytes(StandardCharsets.UTF_8)));
    }

    public static final String getSHA3_256(byte[] bytes) {
        return Helper.bytesToHex(Helper.getSHA3_256Bytes(bytes));
    }

    public static final byte[] getSHA3_256Bytes(byte[] bytes) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA3-256");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Error getting SHA3-256 algorithm. " + e.getMessage());
            return new byte[0];
        }
        return md.digest(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getSHA3_256ForFile(File file) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA3-256");
        try (FileInputStream fis = new FileInputStream(file);){
            int n = 0;
            byte[] buffer = new byte[4096];
            while (n != -1) {
                n = ((InputStream)fis).read(buffer);
                if (n <= 0) continue;
                md.update(buffer, 0, n);
            }
        }
        byte[] byteData = md.digest();
        return Helper.getSHA3_256(Helper.bytesToHex(byteData));
    }

    public static final String bytesToHex(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    public static final Optional<String> nonEmpty(String text) {
        return null == text || text.length() == 0 ? Optional.empty() : Optional.ofNullable(text);
    }

    public static final String padLeft(String input, char ch, int length) {
        return String.format("%" + length + "s", input).replace(' ', ch);
    }

    public static final String padRight(String input, char ch, int length) {
        return String.format("%" + -length + "s", input).replace(' ', ch);
    }

    public static final int getPhysicalCores() {
        Constants.OperatingSystem operatingSystem = Helper.getOperatingSystem();
        Integer noOfPhysicalCores = switch (operatingSystem) {
            case Constants.OperatingSystem.LINUX, Constants.OperatingSystem.ALPINE_LINUX, Constants.OperatingSystem.LINUX_MUSL -> Helper.readFromProc();
            case Constants.OperatingSystem.WINDOWS -> Helper.readFromWMIC();
            case Constants.OperatingSystem.MACOS -> Helper.readFromSysctlOsX();
            case Constants.OperatingSystem.FREE_BSD -> Helper.readFromSysctlFreeBSD();
            default -> -1;
        };
        return null == noOfPhysicalCores ? -1 : noOfPhysicalCores;
    }

    public static final int getLogicalCores() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.availableProcessors();
    }

    public static final long getTotalMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory();
    }

    public static final long getMaxMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.maxMemory();
    }

    public static final long getFreeMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.freeMemory();
    }

    public static final Constants.Architecture getArchitecture() {
        OperatingSystemInfo osInfo = Helper.getOperatingSystemInfo();
        Constants.Architecture arch = Constants.Architecture.fromText(osInfo.arc());
        return Constants.Architecture.NOT_FOUND == arch ? Helper.getArchitecture(Helper.getOperatingSystem()) : arch;
    }

    public static final Constants.Architecture getArchitecture(Constants.OperatingSystem operatingSystem) {
        try {
            ProcessBuilder processBuilder = Constants.OperatingSystem.WINDOWS == operatingSystem ? new ProcessBuilder(WIN_DETECT_ARCH_CMDS) : new ProcessBuilder(UX_DETECT_ARCH_CMDS);
            Process process = processBuilder.start();
            String result = new BufferedReader(new InputStreamReader(process.getInputStream())).lines().collect(Collectors.joining("\n"));
            switch (operatingSystem) {
                case WINDOWS: {
                    ARCHITECTURE_MATCHER.reset(result);
                    List results = ARCHITECTURE_MATCHER.results().collect(Collectors.toList());
                    if (results.size() <= 0) break;
                    Constants.Architecture.fromText(((MatchResult)results.get(0)).group(2));
                    break;
                }
                case MACOS: {
                    return Constants.Architecture.fromText(result);
                }
                case LINUX: {
                    return Constants.Architecture.fromText(result);
                }
            }
        }
        catch (IOException e) {
            return Constants.Architecture.NOT_FOUND;
        }
        String arch = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
        if (arch.contains("sparc")) {
            return Constants.Architecture.SPARC;
        }
        if (arch.contains("amd64") || arch.contains("86_64")) {
            return Constants.Architecture.X64;
        }
        if (arch.contains("86")) {
            return Constants.Architecture.X86;
        }
        if (arch.contains("s390x")) {
            return Constants.Architecture.S390X;
        }
        if (arch.contains("ppc64")) {
            return Constants.Architecture.PPC64;
        }
        if (arch.contains("arm") && arch.contains("64")) {
            return Constants.Architecture.AARCH64;
        }
        if (arch.contains("arm")) {
            return Constants.Architecture.ARM;
        }
        if (arch.contains("aarch64")) {
            return Constants.Architecture.AARCH64;
        }
        return Constants.Architecture.NOT_FOUND;
    }

    public static final Constants.OperatingSystem getOperatingSystem() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return Constants.OperatingSystem.WINDOWS;
        }
        if (os.contains("apple") || os.contains("mac")) {
            return Constants.OperatingSystem.MACOS;
        }
        if (os.contains("nix") || os.contains("nux")) {
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(DETECT_ALPINE_CMDS);
                Process process = processBuilder.start();
                String result = new BufferedReader(new InputStreamReader(process.getInputStream())).lines().collect(Collectors.joining("\n"));
                return null == result ? Constants.OperatingSystem.LINUX : (result.equals("1") ? Constants.OperatingSystem.ALPINE_LINUX : Constants.OperatingSystem.LINUX);
            }
            catch (IOException e) {
                e.printStackTrace();
                return Constants.OperatingSystem.LINUX;
            }
        }
        if (os.contains("sunos")) {
            return Constants.OperatingSystem.SOLARIS;
        }
        if (os.contains("freebsd")) {
            return Constants.OperatingSystem.FREE_BSD;
        }
        OperatingSystemInfo osInfo = Helper.getOperatingSystemInfo();
        return Constants.OperatingSystem.fromText(osInfo.operatingSystemName);
    }

    public static final Constants.OperatingMode getOperatingMode() {
        return Helper.getOperatingMode(Helper.getOperatingSystem());
    }

    public static final Constants.OperatingMode getOperatingMode(Constants.OperatingSystem operatingSystem) {
        try {
            ProcessBuilder processBuilder = Constants.OperatingSystem.WINDOWS == operatingSystem ? new ProcessBuilder(WIN_DETECT_ARCH_CMDS) : new ProcessBuilder(UX_DETECT_ARCH_CMDS);
            Process process = processBuilder.start();
            String result = new BufferedReader(new InputStreamReader(process.getInputStream())).lines().collect(Collectors.joining("\n"));
            switch (operatingSystem) {
                case WINDOWS: {
                    ARCHITECTURE_MATCHER.reset(result);
                    List results = ARCHITECTURE_MATCHER.results().collect(Collectors.toList());
                    int noOfResults = results.size();
                    return noOfResults > 0 ? Constants.OperatingMode.NATIVE : Constants.OperatingMode.NOT_FOUND;
                }
                case MACOS: {
                    ProcessBuilder processBuilder1 = new ProcessBuilder(MAC_DETECT_ROSETTA2_CMDS);
                    Process process1 = processBuilder1.start();
                    String result1 = new BufferedReader(new InputStreamReader(process1.getInputStream())).lines().collect(Collectors.joining("\n"));
                    return result1.equals("1") ? Constants.OperatingMode.EMULATED : Constants.OperatingMode.NATIVE;
                }
                case LINUX: {
                    return Constants.OperatingMode.NATIVE;
                }
            }
            return Constants.OperatingMode.NOT_FOUND;
        }
        catch (IOException e) {
            return Constants.OperatingMode.NOT_FOUND;
        }
    }

    public static final OperatingSystemInfo getOperatingSystemInfo() {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        String arc = operatingSystemMXBean.getArch();
        int availableProcessors = operatingSystemMXBean.getAvailableProcessors();
        String operatingSystemName = operatingSystemMXBean.getName();
        String operatingSystemVersion = operatingSystemMXBean.getVersion();
        double systemLoadAverage = operatingSystemMXBean.getSystemLoadAverage();
        return new OperatingSystemInfo(arc, availableProcessors, operatingSystemName, operatingSystemVersion, systemLoadAverage);
    }

    public static final JvmInfo getJvmInfo() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String vmName = runtimeMXBean.getVmName();
        String vmVendor = runtimeMXBean.getVmVendor();
        String vmVersion = runtimeMXBean.getVmVersion();
        String specName = runtimeMXBean.getSpecName();
        String specVendor = runtimeMXBean.getSpecVendor();
        String specVersion = runtimeMXBean.getSpecVersion();
        return new JvmInfo(vmName, vmVendor, vmVersion, specName, specVendor, specVersion);
    }

    public static final CompilationInfo getCompilationInfo() {
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        long totalCompilationtime = compilationMXBean.getTotalCompilationTime();
        return new CompilationInfo(totalCompilationtime);
    }

    public static final ClassLoadingInfo getClassLoadingInfo() {
        ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        long totalLoadedClassCount = classLoadingMXBean.getTotalLoadedClassCount();
        int loadedClassCount = classLoadingMXBean.getLoadedClassCount();
        long unloadedClassCount = classLoadingMXBean.getUnloadedClassCount();
        return new ClassLoadingInfo(totalLoadedClassCount, loadedClassCount, unloadedClassCount);
    }

    public static final HeapInfo getHeapInfo() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = memoryMXBean.getNonHeapMemoryUsage();
        return new HeapInfo(heapMemoryUsage, nonHeapMemoryUsage);
    }

    public static final MemInfo getMemInfo() {
        return new MemInfo(Helper.getTotalMemory(), Helper.getFreeMemory(), Helper.getMaxMemory());
    }

    public static final List<RootInfo> getRootInfos() {
        File[] roots;
        ArrayList<RootInfo> rootInfos = new ArrayList<RootInfo>();
        for (File root : roots = File.listRoots()) {
            String absolutePath = root.getAbsolutePath();
            long totalSpace = root.getTotalSpace();
            long freeSpace = root.getFreeSpace();
            long usableSpace = root.getUsableSpace();
            rootInfos.add(new RootInfo(absolutePath, totalSpace, freeSpace, usableSpace));
        }
        return rootInfos;
    }

    public static final SystemSummary getSystemSummary() {
        List<RootInfo> rootInfos = Helper.getRootInfos();
        OperatingSystemInfo osInfo = Helper.getOperatingSystemInfo();
        JvmInfo jvmInfo = Helper.getJvmInfo();
        HeapInfo heapInfo = Helper.getHeapInfo();
        MemInfo memInfo = Helper.getMemInfo();
        Constants.OperatingSystem operatingSystem = Helper.getOperatingSystem();
        Constants.Architecture arc = Helper.getArchitecture(operatingSystem);
        Constants.OperatingMode operatingMode = Helper.getOperatingMode(operatingSystem);
        int logicalCores = Helper.getLogicalCores();
        int physicalCores = Helper.getPhysicalCores();
        return new SystemSummary(arc, logicalCores, physicalCores, memInfo, heapInfo, rootInfos, operatingSystem, osInfo, operatingMode, jvmInfo);
    }

    public static final double calcDistanceInMeter(GeoLocation location1, GeoLocation location2) {
        return Helper.calcDistanceInMeter(location1.getLatitude(), location1.getLongitude(), location2.getLatitude(), location2.getLongitude());
    }

    public static final double calcDistanceInMeter(double latitude1, double longitude1, double latitude2, double longitude2) {
        double lat1Radians = Math.toRadians(latitude1);
        double lat2Radians = Math.toRadians(latitude2);
        double deltaLatRadians = Math.toRadians(latitude2 - latitude1);
        double deltaLonRadians = Math.toRadians(longitude2 - longitude1);
        double a = Math.sin(deltaLatRadians * 0.5) * Math.sin(deltaLatRadians * 0.5) + Math.cos(lat1Radians) * Math.cos(lat2Radians) * Math.sin(deltaLonRadians * 0.5) * Math.sin(deltaLonRadians * 0.5);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double distance = 6367517.0 * c;
        return distance;
    }

    public static final double calcBearingInDegree(GeoLocation location1, GeoLocation location2) {
        return Helper.calcBearingInDegree(location1.getLatitude(), location1.getLongitude(), location2.getLatitude(), location2.getLongitude());
    }

    public static final double calcBearingInDegree(double latitude1, double longitude1, double latitude2, double longitude2) {
        double lat1 = Math.toRadians(latitude1);
        double lon1 = Math.toRadians(longitude1);
        double lat2 = Math.toRadians(latitude2);
        double lon2 = Math.toRadians(longitude2);
        double deltaPhi = Math.log(Math.tan(lat2 * 0.5 + 0.7853981633974483) / Math.tan(lat1 * 0.5 + 0.7853981633974483));
        double deltaLon = lon2 - lon1;
        if (Math.abs(deltaLon) > Math.PI) {
            deltaLon = deltaLon > 0.0 ? -(Math.PI * 2 - deltaLon) : Math.PI * 2 + deltaLon;
        }
        double bearing = (Math.toDegrees(Math.atan2(deltaLon, deltaPhi)) + 360.0) % 360.0;
        return bearing;
    }

    public static final CardinalDirection getCardinalDirectionFromBearing(double brng) {
        double bearing = brng % 360.0;
        for (CardinalDirection cardinalDirection : CardinalDirection.getValues()) {
            if (Double.compare(bearing, cardinalDirection.from) < 0 || Double.compare(bearing, cardinalDirection.to) >= 0) continue;
            return cardinalDirection;
        }
        return CardinalDirection.NOT_FOUND;
    }

    private static Integer readFromProc() {
        Integer n;
        String path = "/proc/cpuinfo";
        File cpuinfo = new File("/proc/cpuinfo");
        if (!cpuinfo.exists()) {
            return null;
        }
        FileInputStream in = new FileInputStream(cpuinfo);
        try {
            String s = Helper.readToString(in, Charset.forName("UTF-8"));
            HashMap physicalIdToCoreId = new HashMap();
            int coreIdCount = 0;
            String[] split = s.split("\n");
            String latestPhysicalId = null;
            for (String row : split) {
                if (row.startsWith("physical id")) {
                    latestPhysicalId = row;
                    if (physicalIdToCoreId.get(row) != null) continue;
                    physicalIdToCoreId.put(latestPhysicalId, new HashSet());
                    continue;
                }
                if (!row.startsWith("core id")) continue;
                ((Set)physicalIdToCoreId.get(latestPhysicalId)).add(row);
            }
            for (Set coreIds : physicalIdToCoreId.values()) {
                coreIdCount += coreIds.size();
            }
            n = coreIdCount;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SecurityException e) {
                String string = String.format("Error while reading %s", "/proc/cpuinfo");
                return null;
            }
        }
        ((InputStream)in).close();
        return n;
    }

    private static Integer readFromWMIC() {
        Integer n;
        block11: {
            Process wmicProc;
            ProcessBuilder pb = new ProcessBuilder("WMIC", "/OUTPUT:STDOUT", "CPU", "Get", "/Format:List");
            pb.redirectErrorStream(true);
            try {
                wmicProc = pb.start();
                wmicProc.getOutputStream().close();
            }
            catch (IOException | SecurityException e) {
                return null;
            }
            Helper.waitFor(wmicProc);
            InputStream in = wmicProc.getInputStream();
            try {
                String wmicOutput = Helper.readToString(in, Charset.forName("US-ASCII"));
                n = Helper.parseWmicOutput(wmicOutput);
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException | SecurityException e) {
                    return null;
                }
            }
            in.close();
        }
        return n;
    }

    private static Integer parseWmicOutput(String wmicOutput) {
        String[] rows = wmicOutput.split("\n");
        int coreCount = 0;
        for (String row : rows) {
            if (!row.startsWith("NumberOfCores")) continue;
            String num = row.split("=")[1].trim();
            try {
                coreCount += Integer.parseInt(num);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return coreCount > 0 ? Integer.valueOf(coreCount) : null;
    }

    private static Integer readFromSysctlOsX() {
        String result = Helper.readSysctl("hw.physicalcpu", "-n");
        if (result == null) {
            return null;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Integer readFromSysctlFreeBSD() {
        String result = Helper.readSysctl("dev.cpu", new String[0]);
        if (result == null) {
            return null;
        }
        HashSet<String> cpuLocations = new HashSet<String>();
        for (String row : result.split("\n")) {
            if (!row.contains("location")) continue;
            cpuLocations.add(row.split("\\\\")[1]);
        }
        return cpuLocations.isEmpty() ? null : Integer.valueOf(cpuLocations.size());
    }

    private static String readSysctl(String variable, String ... options) {
        String result;
        Process sysctlProc;
        ArrayList<String> command = new ArrayList<String>();
        command.add("sysctl");
        command.addAll(Arrays.asList(options));
        command.add(variable);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        try {
            sysctlProc = pb.start();
        }
        catch (IOException | SecurityException e) {
            return null;
        }
        try {
            result = Helper.readToString(sysctlProc.getInputStream(), Charset.forName("UTF-8")).trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            return null;
        }
        int exitStatus = Helper.waitFor(sysctlProc);
        if (exitStatus != 0) {
            return null;
        }
        return result;
    }

    private static String readToString(InputStream in, Charset charset) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(in, charset);){
            StringWriter sw = new StringWriter();
            char[] buf = new char[10000];
            while (reader.read(buf) != -1) {
                sw.write(buf);
            }
            String string = sw.toString();
            return string;
        }
    }

    private static int waitFor(Process proc) {
        try {
            return proc.waitFor();
        }
        catch (InterruptedException e) {
            return 1;
        }
    }

    public record OperatingSystemInfo(String arc, int availableProcessors, String operatingSystemName, String operatingSystemVersion, double systemLoadAverage) {
    }

    public record JvmInfo(String vmName, String vmVendor, String vmVersion, String specName, String specVendor, String specVersion) {
    }

    public record CompilationInfo(long totalCompilationTime) {
    }

    public record ClassLoadingInfo(long totalLoadedClassCount, int loadedClassCount, long unloadedClassCount) {
    }

    public record HeapInfo(MemoryUsage heapMemoryUsage, MemoryUsage noneHeapMemoryUsage) {
    }

    public record MemInfo(long totalMemory, long freeMemory, long maxMemory) {
    }

    public record RootInfo(String absolutePath, long totalSpace, long freeSpace, long usableSpace) {
    }

    public record SystemSummary(Constants.Architecture architecture, int logicalCores, int physicalCores, MemInfo memInfo, HeapInfo heapInfo, List<RootInfo> rootInfos, Constants.OperatingSystem operatingSystem, OperatingSystemInfo operatingSystemInfo, Constants.OperatingMode operatingMode, JvmInfo jvmInfo) {
        public String toBeautifiedString() {
            StringBuilder msgBuilder = new StringBuilder().append("{").append("\n").append("  ").append("\"").append("architecture").append("\":").append("\"").append(this.architecture.name()).append("\"").append(",").append("\n").append("  ").append("\"").append("logical_cores").append("\":").append(this.logicalCores).append(",").append("\n").append("  ").append("\"").append("physical_cores").append("\":").append(this.physicalCores).append(",").append("\n").append("  ").append("\"").append("total_memory").append("\":").append(this.memInfo.totalMemory()).append(",").append("\n").append("  ").append("\"").append("free_memory").append("\":").append(this.memInfo.freeMemory()).append(",").append("\n").append("  ").append("\"").append("max_memory").append("\":").append(this.memInfo.maxMemory()).append(",").append("\n").append("  ").append("\"").append("heap_max").append("\":").append(this.heapInfo.heapMemoryUsage.getMax()).append(",").append("\n").append("  ").append("\"").append("heap_committed").append("\":").append(this.heapInfo.heapMemoryUsage.getCommitted()).append(",").append("\n").append("  ").append("\"").append("heap_used").append("\":").append(this.heapInfo.heapMemoryUsage.getUsed()).append(",").append("\n").append("  ").append("\"").append("non_heap_max").append("\":").append(this.heapInfo.noneHeapMemoryUsage.getMax()).append(",").append("\n").append("  ").append("\"").append("non_heap_committed").append("\":").append(this.heapInfo.noneHeapMemoryUsage.getCommitted()).append(",").append("\n").append("  ").append("\"").append("non_heap_used").append("\":").append(this.heapInfo.noneHeapMemoryUsage.getUsed()).append(",").append("\n").append("  ").append("\"").append("root_infos").append("\":").append("[").append("\n");
            this.rootInfos.forEach(rootInfo -> msgBuilder.append("  ").append("  ").append("{").append("\n").append("  ").append("  ").append("  ").append("\"").append("absolute_path").append("\":").append("\"").append(rootInfo.absolutePath()).append("\"").append(",").append("\n").append("  ").append("  ").append("  ").append("\"").append("total_space").append("\":").append(rootInfo.totalSpace()).append(",").append("\n").append("  ").append("  ").append("  ").append("\"").append("free_space").append("\":").append(rootInfo.freeSpace()).append(",").append("\n").append("  ").append("  ").append("  ").append("\"").append("usable_space").append("\":").append(rootInfo.usableSpace()).append("\n").append("  ").append("  ").append("}").append(",").append("\n"));
            msgBuilder.setLength(msgBuilder.length() - 2);
            msgBuilder.append("\n").append("  ").append("]").append(",").append("\n").append("  ").append("\"").append("operating_system").append("\":").append("\"").append(this.operatingSystem.name()).append("\"").append(",").append("\n").append("  ").append("\"").append("operating_system_name").append("\":").append("\"").append(this.operatingSystemInfo.operatingSystemName).append("\"").append(",").append("\n").append("  ").append("\"").append("operating_system_version").append("\":").append("\"").append(this.operatingSystemInfo.operatingSystemVersion()).append("\"").append(",").append("\n").append("  ").append("\"").append("operating_mode").append("\":").append("\"").append(this.operatingMode.name()).append("\"").append(",").append("\n").append("  ").append("\"").append("vm_name").append("\":").append("\"").append(this.jvmInfo.vmName()).append("\"").append(",").append("\n").append("  ").append("\"").append("vm_vendor").append("\":").append("\"").append(this.jvmInfo.vmVendor()).append("\"").append(",").append("\n").append("  ").append("\"").append("vm_version").append("\":").append("\"").append(this.jvmInfo.vmVersion()).append("\"").append(",").append("\n").append("  ").append("\"").append("spec_name").append("\":").append("\"").append(this.jvmInfo.specName()).append("\"").append(",").append("\n").append("  ").append("\"").append("spec_vendor").append("\":").append("\"").append(this.jvmInfo.specVendor()).append("\"").append(",").append("\n").append("  ").append("\"").append("spec_version").append("\":").append("\"").append(this.jvmInfo.specVersion()).append("\"").append("\n").append("}");
            return msgBuilder.toString();
        }

        @Override
        public String toString() {
            StringBuilder msgBuilder = new StringBuilder().append("{").append("\"").append("architecture").append("\":").append("\"").append(this.architecture.name()).append("\"").append(",").append("\"").append("logical_cores").append("\":").append(this.logicalCores).append(",").append("\"").append("physical_cores").append("\":").append(this.physicalCores).append(",").append("\"").append("total_memory").append("\":").append(this.memInfo.totalMemory()).append(",").append("\"").append("free_memory").append("\":").append(this.memInfo.freeMemory()).append(",").append("\"").append("max_memory").append("\":").append(this.memInfo.maxMemory()).append(",").append("\"").append("heap_max").append("\":").append(this.heapInfo.heapMemoryUsage.getMax()).append(",").append("\"").append("heap_committed").append("\":").append(this.heapInfo.heapMemoryUsage.getCommitted()).append(",").append("\"").append("heap_used").append("\":").append(this.heapInfo.heapMemoryUsage.getUsed()).append(",").append("\"").append("non_heap_max").append("\":").append(this.heapInfo.noneHeapMemoryUsage.getMax()).append(",").append("\"").append("non_heap_committed").append("\":").append(this.heapInfo.noneHeapMemoryUsage.getCommitted()).append(",").append("\"").append("non_heap_used").append("\":").append(this.heapInfo.noneHeapMemoryUsage.getUsed()).append(",").append("\"").append("root_infos").append("\":").append("[");
            this.rootInfos.forEach(rootInfo -> msgBuilder.append("{").append("\"").append("absolute_path").append("\":").append("\"").append(rootInfo.absolutePath()).append("\"").append(",").append("\"").append("total_space").append("\":").append(rootInfo.totalSpace()).append(",").append("\"").append("free_space").append("\":").append(rootInfo.freeSpace()).append(",").append("\"").append("usable_space").append("\":").append(rootInfo.usableSpace()).append("}").append(","));
            msgBuilder.setLength(msgBuilder.length() - 1);
            msgBuilder.append("]").append(",").append("\"").append("operating_system").append("\":").append("\"").append(this.operatingSystem.name()).append("\"").append(",").append("\"").append("operating_system_name").append("\":").append("\"").append(this.operatingSystemInfo.operatingSystemName).append("\"").append(",").append("\"").append("operating_system_version").append("\":").append("\"").append(this.operatingSystemInfo.operatingSystemVersion()).append("\"").append(",").append("\"").append("operating_mode").append("\":").append("\"").append(this.operatingMode.name()).append("\"").append(",").append("\"").append("vm_name").append("\":").append("\"").append(this.jvmInfo.vmName()).append("\"").append(",").append("\"").append("vm_vendor").append("\":").append("\"").append(this.jvmInfo.vmVendor()).append("\"").append(",").append("\"").append("vm_version").append("\":").append("\"").append(this.jvmInfo.vmVersion()).append("\"").append(",").append("\"").append("spec_name").append("\":").append("\"").append(this.jvmInfo.specName()).append("\"").append(",").append("\"").append("spec_vendor").append("\":").append("\"").append(this.jvmInfo.specVendor()).append("\"").append(",").append("\"").append("spec_version").append("\":").append("\"").append(this.jvmInfo.specVersion()).append("\"").append("}");
            return msgBuilder.toString();
        }
    }
}

