/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox;

import eu.hansolo.toolbox.Helper;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolbox.evt.type.ChangeEvt;
import eu.hansolo.toolbox.evt.type.GeoLocationChangeEvt;
import eu.hansolo.toolbox.evt.type.ListChangeEvt;
import eu.hansolo.toolbox.evt.type.MapChangeEvt;
import eu.hansolo.toolbox.evt.type.MatrixItemChangeEvt;
import eu.hansolo.toolbox.evtbus.EvtBus;
import eu.hansolo.toolbox.evtbus.Subscriber;
import eu.hansolo.toolbox.evtbus.Topic;
import eu.hansolo.toolbox.geo.GeoLocation;
import eu.hansolo.toolbox.geo.GeoLocationBuilder;
import eu.hansolo.toolbox.observables.ObservableList;
import eu.hansolo.toolbox.observables.ObservableMap;
import eu.hansolo.toolbox.observables.ObservableMatrix;
import eu.hansolo.toolbox.properties.BooleanProperty;
import eu.hansolo.toolbox.properties.DoubleProperty;
import eu.hansolo.toolbox.properties.IntegerProperty;
import eu.hansolo.toolbox.properties.ObjectProperty;
import eu.hansolo.toolbox.properties.ReadOnlyBooleanProperty;
import eu.hansolo.toolbox.properties.ReadOnlyDoubleProperty;
import eu.hansolo.toolbox.statemachine.State;
import eu.hansolo.toolbox.statemachine.StateChangeException;
import eu.hansolo.toolbox.statemachine.StateMachine;
import eu.hansolo.toolbox.time.DateTimes;
import eu.hansolo.toolbox.time.Dates;
import eu.hansolo.toolbox.time.Times;
import eu.hansolo.toolbox.tuples.Pair;
import eu.hansolo.toolbox.tuples.Quartet;
import eu.hansolo.toolbox.tuples.Triplet;
import eu.hansolo.toolbox.unit.Category;
import eu.hansolo.toolbox.unit.Converter;
import eu.hansolo.toolbox.unit.UnitDefinition;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class Demo {
    private PoJo pojo;
    private DoubleProperty doubleProperty;
    private ObjectProperty<String> objectProperty;
    private IntegerProperty integerProperty;
    private DoubleProperty doubleProperty1;
    private ReadOnlyDoubleProperty readOnlyDoubleProperty;

    public Demo() {
        this.propertiesDemo();
        this.tuplesDemo();
        this.converterDemo();
        this.observableListDemo();
        this.observableMapDemo();
        this.observableMatrixDemo();
        this.datesDemo();
        this.timesDemo();
        this.dateTimesDemo();
        this.stateMachineDemo();
        this.evtBusDemo();
        this.helperDemo();
        this.geoDemo();
    }

    private void propertiesDemo() {
        System.out.println("\n-------------------- properties demo --------------------");
        this.pojo = new PoJo();
        this.pojo.valueProperty().addObserver(evt -> System.out.println("pojo.valueProperty -> Value changed from " + evt.getOldValue() + " to " + evt.getValue()));
        this.pojo.valueProperty().addInvalidationObserver(evt -> System.out.println("pojo.valueProperty might have changed"));
        EvtObserver doubleChangeObserver = e -> System.out.println(e.getOldValue() + " -> " + e.getValue());
        this.doubleProperty = new DoubleProperty(){

            @Override
            protected void willChange(Double oldValue, Double newValue) {
                System.out.println("DoubleProperty will change from " + oldValue + " to " + newValue);
            }

            @Override
            protected void didChange(Double oldValue, Double newValue) {
                System.out.println("DoubleProperty changed from " + oldValue + " to " + newValue);
            }
        };
        this.doubleProperty.addOnChange(doubleChangeObserver);
        this.doubleProperty.removeObserver(doubleChangeObserver);
        this.doubleProperty.removeAllObservers();
        this.objectProperty = new ObjectProperty();
        this.integerProperty = new IntegerProperty(10){

            @Override
            public void set(int VALUE) {
                super.set(VALUE);
            }

            @Override
            public int get() {
                return super.get();
            }

            @Override
            protected void didChange(Integer oldValue, Integer newValue) {
                System.out.println("Color changed to: " + newValue);
            }

            @Override
            public Object getBean() {
                return Demo.this;
            }

            @Override
            public String getName() {
                return "color";
            }
        };
        this.doubleProperty1 = new DoubleProperty((Object)this, "oldValue", 10.0);
        this.readOnlyDoubleProperty = new ReadOnlyDoubleProperty(5.0);
        this.pojo.doubleValueProperty().addOnChange(e -> System.out.println("DoubleProperty: " + e.getOldValue() + " -> " + e.getValue()));
        this.doubleProperty.addObserver(e -> System.out.println("DoubleProperty: " + e.getOldValue() + " -> " + e.getValue()));
        this.objectProperty.addObserver(e -> System.out.println("ObjectProperty<String>: " + (String)e.getOldValue() + " -> " + (String)e.getValue()));
        this.pojo.setDoubleValue(7.0);
        System.out.println("\npojo.setValue(7)");
        this.pojo.setValue(7.0);
        System.out.println("\npojo.setValue(7)");
        this.pojo.setValue(7.0);
        System.out.println("\npojo.setValue(5)");
        this.pojo.setValue(5.0);
        System.out.println("\npojo.valueProperty().set(8)");
        this.pojo.valueProperty().set(8.0);
        System.out.println("\ndoubleProperty.set(20)");
        this.doubleProperty.set(20.0);
        System.out.println("\nobjectProperty.set(Hallo)");
        this.objectProperty.set(new String("Hallo"));
        System.out.println("\nobjectProperty.set(Test)");
        this.objectProperty.set(new String("Test"));
        System.out.println("\nobjectProperty.set(Bla)");
        this.objectProperty.set("Bla");
        System.out.println("\n\n---------- Unidirectional Binding ------------");
        DoubleProperty propertyA = new DoubleProperty(5.0);
        DoubleProperty propertyB = new DoubleProperty(10.0);
        System.out.println("Property A: " + propertyA.get() + " is bound: " + propertyA.isBound());
        System.out.println("Property B: " + propertyB.get() + " is bound: " + propertyB.isBound());
        System.out.println("\npropertyA.bind(propertyB)");
        propertyA.bind(propertyB);
        System.out.println("\nProperty A: " + propertyA.get() + " is bound: " + propertyA.isBound());
        System.out.println("Property B: " + propertyB.get() + " is bound: " + propertyB.isBound());
        System.out.println("\npropertyB.set(5)");
        propertyB.set(5.0);
        System.out.println("\npropertyB = " + propertyB.get());
        System.out.println("propertyA = " + propertyA.get());
        System.out.println("\npropertyA.set(20)");
        try {
            propertyA.set(20.0);
        }
        catch (IllegalArgumentException e2) {
            System.out.println("Error, a bound value cannot be set.");
        }
        System.out.println("\npropertyA.unbind()");
        propertyA.unbind();
        System.out.println("\nProperty A: " + propertyA.get() + " is bound: " + propertyA.isBound());
        System.out.println("Property B: " + propertyB.get() + " is bound: " + propertyB.isBound());
        System.out.println("\npropertyB.set(15)");
        propertyB.set(15.0);
        System.out.println("\nProperty A: " + propertyA.get() + " is bound: " + propertyA.isBound());
        System.out.println("Property B: " + propertyB.get() + " is bound: " + propertyB.isBound());
        System.out.println("\nReadOnlyDoubleProperty: " + this.readOnlyDoubleProperty.getValue());
        System.out.println("DoubleProperty        : " + this.doubleProperty.getValue());
        System.out.println("Bind DoubleProperty -> ReadOnlyDoubleProperty");
        this.doubleProperty.bind(this.readOnlyDoubleProperty);
        System.out.println("DoubleProperty        : " + this.doubleProperty.getValue());
        System.out.println("Unbind DoubleProperty -> ReadOnlyDoubleProperty");
        this.doubleProperty.unbind();
        System.out.println("Set DoubleProperty -> 13");
        this.doubleProperty.set(13.0);
        System.out.println("DoubleProperty        : " + this.doubleProperty.getValue());
        System.out.println("\n\n---------- Bidirectional Binding ------------");
        DoubleProperty propertyC = new DoubleProperty(0.0);
        DoubleProperty propertyD = new DoubleProperty(25.0);
        System.out.println("Property C: " + propertyC.get() + " is bound bidirectional: " + propertyC.isBoundBidirectional());
        System.out.println("Property D: " + propertyD.get() + " is bound bidirectional: " + propertyD.isBoundBidirectional());
        System.out.println("\npropertyC.bindBidirectional(propertyD)");
        propertyC.bindBidirectional(propertyD);
        System.out.println("\nProperty C: " + propertyC.get() + " is bound bidirectional: " + propertyC.isBoundBidirectional());
        System.out.println("Property D: " + propertyD.get() + " is bound bidirectional: " + propertyD.isBoundBidirectional());
        System.out.println("\npropertyD.set(5)");
        propertyD.set(5.0);
        System.out.println("\npropertyC = " + propertyC.get());
        System.out.println("propertyD = " + propertyD.get());
        System.out.println("\npropertyC.set(20)");
        propertyC.set(20.0);
        System.out.println("\npropertyC = " + propertyC.get());
        System.out.println("propertyD = " + propertyD.get());
        System.out.println("\npropertyD.unbind()");
        propertyD.unbind();
        System.out.println("\nProperty C: " + propertyC.get() + " is bound bidirectional: " + propertyC.isBoundBidirectional());
        System.out.println("Property D: " + propertyD.get() + " is bound bidirectional: " + propertyD.isBoundBidirectional());
        System.out.println("\npropertyD.set(5)");
        propertyD.set(5.0);
        System.out.println("\nProperty C: " + propertyC.get() + " is bound bidirectional: " + propertyC.isBoundBidirectional());
        System.out.println("Property D: " + propertyD.get() + " is bound bidirectional: " + propertyD.isBoundBidirectional());
        System.out.println("\npropertyC.set(10)");
        propertyC.set(10.0);
        System.out.println("\nProperty C: " + propertyC.get() + " is bound bidirectional: " + propertyC.isBoundBidirectional());
        System.out.println("Property D: " + propertyD.get() + " is bound bidirectional: " + propertyD.isBoundBidirectional());
    }

    private void tuplesDemo() {
        System.out.println("\n-------------------- tuples demo --------------------");
        Pair<Double, Integer> pair = new Pair<Double, Integer>(5.0, 3);
        Triplet<Double, Integer, Integer> triplet = new Triplet<Double, Integer, Integer>(5.0, 3, 500);
        Quartet<Double, Integer, String, Integer> quartet = new Quartet<Double, Integer, String, Integer>(1.0, 5, "Test", 1000);
        System.out.println("Quartet size      : " + quartet.size());
        System.out.println("Quartet value at 2: " + quartet.getValueAt(2));
        System.out.println("Quartet type at 2 : " + quartet.getTypeAt(2));
    }

    private void converterDemo() {
        System.out.println("\n-------------------- converter demo --------------------");
        Converter temperatureConverter = new Converter(Category.TEMPERATURE, UnitDefinition.CELSIUS);
        double celsius = 32.0;
        double fahrenheit = temperatureConverter.convert(celsius, UnitDefinition.FAHRENHEIT);
        double kelvin = temperatureConverter.convert(celsius, UnitDefinition.KELVIN);
        System.out.println(celsius + "\u00b0C   =>   " + fahrenheit + "\u00b0F    =>   " + kelvin + "\u00b0K");
        Converter lengthConverter = new Converter(Category.LENGTH, UnitDefinition.METER);
        double meter = 1.0;
        double inches = lengthConverter.convert(meter, UnitDefinition.INCHES);
        double nanometer = lengthConverter.convert(inches, UnitDefinition.NANOMETER);
        System.out.println(meter + " " + lengthConverter.getUnitShort() + "   =>   " + inches + " in   =>   " + nanometer + " nm");
        Converter volumeConverter = new Converter(Category.VOLUME, UnitDefinition.CUBIC_METER);
        double cubicMeter = 3.0;
        double liters = volumeConverter.convert(cubicMeter, UnitDefinition.LITER);
        System.out.println(cubicMeter + " cubic meter -> " + liters + " liter");
        Converter literConverter = new Converter(Category.VOLUME, UnitDefinition.LITER);
        double liter = 3000.0;
        double cubicMeters = literConverter.convert(liter, UnitDefinition.CUBIC_METER);
        System.out.println(liter + " liter -> " + cubicMeters + " cubic meter");
        Converter glucoseConverter = new Converter(Category.BLOOD_GLUCOSE, UnitDefinition.MILLIMOL_PER_LITER);
        double millimolPerLiter = 6.0;
        double milligramPerDeciliter = glucoseConverter.convert(millimolPerLiter, UnitDefinition.MILLIGRAM_PER_DECILITER);
        System.out.println(millimolPerLiter + "mmol/l -> " + milligramPerDeciliter + "mg/dl");
        Converter mgdlConverter = new Converter(Category.BLOOD_GLUCOSE, UnitDefinition.MILLIGRAM_PER_DECILITER);
        double mgdl = 108.108108;
        double mmoll = mgdlConverter.convert(mgdl, UnitDefinition.MILLIMOL_PER_LITER);
        System.out.println(mgdl + " mg/dl -> " + mmoll + " mmol/l");
        System.out.println(lengthConverter.convertToString(meter, UnitDefinition.CENTIMETER));
        System.out.println(Converter.format(1500000.0, 1));
        System.out.println(Converter.format(1000000.0, 0));
    }

    private void observableListDemo() {
        System.out.println("\n-------------------- observable list demo --------------------");
        ObservableList observableList = new ObservableList();
        observableList.addListChangeObserver(ListChangeEvt.ANY, e -> {
            EvtType type = e.getEvtType();
            if (ListChangeEvt.CHANGED.equals(type)) {
                System.out.println("List changed");
            } else if (ListChangeEvt.ADDED.equals(type)) {
                e.getAddedElements().forEach(item -> System.out.println("Added: " + item));
            } else if (ListChangeEvt.REMOVED.equals(type)) {
                e.getRemovedElements().forEach(item -> System.out.println("Removed: " + item));
            }
        });
        System.out.println("---------- adding ----------");
        observableList.add("Gerrit");
        observableList.add("Sandra");
        observableList.add("Lilli");
        observableList.add("Anton");
        observableList.add("Neo");
        System.out.println("---------- remove 1 ----------");
        observableList.remove("Neo");
        System.out.println("---------- add list of 3 ----------");
        observableList.addAll(List.of("Test", "Test2", "Test3"));
        System.out.println("---------- remove 1 ----------");
        observableList.remove("Test2");
        System.out.println("---------- add 1 ----------");
        observableList.add(2, "Neo");
        System.out.println("---------- print all ----------");
        observableList.forEach(item -> System.out.println((String)item));
        System.out.println("---------- retain all (Gerrit, Sandra, Lilli, Anton, Neo) ----------");
        List<String> keep = List.of("Gerrit", "Sandra", "Lilli", "Anton", "Neo");
        observableList.retainAll(keep);
        System.out.println("---------- clear ----------");
        observableList.clear();
    }

    private void observableMapDemo() {
        System.out.println("\n-------------------- observable map demo --------------------");
        ObservableMap observableMap = new ObservableMap();
        observableMap.addMapChangeObserver(MapChangeEvt.ANY, e -> {
            EvtType type = e.getEvtType();
            if (MapChangeEvt.MODIFIED.equals(type)) {
                e.getModifiedEntries().forEach(entry -> System.out.println("Modified: " + (String)entry.getKey() + " -> " + entry.getValue()));
            } else if (MapChangeEvt.ADDED.equals(type)) {
                e.getAddedEntries().forEach(entry -> System.out.println("Added   : " + (String)entry.getKey() + " -> " + entry.getValue()));
            } else if (MapChangeEvt.REMOVED.equals(type)) {
                e.getRemovedEntries().forEach(entry -> System.out.println("Removed : " + (String)entry.getKey() + " -> " + entry.getValue()));
            }
        });
        observableMap.put("Gerrit", 52);
        observableMap.put("Sandra", 50);
        observableMap.put("Lilli", 18);
        observableMap.put("Anton", 13);
        observableMap.put("Neo", 3);
        System.out.println("---------- remove 1 ----------");
        observableMap.remove("Neo");
        System.out.println("---------- add map of 3 ----------");
        observableMap.putAll(Map.of("Test", 1, "Test2", 2, "Test3", 3));
        System.out.println("---------- remove 1 ----------");
        observableMap.remove("Test2");
        System.out.println("---------- add 1 ----------");
        observableMap.put("Neo", 3);
        System.out.println("---------- print all ----------");
        observableMap.entrySet().forEach(entry -> System.out.println((String)entry.getKey() + " -> " + entry.getValue()));
        System.out.println("---------- clear ----------");
        observableMap.clear();
    }

    private void observableMatrixDemo() {
        System.out.println("\n-------------------- observable matrix demo --------------------");
        Random rnd = new Random();
        int cols = 3;
        int rows = 2;
        ObservableMatrix<Integer> integerMatrix = new ObservableMatrix<Integer>(Integer.class, 3, 2);
        integerMatrix.addMatrixItemChangeObserver(MatrixItemChangeEvt.ANY, e -> {
            EvtType type = e.getEvtType();
            if (MatrixItemChangeEvt.ITEM_ADDED.equals(type)) {
                System.out.println("Item added  : " + e.getItem() + " at " + e.getX() + ", " + e.getY());
            } else if (MatrixItemChangeEvt.ITEM_REMOVED.equals(type)) {
                System.out.println("Item removed: " + e.getOldItem() + " at " + e.getX() + ", " + e.getY());
            } else if (MatrixItemChangeEvt.ITEM_CHANGED.equals(type)) {
                System.out.println("Item changed: " + e.getItem() + " at " + e.getX() + ", " + e.getY());
            }
        });
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 3; ++x) {
                Integer value = rnd.nextInt(10);
                integerMatrix.setItemAt(x, y, value);
            }
        }
        integerMatrix.removeItemAt(0, 0);
        integerMatrix.setItemAt(2, 0, 5);
    }

    private void datesDemo() {
        System.out.println("\n-------------------- dates demo --------------------");
        LocalDate localDate = LocalDate.of(2022, 12, 3);
        System.out.println(Dates.dd_MM_yyyy.format(localDate));
        System.out.println(Dates.dd_MMMM_yyyy.format(localDate));
        System.out.println(Dates.yyyy_w.format(localDate));
        System.out.println(Dates.yyyy_w_e.format(localDate));
        System.out.println(Dates.yyyywe.format(localDate));
    }

    private void timesDemo() {
        System.out.println("\n-------------------- times demo --------------------");
        LocalTime localTime = LocalTime.now();
        System.out.println(Times.HH_mm_ss_SSSS.format(localTime));
        System.out.println(Times.HH_mm.format(localTime));
        System.out.println(Times.HHmmss.format(localTime));
        System.out.println(Times.HHmmss_SSSS.format(localTime));
    }

    private void dateTimesDemo() {
        System.out.println("\n-------------------- date times demo --------------------");
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        System.out.println(DateTimes.toEpoch(zonedDateTime));
        System.out.println(DateTimes.dd_MM_yyyy_HH_mm_ss_SSSS.format(zonedDateTime));
    }

    private void stateMachineDemo() {
        System.out.println("\n-------------------- state machine demo --------------------");
        static enum MyState implements State
        {
            IDLE("IDLE"),
            BUSY("BUSY"),
            ERROR("ERROR"),
            FINISHED("FINISHED");

            private final String name;
            private Set transitions;

            private MyState(String name) {
                this.name = name;
            }

            private void canTransitionTo(MyState ... transitions) {
                this.transitions = EnumSet.copyOf(Arrays.asList(transitions));
            }

            @Override
            public Set<State> getTransitions() {
                return this.transitions;
            }

            @Override
            public boolean canChangeTo(State state) {
                return this.transitions.contains(state);
            }

            @Override
            public String getName() {
                return this.name;
            }

            static {
                IDLE.canTransitionTo(IDLE, BUSY, ERROR);
                BUSY.canTransitionTo(IDLE, BUSY, ERROR);
                ERROR.canTransitionTo(IDLE, ERROR);
            }
        }
        StateMachine<MyState> stateMachine = new StateMachine<MyState>(){
            private ObjectProperty<MyState> state = new ObjectProperty<MyState>(MyState.IDLE);
            {
                static enum MyState implements State
                {
                    IDLE("IDLE"),
                    BUSY("BUSY"),
                    ERROR("ERROR"),
                    FINISHED("FINISHED");

                    private final String name;
                    private Set transitions;

                    private MyState(String name) {
                        this.name = name;
                    }

                    private void canTransitionTo(MyState ... transitions) {
                        this.transitions = EnumSet.copyOf(Arrays.asList(transitions));
                    }

                    @Override
                    public Set<State> getTransitions() {
                        return this.transitions;
                    }

                    @Override
                    public boolean canChangeTo(State state) {
                        return this.transitions.contains(state);
                    }

                    @Override
                    public String getName() {
                        return this.name;
                    }

                    static {
                        IDLE.canTransitionTo(IDLE, BUSY, ERROR);
                        BUSY.canTransitionTo(IDLE, BUSY, ERROR);
                        ERROR.canTransitionTo(IDLE, ERROR);
                    }
                }
            }

            @Override
            public State getState() {
                static enum MyState implements State
                {
                    IDLE("IDLE"),
                    BUSY("BUSY"),
                    ERROR("ERROR"),
                    FINISHED("FINISHED");

                    private final String name;
                    private Set transitions;

                    private MyState(String name) {
                        this.name = name;
                    }

                    private void canTransitionTo(MyState ... transitions) {
                        this.transitions = EnumSet.copyOf(Arrays.asList(transitions));
                    }

                    @Override
                    public Set<State> getTransitions() {
                        return this.transitions;
                    }

                    @Override
                    public boolean canChangeTo(State state) {
                        return this.transitions.contains(state);
                    }

                    @Override
                    public String getName() {
                        return this.name;
                    }

                    static {
                        IDLE.canTransitionTo(IDLE, BUSY, ERROR);
                        BUSY.canTransitionTo(IDLE, BUSY, ERROR);
                        ERROR.canTransitionTo(IDLE, ERROR);
                    }
                }
                return (State)this.state.get();
            }

            @Override
            public void setState(MyState state) throws StateChangeException {
                static enum MyState implements State
                {
                    IDLE("IDLE"),
                    BUSY("BUSY"),
                    ERROR("ERROR"),
                    FINISHED("FINISHED");

                    private final String name;
                    private Set transitions;

                    private MyState(String name) {
                        this.name = name;
                    }

                    private void canTransitionTo(MyState ... transitions) {
                        this.transitions = EnumSet.copyOf(Arrays.asList(transitions));
                    }

                    @Override
                    public Set<State> getTransitions() {
                        return this.transitions;
                    }

                    @Override
                    public boolean canChangeTo(State state) {
                        return this.transitions.contains(state);
                    }

                    @Override
                    public String getName() {
                        return this.name;
                    }

                    static {
                        IDLE.canTransitionTo(IDLE, BUSY, ERROR);
                        BUSY.canTransitionTo(IDLE, BUSY, ERROR);
                        ERROR.canTransitionTo(IDLE, ERROR);
                    }
                }
                if (!((MyState)this.state.get()).canChangeTo(state)) {
                    throw new StateChangeException("Not allowed to change from " + ((MyState)this.state.get()).getName() + " to " + state.getName());
                }
                this.state.set(state);
            }

            @Override
            public ObjectProperty<MyState> stateProperty() {
                static enum MyState implements State
                {
                    IDLE("IDLE"),
                    BUSY("BUSY"),
                    ERROR("ERROR"),
                    FINISHED("FINISHED");

                    private final String name;
                    private Set transitions;

                    private MyState(String name) {
                        this.name = name;
                    }

                    private void canTransitionTo(MyState ... transitions) {
                        this.transitions = EnumSet.copyOf(Arrays.asList(transitions));
                    }

                    @Override
                    public Set<State> getTransitions() {
                        return this.transitions;
                    }

                    @Override
                    public boolean canChangeTo(State state) {
                        return this.transitions.contains(state);
                    }

                    @Override
                    public String getName() {
                        return this.name;
                    }

                    static {
                        IDLE.canTransitionTo(IDLE, BUSY, ERROR);
                        BUSY.canTransitionTo(IDLE, BUSY, ERROR);
                        ERROR.canTransitionTo(IDLE, ERROR);
                    }
                }
                return this.state;
            }
        };
        stateMachine.stateProperty().addObserver(e -> System.out.println("State changed from " + ((MyState)e.getOldValue()).getName() + " to " + ((MyState)e.getValue()).getName()));
        try {
            stateMachine.setState(MyState.BUSY);
            stateMachine.setState(MyState.IDLE);
            stateMachine.setState(MyState.ERROR);
            stateMachine.setState(MyState.BUSY);
        }
        catch (StateChangeException e2) {
            System.out.println(e2.getMessage() + " -> StateMachine still in state: " + stateMachine.getState().getName());
        }
    }

    private void evtBusDemo() {
        System.out.println("\n-------------------- evtbus demo --------------------");
        class TopicEvtBus
        implements EvtBus {
            private final Map<Topic, Map<EvtType, List<Subscriber>>> topicSubscribers = new ConcurrentHashMap<Topic, Map<EvtType, List<Subscriber>>>();

            TopicEvtBus() {
            }

            @Override
            public <T extends Evt> void publish(Topic topic, T evt) {
                EvtType<? extends Evt> type = evt.getEvtType();
                if (this.topicSubscribers.containsKey(topic)) {
                    class TopicEvt
                    extends ChangeEvt {
                        public static final EvtType<TopicEvt> ANY = new EvtType<ChangeEvt>(ChangeEvt.ANY, "ANY");
                        public static final EvtType<TopicEvt> NEW_MSG = new EvtType<TopicEvt>(ANY, "NEW_MSG");
                        public static final EvtType<TopicEvt> UPDATE_MSG = new EvtType<TopicEvt>(ANY, "UPDATE_MSG");
                        private final Msg msg;

                        public TopicEvt(Object src, EvtType<TopicEvt> evtType, Msg msg) {
                            super(src, (EvtType<? extends ChangeEvt>)evtType);
                            class Msg {
                                private final String id = UUID.randomUUID().toString();
                                private final String txt;

                                public Msg(String txt) {
                                    this.txt = txt;
                                }

                                public String getId() {
                                    return this.id;
                                }

                                public String getTxt() {
                                    return this.txt;
                                }

                                public String toString() {
                                    return this.txt;
                                }

                                public boolean equals(Object o) {
                                    if (this == o) {
                                        return true;
                                    }
                                    if (o == null || this.getClass() != o.getClass()) {
                                        return false;
                                    }
                                    Msg msg = (Msg)o;
                                    return this.id.equals(msg.id);
                                }

                                public int hashCode() {
                                    return Objects.hash(this.id);
                                }
                            }
                            this.msg = msg;
                        }

                        public Msg getMsg() {
                            return this.msg;
                        }

                        public EvtType<? extends TopicEvt> getEvtType() {
                            return super.getEvtType();
                        }

                        @Override
                        public boolean equals(Object o) {
                            if (this == o) {
                                return true;
                            }
                            if (o == null || this.getClass() != o.getClass()) {
                                return false;
                            }
                            if (!super.equals(o)) {
                                return false;
                            }
                            TopicEvt that = (TopicEvt)o;
                            return Objects.equals(that.getMsg(), this.getMsg());
                        }

                        @Override
                        public int hashCode() {
                            return Objects.hash(super.hashCode(), this.msg);
                        }
                    }
                    Map<EvtType, List<Subscriber>> subscribers = this.topicSubscribers.get(topic);
                    subscribers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(TopicEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle(evt)));
                    if (subscribers.containsKey(type) && !type.equals(TopicEvt.ANY)) {
                        subscribers.get(type).forEach(subscriber -> subscriber.handle(evt));
                    }
                }
            }

            @Override
            public void subscribe(Topic topic, Subscriber subscriber) {
                EvtType<Evt> evtType = subscriber.getEvtType();
                if (!this.topicSubscribers.containsKey(topic)) {
                    this.topicSubscribers.put(topic, new ConcurrentHashMap());
                }
                if (!this.topicSubscribers.get(topic).containsKey(evtType)) {
                    this.topicSubscribers.get(topic).put(evtType, new CopyOnWriteArrayList());
                }
                if (!this.topicSubscribers.get(topic).get(evtType).contains(subscriber)) {
                    this.topicSubscribers.get(topic).get(evtType).add(subscriber);
                }
            }

            @Override
            public void unsubscribe(Topic topic, Subscriber subscriber) {
                EvtType<Evt> evtType = subscriber.getEvtType();
                if (this.topicSubscribers.containsKey(topic) && this.topicSubscribers.get(topic).containsKey(evtType) && this.topicSubscribers.get(topic).get(evtType).contains(subscriber)) {
                    this.topicSubscribers.get(topic).get(evtType).remove(subscriber);
                    if (this.topicSubscribers.get(topic).get(evtType).isEmpty()) {
                        this.topicSubscribers.get(topic).remove(evtType);
                    }
                    if (this.topicSubscribers.get(topic).isEmpty()) {
                        this.topicSubscribers.remove(topic);
                    }
                }
            }
        }
        TopicEvtBus eventBus = new TopicEvtBus();
        class MyTopic
        implements Topic {
            private final String id = UUID.randomUUID().toString();
            private final String name;

            public MyTopic(String name) {
                this.name = name;
            }

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public String getName() {
                return this.name;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                MyTopic myTopic = (MyTopic)o;
                return this.id.equals(myTopic.id);
            }

            public int hashCode() {
                return Objects.hash(this.id);
            }
        }
        MyTopic topic1 = new MyTopic("Topic 1");
        MyTopic topic2 = new MyTopic("Topic 2");
        class TopicSubscriber
        implements Subscriber {
            private final String name;
            private final EvtType evtType;

            public TopicSubscriber(String name, EvtType evtType) {
                this.name = name;
                this.evtType = evtType;
            }

            public String getName() {
                return this.name;
            }

            @Override
            public EvtType<Evt> getEvtType() {
                return this.evtType;
            }

            @Override
            public void handle(Evt evt) {
                TopicEvt topicEvt = (TopicEvt)evt;
                System.out.println(this.name + ":  -> " + topicEvt.getMsg().getTxt());
            }
        }
        TopicSubscriber newMsgSubscriber = new TopicSubscriber("newMsgSubscriber", TopicEvt.NEW_MSG);
        TopicSubscriber updateSubscriber = new TopicSubscriber("updateSubscriber", TopicEvt.UPDATE_MSG);
        eventBus.subscribe(topic1, newMsgSubscriber);
        eventBus.subscribe(topic2, updateSubscriber);
        eventBus.publish(topic1, new TopicEvt(eventBus, TopicEvt.NEW_MSG, new Msg("New Msg topic 1")));
        eventBus.publish(topic1, new TopicEvt(eventBus, TopicEvt.UPDATE_MSG, new Msg("Update Msg topic 1")));
        eventBus.publish(topic2, new TopicEvt(eventBus, TopicEvt.UPDATE_MSG, new Msg("Update Msg topic 2")));
    }

    private void helperDemo() {
        System.out.println("\n-------------------- helper demo --------------------");
        Helper.SystemSummary systemSummary = Helper.getSystemSummary();
        System.out.println(systemSummary.toBeautifiedString());
    }

    private void geoDemo() {
        System.out.println("\n-------------------- geo demo --------------------");
        GeoLocation home = ((GeoLocationBuilder)((GeoLocationBuilder)((GeoLocationBuilder)((GeoLocationBuilder)GeoLocationBuilder.create().name("Home")).latitude(51.912781150242054)).longitude(7.633729751419756)).altitude(66.0)).build();
        GeoLocation azul = ((GeoLocationBuilder)((GeoLocationBuilder)((GeoLocationBuilder)((GeoLocationBuilder)GeoLocationBuilder.create().name("Azul")).latitude(37.40668261833162)).longitude(-122.01573123930172)).altitude(20.0)).build();
        home.addGeoLocationObserver(GeoLocationChangeEvt.NAME_CHANGED, e -> System.out.println("Name changed from: " + e.getOldGeoLocation().getName() + " to " + e.getGeoLocation().getName()));
        System.out.println("Distance from Home to Azul: " + String.format(Locale.US, "%.2f km", home.getDistanceTo(azul) / 1000.0));
        home.setName("Home of Han Solo");
    }

    public static void main(String[] args) {
        new Demo();
    }

    public class PoJo {
        private double _value = 0.0;
        private DoubleProperty value;
        private DoubleProperty doubleValue = new DoubleProperty(3.0);
        private BooleanProperty booleanValue = new BooleanProperty(true);

        public double getValue() {
            return null == this.value ? this._value : this.value.get();
        }

        public void setValue(double value) {
            if (null == this.value) {
                this._value = value;
            } else {
                this.value.set(value);
            }
        }

        public DoubleProperty valueProperty() {
            if (null == this.value) {
                this.value = new DoubleProperty(this._value){

                    @Override
                    protected void willChange(Double oldValue, Double newValue) {
                        System.out.println("Value will change from " + oldValue + " to " + newValue);
                    }

                    @Override
                    protected void didChange(Double oldValue, Double newValue) {
                        System.out.println("Value changed from " + oldValue + " to " + newValue);
                    }
                };
            }
            return this.value;
        }

        public double getDoubleValue() {
            return this.doubleValue.get();
        }

        public void setDoubleValue(double value) {
            this.doubleValue.set(value);
        }

        public DoubleProperty doubleValueProperty() {
            return this.doubleValue;
        }

        public boolean isBooleanValue() {
            return this.booleanValue.get();
        }

        public ReadOnlyBooleanProperty booleanValueProperty() {
            return this.booleanValue;
        }
    }
}

