/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.observables;

import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolbox.evt.type.ListChangeEvt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class ObservableList<T>
implements List<T>,
RandomAccess,
Cloneable {
    private final CopyOnWriteArrayList<T> list;
    private Map<EvtType<? extends Evt>, List<EvtObserver<ListChangeEvt<T>>>> observers;

    public ObservableList() {
        this.list = new CopyOnWriteArrayList();
    }

    public ObservableList(Collection<? extends T> collection) {
        this.list = new CopyOnWriteArrayList<T>(collection);
    }

    public ObservableList(T[] array) {
        this.list = new CopyOnWriteArrayList<T>(array);
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public T set(int index, T element) {
        List<T> removedElements = List.of(this.list.get(index));
        List<T> addedElements = List.of(this.list.set(index, element));
        this.fireListChangeEvt(new ListChangeEvt<T>(this, ListChangeEvt.CHANGED, addedElements, removedElements));
        return addedElements.get(0);
    }

    @Override
    public boolean add(T element) {
        boolean result = this.list.add(element);
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.ADDED, result ? List.of(element) : List.of(), List.of()));
        return result;
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
        this.fireListChangeEvt(new ListChangeEvt<T>(this, ListChangeEvt.ADDED, List.of(element), List.of()));
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean result = this.list.addAll(collection);
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.ADDED, result ? new ArrayList<T>(collection) : List.of(), List.of()));
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        boolean result = this.list.addAll(index, collection);
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.ADDED, result ? new ArrayList<T>(collection) : List.of(), List.of()));
        return result;
    }

    public boolean addIfAbsent(T element) {
        boolean result = this.list.addIfAbsent(element);
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.ADDED, result ? List.of(element) : List.of(), List.of()));
        return result;
    }

    public int addAllAbsent(Collection<T> collection) {
        List addedElements = this.list.stream().filter(element -> !collection.contains(element)).collect(Collectors.toList());
        int result = this.list.addAllAbsent(collection);
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.ADDED, addedElements, List.of()));
        return result;
    }

    @Override
    public T remove(int index) {
        T element = this.list.remove(index);
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.REMOVED, List.of(), List.of(element)));
        return element;
    }

    @Override
    public boolean remove(Object obj) {
        boolean result = this.list.remove(obj);
        ArrayList<Object> removedElements = new ArrayList<Object>();
        if (result) {
            removedElements.add(obj);
        }
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.REMOVED, List.of(), removedElements));
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean result = this.list.removeAll(collection);
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.REMOVED, List.of(), result ? new ArrayList(collection) : List.of()));
        return result;
    }

    @Override
    public void clear() {
        Object clone = this.clone();
        this.list.clear();
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.REMOVED, List.of(), clone));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Object clone = this.clone();
        boolean result = this.list.retainAll(collection);
        List removedElements = clone.stream().filter(element -> !this.list.contains(element)).collect(Collectors.toList());
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.REMOVED, List.of(), removedElements));
        return result;
    }

    @Override
    public boolean contains(Object obj) {
        return this.list.contains(obj);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public int indexOf(Object obj) {
        return this.list.indexOf(obj);
    }

    public int indexOf(T element, int index) {
        return this.list.indexOf(element, index);
    }

    @Override
    public int lastIndexOf(Object obj) {
        return this.list.lastIndexOf(obj);
    }

    public int lastIndexOf(T element, int index) {
        return this.list.lastIndexOf(element, index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.list.toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.list.spliterator();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object obj) {
        return this.list.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    public ObservableList<T> clone() {
        try {
            ObservableList<T> clone = new ObservableList<T>();
            clone.addAll((Collection<T>)this.list);
            return clone;
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.list.forEach((Consumer<T>)action);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        boolean result = this.list.removeIf(filter);
        if (result) {
            this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.REMOVED, null, null));
        }
        return result;
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        this.list.replaceAll(operator);
        this.fireListChangeEvt(new ListChangeEvt(this, ListChangeEvt.CHANGED, null, null));
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        this.list.sort(comparator);
    }

    public String toString() {
        return this.list.toString();
    }

    public void addListChangeObserver(EvtType<? extends Evt> type, EvtObserver<ListChangeEvt<T>> observer) {
        if (null == type || null == observer) {
            return;
        }
        if (null == this.observers) {
            this.observers = new ConcurrentHashMap<EvtType<? extends Evt>, List<EvtObserver<ListChangeEvt<T>>>>();
        }
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeListChangeObserver(EvtType<? extends Evt> type, EvtObserver<ListChangeEvt<T>> observer) {
        if (null == this.observers || null == type || null == observer) {
            return;
        }
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllListChangeObservers() {
        if (null == this.observers) {
            return;
        }
        this.observers.clear();
    }

    public void fireListChangeEvt(ListChangeEvt<T> evt) {
        if (null == this.observers) {
            return;
        }
        this.observers.entrySet().stream().filter(entry -> !((EvtType)entry.getKey()).equals(ListChangeEvt.ANY)).filter(entry -> ((EvtType)entry.getKey()).equals(evt.getEvtType())).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle(evt)));
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(ListChangeEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle(evt)));
    }
}

