/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.geo;

import eu.hansolo.toolbox.geo.GeoLocation;
import eu.hansolo.toolbox.geo.PolygonPoint;
import java.util.Arrays;
import java.util.Objects;

public class Polygon {
    private int size;
    private PolygonPoint[] points;

    public Polygon() {
        this.size = 0;
        this.points = new PolygonPoint[8];
    }

    public Polygon(PolygonPoint ... points) {
        this.size = points.length;
        this.points = new PolygonPoint[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.points[i] = points[i];
        }
    }

    public Polygon(GeoLocation ... locations) {
        this.size = locations.length;
        this.points = new PolygonPoint[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.points[i] = new PolygonPoint(locations[i].getLongitude(), locations[i].getLatitude());
        }
    }

    private void resize() {
        PolygonPoint[] tmp = new PolygonPoint[2 * this.size + 1];
        for (int i = 0; i <= this.size; ++i) {
            tmp[i] = this.points[i];
        }
        this.points = tmp;
    }

    public int size() {
        return this.size;
    }

    public void add(GeoLocation location) {
        this.add(new PolygonPoint(location.getLongitude(), location.getLatitude()));
    }

    public void add(PolygonPoint point) {
        if (this.size >= this.points.length - 1) {
            this.resize();
        }
        this.points[this.size++] = point;
        this.points[this.size] = this.points[0];
    }

    public boolean contains(GeoLocation location) {
        return this.contains(new PolygonPoint(location.getLongitude(), location.getLatitude()));
    }

    public boolean contains(PolygonPoint point) {
        int winding = 0;
        for (int i = 0; i < this.size - 1; ++i) {
            int ccw = PolygonPoint.ccw(this.points[i], this.points[i + 1], point);
            if (this.points[i + 1].y > point.y && point.y >= this.points[i].y && ccw == 1) {
                ++winding;
            }
            if (!(this.points[i + 1].y <= point.y) || !(point.y < this.points[i].y) || ccw != -1) continue;
            --winding;
        }
        return winding != 0;
    }

    public boolean contains2(PolygonPoint point) {
        int crossings = 0;
        for (int i = 0; i < this.size; ++i) {
            boolean cond2;
            int j = i + 1;
            boolean cond1 = this.points[i].y <= point.y && point.y < this.points[j].y;
            boolean bl = cond2 = this.points[j].y <= point.y && point.y < this.points[i].y;
            if (!cond1 && !cond2 || !(point.x < (this.points[j].x - this.points[i].x) * (point.y - this.points[i].y) / (this.points[j].y - this.points[i].y) + this.points[i].x)) continue;
            ++crossings;
        }
        return crossings % 2 == 1;
    }

    public double getPerimeter() {
        double sum = 0.0;
        for (int i = 0; i < this.size; ++i) {
            sum += this.points[i].distanceTo(this.points[i + 1]);
        }
        return sum;
    }

    public double getArea() {
        double sum = 0.0;
        for (int i = 0; i < this.size; ++i) {
            sum = sum + this.points[i].x * this.points[i + 1].y - this.points[i].y * this.points[i + 1].x;
        }
        return 0.5 * sum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Polygon polygon = (Polygon)o;
        return this.size == polygon.size && Arrays.equals(this.points, polygon.points);
    }

    public int hashCode() {
        int result = Objects.hash(this.size);
        result = 31 * result + Arrays.hashCode(this.points);
        return result;
    }

    public String toString() {
        StringBuilder msgBuilder = new StringBuilder();
        msgBuilder.append("[");
        for (PolygonPoint p : this.points) {
            msgBuilder.append(p.toString()).append(",");
        }
        if (msgBuilder.length() > 1) {
            msgBuilder.setLength(msgBuilder.length() - 1);
        }
        msgBuilder.append("]");
        return msgBuilder.toString();
    }
}

