/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.observables;

import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolbox.evt.type.MapChangeEvt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;

public class ObservableMap<K, V>
implements Map<K, V>,
Cloneable {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final ConcurrentHashMap<K, V> map;
    private Map<EvtType<? extends Evt>, List<EvtObserver<MapChangeEvt<K, V>>>> observers;

    public ObservableMap() {
        this(16, 0.75f);
    }

    public ObservableMap(int capacity) {
        this(capacity, 0.75f);
    }

    public ObservableMap(int capacity, float loadFactor) {
        this.map = new ConcurrentHashMap(capacity, loadFactor);
    }

    public ObservableMap(int capacity, float loadFactor, int concurrencyLevel) {
        this.map = new ConcurrentHashMap(capacity, loadFactor, concurrencyLevel);
    }

    public ObservableMap(Map<? extends K, ? extends V> map) {
        this.map = new ConcurrentHashMap<K, V>(map);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (this.map.containsKey(key)) {
            V result = this.map.put(key, value);
            this.fireMapChangeEvt(new MapChangeEvt(this, MapChangeEvt.MODIFIED, List.of(), List.of(Map.entry(key, value)), List.of()));
            return result;
        }
        V result = this.map.put(key, value);
        this.fireMapChangeEvt(new MapChangeEvt<K, V>(this, MapChangeEvt.ADDED, List.of(Map.entry(key, value)), List.of(), List.of()));
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        map.entrySet().forEach((? super T entry) -> this.put(entry.getKey(), entry.getValue()));
    }

    @Override
    public V remove(Object key) {
        V result;
        if (this.map.containsKey(key)) {
            Map.Entry<Object, V> removedEntry = Map.entry(key, this.map.get(key));
            result = this.map.remove(key);
            this.fireMapChangeEvt(new MapChangeEvt(this, MapChangeEvt.REMOVED, List.of(), List.of(), List.of(removedEntry)));
        } else {
            result = this.map.remove(key);
        }
        return result;
    }

    @Override
    public void clear() {
        ArrayList<Map.Entry<K, V>> removedEntries = new ArrayList<Map.Entry<K, V>>(this.entrySet());
        this.map.clear();
        this.fireMapChangeEvt(new MapChangeEvt(this, MapChangeEvt.REMOVED, List.of(), List.of(), removedEntries));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public ConcurrentHashMap.KeySetView<K, V> keySet() {
        return this.map.keySet();
    }

    public ConcurrentHashMap.KeySetView<K, V> keySet(V mappedValue) {
        return this.map.keySet(mappedValue);
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public Enumeration<K> keys() {
        return this.map.keys();
    }

    public Enumeration<V> elements() {
        return this.map.elements();
    }

    public long mappingCount() {
        return this.map.mappingCount();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V result = this.map.putIfAbsent(key, value);
        if (null == result) {
            this.fireMapChangeEvt(new MapChangeEvt<K, V>(this, MapChangeEvt.ADDED, List.of(Map.entry(key, value)), List.of(), List.of()));
        } else {
            this.fireMapChangeEvt(new MapChangeEvt(this, MapChangeEvt.MODIFIED, List.of(), List.of(Map.entry(key, result)), List.of()));
        }
        return result;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean result = this.map.remove(key, value);
        if (result) {
            this.fireMapChangeEvt(new MapChangeEvt(this, MapChangeEvt.REMOVED, List.of(), List.of(), List.of(Map.entry(key, value))));
        }
        return result;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        boolean result = this.map.replace(key, oldValue, newValue);
        if (result) {
            this.fireMapChangeEvt(new MapChangeEvt(this, MapChangeEvt.MODIFIED, List.of(), List.of(Map.entry(key, newValue)), List.of()));
        }
        return result;
    }

    @Override
    public V replace(K key, V value) {
        V result = this.map.replace(key, value);
        if (this.map.containsKey(key)) {
            this.fireMapChangeEvt(new MapChangeEvt(this, MapChangeEvt.MODIFIED, List.of(), List.of(Map.entry(key, value)), List.of()));
        }
        return result;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.map.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.map.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.map.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.map.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.map.forEach(action);
    }

    public void forEach(long parallelismThreshold, BiConsumer<? super K, ? super V> action) {
        this.map.forEach(action);
    }

    public <U> void forEach(long parallelismThreshold, BiFunction<? super K, ? super V, ? extends U> transformer, Consumer<? super U> action) {
        this.map.forEach(parallelismThreshold, transformer, action);
    }

    public <U> U search(long parallelismThreshold, BiFunction<? super K, ? super V, ? extends U> searchFunction) {
        return this.map.search(parallelismThreshold, searchFunction);
    }

    public <U> U reduce(long parallelismThreshold, BiFunction<? super K, ? super V, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        return this.map.reduce(parallelismThreshold, transformer, reducer);
    }

    public double reduceToDouble(long parallelismThreshold, ToDoubleBiFunction<? super K, ? super V> transformer, double basis, DoubleBinaryOperator reducer) {
        return this.map.reduceToDouble(parallelismThreshold, transformer, basis, reducer);
    }

    public long reduceToLong(long parallelismThreshold, ToLongBiFunction<? super K, ? super V> transformer, long basis, LongBinaryOperator reducer) {
        return this.map.reduceToLong(parallelismThreshold, transformer, basis, reducer);
    }

    public int reduceToInt(long parallelismThreshold, ToIntBiFunction<? super K, ? super V> transformer, int basis, IntBinaryOperator reducer) {
        return this.map.reduceToInt(parallelismThreshold, transformer, basis, reducer);
    }

    public void forEachKey(long parallelismThreshold, Consumer<? super K> action) {
        this.map.forEachKey(parallelismThreshold, action);
    }

    public <U> void forEachKey(long parallelismThreshold, Function<? super K, ? extends U> transformer, Consumer<? super U> action) {
        this.map.forEachKey(parallelismThreshold, transformer, action);
    }

    public <U> U searchKeys(long parallelismThreshold, Function<? super K, ? extends U> searchFunction) {
        return this.map.searchKeys(parallelismThreshold, searchFunction);
    }

    public K reduceKeys(long parallelismThreshold, BiFunction<? super K, ? super K, ? extends K> reducer) {
        return this.map.reduceKeys(parallelismThreshold, reducer);
    }

    public <U> U reduceKeys(long parallelismThreshold, Function<? super K, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        return this.map.reduceKeys(parallelismThreshold, transformer, reducer);
    }

    public double reduceKeysToDouble(long parallelismThreshold, ToDoubleFunction<? super K> transformer, double basis, DoubleBinaryOperator reducer) {
        return this.map.reduceKeysToDouble(parallelismThreshold, transformer, basis, reducer);
    }

    public long reduceKeysToLong(long parallelismThreshold, ToLongFunction<? super K> transformer, long basis, LongBinaryOperator reducer) {
        return this.map.reduceKeysToLong(parallelismThreshold, transformer, basis, reducer);
    }

    public int reduceKeysToInt(long parallelismThreshold, ToIntFunction<? super K> transformer, int basis, IntBinaryOperator reducer) {
        return this.map.reduceKeysToInt(parallelismThreshold, transformer, basis, reducer);
    }

    public void forEachValue(long parallelismThreshold, Consumer<? super V> action) {
        this.map.forEachValue(parallelismThreshold, action);
    }

    public <U> void forEachValue(long parallelismThreshold, Function<? super V, ? extends U> transformer, Consumer<? super U> action) {
        this.map.forEachValue(parallelismThreshold, transformer, action);
    }

    public <U> U searchValues(long parallelismThreshold, Function<? super V, ? extends U> searchFunction) {
        return this.map.searchValues(parallelismThreshold, searchFunction);
    }

    public V reduceValues(long parallelismThreshold, BiFunction<? super V, ? super V, ? extends V> reducer) {
        return this.map.reduceValues(parallelismThreshold, reducer);
    }

    public <U> U reduceValues(long parallelismThreshold, Function<? super V, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        return this.map.reduceValues(parallelismThreshold, transformer, reducer);
    }

    public double reduceValuesToDouble(long parallelismThreshold, ToDoubleFunction<? super V> transformer, double basis, DoubleBinaryOperator reducer) {
        return this.map.reduceValuesToDouble(parallelismThreshold, transformer, basis, reducer);
    }

    public long reduceValuesToLong(long parallelismThreshold, ToLongFunction<? super V> transformer, long basis, LongBinaryOperator reducer) {
        return this.map.reduceValuesToLong(parallelismThreshold, transformer, basis, reducer);
    }

    public int reduceValuesToInt(long parallelismThreshold, ToIntFunction<? super V> transformer, int basis, IntBinaryOperator reducer) {
        return this.map.reduceValuesToInt(parallelismThreshold, transformer, basis, reducer);
    }

    public void forEachEntry(long parallelismThreshold, Consumer<? super Map.Entry<K, V>> action) {
        this.map.forEachEntry(parallelismThreshold, action);
    }

    public <U> void forEachEntry(long parallelismThreshold, Function<Map.Entry<K, V>, ? extends U> transformer, Consumer<? super U> action) {
        this.map.forEachEntry(parallelismThreshold, transformer, action);
    }

    public <U> U searchEntries(long parallelismThreshold, Function<Map.Entry<K, V>, ? extends U> searchFunction) {
        return this.map.searchEntries(parallelismThreshold, searchFunction);
    }

    public Map.Entry<K, V> reduceEntries(long parallelismThreshold, BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer) {
        return this.map.reduceEntries(parallelismThreshold, reducer);
    }

    public <U> U reduceEntries(long parallelismThreshold, Function<Map.Entry<K, V>, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        return this.map.reduceEntries(parallelismThreshold, transformer, reducer);
    }

    public double reduceEntriesToDouble(long parallelismThreshold, ToDoubleFunction<Map.Entry<K, V>> transformer, double basis, DoubleBinaryOperator reducer) {
        return this.map.reduceEntriesToDouble(parallelismThreshold, transformer, basis, reducer);
    }

    public long reduceEntriesToLong(long parallelismThreshold, ToLongFunction<Map.Entry<K, V>> transformer, long basis, LongBinaryOperator reducer) {
        return this.map.reduceEntriesToLong(parallelismThreshold, transformer, basis, reducer);
    }

    public int reduceEntriesToInt(long parallelismThreshold, ToIntFunction<Map.Entry<K, V>> transformer, int basis, IntBinaryOperator reducer) {
        return this.map.reduceEntriesToInt(parallelismThreshold, transformer, basis, reducer);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.map.replaceAll(function);
    }

    public ObservableMap<K, V> clone() {
        try {
            ObservableMap clone = (ObservableMap)super.clone();
            clone.putAll(this.map);
            return clone;
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public void addMapChangeObserver(EvtType<? extends Evt> type, EvtObserver<MapChangeEvt<K, V>> observer) {
        if (null == type || null == observer) {
            return;
        }
        if (null == this.observers) {
            this.observers = new ConcurrentHashMap<EvtType<? extends Evt>, List<EvtObserver<MapChangeEvt<K, V>>>>();
        }
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeMapChangeObserver(EvtType<? extends Evt> type, EvtObserver<MapChangeEvt<K, V>> observer) {
        if (null == this.observers || null == type || null == observer) {
            return;
        }
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllMapChangeObservers() {
        if (null == this.observers) {
            return;
        }
        this.observers.clear();
    }

    public void fireMapChangeEvt(MapChangeEvt<K, V> evt) {
        if (null == this.observers) {
            return;
        }
        this.observers.entrySet().stream().filter(entry -> !((EvtType)entry.getKey()).equals(MapChangeEvt.ANY)).filter(entry -> ((EvtType)entry.getKey()).equals(evt.getEvtType())).forEach((? super T entry) -> ((List)entry.getValue()).forEach((? super T observer) -> observer.handle(evt)));
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(MapChangeEvt.ANY)).forEach((? super T entry) -> ((List)entry.getValue()).forEach((? super T observer) -> observer.handle(evt)));
    }
}

