/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.properties;

import eu.hansolo.toolbox.evt.type.InvalidationEvt;
import eu.hansolo.toolbox.evt.type.PropertyChangeEvt;
import eu.hansolo.toolbox.properties.ReadOnlyIntegerProperty;

public class IntegerProperty
extends ReadOnlyIntegerProperty {
    protected ReadOnlyIntegerProperty propertyBoundTo;
    protected boolean bound;

    public IntegerProperty() {
        this((Object)null, (String)null, 0);
    }

    public IntegerProperty(int value) {
        this((Object)null, (String)null, value);
    }

    public IntegerProperty(String name, int value) {
        this((Object)null, name, value);
    }

    public IntegerProperty(Object bean, String name, int value) {
        super(bean, name, value);
        this.propertyToUpdate = null;
        this.propertyBoundTo = null;
        this.bound = false;
        this.bidirectional = false;
    }

    public void set(int value) {
        this.setValue(value);
    }

    public void setValue(Integer value) {
        if (this.bound && !this.bidirectional) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        this.setValue(value, null);
    }

    protected void setValue(Integer value, IntegerProperty property) {
        if (!value.equals(this.getValue())) {
            this.willChange((Integer)this.value, value);
            Integer oldValue = (Integer)this.value;
            this.value = value;
            if (null == property && null != this.propertyToUpdate) {
                this.propertyToUpdate.setValue(value, this);
            }
            this.fireEvent(new PropertyChangeEvt<Object>(this, PropertyChangeEvt.CHANGED, oldValue, this.value));
            this.didChange(oldValue, (Integer)this.value);
        }
        this.invalidated();
    }

    @Override
    public void invalidated() {
        this.fireEvent(new InvalidationEvt(this, InvalidationEvt.INVALIDATED));
    }

    public void unset() {
        this.setValue((Integer)this.getInitialValue());
    }

    public void setInitialValue(Integer initialValue) {
        this.initialValue = initialValue;
    }

    public void bind(ReadOnlyIntegerProperty property) {
        this.propertyBoundTo = property;
        this.value = this.propertyBoundTo.getValue();
        this.propertyBoundTo.setPropertyToUpdate(this);
        this.propertyToUpdate = null;
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void bindBidirectional(IntegerProperty property) {
        this.setPropertyToUpdate(property, true);
        property.setPropertyToUpdate(this, true);
        this.propertyBoundTo = property;
        this.bound = true;
    }

    public boolean isBoundBidirectional() {
        return this.bidirectional;
    }

    public void unbind() {
        if (null != this.propertyToUpdate) {
            this.propertyToUpdate.unsetPropertyToUpdate();
            this.propertyToUpdate.unbind();
            this.propertyToUpdate = null;
        }
        if (null != this.propertyBoundTo) {
            this.propertyBoundTo.unsetPropertyToUpdate();
            this.propertyBoundTo = null;
        }
        this.bound = false;
        this.bidirectional = false;
    }

    protected void setPropertyToUpdate(IntegerProperty property, boolean bidirectional) {
        this.propertyToUpdate = property;
        if (null == property) {
            this.bidirectional = false;
        } else {
            this.value = property.getValue();
            this.bidirectional = bidirectional;
        }
    }
}

