/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.properties;

import eu.hansolo.toolbox.evt.type.InvalidationEvt;
import eu.hansolo.toolbox.evt.type.PropertyChangeEvt;
import eu.hansolo.toolbox.properties.ReadOnlyProperty;

public abstract class Property<T>
extends ReadOnlyProperty<T> {
    protected ReadOnlyProperty<T> propertyBoundTo = null;
    protected boolean bound = false;

    public Property() {
        this(null, null, null);
    }

    public Property(T value) {
        this(null, null, value);
    }

    public Property(String name, T value) {
        this(null, name, value);
    }

    public Property(Object bean, String name, T value) {
        super(bean, name, value);
    }

    public void set(T value) {
        this.setValue(value);
    }

    public void setValue(T value) {
        if (this.bound && !this.bidirectional) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        this.setValue(value, null);
    }

    protected void setValue(T value, Property<T> property) {
        if (!value.equals(this.getValue())) {
            this.willChange(this.value, value);
            Object oldValue = this.value;
            this.value = value;
            if (null == property && null != this.propertyToUpdate) {
                this.propertyToUpdate.setValue(value, this);
            }
            this.fireEvent(new PropertyChangeEvt<Object>(this, PropertyChangeEvt.CHANGED, oldValue, this.value));
            this.didChange(oldValue, this.value);
        }
        this.invalidated();
    }

    @Override
    public void invalidated() {
        this.fireEvent(new InvalidationEvt(this, InvalidationEvt.INVALIDATED));
    }

    public void unset() {
        this.setValue(this.getInitialValue());
    }

    public void setInitialValue(T initialValue) {
        this.initialValue = initialValue;
    }

    public void bind(ReadOnlyProperty<T> property) {
        this.propertyBoundTo = property;
        this.value = this.propertyBoundTo.getValue();
        this.propertyBoundTo.setPropertyToUpdate(this);
        this.propertyToUpdate = null;
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void bindBidirectional(Property<T> property) {
        this.setPropertyToUpdate(property, true);
        property.setPropertyToUpdate(this, true);
        this.propertyBoundTo = property;
        this.bound = true;
    }

    public boolean isBoundBidirectional() {
        return this.bidirectional;
    }

    public void unbind() {
        if (null != this.propertyToUpdate) {
            this.propertyToUpdate.setPropertyToUpdate(null);
            this.propertyToUpdate.unbind();
            this.propertyToUpdate = null;
        }
        if (null != this.propertyBoundTo) {
            this.propertyBoundTo.setPropertyToUpdate(null);
            this.propertyBoundTo = null;
        }
        this.bound = false;
        this.bidirectional = false;
    }

    protected void setPropertyToUpdate(Property<T> property, boolean bidirectional) {
        this.propertyToUpdate = property;
        if (null == property) {
            this.bidirectional = false;
        } else {
            this.value = property.getValue();
            this.bidirectional = bidirectional;
        }
    }
}

