/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.tuples;

import eu.hansolo.toolbox.tuples.Tuple;
import java.util.Objects;

public class Quartet<A, B, C, D>
implements Tuple {
    private A a;
    private B b;
    private C c;
    private D d;

    public Quartet(A a, B b, C c, D d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public A getA() {
        return this.a;
    }

    public void setA(A a) {
        this.a = a;
    }

    public B getB() {
        return this.b;
    }

    public void setB(B b) {
        this.b = b;
    }

    public C getC() {
        return this.c;
    }

    public void setC(C c) {
        this.c = c;
    }

    public D getD() {
        return this.d;
    }

    public void setD(D d) {
        this.d = d;
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    public Object getValueAt(int i) {
        if (0 > i && i >= this.size()) {
            throw new IllegalArgumentException("Index out of bounds, " + this.getClass().getSimpleName() + " has " + this.size() + " elements");
        }
        switch (i) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.d;
            }
        }
        return null;
    }

    @Override
    public Class getTypeAt(int i) {
        if (0 > i && i >= this.size()) {
            throw new IllegalArgumentException("Index out of bounds, " + this.getClass().getSimpleName() + " has " + this.size() + " elements");
        }
        switch (i) {
            case 0: {
                return this.a.getClass();
            }
            case 1: {
                return this.b.getClass();
            }
            case 2: {
                return this.c.getClass();
            }
            case 3: {
                return this.d.getClass();
            }
        }
        return null;
    }

    public String toString() {
        return "{" + "\"" + "a" + "\"" + ":" + "\"" + this.a + "\"" + "," + "\"" + "b" + "\"" + ":" + "\"" + this.b + "\"" + "," + "\"" + "c" + "\"" + ":" + "\"" + this.c + "\"" + "," + "\"" + "d" + "\"" + ":" + "\"" + this.d + "\"" + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quartet quartet = (Quartet)o;
        return this.a.equals(quartet.a) && this.b.equals(quartet.b) && this.c.equals(quartet.c) && this.d.equals(quartet.d);
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b, this.c, this.d);
    }
}

