/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox;

import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class CountdownLock<T> {
    private ScheduledExecutorService service;
    private final Duration timeout;
    private final AtomicBoolean running;
    private final Command cmd;
    private final T param;
    private final AtomicLong secondsToGo;

    public CountdownLock(Command cmd, T param, Duration timeout) {
        if (null == cmd || null == timeout) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        this.service = Executors.newSingleThreadScheduledExecutor();
        this.cmd = cmd;
        this.param = param;
        this.timeout = timeout;
        this.running = new AtomicBoolean(false);
        this.secondsToGo = new AtomicLong(timeout.getSeconds());
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        Runnable runnable = () -> {
            this.secondsToGo.decrementAndGet();
            if (this.secondsToGo.get() < 0L) {
                this.cmd.execute(this.param);
                this.stop();
            }
        };
        this.service.scheduleAtFixedRate(runnable, 0L, 1L, TimeUnit.SECONDS);
        this.running.set(true);
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.service.shutdown();
        this.running.set(false);
        this.service = Executors.newScheduledThreadPool(1);
        this.secondsToGo.set(this.timeout.getSeconds());
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public long getSecondsToGo() {
        return this.secondsToGo.get() + 1L;
    }

    @FunctionalInterface
    public static interface Command<T> {
        public void execute(T var1);
    }
}

