/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox;

import eu.hansolo.toolbox.properties.DoubleProperty;

public class Range {
    private static final String ERR_MSG = "min must be smaller than max";
    private double _min;
    private DoubleProperty min;
    private double _max;
    private DoubleProperty max;

    public Range(double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException(ERR_MSG);
        }
        this._min = min;
        this._max = max;
    }

    public double getMin() {
        return null == this.min ? this._min : this.min.get();
    }

    public void setMin(double min) {
        if (this.isValid(min, this.getMax())) {
            if (null == this.min) {
                this._min = min;
            } else {
                this.min.set(min);
            }
        } else {
            throw new IllegalArgumentException(ERR_MSG);
        }
    }

    public DoubleProperty minProperty() {
        if (null == this.min) {
            this.min = new DoubleProperty(this._min){

                @Override
                public void set(double value) {
                    if (!Range.this.isValid(value, Range.this.getMax())) {
                        throw new IllegalArgumentException(Range.ERR_MSG);
                    }
                    super.set(value);
                }
            };
        }
        return this.min;
    }

    public double getMax() {
        return null == this.max ? this._max : this.max.get();
    }

    public void setMax(double max) {
        if (this.getMin() < max) {
            if (null == this.max) {
                this._max = max;
            } else {
                this.max.set(max);
            }
        } else {
            throw new IllegalArgumentException(ERR_MSG);
        }
    }

    public DoubleProperty maxProperty() {
        if (null == this.max) {
            this.max = new DoubleProperty(this._max){

                @Override
                public void set(double value) {
                    if (!Range.this.isValid(Range.this.getMin(), value)) {
                        throw new IllegalArgumentException(Range.ERR_MSG);
                    }
                    super.set(value);
                }
            };
        }
        return this.max;
    }

    public boolean contains(double value) {
        return value >= this.getMin() && value <= this.getMax();
    }

    public static int isValueInRange(double value, Range range) {
        if (value < range.getMin()) {
            return -1;
        }
        if (value > range.getMax()) {
            return 1;
        }
        return 0;
    }

    private boolean isValid(double min, double max) {
        return min < max;
    }

    public String toString() {
        return "{" + "\"" + "min" + "\":" + this.getMax() + "," + "\"" + "max" + "\":" + this.getMax() + "}";
    }
}

