/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.geo;

import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolbox.evt.type.GeoFenceEvt;
import eu.hansolo.toolbox.evt.type.GeoLocationChangeEvt;
import eu.hansolo.toolbox.geo.GeoLocation;
import eu.hansolo.toolbox.geo.Polygon;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class GeoFence {
    private final String id = UUID.randomUUID().toString();
    private String name;
    private String info;
    private String group;
    private boolean isActive;
    private boolean isTimeBased;
    private LocalTime startTime;
    private LocalTime endTime;
    private ZoneId zoneId;
    private Set<DayOfWeek> days;
    private Set<String> tags;
    private Polygon polygon;
    private HashMap<String, GeoLocation> objectsInFence;
    private Map<EvtType, List<EvtObserver<GeoFenceEvt>>> observers;

    public GeoFence() {
        this("", "", "", false, false, LocalTime.now(), LocalTime.now(), ZoneId.systemDefault(), new HashSet<DayOfWeek>(), new HashSet<String>(), new Polygon());
    }

    public GeoFence(String name, String info, String group, boolean active, boolean timeBased, LocalTime startTime, LocalTime endTime, ZoneId zoneId, Set<DayOfWeek> days, Set<String> tags, Polygon polygon) {
        this.name = name;
        this.info = info;
        this.group = group;
        this.isActive = active;
        this.isTimeBased = timeBased;
        this.startTime = startTime;
        this.endTime = endTime;
        this.zoneId = zoneId;
        this.days = new HashSet<DayOfWeek>(days);
        this.tags = new HashSet<String>(tags);
        this.objectsInFence = new HashMap();
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<GeoFenceEvt>>>();
        this.polygon = polygon;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.NAME_CHANGED, oldName, this.name));
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        String oldInfo = this.info;
        this.info = info;
        this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.INFO_CHANGED, oldInfo, this.info));
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        String oldGroup = this.group;
        this.group = group;
        this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.GROUP_CHANGED, oldGroup, this.group));
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        boolean wasActive = this.isActive;
        this.isActive = active;
        this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.ACTIVE_CHANGED, wasActive, this.isActive));
    }

    public boolean isTimeBased() {
        return this.isTimeBased;
    }

    public void setTimeBased(boolean timeBased) {
        boolean wasTimeBased = this.isTimeBased;
        this.isTimeBased = timeBased;
        this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.TIME_BASED_CHANGED, wasTimeBased, this.isTimeBased));
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalTime startTime) {
        LocalTime oldStartTime = this.startTime;
        this.startTime = startTime;
        this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.START_TIME_CHANGED, oldStartTime, this.startTime));
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalTime endTime) {
        LocalTime oldEndTime = this.endTime;
        this.endTime = endTime;
        this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.END_TIME_CHANGED, oldEndTime, this.endTime));
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        ZoneId oldZoneId = this.zoneId;
        this.zoneId = zoneId;
        this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.ZONE_ID_CHANGED, oldZoneId, this.zoneId));
    }

    public Set<DayOfWeek> getDays() {
        return this.days;
    }

    public void setDays(Set<DayOfWeek> days) {
        HashSet<DayOfWeek> oldDays = new HashSet<DayOfWeek>(this.days);
        this.days = days;
        this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.DAYS_CHANGED, oldDays, this.days));
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        HashSet<String> oldTags = new HashSet<String>(this.tags);
        this.tags = tags;
        this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.TAGS_CHANGED, oldTags, this.tags));
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public void setPolygon(Polygon polygon) {
        Polygon oldPolygon = this.polygon;
        this.polygon = polygon;
        this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.POLYGON_CHANGED, oldPolygon, this.polygon));
    }

    public boolean isInFence(GeoLocation location) {
        boolean isKnown = this.objectsInFence.containsKey(location.getId());
        boolean isInFence = this.polygon.contains(location);
        if (isKnown) {
            this.objectsInFence.get(location.getId()).set(location);
            if (isInFence) {
                this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.INSIDE_FENCE, null, location));
            } else {
                this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.OUTSIDE_FENCE, null, location));
                this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.LEFT_FENCE, null, location));
                this.objectsInFence.remove(location.getId());
            }
        } else if (isInFence) {
            this.objectsInFence.put(location.getId(), location);
            this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.INSIDE_FENCE, null, location));
            this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.ENTERED_FENCE, null, location));
        } else {
            this.fireGeoFenceEvent(new GeoFenceEvt(this, GeoFenceEvt.OUTSIDE_FENCE, null, location));
        }
        return isInFence;
    }

    public Set<String> getIdsOfObjectsInFence() {
        return new HashSet<String>(this.objectsInFence.keySet());
    }

    public void addGeoFenceObserver(EvtType<? extends Evt> type, EvtObserver<GeoFenceEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeGeoFenceObserver(EvtType<? extends Evt> type, EvtObserver<GeoFenceEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllGeoFenceObservers() {
        this.observers.clear();
    }

    public void fireGeoFenceEvent(GeoFenceEvt evt) {
        EvtType<? extends GeoLocationChangeEvt> type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(GeoFenceEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle(evt)));
        if (this.observers.containsKey(type)) {
            this.observers.get(type).forEach(observer -> observer.handle(evt));
        }
    }
}

