/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.geo;

import eu.hansolo.toolbox.geo.GeoFence;
import eu.hansolo.toolbox.geo.Polygon;
import eu.hansolo.toolbox.properties.BooleanProperty;
import eu.hansolo.toolbox.properties.ObjectProperty;
import eu.hansolo.toolbox.properties.ReadOnlyProperty;
import eu.hansolo.toolbox.properties.StringProperty;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class GeoFenceBuilder<B extends GeoFenceBuilder<B>> {
    private HashMap<String, ReadOnlyProperty> properties = new HashMap();

    protected GeoFenceBuilder() {
    }

    public static final GeoFenceBuilder create() {
        return new GeoFenceBuilder();
    }

    public final B name(String name) {
        this.properties.put("name", new StringProperty(name));
        return (B)this;
    }

    public final B info(String info) {
        this.properties.put("info", new StringProperty(info));
        return (B)this;
    }

    public final B group(String group) {
        this.properties.put("group", new StringProperty(group));
        return (B)this;
    }

    public final B isActive(boolean isActive) {
        this.properties.put("isActive", new BooleanProperty(isActive));
        return (B)this;
    }

    public final B isTimeBased(boolean isTimeBased) {
        this.properties.put("isTimeBased", new BooleanProperty(isTimeBased));
        return (B)this;
    }

    public final B startTime(LocalTime startTime) {
        this.properties.put("startTime", new ObjectProperty<LocalTime>(startTime));
        return (B)this;
    }

    public final B endTime(LocalTime endTime) {
        this.properties.put("endTime", new ObjectProperty<LocalTime>(endTime));
        return (B)this;
    }

    public final B zoneId(ZoneId zoneId) {
        this.properties.put("zoneId", new ObjectProperty<ZoneId>(zoneId));
        return (B)this;
    }

    public final B days(DayOfWeek ... days) {
        this.properties.put("days", new ObjectProperty<HashSet<DayOfWeek>>(new HashSet<DayOfWeek>(Arrays.asList(days))));
        return (B)this;
    }

    public final B days(Set<DayOfWeek> days) {
        this.properties.put("days", new ObjectProperty<HashSet<DayOfWeek>>(new HashSet<DayOfWeek>(days)));
        return (B)this;
    }

    public final B tags(String ... tags) {
        this.properties.put("tags", new ObjectProperty<HashSet<String>>(new HashSet<String>(Arrays.asList(tags))));
        return (B)this;
    }

    public final B tags(Set<String> tags) {
        this.properties.put("tags", new ObjectProperty<HashSet<String>>(new HashSet<String>(tags)));
        return (B)this;
    }

    public final B polygon(Polygon polygon) {
        this.properties.put("polygon", new ObjectProperty<Polygon>(polygon));
        return (B)this;
    }

    public final GeoFence build() {
        GeoFence geoFence = new GeoFence();
        this.properties.forEach((key, property) -> {
            switch (key) {
                case "name": {
                    geoFence.setName(((StringProperty)property).get());
                    break;
                }
                case "info": {
                    geoFence.setInfo(((StringProperty)property).get());
                    break;
                }
                case "group": {
                    geoFence.setGroup(((StringProperty)property).get());
                    break;
                }
                case "isActive": {
                    geoFence.setActive(((BooleanProperty)property).get());
                    break;
                }
                case "isTimeBased": {
                    geoFence.setTimeBased(((BooleanProperty)property).get());
                    break;
                }
                case "startTime": {
                    geoFence.setStartTime((LocalTime)((ObjectProperty)property).get());
                    break;
                }
                case "endTime": {
                    geoFence.setEndTime((LocalTime)((ObjectProperty)property).get());
                    break;
                }
                case "zoneId": {
                    geoFence.setZoneId((ZoneId)((ObjectProperty)property).get());
                    break;
                }
                case "days": {
                    geoFence.setDays((Set)((ObjectProperty)property).get());
                    break;
                }
                case "tags": {
                    geoFence.setTags((Set)((ObjectProperty)property).get());
                    break;
                }
                case "polygon": {
                    geoFence.setPolygon((Polygon)((ObjectProperty)property).get());
                }
            }
        });
        return geoFence;
    }
}

