/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.geo;

import eu.hansolo.toolbox.geo.GeoLocation;
import java.util.Objects;

public class PolygonPoint {
    public double x;
    public double y;

    public PolygonPoint() {
        this(0.0, 0.0);
    }

    public PolygonPoint(GeoLocation location) {
        this(location.getLongitude(), location.getLatitude());
    }

    public PolygonPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double distanceTo(PolygonPoint point) {
        if (point == null) {
            return Double.POSITIVE_INFINITY;
        }
        double dx = this.x - point.x;
        double dy = this.y - point.y;
        return Math.hypot(dx, dy);
    }

    public static int ccw(PolygonPoint point1, PolygonPoint point2, PolygonPoint point3) {
        double area = (point2.x - point1.x) * (point3.y - point1.y) - (point3.x - point1.x) * (point2.y - point1.y);
        return area < 0.0 ? -1 : (area > 0.0 ? 1 : 0);
    }

    public static boolean collinear(PolygonPoint point1, PolygonPoint point2, PolygonPoint point3) {
        return PolygonPoint.ccw(point1, point2, point3) == 0;
    }

    public static boolean isBetween(PolygonPoint point, PolygonPoint point1, PolygonPoint point2) {
        if (PolygonPoint.ccw(point1, point2, point) != 0) {
            return false;
        }
        if (Double.compare(point1.x, point2.x) == 0 && Double.compare(point1.y, point2.y) == 0) {
            return Double.compare(point1.x, point.x) == 0 && Double.compare(point1.y, point.y) == 0;
        }
        if (point1.x != point2.x) {
            return point1.x <= point.x && point.x <= point2.x || point1.x >= point.x && point.x >= point2.x;
        }
        return point1.y <= point.y && point.y <= point2.y || point1.y >= point.y && point.y >= point2.y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolygonPoint point = (PolygonPoint)o;
        return Double.compare(this.x, point.x) == 0 && Double.compare(this.y, point.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return "{" + "\"" + "x" + "\":" + this.x + "," + "\"" + "y" + "\":" + this.y + "}";
    }
}

