/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.observables;

import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolbox.evt.type.MatrixChangeEvt;
import eu.hansolo.toolbox.evt.type.MatrixItemChangeEvt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ObservableMatrix<T> {
    private final Class<T> type;
    private Map<EvtType<? extends Evt>, List<EvtObserver<MatrixChangeEvt<T>>>> matrixObservers;
    private Map<EvtType<? extends Evt>, List<EvtObserver<MatrixItemChangeEvt<T>>>> itemObservers;
    private AtomicReference<T>[][] matrix;
    private AtomicInteger cols;
    private AtomicInteger rows;
    private boolean colsMirrored;
    private boolean rowsMirrored;
    private boolean resizeMatrixWhenInnerRowOrColIsRemoved;

    public ObservableMatrix(Class<T> type, int cols, int rows) {
        this(type, cols, rows, false);
    }

    public ObservableMatrix(Class<T> type, int cols, int rows, boolean resizeMatrixWhenInnerRowOrColIsRemoved) {
        this.type = type;
        this.matrix = ObservableMatrix.createArray(type, cols, rows);
        this.cols = new AtomicInteger(cols);
        this.rows = new AtomicInteger(rows);
        this.colsMirrored = false;
        this.rowsMirrored = false;
        this.resizeMatrixWhenInnerRowOrColIsRemoved = resizeMatrixWhenInnerRowOrColIsRemoved;
    }

    public ObservableMatrix(ObservableMatrix<T> copyFromMatrix) {
        this.type = copyFromMatrix.getType();
        this.matrix = ObservableMatrix.createArray(this.type, copyFromMatrix.cols.get(), copyFromMatrix.rows.get());
        this.cols = copyFromMatrix.cols;
        this.rows = copyFromMatrix.rows;
        this.colsMirrored = copyFromMatrix.colsMirrored;
        this.rowsMirrored = copyFromMatrix.rowsMirrored;
        this.resizeMatrixWhenInnerRowOrColIsRemoved = copyFromMatrix.resizeMatrixWhenInnerRowOrColIsRemoved;
        for (int y = 0; y < this.rows.get(); ++y) {
            for (int x = 0; x < this.cols.get(); ++x) {
                this.setItemAt(x, y, copyFromMatrix.getItemAt(x, y));
            }
        }
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getItemAt(int x, int y) {
        if (x < 0 || x > this.cols.get() - 1 || y < 0 || y > this.rows.get() - 1) {
            throw new IllegalArgumentException("cols/rows cannot be smaller than 0/0 or larger than " + (this.cols.get() - 1) + "/" + (this.rows.get() - 1));
        }
        return this.matrix[x][y].get();
    }

    public void setItemAt(int x, int y, T item) {
        this.setItemAt(x, y, item, true);
    }

    public void setItemAt(int x, int y, T item, boolean notify) {
        if (x < 0 || x > this.cols.get() - 1 || y < 0 || y > this.rows.get() - 1) {
            throw new IllegalArgumentException("cols/rows cannot be smaller than 0");
        }
        T oldItem = this.matrix[x][y].get();
        this.matrix[x][y].set(item);
        if (notify) {
            if (null == oldItem && item != null) {
                this.fireMatrixItemChangeEvt(new MatrixItemChangeEvt<T>(this, MatrixItemChangeEvt.ITEM_ADDED, x, y, oldItem, item));
            } else if (null != oldItem && item == null) {
                this.fireMatrixItemChangeEvt(new MatrixItemChangeEvt<T>(this, MatrixItemChangeEvt.ITEM_REMOVED, x, y, oldItem, item));
            } else if (null != oldItem && item != null) {
                this.fireMatrixItemChangeEvt(new MatrixItemChangeEvt<T>(this, MatrixItemChangeEvt.ITEM_CHANGED, x, y, oldItem, item));
            } else {
                return;
            }
        }
    }

    public void removeItemAt(int x, int y) {
        this.removeItemAt(x, y, true);
    }

    public void removeItemAt(int x, int y, boolean notify) {
        if (x < 0 || x > this.cols.get() - 1 || y < 0 || y > this.rows.get() - 1) {
            throw new IllegalArgumentException("cols/rows cannot be smaller than 0");
        }
        T oldItem = this.matrix[x][y].get();
        this.matrix[x][y].set(null);
        if (notify) {
            this.fireMatrixItemChangeEvt(new MatrixItemChangeEvt<Object>(this, MatrixItemChangeEvt.ITEM_REMOVED, x, y, oldItem, null));
        }
        this.checkForRemovedColumnsAndRows(x, y, notify);
    }

    public void removeItem(T item) {
        this.removeItem(item, true);
    }

    public void removeItem(T item, boolean notify) {
        for (int y = 0; y < this.rows.get(); ++y) {
            for (int x = 0; x < this.cols.get(); ++x) {
                T matrixItem = this.matrix[x][y].get();
                if (null == matrixItem || !matrixItem.equals(item)) continue;
                this.matrix[x][y] = null;
                if (notify) {
                    this.fireMatrixItemChangeEvt(new MatrixItemChangeEvt<Object>(this, MatrixItemChangeEvt.ITEM_REMOVED, x, y, item, null));
                }
                this.checkForRemovedColumnsAndRows(x, y, notify);
                return;
            }
        }
    }

    public boolean contains(T item) {
        for (int y = 0; y < this.rows.get(); ++y) {
            for (int x = 0; x < this.cols.get(); ++x) {
                if (null == this.matrix[x][y] || !this.matrix[x][y].equals(item)) continue;
                return true;
            }
        }
        return false;
    }

    public int[] getIndicesOf(T item) {
        for (int y = 0; y < this.rows.get(); ++y) {
            for (int x = 0; x < this.cols.get(); ++x) {
                if (!this.matrix[x][y].equals(item)) continue;
                return new int[]{x, y};
            }
        }
        return new int[]{-1, -1};
    }

    public AtomicReference<T>[][] getMatrix() {
        return this.matrix;
    }

    public List<AtomicReference<T>> getAllItems() {
        return this.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Stream<AtomicReference<T>> stream() {
        return Arrays.stream(this.matrix).flatMap(t -> Arrays.stream(t));
    }

    public void reset() {
        if (this.rows.get() == -1 || this.cols.get() == -1) {
            throw new IllegalArgumentException("cols/rows cannot be smaller 0");
        }
        for (int y = 0; y < this.rows.get(); ++y) {
            for (int x = 0; x < this.cols.get(); ++x) {
                this.matrix[x][y] = null;
            }
        }
    }

    public List<T> getCol(int col) {
        if (this.rows.get() == -1 || this.cols.get() == -1 || col < 0 || col > this.cols.get()) {
            throw new IllegalArgumentException("cols/rows cannot be smaller 0");
        }
        ArrayList<T> c = new ArrayList<T>();
        for (int y = 0; y < this.rows.get(); ++y) {
            c.add(this.matrix[col][y].get());
        }
        return c;
    }

    public List<T> getRow(int row) {
        if (this.rows.get() == -1 || this.cols.get() == -1 || row < 0 || row > this.rows.get()) {
            throw new IllegalArgumentException("cols/rows cannot be smaller 0");
        }
        ArrayList<T> r = new ArrayList<T>();
        for (int x = 0; x < this.cols.get(); ++x) {
            r.add(this.matrix[x][row].get());
        }
        return r;
    }

    public boolean isColEmpty(int col) {
        List<T> c = this.getCol(col);
        long count = 0L;
        for (T item : c) {
            if (null == item) continue;
            ++count;
        }
        return 0L == count;
    }

    public boolean isRowEmpty(int row) {
        List<T> r = this.getRow(row);
        long count = 0L;
        for (T item : r) {
            if (null == item) continue;
            ++count;
        }
        return 0L == count;
    }

    public int getNoOfCols() {
        return this.cols.get();
    }

    public void setCols(int cols) {
        this.setCols(cols, true);
    }

    public void setCols(int cols, boolean notify) {
        if (this.rows.get() == -1 || cols == -1 || this.cols.get() == -1) {
            throw new IllegalArgumentException("cols/rows cannot be smaller 0");
        }
        AtomicReference[][] oldMatrix = new AtomicReference[cols][this.rows.get()];
        for (int y = 0; y < this.rows.get(); ++y) {
            for (int x = 0; x < this.cols.get(); ++x) {
                oldMatrix[x][y].set(this.matrix[x][y].get());
            }
        }
        int oldCols = this.cols.get();
        this.cols.set(cols);
        this.matrix = ObservableMatrix.createArray(this.type, cols, this.rows.get());
        int r = this.rows.get();
        int c = cols > this.cols.get() ? oldCols : (cols < this.cols.get() ? cols : cols);
        for (int y = 0; y < r; ++y) {
            for (int x = 0; x < c; ++x) {
                this.matrix[x][y].set(oldMatrix[x][y].get());
            }
        }
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.NO_OF_COLUMNS_CHANGED, cols, -1));
        }
    }

    public void addCol(int at, Supplier<T> itemSupplier) {
        this.addCol(at, itemSupplier, true);
    }

    public void addCol(int at, Supplier<T> itemSupplier, boolean notify) {
        int x;
        int y;
        if (at < 0 || at > this.cols.get()) {
            throw new IllegalArgumentException("index cannot be smaller or larger than cols");
        }
        this.cols.getAndIncrement();
        AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols.get(), this.rows.get());
        for (y = 0; y < this.rows.get(); ++y) {
            for (x = 0; x < at; ++x) {
                newMatrix[x][y].set(this.matrix[x][y].get());
            }
        }
        for (y = 0; y < this.rows.get(); ++y) {
            newMatrix[at][y].set(itemSupplier.get());
        }
        for (y = 0; y < this.rows.get(); ++y) {
            for (x = at + 1; x < this.cols.get(); ++x) {
                newMatrix[x][y].set(this.matrix[x - 1][y].get());
            }
        }
        this.matrix = newMatrix;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.COLUMN_ADDED, at, -1));
        }
    }

    public void addCol(int at, List<T> items) {
        this.addCol(at, items, true);
    }

    public void addCol(int at, List<T> items, boolean notify) {
        int x;
        int y;
        if (at < 0 || at > this.cols.get()) {
            throw new IllegalArgumentException("index cannot be smaller or larger than cols");
        }
        if (items.size() != this.rows.get()) {
            throw new IllegalArgumentException("no of items must be equal to number of rows");
        }
        this.cols.getAndIncrement();
        AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols.get(), this.rows.get());
        for (y = 0; y < this.rows.get(); ++y) {
            for (x = 0; x < at; ++x) {
                newMatrix[x][y].set(this.matrix[x][y].get());
            }
        }
        for (y = 0; y < this.rows.get(); ++y) {
            newMatrix[at][y].set(items.get(y));
        }
        for (y = 0; y < this.rows.get(); ++y) {
            for (x = at + 1; x < this.cols.get(); ++x) {
                newMatrix[x][y].set(this.matrix[x - 1][y].get());
            }
        }
        this.matrix = newMatrix;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.COLUMN_ADDED, at, -1));
        }
    }

    public void addNullCol(int at) {
        this.addNullCol(at, true);
    }

    public void addNullCol(int at, boolean notify) {
        int x;
        int y;
        if (at < 0 || at > this.cols.get()) {
            throw new IllegalArgumentException("index cannot be smaller or larger than cols");
        }
        this.cols.getAndIncrement();
        AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols.get(), this.rows.get());
        for (y = 0; y < this.rows.get(); ++y) {
            for (x = 0; x < at; ++x) {
                newMatrix[x][y].set(this.matrix[x][y].get());
            }
        }
        for (y = 0; y < this.rows.get(); ++y) {
            newMatrix[at][y].set(null);
        }
        for (y = 0; y < this.rows.get(); ++y) {
            for (x = at + 1; x < this.cols.get(); ++x) {
                newMatrix[x][y].set(this.matrix[x - 1][y].get());
            }
        }
        this.matrix = newMatrix;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.COLUMN_ADDED, at, -1));
        }
    }

    public void removeCol(int at) {
        this.removeCol(at, true);
    }

    public void removeCol(int at, boolean notify) {
        if (at < 0 || at > this.cols.get()) {
            throw new IllegalArgumentException("index cannot be smaller or larger than cols");
        }
        if (this.cols.get() <= 1) {
            throw new IllegalArgumentException("there is just one column in the matrix");
        }
        for (int y = 0; y < this.getNoOfRows(); ++y) {
            this.matrix[at][y] = null;
        }
        if (0 == at || this.cols.get() - 1 == at || this.resizeMatrixWhenInnerRowOrColIsRemoved) {
            this.cols.getAndDecrement();
            AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols.get(), this.rows.get());
            for (int y = 0; y < this.rows.get(); ++y) {
                for (int x = 0; x <= this.cols.get(); ++x) {
                    if (x < at) {
                        newMatrix[x][y].set(this.matrix[x][y].get());
                        continue;
                    }
                    if (x == at) continue;
                    newMatrix[x - 1][y].set(this.matrix[x][y].get());
                }
            }
            this.matrix = newMatrix;
        }
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.COLUMN_REMOVED, at, -1));
        }
    }

    public void addRow(int at, Supplier<T> itemSupplier) {
        this.addRow(at, itemSupplier, true);
    }

    public void addRow(int at, Supplier<T> itemSupplier, boolean notify) {
        int x;
        int y;
        if (at < 0 || at > this.rows.get()) {
            throw new IllegalArgumentException("index cannot be smaller or larger than rows");
        }
        this.rows.getAndIncrement();
        AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols.get(), this.rows.get());
        for (y = 0; y < at; ++y) {
            for (x = 0; x < this.cols.get(); ++x) {
                newMatrix[x][y].set(this.matrix[x][y].get());
            }
        }
        for (int x2 = 0; x2 < this.cols.get(); ++x2) {
            newMatrix[x2][at].set(itemSupplier.get());
        }
        for (y = at + 1; y < this.rows.get(); ++y) {
            for (x = 0; x < this.cols.get(); ++x) {
                newMatrix[x][y].set(this.matrix[x][y - 1].get());
            }
        }
        this.matrix = newMatrix;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.ROW_ADDED, -1, at));
        }
    }

    public void addRow(int at, List<T> items) {
        this.addRow(at, items, true);
    }

    public void addRow(int at, List<T> items, boolean notify) {
        int x;
        int y;
        if (at < 0 || at > this.rows.get()) {
            throw new IllegalArgumentException("index cannot be smaller or larger than rows");
        }
        if (items.size() != this.cols.get()) {
            throw new IllegalArgumentException("now of items must be equal to number of columns");
        }
        this.rows.getAndIncrement();
        AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols.get(), this.rows.get());
        for (y = 0; y < at; ++y) {
            for (x = 0; x < this.cols.get(); ++x) {
                newMatrix[x][y].set(this.matrix[x][y].get());
            }
        }
        for (int x2 = 0; x2 < this.cols.get(); ++x2) {
            newMatrix[x2][at].set(items.get(x2));
        }
        for (y = at + 1; y < this.rows.get(); ++y) {
            for (x = 0; x < this.cols.get(); ++x) {
                newMatrix[x][y].set(this.matrix[x][y - 1].get());
            }
        }
        this.matrix = newMatrix;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.ROW_ADDED, -1, at));
        }
    }

    public void addNullRow(int at) {
        this.addNullRow(at, true);
    }

    public void addNullRow(int at, boolean notify) {
        int x;
        int y;
        if (at < 0 || at > this.rows.get()) {
            throw new IllegalArgumentException("index cannot be smaller or larger than rows");
        }
        this.rows.getAndIncrement();
        AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols.get(), this.rows.get());
        for (y = 0; y < at; ++y) {
            for (x = 0; x < this.cols.get(); ++x) {
                newMatrix[x][y].set(this.matrix[x][y].get());
            }
        }
        for (int x2 = 0; x2 < this.cols.get(); ++x2) {
            newMatrix[x2][at].set(null);
        }
        for (y = at + 1; y < this.rows.get(); ++y) {
            for (x = 0; x < this.cols.get(); ++x) {
                newMatrix[x][y].set(this.matrix[x][y - 1].get());
            }
        }
        this.matrix = newMatrix;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.ROW_ADDED, -1, at));
        }
    }

    public void removeRow(int at) {
        this.removeRow(at, true);
    }

    public void removeRow(int at, boolean notify) {
        if (at < 0 || at > this.rows.get()) {
            throw new IllegalArgumentException("index cannot be smaller or larger than rows");
        }
        if (this.rows.get() <= 1) {
            throw new IllegalArgumentException("there is just one row in the matrix");
        }
        for (int x = 0; x < this.getNoOfCols(); ++x) {
            this.matrix[x][at] = null;
        }
        if (0 == at || this.rows.get() - 1 == at || this.resizeMatrixWhenInnerRowOrColIsRemoved) {
            this.rows.getAndDecrement();
            AtomicReference<T>[][] newMatrix = ObservableMatrix.createArray(this.type, this.cols.get(), this.rows.get());
            for (int y = 0; y <= this.rows.get(); ++y) {
                int x;
                if (y < at) {
                    for (x = 0; x < this.cols.get(); ++x) {
                        newMatrix[x][y].set(this.matrix[x][y].get());
                    }
                    continue;
                }
                if (y == at) continue;
                for (x = 0; x < this.cols.get(); ++x) {
                    newMatrix[x][y - 1].set(this.matrix[x][y].get());
                }
            }
            this.matrix = newMatrix;
        }
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.ROW_REMOVED, -1, at));
        }
    }

    public int getNoOfRows() {
        return this.rows.get();
    }

    public void setRows(int rows) {
        this.setRows(rows, true);
    }

    public void setRows(int rows, boolean notify) {
        if (rows == -1 || this.cols.get() == -1 || this.rows.get() == -1) {
            throw new IllegalArgumentException("cols/rows cannot be smaller 0");
        }
        AtomicReference[][] oldMatrix = new AtomicReference[this.cols.get()][rows];
        for (int y = 0; y < this.rows.get(); ++y) {
            for (int x = 0; x < this.cols.get(); ++x) {
                oldMatrix[x][y].set(this.matrix[x][y].get());
            }
        }
        int oldRows = this.rows.get();
        this.rows.set(rows);
        this.matrix = ObservableMatrix.createArray(this.type, this.cols.get(), rows);
        int c = this.cols.get();
        int r = rows > this.rows.get() ? oldRows : (rows < this.rows.get() ? rows : rows);
        for (int y = 0; y < r; ++y) {
            for (int x = 0; x < c; ++x) {
                this.matrix[x][y].set(oldMatrix[x][y].get());
            }
        }
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.NO_OF_ROWS_CHANGED, -1, rows));
        }
    }

    public List<List<T>> getAllColumns() {
        ArrayList<List<T>> columns = new ArrayList<List<T>>();
        for (int i = 0; i < this.getNoOfCols(); ++i) {
            columns.add(this.getCol(i));
        }
        return columns;
    }

    public List<Integer> getAllEmptyColumns() {
        ArrayList<Integer> emptyColumns = new ArrayList<Integer>();
        for (int x = 0; x < this.getNoOfCols(); ++x) {
            if (this.getCol(x).stream().filter(Objects::nonNull).count() != 0L) continue;
            emptyColumns.add(x);
        }
        return emptyColumns;
    }

    public List<List<T>> getAllRows() {
        ArrayList<List<T>> rows = new ArrayList<List<T>>();
        for (int i = 0; i < this.getNoOfRows(); ++i) {
            rows.add(this.getRow(i));
        }
        return rows;
    }

    public List<Integer> getAllEmptyRows() {
        ArrayList<Integer> emptyRows = new ArrayList<Integer>();
        for (int y = 0; y < this.getNoOfRows(); ++y) {
            if (this.getRow(y).stream().filter(Objects::nonNull).count() != 0L) continue;
            emptyRows.add(y);
        }
        return emptyRows;
    }

    public void mirrorColumns() {
        this.mirrorColumns(true);
    }

    public void mirrorColumns(boolean notify) {
        for (int i = 0; i < this.matrix.length / 2; ++i) {
            AtomicReference<T>[] temp = this.matrix[i];
            this.matrix[i] = this.matrix[this.matrix.length - i - 1];
            this.matrix[this.matrix.length - i - 1] = temp;
        }
        boolean bl = this.colsMirrored = !this.colsMirrored;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.COLUMNS_MIRRORED, this.cols.get(), -1));
        }
    }

    public void mirrorRows() {
        this.mirrorRows(true);
    }

    public void mirrorRows(boolean notify) {
        for (int j = 0; j < this.matrix.length; ++j) {
            AtomicReference<T>[] row = this.matrix[j];
            for (int i = 0; i < row.length / 2; ++i) {
                T temp = row[i].get();
                row[i] = this.matrix[j][row.length - i - 1];
                row[row.length - i - 1].set(temp);
            }
        }
        boolean bl = this.rowsMirrored = !this.rowsMirrored;
        if (notify) {
            this.fireMatrixChangeEvt(new MatrixChangeEvt(this, MatrixChangeEvt.ROWS_MIRRORED, -1, this.rows.get()));
        }
    }

    public boolean getColsMirrored() {
        return this.colsMirrored;
    }

    public boolean getRowsMirrored() {
        return this.rowsMirrored;
    }

    public boolean getResizeMatrixWhenInnerRowOrColIsRemoved() {
        return this.resizeMatrixWhenInnerRowOrColIsRemoved;
    }

    public void setResizeMatrixWhenInnerRowOrColIsRemoved(boolean resize) {
        this.resizeMatrixWhenInnerRowOrColIsRemoved = resize;
    }

    public boolean isEmpty() {
        return this.getAllEmptyColumns().size() == this.getNoOfCols() && this.getAllEmptyRows().size() == this.getNoOfRows();
    }

    private void shiftLeft() {
        for (int y = 0; y < this.rows.get(); ++y) {
            for (int x = 1; x < this.cols.get(); ++x) {
                this.matrix[x - 1][y] = this.matrix[x][y];
            }
        }
    }

    private void shiftUp() {
        for (int y = 1; y < this.rows.get(); ++y) {
            for (int x = 0; x < this.cols.get(); ++x) {
                this.matrix[x][y - 1] = this.matrix[x][y];
            }
        }
    }

    private static <T> AtomicReference<T>[][] createArray(Class type, int cols, int rows) {
        if (null == type) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (cols < 1 || rows < 1) {
            throw new IllegalArgumentException("cols/rows cannot be smaller than 1");
        }
        AtomicReference[][] emptyMatrix = new AtomicReference[cols][rows];
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                emptyMatrix[x][y] = new AtomicReference();
            }
        }
        return emptyMatrix;
    }

    private void checkForRemovedColumnsAndRows(int removedItemCol, int removedItemRow, boolean notify) {
        int nullItemCounter = 0;
        for (int r = 0; r < this.rows.get(); ++r) {
            if (null != this.getItemAt(removedItemCol, r)) continue;
            ++nullItemCounter;
        }
        if (nullItemCounter == this.rows.get()) {
            this.removeCol(removedItemCol, notify);
            return;
        }
        nullItemCounter = 0;
        for (int c = 0; c < this.cols.get(); ++c) {
            if (null != this.getItemAt(c, removedItemRow)) continue;
            ++nullItemCounter;
        }
        if (nullItemCounter == this.cols.get()) {
            this.removeRow(removedItemRow, notify);
            return;
        }
    }

    public void addMatrixChangeObserver(EvtType<? extends Evt> type, EvtObserver<MatrixChangeEvt<T>> observer) {
        if (null == type || null == observer) {
            return;
        }
        if (null == this.matrixObservers) {
            this.matrixObservers = new ConcurrentHashMap<EvtType<? extends Evt>, List<EvtObserver<MatrixChangeEvt<T>>>>();
        }
        if (!this.matrixObservers.containsKey(type)) {
            this.matrixObservers.put(type, new CopyOnWriteArrayList());
        }
        if (this.matrixObservers.get(type).contains(observer)) {
            return;
        }
        this.matrixObservers.get(type).add(observer);
    }

    public void removeMatrixChangeObserver(EvtType<? extends Evt> type, EvtObserver<MatrixChangeEvt<T>> observer) {
        if (null == this.matrixObservers || null == type || null == observer) {
            return;
        }
        if (this.matrixObservers.containsKey(type) && this.matrixObservers.get(type).contains(observer)) {
            this.matrixObservers.get(type).remove(observer);
        }
    }

    public void removeAllMatrixChangeObservers() {
        if (null == this.matrixObservers) {
            return;
        }
        this.matrixObservers.clear();
    }

    public void fireMatrixChangeEvt(MatrixChangeEvt<T> evt) {
        if (null == this.matrixObservers) {
            return;
        }
        this.matrixObservers.entrySet().stream().filter(entry -> !((EvtType)entry.getKey()).equals(MatrixChangeEvt.ANY)).filter(entry -> ((EvtType)entry.getKey()).equals(evt.getEvtType())).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle(evt)));
        this.matrixObservers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(MatrixChangeEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle(evt)));
    }

    public void addMatrixItemChangeObserver(EvtType<? extends Evt> type, EvtObserver<MatrixItemChangeEvt<T>> observer) {
        if (null == type || null == observer) {
            return;
        }
        if (null == this.itemObservers) {
            this.itemObservers = new ConcurrentHashMap<EvtType<? extends Evt>, List<EvtObserver<MatrixItemChangeEvt<T>>>>();
        }
        if (!this.itemObservers.containsKey(type)) {
            this.itemObservers.put(type, new CopyOnWriteArrayList());
        }
        if (this.itemObservers.get(type).contains(observer)) {
            return;
        }
        this.itemObservers.get(type).add(observer);
    }

    public void removeMatrixItemChangeObserver(EvtType<? extends Evt> type, EvtObserver<MatrixItemChangeEvt<T>> observer) {
        if (null == type || null == observer || null == this.itemObservers) {
            return;
        }
        if (this.itemObservers.containsKey(type) && this.itemObservers.get(type).contains(observer)) {
            this.itemObservers.get(type).remove(observer);
        }
    }

    public void removeAllMatrixItemChangeObservers() {
        if (null == this.itemObservers) {
            return;
        }
        this.itemObservers.clear();
    }

    public void fireMatrixItemChangeEvt(MatrixItemChangeEvt<T> evt) {
        if (null == this.itemObservers) {
            return;
        }
        this.itemObservers.entrySet().stream().filter(entry -> !((EvtType)entry.getKey()).equals(MatrixItemChangeEvt.ANY)).filter(entry -> ((EvtType)entry.getKey()).equals(evt.getEvtType())).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle(evt)));
        this.itemObservers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(MatrixItemChangeEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle(evt)));
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        for (int y = 0; y < this.rows.get(); ++y) {
            for (int x = 0; x < this.cols.get(); ++x) {
                output.append(this.matrix[x][y]).append(" ");
            }
            output.append("\n");
        }
        return output.toString();
    }
}

