/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.properties;

import eu.hansolo.toolbox.evt.type.InvalidationEvt;
import eu.hansolo.toolbox.evt.type.PropertyChangeEvt;
import eu.hansolo.toolbox.properties.ReadOnlyBooleanProperty;

public class BooleanProperty
extends ReadOnlyBooleanProperty {
    protected ReadOnlyBooleanProperty propertyBoundTo = null;
    protected boolean bound = false;

    public BooleanProperty() {
        this((Object)null, (String)null, false);
    }

    public BooleanProperty(boolean value) {
        this((Object)null, (String)null, value);
    }

    public BooleanProperty(String name, boolean value) {
        this((Object)null, name, value);
    }

    public BooleanProperty(Object bean, String name, boolean value) {
        super(bean, name, value);
    }

    public void set(boolean value) {
        this.setValue(value);
    }

    public void setValue(Boolean value) {
        if (this.bound && !this.bidirectional) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        this.setValue(value, null);
    }

    protected void setValue(Boolean value, BooleanProperty property) {
        if (!value.equals(this.getValue())) {
            this.willChange((Boolean)this.value, value);
            Boolean oldValue = (Boolean)this.value;
            this.value = value;
            if (null == property && null != this.propertyToUpdate) {
                this.propertyToUpdate.setValue(value, this);
            }
            this.fireEvent(new PropertyChangeEvt<Object>(this, PropertyChangeEvt.CHANGED, oldValue, this.value));
            this.didChange(oldValue, (Boolean)this.value);
        }
        this.invalidated();
    }

    @Override
    public void invalidated() {
        this.fireEvent(new InvalidationEvt(this, InvalidationEvt.INVALIDATED));
    }

    public void unset() {
        this.setValue((Boolean)this.getInitialValue());
    }

    public void setInitialValue(Boolean initialValue) {
        this.initialValue = initialValue;
    }

    public void bind(ReadOnlyBooleanProperty property) {
        this.propertyBoundTo = property;
        this.value = this.propertyBoundTo.getValue();
        this.propertyBoundTo.setPropertyToUpdate(this);
        this.propertyToUpdate = null;
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void bindBidirectional(BooleanProperty property) {
        this.setPropertyToUpdate(property, true);
        property.setPropertyToUpdate(this, true);
        this.propertyBoundTo = property;
        this.bound = true;
    }

    public boolean isBoundBidirectional() {
        return this.bidirectional;
    }

    public void unbind() {
        if (null != this.propertyToUpdate) {
            this.propertyToUpdate.unsetPropertyToUpdate();
            this.propertyToUpdate.unbind();
            this.propertyToUpdate = null;
        }
        if (null != this.propertyBoundTo) {
            this.propertyBoundTo.unsetPropertyToUpdate();
            this.propertyBoundTo = null;
        }
        this.bound = false;
        this.bidirectional = false;
    }

    protected void setPropertyToUpdate(BooleanProperty property, boolean bidirectional) {
        this.propertyToUpdate = property;
        if (null == property) {
            this.bidirectional = false;
        } else {
            this.value = property.getValue();
            this.bidirectional = bidirectional;
        }
    }
}

