/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolboxfx;

import eu.hansolo.toolbox.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;

public class GradientLookup {
    private Map<Double, Stop> stops = new TreeMap<Double, Stop>();

    public GradientLookup() {
        this(new Stop[0]);
    }

    public GradientLookup(Stop ... stops) {
        this(Arrays.asList(stops));
    }

    public GradientLookup(List<Stop> stops) {
        for (Stop stop : stops) {
            this.stops.put(stop.getOffset(), stop);
        }
        this.init();
    }

    private void init() {
        if (this.stops.isEmpty()) {
            return;
        }
        double minFraction = Collections.min(this.stops.keySet());
        double maxFraction = Collections.max(this.stops.keySet());
        if (Double.compare(minFraction, 0.0) > 0) {
            this.stops.put(0.0, new Stop(0.0, this.stops.get(minFraction).getColor()));
        }
        if (Double.compare(maxFraction, 1.0) < 0) {
            this.stops.put(1.0, new Stop(1.0, this.stops.get(maxFraction).getColor()));
        }
    }

    public Color getColorAt(double positionOfColor) {
        Color color;
        if (this.stops.isEmpty()) {
            return Color.BLACK;
        }
        int size = this.stops.size();
        double position = Helper.clamp((double)0.0, (double)1.0, (double)positionOfColor);
        if (size == 1) {
            Map oneEntry = (Map)((Object)this.stops.entrySet().iterator().next());
            color = this.stops.get(oneEntry.keySet().iterator().next()).getColor();
        } else {
            Stop lowerBound = this.stops.get(0.0);
            Stop upperBound = this.stops.get(1.0);
            int counter = 0;
            for (Map.Entry<Double, Stop> entry : this.stops.entrySet()) {
                double fraction = entry.getKey();
                Stop stop = entry.getValue();
                if (counter != size - 1 && Double.compare(fraction, position) == 0) {
                    lowerBound = stop;
                } else if (Double.compare(fraction, position) < 0) {
                    lowerBound = stop;
                } else if (Double.compare(fraction, position) > 0) {
                    upperBound = stop;
                    break;
                }
                ++counter;
            }
            color = this.interpolateColor(lowerBound, upperBound, position);
        }
        return color;
    }

    public List<Stop> getStops() {
        return new ArrayList<Stop>(this.stops.values());
    }

    public void setStops(Stop ... stops) {
        this.setStops(Arrays.asList(stops));
    }

    public void setStops(List<Stop> stops) {
        this.stops.clear();
        for (Stop stop : stops) {
            this.stops.put(stop.getOffset(), stop);
        }
        this.init();
    }

    public Stop getStopAt(double positionOfStop) {
        if (this.stops.isEmpty()) {
            throw new IllegalArgumentException("GradientStop stops should not be empty");
        }
        double position = Helper.clamp((double)0.0, (double)1.0, (double)positionOfStop);
        Stop stop = null;
        double distance = Math.abs(this.stops.get(0.0).getOffset() - position);
        for (Map.Entry<Double, Stop> entry : this.stops.entrySet()) {
            double cdistance = Math.abs(entry.getKey() - position);
            if (!(cdistance < distance)) continue;
            stop = this.stops.get(entry.getKey());
            distance = cdistance;
        }
        return stop;
    }

    public List<Stop> getStopsBetween(double minOffset, double maxOffset) {
        ArrayList<Stop> selectedStops = new ArrayList<Stop>();
        for (Map.Entry<Double, Stop> entry : this.stops.entrySet()) {
            if (!(entry.getValue().getOffset() >= minOffset) || !(entry.getValue().getOffset() <= maxOffset)) continue;
            selectedStops.add(entry.getValue());
        }
        return selectedStops;
    }

    private Color interpolateColor(Stop lowerBound, Stop upperBound, double position) {
        double pos = (position - lowerBound.getOffset()) / (upperBound.getOffset() - lowerBound.getOffset());
        double deltaRed = (upperBound.getColor().getRed() - lowerBound.getColor().getRed()) * pos;
        double deltaGreen = (upperBound.getColor().getGreen() - lowerBound.getColor().getGreen()) * pos;
        double deltaBlue = (upperBound.getColor().getBlue() - lowerBound.getColor().getBlue()) * pos;
        double deltaOpacity = (upperBound.getColor().getOpacity() - lowerBound.getColor().getOpacity()) * pos;
        double red = Helper.clamp((double)0.0, (double)1.0, (double)(lowerBound.getColor().getRed() + deltaRed));
        double green = Helper.clamp((double)0.0, (double)1.0, (double)(lowerBound.getColor().getGreen() + deltaGreen));
        double blue = Helper.clamp((double)0.0, (double)1.0, (double)(lowerBound.getColor().getBlue() + deltaBlue));
        double opacity = Helper.clamp((double)0.0, (double)1.0, (double)(lowerBound.getColor().getOpacity() + deltaOpacity));
        return Color.color((double)red, (double)green, (double)blue, (double)opacity);
    }
}

