/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolboxfx.geom;

import eu.hansolo.toolboxfx.geom.Point;

public class CatmullRom<T extends Point> {
    private CatmullRomSpline splineXValues;
    private CatmullRomSpline splineYValues;

    public CatmullRom(T P0, T P1, T P2, T P3) {
        if (P0 == null) {
            throw new AssertionError((Object)"p0 cannot be null");
        }
        if (P1 == null) {
            throw new AssertionError((Object)"p1 cannot be null");
        }
        if (P2 == null) {
            throw new AssertionError((Object)"p2 cannot be null");
        }
        if (P3 == null) {
            throw new AssertionError((Object)"p3 cannot be null");
        }
        this.splineXValues = new CatmullRomSpline(this, ((Point)P0).getX(), ((Point)P1).getX(), ((Point)P2).getX(), ((Point)P3).getX());
        this.splineYValues = new CatmullRomSpline(this, ((Point)P0).getY(), ((Point)P1).getY(), ((Point)P2).getY(), ((Point)P3).getY());
    }

    public T q(double T) {
        return (T)new Point(this.splineXValues.q(T), this.splineYValues.q(T));
    }

    class CatmullRomSpline {
        private double p0;
        private double p1;
        private double p2;
        private double p3;

        protected CatmullRomSpline(CatmullRom this$0, double P0, double P1, double P2, double P3) {
            this.p0 = P0;
            this.p1 = P1;
            this.p2 = P2;
            this.p3 = P3;
        }

        protected double q(double T) {
            return 0.5 * (2.0 * this.p1 + (this.p2 - this.p0) * T + (2.0 * this.p0 - 5.0 * this.p1 + 4.0 * this.p2 - this.p3) * T * T + (3.0 * this.p1 - this.p0 - 3.0 * this.p2 + this.p3) * T * T * T);
        }
    }
}

