/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolboxfx.geom;

import eu.hansolo.toolboxfx.geom.Bounds;
import java.util.Objects;

public class Rectangle {
    public double x;
    public double y;
    public double width;
    public double height;

    public Rectangle() {
    }

    public Rectangle(double w, double h) {
        this(0.0, 0.0, w, h);
    }

    public Rectangle(double x, double y, double w, double h) {
        this.set(x, y, w, h);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void set(Rectangle rect) {
        this.set(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public void set(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public double getCenterX() {
        return this.x + this.width / 2.0;
    }

    public double getCenterY() {
        return this.y + this.height / 2.0;
    }

    public boolean isEmpty() {
        return Double.compare(this.width, 0.0) <= 0 || Double.compare(this.height, 0.0) <= 0;
    }

    public Bounds getBounds() {
        return new Bounds(this.x, this.y, this.x + this.width, this.y + this.height);
    }

    public boolean intersects(double x, double y, double width, double height) {
        return this.getBounds().intersects(x, y, width, height);
    }

    public Rectangle createIntersection(Rectangle rect) {
        Rectangle dst = new Rectangle();
        Rectangle.intersect(this, rect, dst);
        return dst;
    }

    public Rectangle createUnion(Rectangle rect) {
        Rectangle dst = new Rectangle();
        Rectangle.union(this, rect, dst);
        return dst;
    }

    public boolean contains(double x, double y) {
        return Double.compare(x, this.x) >= 0 && Double.compare(y, this.y) >= 0 && Double.compare(x, this.x + this.width) <= 0 && Double.compare(y, this.y + this.height) <= 0;
    }

    public boolean contains(double x, double y, double width, double height) {
        return this.contains(x, y) && this.contains(x + width, y) && this.contains(x, y + height) && this.contains(x + width, y + height);
    }

    public static void union(Rectangle src1, Rectangle src2, Rectangle dst) {
        Bounds bounds1 = src1.getBounds();
        Bounds bounds2 = src2.getBounds();
        double x1 = Math.min(bounds1.getMinX(), bounds2.getMinX());
        double y1 = Math.min(bounds1.getMinY(), bounds2.getMinY());
        double x2 = Math.max(bounds1.getMaxX(), bounds2.getMaxX());
        double y2 = Math.max(bounds1.getMaxY(), bounds2.getMaxY());
        dst.set(x1, y1, x2 - x1, y2 - y1);
    }

    public static void intersect(Rectangle src1, Rectangle src2, Rectangle dst) {
        Bounds bounds1 = src1.getBounds();
        Bounds bounds2 = src2.getBounds();
        double x1 = Math.max(bounds1.getMinX(), bounds2.getMinX());
        double y1 = Math.max(bounds1.getMinY(), bounds2.getMinY());
        double x2 = Math.min(bounds1.getMaxX(), bounds2.getMaxX());
        double y2 = Math.min(bounds1.getMaxY(), bounds2.getMaxY());
        dst.set(x1, y1, x2 - x1, y2 - y1);
    }

    public Rectangle copy() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)obj;
            return Double.compare(this.x, rectangle.x) == 0 && Double.compare(this.y, rectangle.y) == 0 && Double.compare(this.width, rectangle.width) == 0 && Double.compare(this.height, rectangle.height) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.width, this.height);
    }

    public String toString() {
        return "{" + "\"" + "x" + "\"" + ":" + this.x + "," + "\"" + "y" + "\"" + ":" + this.y + "," + "\"" + "w" + "\"" + ":" + this.width + "," + "\"" + "h" + "\"" + ":" + this.height + "}";
    }
}

