/*
 * Decompiled with CFR 0.152.
 */
package eu.lestard.advanced_bindings.api;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.FloatBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.LongBinding;
import javafx.beans.binding.NumberBinding;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableValue;

public class NumberBindings {
    public static BooleanBinding isNaN(ObservableDoubleValue observableValue) {
        return Bindings.createBooleanBinding(() -> Double.isNaN(observableValue.get()), (Observable[])new Observable[]{observableValue});
    }

    public static BooleanBinding isInfinite(ObservableDoubleValue observableValue) {
        return Bindings.createBooleanBinding(() -> Double.isInfinite(observableValue.get()), (Observable[])new Observable[]{observableValue});
    }

    public static NumberBinding divideSafe(ObservableValue<Number> dividend, ObservableValue<Number> divisor) {
        return NumberBindings.divideSafe(dividend, divisor, (ObservableValue<Number>)new SimpleDoubleProperty(0.0));
    }

    public static NumberBinding divideSafe(double dividend, ObservableValue<Number> divisor) {
        return NumberBindings.divideSafe((ObservableValue<Number>)new SimpleDoubleProperty(dividend), divisor);
    }

    public static NumberBinding divideSafe(ObservableValue<Number> dividend, double divisor) {
        return NumberBindings.divideSafe(dividend, (ObservableValue<Number>)new SimpleDoubleProperty(divisor));
    }

    public static NumberBinding divideSafe(ObservableValue<Number> dividend, ObservableValue<Number> divisor, ObservableValue<Number> defaultValue) {
        return Bindings.createDoubleBinding(() -> {
            if (((Number)divisor.getValue()).doubleValue() == 0.0) {
                return ((Number)defaultValue.getValue()).doubleValue();
            }
            return ((Number)dividend.getValue()).doubleValue() / ((Number)divisor.getValue()).doubleValue();
        }, (Observable[])new Observable[]{dividend, divisor});
    }

    public static NumberBinding divideSafe(ObservableValue<Number> dividend, ObservableValue<Number> divisor, double defaultValue) {
        return NumberBindings.divideSafe(dividend, divisor, (ObservableValue<Number>)new SimpleDoubleProperty(defaultValue));
    }

    public static IntegerBinding divideSafe(ObservableIntegerValue dividend, ObservableIntegerValue divisor) {
        return NumberBindings.divideSafe(dividend, divisor, (ObservableIntegerValue)new SimpleIntegerProperty(0));
    }

    public static IntegerBinding divideSafe(int dividend, ObservableIntegerValue divisor) {
        return NumberBindings.divideSafe((ObservableIntegerValue)new SimpleIntegerProperty(dividend), divisor);
    }

    public static IntegerBinding divideSafe(ObservableIntegerValue dividend, int divisor) {
        return NumberBindings.divideSafe(dividend, (ObservableIntegerValue)new SimpleIntegerProperty(divisor));
    }

    public static IntegerBinding divideSafe(ObservableIntegerValue dividend, ObservableIntegerValue divisor, ObservableIntegerValue defaultValue) {
        return Bindings.createIntegerBinding(() -> {
            if (divisor.intValue() == 0) {
                return defaultValue.get();
            }
            return dividend.intValue() / divisor.intValue();
        }, (Observable[])new Observable[]{dividend, divisor});
    }

    public static IntegerBinding divideSafe(ObservableIntegerValue dividend, ObservableIntegerValue divisor, int defaultValue) {
        return NumberBindings.divideSafe(dividend, divisor, (ObservableIntegerValue)new SimpleIntegerProperty(defaultValue));
    }

    public static IntegerBinding asInteger(ObservableValue<Number> source) {
        return Bindings.createIntegerBinding(() -> NumberBindings.nonNullNumber((Number)source.getValue()).intValue(), (Observable[])new Observable[]{source});
    }

    public static DoubleBinding asDouble(ObservableValue<Number> source) {
        return Bindings.createDoubleBinding(() -> NumberBindings.nonNullNumber((Number)source.getValue()).doubleValue(), (Observable[])new Observable[]{source});
    }

    public static FloatBinding asFloat(ObservableValue<Number> source) {
        return Bindings.createFloatBinding(() -> Float.valueOf(NumberBindings.nonNullNumber((Number)source.getValue()).floatValue()), (Observable[])new Observable[]{source});
    }

    public static LongBinding asLong(ObservableValue<Number> source) {
        return Bindings.createLongBinding(() -> NumberBindings.nonNullNumber((Number)source.getValue()).longValue(), (Observable[])new Observable[]{source});
    }

    private static Number nonNullNumber(Number number) {
        if (number == null) {
            return 0;
        }
        return number;
    }
}

