/*
 * Decompiled with CFR 0.152.
 */
package eu.lestard.advanced_bindings.api;

import java.util.Locale;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;

public class StringBindings {
    public static BooleanBinding matches(ObservableValue<String> text, String pattern) {
        return Bindings.createBooleanBinding(() -> {
            String textToVerify = (String)text.getValue();
            return textToVerify != null && textToVerify.matches(pattern);
        }, (Observable[])new Observable[]{text});
    }

    public static BooleanBinding matches(ObservableValue<String> text, ObservableValue<String> pattern) {
        return Bindings.createBooleanBinding(() -> {
            String textToVerify = (String)text.getValue();
            String patternString = (String)pattern.getValue();
            return textToVerify != null && patternString != null && textToVerify.matches(patternString);
        }, (Observable[])new Observable[]{text, pattern});
    }

    public static StringBinding trim(ObservableValue<String> text) {
        return Bindings.createStringBinding(() -> text.getValue() == null ? "" : ((String)text.getValue()).trim(), (Observable[])new Observable[]{text});
    }

    public static StringBinding toLowerCase(ObservableValue<String> text) {
        return Bindings.createStringBinding(() -> text.getValue() == null ? "" : ((String)text.getValue()).toLowerCase(), (Observable[])new Observable[]{text});
    }

    public static StringBinding toLowerCase(ObservableValue<String> text, Locale locale) {
        return Bindings.createStringBinding(() -> text.getValue() == null ? "" : ((String)text.getValue()).toLowerCase(locale), (Observable[])new Observable[]{text});
    }

    public static StringBinding toLowerCase(ObservableValue<String> text, ObservableValue<Locale> locale) {
        return Bindings.createStringBinding(() -> {
            if (text.getValue() == null) {
                return "";
            }
            Locale localeValue = locale.getValue() == null ? Locale.getDefault() : (Locale)locale.getValue();
            return ((String)text.getValue()).toLowerCase(localeValue);
        }, (Observable[])new Observable[]{text, locale});
    }

    public static StringBinding toUpperCase(ObservableValue<String> text) {
        return Bindings.createStringBinding(() -> text.getValue() == null ? "" : ((String)text.getValue()).toUpperCase(), (Observable[])new Observable[]{text});
    }

    public static StringBinding toUpperCase(ObservableValue<String> text, Locale locale) {
        return Bindings.createStringBinding(() -> text.getValue() == null ? "" : ((String)text.getValue()).toUpperCase(locale), (Observable[])new Observable[]{text});
    }

    public static StringBinding toUpperCase(ObservableValue<String> text, ObservableValue<Locale> locale) {
        return Bindings.createStringBinding(() -> {
            Locale localeValue = locale.getValue() == null ? Locale.getDefault() : (Locale)locale.getValue();
            return text.getValue() == null ? "" : ((String)text.getValue()).toUpperCase(localeValue);
        }, (Observable[])new Observable[]{text, locale});
    }
}

