/*
 * Decompiled with CFR 0.152.
 */
package eu.lestard.advanced_bindings.api;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.util.Callback;

public class SwitchBindings {
    public static <T, R> SwitchBuilder<T, R> switchBinding(ObservableValue<T> observable, Class<R> bindingType) {
        return new SwitchBuilder(observable);
    }

    public static class SwitchBuilder<T, R> {
        private final ObservableValue<T> baseObservable;
        private Map<T, Callback<T, R>> valueMap = new HashMap<T, Callback<T, R>>();
        private Supplier<R> defaultValue;

        private SwitchBuilder(ObservableValue<T> baseObservable) {
            this.baseObservable = baseObservable;
        }

        public SwitchBuilder<T, R> bindCase(T value, Callback<T, R> callback) {
            this.valueMap.put(value, callback);
            return this;
        }

        public SwitchBuilder<T, R> bindDefault(Supplier<R> consumer) {
            this.defaultValue = consumer;
            return this;
        }

        public ObservableValue<R> build() {
            return Bindings.createObjectBinding(() -> {
                Object enumValue = this.baseObservable.getValue();
                if (enumValue == null) {
                    return this.getDefaultValue();
                }
                if (this.valueMap.containsKey(enumValue)) {
                    return this.valueMap.get(enumValue).call(enumValue);
                }
                return this.getDefaultValue();
            }, (Observable[])new Observable[]{this.baseObservable});
        }

        private R getDefaultValue() {
            if (this.defaultValue == null) {
                return null;
            }
            return this.defaultValue.get();
        }
    }
}

