/*
 * Decompiled with CFR 0.152.
 */
package eu.lestard.easydi;

import eu.lestard.easydi.EasyDiException;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EasyDI {
    private final Set<Class<?>> requestedClasses = new HashSet();
    private final Set<Class<?>> instantiableClasses = new HashSet();
    private final Map<Class<?>, Object> singletonInstances = new HashMap();
    private final Set<Class<?>> singletonClasses = new HashSet();
    private final Map<Class<?>, Class> interfaceMappings = new HashMap();
    private final Map<Class<?>, Provider> providers = new HashMap();

    public <T> T getInstance(Class<T> requestedType) {
        return this.getInstance(requestedType, null);
    }

    private <T> T getInstance(Class<T> requestedType, Class<?> parent) {
        try {
            Class type = requestedType;
            if (requestedType.isInterface()) {
                if (this.interfaceMappings.containsKey(requestedType)) {
                    type = this.interfaceMappings.get(requestedType);
                } else {
                    if (this.providers.containsKey(requestedType)) {
                        return this.getInstanceFromProvider(requestedType);
                    }
                    throw new EasyDiException(this.createErrorMessageStart(requestedType) + "It is an interface and there was no implementation class mapping defined for this type. Please use the 'bindInterface' method of EasyDI to define what implementing class should be used for a given interface.");
                }
            }
            if (EasyDI.isAbstractClass(requestedType)) {
                if (this.providers.containsKey(requestedType)) {
                    return this.getInstanceFromProvider(requestedType);
                }
                throw new EasyDiException(this.createErrorMessageStart(requestedType) + "It is an abstract class and there is no provider for this class available. Please define a provider with the `bindProvider` method for this abstract class type.");
            }
            if (this.requestedClasses.contains(type)) {
                if (!this.instantiableClasses.contains(type)) {
                    throw new EasyDiException(this.createErrorMessageStart(type) + "A cyclic dependency was detected.");
                }
            } else {
                this.requestedClasses.add(type);
            }
            if (this.singletonInstances.containsKey(type)) {
                return (T)this.singletonInstances.get(type);
            }
            if (this.providers.containsKey(type)) {
                T instanceFromProvider = this.getInstanceFromProvider(type);
                this.markAsInstantiable(type);
                if (this.isSingleton(type)) {
                    this.singletonInstances.put(type, instanceFromProvider);
                }
                return instanceFromProvider;
            }
            return this.createNewInstance(type, parent);
        }
        catch (EasyDiException rootCause) {
            Object errorMessage = "EasyDI wasn't able to create your class hierarchy. ";
            if (parent != null) {
                errorMessage = (String)errorMessage + "\nCannot instantiate the class [" + parent.getName() + "]. At least one of the constructor parameters of type [" + requestedType + "] can't be instantiated. ";
            }
            errorMessage = (String)errorMessage + "See the root cause exception for a detailed explanation.";
            throw new IllegalStateException((String)errorMessage, rootCause);
        }
    }

    private <T> T createNewInstance(Class<T> type, Class<?> parent) {
        Constructor<T> constructor = this.findConstructor(type);
        Parameter[] parameters = constructor.getParameters();
        List<Object> arguments = Arrays.stream(parameters).map(param -> {
            if (param.getType().equals(Provider.class)) {
                return this.getProviderArgument((Parameter)param, type);
            }
            return this.getInstance(param.getType(), type);
        }).toList();
        try {
            T newInstance = constructor.newInstance(arguments.toArray());
            this.markAsInstantiable(type);
            if (this.isSingleton(type)) {
                this.singletonInstances.put(type, newInstance);
            }
            return newInstance;
        }
        catch (Exception e) {
            throw new EasyDiException(this.createErrorMessageStart(type) + "An Exception was thrown during the instantiation.", e);
        }
    }

    public <T> void bindInterface(Class<T> interfaceType, Class<? extends T> implementationType) {
        if (interfaceType.isInterface()) {
            if (implementationType.isInterface()) {
                throw new IllegalArgumentException("The given type is an interface. Expecting the second argument to not be an interface but an actual class");
            }
            if (EasyDI.isAbstractClass(implementationType)) {
                throw new IllegalArgumentException("The given type is an abstract class. Expecting the second argument to be an actual implementing class");
            }
        } else {
            throw new IllegalArgumentException("The given type is not an interface. Expecting the first argument to be an interface.");
        }
        this.interfaceMappings.put(interfaceType, implementationType);
    }

    public <T> void bindProvider(Class<T> classType, Provider<T> provider) {
        this.providers.put(classType, provider);
    }

    public <T> void bindInstance(Class<T> classType, T instance) {
        this.bindProvider(classType, () -> instance);
    }

    public void markAsSingleton(Class type) {
        if (type.isInterface()) {
            throw new IllegalArgumentException("The given type is an interface. Expecting the param to be an actual class");
        }
        this.singletonClasses.add(type);
    }

    static boolean isAbstractClass(Class type) {
        return !type.isInterface() && Modifier.isAbstract(type.getModifiers());
    }

    private Provider getProviderArgument(Parameter param, Class requestedType) {
        Type type = param.getParameterizedType();
        if (type instanceof ParameterizedType) {
            ParameterizedType typeParam = (ParameterizedType)type;
            Type providerType = typeParam.getActualTypeArguments()[0];
            return () -> this.getInstance((Class)providerType);
        }
        throw new EasyDiException(this.createErrorMessageStart(requestedType) + "There is a javax.inject.Provider without a type parameter declared as dependency. When using javax.inject.Provider as dependency you need to define a type parameter for this provider!");
    }

    private void markAsInstantiable(Class type) {
        if (!this.instantiableClasses.contains(type)) {
            this.instantiableClasses.add(type);
        }
    }

    private boolean isSingleton(Class type) {
        return type.isAnnotationPresent(Singleton.class) || this.singletonClasses.contains(type);
    }

    private <T> T getInstanceFromProvider(Class<T> type) {
        try {
            Provider provider = this.providers.get(type);
            return (T)provider.get();
        }
        catch (Exception e) {
            throw new EasyDiException(this.createErrorMessageStart(type) + "An Exception was thrown by the provider.", e);
        }
    }

    private <T> Constructor<T> findConstructor(Class<T> type) {
        Constructor<?>[] constructors = type.getConstructors();
        if (constructors.length == 0) {
            throw new EasyDiException(this.createErrorMessageStart(type) + "The class has no public constructor.");
        }
        if (constructors.length > 1) {
            List<Constructor> constructorsWithInject = Arrays.stream(constructors).filter(c -> c.isAnnotationPresent(Inject.class)).toList();
            if (constructorsWithInject.isEmpty()) {
                throw new EasyDiException(this.createErrorMessageStart(type) + "There is more than one public constructor defined so I don't know which one to use. Fix this by either make only one constructor public or annotate exactly one constructor with the javax.inject.Inject annotation.");
            }
            if (constructorsWithInject.size() != 1) {
                throw new EasyDiException(this.createErrorMessageStart(type) + "There is more than one public constructor marked with @Inject so I don't know which one to use. Fix this by either make only one constructor public or annotate exactly one constructor with the javax.inject.Inject annotation.");
            }
            return constructorsWithInject.get(0);
        }
        return constructors[0];
    }

    private String createErrorMessageStart(Class type) {
        return "EasyDI can't create an instance of the class [" + type + "]. ";
    }
}

