/*
 * Decompiled with CFR 0.152.
 */
package eu.lp0.slf4j.android;

import android.util.Log;
import eu.lp0.slf4j.android.CallerStackTrace;
import eu.lp0.slf4j.android.LogLevel;
import eu.lp0.slf4j.android.LoggerConfig;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

final class LogAdapter
implements Logger {
    private static final ConcurrentMap<String, LogLevel> nativeLevelMap = new ConcurrentHashMap<String, LogLevel>();
    private static final int DIRECT_FRAMES = 2;
    private static final int FORMAT_FRAMES = 3;
    private final String name;
    private final String tag;
    private final String prefixName;
    private final boolean showThread;
    private final boolean showCaller;
    private final boolean complexRewriteMsg;
    private final boolean ERROR;
    private final boolean WARN;
    private final boolean INFO;
    private final boolean DEBUG;
    private final boolean TRACE;

    LogAdapter(String name, LoggerConfig config) {
        this.name = name;
        this.tag = config.tag;
        if (config.level == LogLevel.NATIVE) {
            config.level = this.getNativeLogLevel();
        }
        this.TRACE = config.level == LogLevel.VERBOSE;
        this.DEBUG = this.TRACE || config.level == LogLevel.DEBUG;
        this.INFO = this.DEBUG || config.level == LogLevel.INFO;
        this.WARN = this.INFO || config.level == LogLevel.WARN;
        this.ERROR = this.WARN || config.level == LogLevel.ERROR;
        switch (config.showName) {
            case CALLER: {
                this.prefixName = null;
                this.showCaller = true;
                break;
            }
            case LONG: {
                this.prefixName = name.concat(": ");
                this.showCaller = false;
                break;
            }
            case COMPACT: {
                this.prefixName = this.getCompactName().concat(": ");
                this.showCaller = false;
                break;
            }
            case SHORT: {
                this.prefixName = name.substring(name.lastIndexOf(46) + 1).concat(": ");
                this.showCaller = false;
                break;
            }
            default: {
                this.showCaller = false;
                this.prefixName = null;
            }
        }
        this.showThread = config.showThread;
        this.complexRewriteMsg = this.showThread || this.showCaller;
    }

    private final LogLevel getNativeLogLevel() {
        LogLevel level = (LogLevel)((Object)nativeLevelMap.get(this.tag));
        if (level != null) {
            return level;
        }
        level = Log.isLoggable((String)this.tag, (int)4) ? (Log.isLoggable((String)this.tag, (int)3) ? (Log.isLoggable((String)this.tag, (int)2) ? LogLevel.VERBOSE : LogLevel.DEBUG) : LogLevel.INFO) : (Log.isLoggable((String)this.tag, (int)5) ? LogLevel.WARN : (Log.isLoggable((String)this.tag, (int)6) ? LogLevel.ERROR : LogLevel.SUPPRESS));
        nativeLevelMap.put(this.tag, level);
        return level;
    }

    private final String getCompactName() {
        char[] compactName = this.name.toCharArray();
        int arrayLen = compactName.length;
        int len = 0;
        int mark = 0;
        int i = 0;
        while (i < arrayLen) {
            if (compactName[i] == '.') {
                len = mark;
                if (compactName[len] != '.') {
                    // empty if block
                }
                mark = ++len;
                if (i + 1 < arrayLen && compactName[i + 1] != '.') {
                    ++mark;
                }
            }
            compactName[len] = compactName[i];
            ++i;
            ++len;
        }
        return new String(compactName, 0, len);
    }

    public final String getName() {
        return this.name;
    }

    private final String rewriteMsg(String msg, int frames) {
        if (msg == null) {
            msg = "null";
        }
        if (this.complexRewriteMsg) {
            StringBuilder sb = new StringBuilder(msg.length() + 64);
            if (this.showThread) {
                sb.append('[').append(Thread.currentThread().getName()).append("] ");
            }
            if (this.showCaller) {
                sb.append(new CallerStackTrace(frames).toString()).append(": ");
            } else if (this.prefixName != null) {
                sb.append(this.prefixName);
            }
            sb.append(msg);
            return sb.toString();
        }
        if (this.prefixName != null) {
            return this.prefixName.concat(msg);
        }
        return msg;
    }

    public final boolean isTraceEnabled() {
        return this.TRACE;
    }

    private final void __trace(String msg, Throwable t) {
        if (t == null) {
            Log.v((String)this.tag, (String)msg);
        } else {
            Log.v((String)this.tag, (String)msg, (Throwable)t);
        }
    }

    private final void __traceFormat(String format, Object ... arguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.__trace(this.rewriteMsg(ft.getMessage(), 3), ft.getThrowable());
    }

    public final void trace(String msg) {
        if (this.TRACE) {
            Log.v((String)this.tag, (String)this.rewriteMsg(msg, 2));
        }
    }

    public final void trace(String format, Object arg) {
        if (this.TRACE) {
            this.__traceFormat(format, arg);
        }
    }

    public final void trace(String format, Object arg1, Object arg2) {
        if (this.TRACE) {
            this.__traceFormat(format, arg1, arg2);
        }
    }

    public final void trace(String format, Object ... arguments) {
        if (this.TRACE) {
            this.__traceFormat(format, arguments);
        }
    }

    public final void trace(String msg, Throwable t) {
        if (this.TRACE) {
            this.__trace(this.rewriteMsg(msg, 2), t);
        }
    }

    public final boolean isTraceEnabled(Marker marker) {
        return this.TRACE;
    }

    public final void trace(Marker marker, String msg) {
        if (this.TRACE) {
            Log.v((String)this.tag, (String)this.rewriteMsg(msg, 2));
        }
    }

    public final void trace(Marker marker, String format, Object arg) {
        if (this.TRACE) {
            this.__traceFormat(format, arg);
        }
    }

    public final void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.TRACE) {
            this.__traceFormat(format, arg1, arg2);
        }
    }

    public final void trace(Marker marker, String format, Object ... argArray) {
        if (this.TRACE) {
            this.__traceFormat(format, argArray);
        }
    }

    public final void trace(Marker marker, String msg, Throwable t) {
        if (this.TRACE) {
            this.__trace(this.rewriteMsg(msg, 2), t);
        }
    }

    public final boolean isDebugEnabled() {
        return this.DEBUG;
    }

    private final void __debug(String msg, Throwable t) {
        if (t == null) {
            Log.d((String)this.tag, (String)msg);
        } else {
            Log.d((String)this.tag, (String)msg, (Throwable)t);
        }
    }

    private final void __debugFormat(String format, Object ... arguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.__debug(this.rewriteMsg(ft.getMessage(), 3), ft.getThrowable());
    }

    public final void debug(String msg) {
        if (this.DEBUG) {
            Log.d((String)this.tag, (String)this.rewriteMsg(msg, 2));
        }
    }

    public final void debug(String format, Object arg) {
        if (this.DEBUG) {
            this.__debugFormat(format, arg);
        }
    }

    public final void debug(String format, Object arg1, Object arg2) {
        if (this.DEBUG) {
            this.__debugFormat(format, arg1, arg2);
        }
    }

    public final void debug(String format, Object ... arguments) {
        if (this.DEBUG) {
            this.__debugFormat(format, arguments);
        }
    }

    public final void debug(String msg, Throwable t) {
        if (this.DEBUG) {
            this.__debug(this.rewriteMsg(msg, 2), t);
        }
    }

    public final boolean isDebugEnabled(Marker marker) {
        return this.DEBUG;
    }

    public final void debug(Marker marker, String msg) {
        if (this.DEBUG) {
            Log.d((String)this.tag, (String)this.rewriteMsg(msg, 2));
        }
    }

    public final void debug(Marker marker, String format, Object arg) {
        if (this.DEBUG) {
            this.__debugFormat(format, arg);
        }
    }

    public final void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.DEBUG) {
            this.__debugFormat(format, arg1, arg2);
        }
    }

    public final void debug(Marker marker, String format, Object ... argArray) {
        if (this.DEBUG) {
            this.__debugFormat(format, argArray);
        }
    }

    public final void debug(Marker marker, String msg, Throwable t) {
        if (this.DEBUG) {
            this.__debug(this.rewriteMsg(msg, 2), t);
        }
    }

    public final boolean isInfoEnabled() {
        return this.INFO;
    }

    private final void __info(String msg, Throwable t) {
        if (t == null) {
            Log.i((String)this.tag, (String)msg);
        } else {
            Log.i((String)this.tag, (String)msg, (Throwable)t);
        }
    }

    private final void __infoFormat(String format, Object ... arguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.__info(this.rewriteMsg(ft.getMessage(), 3), ft.getThrowable());
    }

    public final void info(String msg) {
        if (this.INFO) {
            Log.i((String)this.tag, (String)this.rewriteMsg(msg, 2));
        }
    }

    public final void info(String format, Object arg) {
        if (this.INFO) {
            this.__infoFormat(format, arg);
        }
    }

    public final void info(String format, Object arg1, Object arg2) {
        if (this.INFO) {
            this.__infoFormat(format, arg1, arg2);
        }
    }

    public final void info(String format, Object ... arguments) {
        if (this.INFO) {
            this.__infoFormat(format, arguments);
        }
    }

    public final void info(String msg, Throwable t) {
        if (this.INFO) {
            this.__info(this.rewriteMsg(msg, 2), t);
        }
    }

    public final boolean isInfoEnabled(Marker marker) {
        return this.INFO;
    }

    public final void info(Marker marker, String msg) {
        if (this.INFO) {
            Log.i((String)this.tag, (String)this.rewriteMsg(msg, 2));
        }
    }

    public final void info(Marker marker, String format, Object arg) {
        if (this.INFO) {
            this.__infoFormat(format, arg);
        }
    }

    public final void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.INFO) {
            this.__infoFormat(format, arg1, arg2);
        }
    }

    public final void info(Marker marker, String format, Object ... argArray) {
        if (this.INFO) {
            this.__infoFormat(format, argArray);
        }
    }

    public final void info(Marker marker, String msg, Throwable t) {
        if (this.INFO) {
            this.__info(this.rewriteMsg(msg, 2), t);
        }
    }

    public final boolean isWarnEnabled() {
        return this.WARN;
    }

    private final void __warn(String msg, Throwable t) {
        if (t == null) {
            Log.w((String)this.tag, (String)msg);
        } else {
            Log.w((String)this.tag, (String)msg, (Throwable)t);
        }
    }

    private final void __warnFormat(String format, Object ... arguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.__warn(this.rewriteMsg(ft.getMessage(), 3), ft.getThrowable());
    }

    public final void warn(String msg) {
        if (this.WARN) {
            Log.w((String)this.tag, (String)this.rewriteMsg(msg, 2));
        }
    }

    public final void warn(String format, Object arg) {
        if (this.WARN) {
            this.__warnFormat(format, arg);
        }
    }

    public final void warn(String format, Object arg1, Object arg2) {
        if (this.WARN) {
            this.__warnFormat(format, arg1, arg2);
        }
    }

    public final void warn(String format, Object ... arguments) {
        if (this.WARN) {
            this.__warnFormat(format, arguments);
        }
    }

    public final void warn(String msg, Throwable t) {
        if (this.WARN) {
            this.__warn(this.rewriteMsg(msg, 2), t);
        }
    }

    public final boolean isWarnEnabled(Marker marker) {
        return this.WARN;
    }

    public final void warn(Marker marker, String msg) {
        if (this.WARN) {
            Log.w((String)this.tag, (String)this.rewriteMsg(msg, 2));
        }
    }

    public final void warn(Marker marker, String format, Object arg) {
        if (this.WARN) {
            this.__warnFormat(format, arg);
        }
    }

    public final void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.WARN) {
            this.__warnFormat(format, arg1, arg2);
        }
    }

    public final void warn(Marker marker, String format, Object ... argArray) {
        if (this.WARN) {
            this.__warnFormat(format, argArray);
        }
    }

    public final void warn(Marker marker, String msg, Throwable t) {
        if (this.WARN) {
            this.__warn(this.rewriteMsg(msg, 2), t);
        }
    }

    public final boolean isErrorEnabled() {
        return this.ERROR;
    }

    private final void __error(String msg, Throwable t) {
        if (t == null) {
            Log.e((String)this.tag, (String)msg);
        } else {
            Log.e((String)this.tag, (String)msg, (Throwable)t);
        }
    }

    private final void __errorFormat(String format, Object ... arguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.__error(this.rewriteMsg(ft.getMessage(), 3), ft.getThrowable());
    }

    public final void error(String msg) {
        if (this.ERROR) {
            Log.e((String)this.tag, (String)this.rewriteMsg(msg, 2));
        }
    }

    public final void error(String format, Object arg) {
        if (this.ERROR) {
            this.__errorFormat(format, arg);
        }
    }

    public final void error(String format, Object arg1, Object arg2) {
        if (this.ERROR) {
            this.__errorFormat(format, arg1, arg2);
        }
    }

    public final void error(String format, Object ... arguments) {
        if (this.ERROR) {
            this.__errorFormat(format, arguments);
        }
    }

    public final void error(String msg, Throwable t) {
        if (this.ERROR) {
            this.__error(this.rewriteMsg(msg, 2), t);
        }
    }

    public final boolean isErrorEnabled(Marker marker) {
        return this.ERROR;
    }

    public final void error(Marker marker, String msg) {
        if (this.ERROR) {
            Log.e((String)this.tag, (String)this.rewriteMsg(msg, 2));
        }
    }

    public final void error(Marker marker, String format, Object arg) {
        if (this.ERROR) {
            this.__errorFormat(format, arg);
        }
    }

    public final void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.ERROR) {
            this.__errorFormat(format, arg1, arg2);
        }
    }

    public final void error(Marker marker, String format, Object ... argArray) {
        if (this.ERROR) {
            this.__errorFormat(format, argArray);
        }
    }

    public final void error(Marker marker, String msg, Throwable t) {
        if (this.ERROR) {
            this.__error(this.rewriteMsg(msg, 2), t);
        }
    }
}

