/*
 * Decompiled with CFR 0.152.
 */
package eu.lp0.slf4j.android;

import eu.lp0.slf4j.android.LogLevel;

final class LoggerConfig {
    static final LoggerConfig DEFAULT = new LoggerConfig();
    String tag;
    LogLevel level;
    ShowName showName;
    Boolean showThread;

    LoggerConfig() {
    }

    LoggerConfig(String tag) {
        this.tag = tag;
    }

    LoggerConfig(LogLevel level) {
        this.level = level;
    }

    LoggerConfig(ShowName showName) {
        this.showName = showName;
    }

    final boolean isComplete() {
        return this.tag != null && this.level != null && this.showName != null && this.showThread != null;
    }

    final boolean merge(LoggerConfig config) {
        if (config == null) {
            return this.isComplete();
        }
        boolean complete = true;
        if (this.tag == null) {
            this.tag = config.tag;
            complete = false;
        }
        if (this.level == null) {
            this.level = config.level;
            complete = false;
        }
        if (this.showName == null) {
            this.showName = config.showName;
            complete = false;
        }
        if (this.showThread == null) {
            this.showThread = config.showThread;
            complete = false;
        }
        return complete;
    }

    static {
        LoggerConfig.DEFAULT.tag = "";
        LoggerConfig.DEFAULT.level = LogLevel.NATIVE;
        LoggerConfig.DEFAULT.showName = ShowName.FALSE;
        LoggerConfig.DEFAULT.showThread = false;
    }

    static enum ShowName {
        FALSE,
        SHORT,
        COMPACT,
        LONG,
        CALLER;

    }
}

